/* getbtimg -- get boot media image for making bootable CD */
/* Osamu Imaizumi aka Gigo */
/* mailto:gigo@yk.rim.or.jp*/
/* http://www1.yk.rim.or.jp/~gigo/ */
/* compiler MSC6.00A "CL /W3 [/DDEBUG] getbtimg.c */

/* History */
/* V001a - may 2.88MB floppy can handle. */
/* V002 - works on Windows95 */
/* V003 - Experimental CHS Adjustment function added */
/* V004 - Experimental FIPS like cutoff routine added */
/* V004b - add options -H,-S,-A,-R */
/* V005 - input from image file for re-convert,reduce */
/* V006 - Dos Extended partition option */

/* description */
/* The GETBTIMG GETs BooTable IMaGe for EL TORITO spec. */
/* The program can get disk and floppy image under DOS,95 and NT, */
/* except Disk image under NT. */

/* caution */
/* The test of this programs isn't perfect. */

/* usage example for floppy. */
/* getbtimg A: file */
/* getbtimg B: file */

/* for Disk. */
/* When partition is not specified, only the first */
/* partition is copied without any adjustment. */
/* (LBN 0 to first partition's last sector.) */
/* ex. Disk0 partition 0 to file without adjustment */
/*   getbtimg HD0: file */

/* When partition is specified, The partition is copied */
/* as first partition with adjustment. */
/* ex. Disk1 partition 1 to file with adjustment */
/*   getbtimg HD1: file 1 */

/* Features for Disk */
/* CHS conversion. (-A,-H,-S) */
/* File size is reduced by not copying non-used cluster.(-R) */
/* -A and -R recommended. */

/* consideration */
/* The small IDE Disk is accessed by CHS not LBA. */
/* I guesses, this cause geometry problem. because */
/* SCSI BIOS knows only LBA. */
/* -A (head = 64, Sector = 32) option recommended for SCSI CD-ROM */
/* Some IDE BIOS required IDE type CHS */
/* try, -H64 -S63 (head = 64, Sector = 63) */

/* For file */
/* for convert image file */
/* getbtimg image-file output-file */
/* If you get image once, can convert it. */
/* ex. getbtimg Q:fullimge.img -r reduced.img */
/*     getbtimg Q:Wrong.img -A adjusted.img */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <dos.h>

#define byte unsigned char
#define word unsigned short int
#define dword unsigned long

#define PHY_READ  0
#define PHY_WRITE 1

#pragma pack(1)
/* Floppy Disk Boot Sector */
typedef struct FDBS_t {
    byte   JumpByte[1];
    byte   stab1[2];
    byte   OemData[8];
    word   BytesPerSector;
    byte   SectorsPerCluster;
    word   NumberOfReservedSct;
    byte   NumberOfFAT;
    word   DirectorySize;
    word   NumberOfSectors;
    byte   MediaByte[1];
    word   SectorsPerFAT;
    word   SectorsPerTrack;
    word   NumberOfHeads;
    word   NumberOfHiddenSectors;
    byte   stab2[2];
    dword  NumberOfSectorsExt;
} FDBS;

/* Partition data table */
typedef struct PDT_t {
    byte   BootIndicator;
    byte   BeginningSectorHeadNumber;
    byte   BeginningSector;     /* 2 high bits of cylinder #) */
    byte   BeginningCylinder;   /* low order bits of cylinder */
    byte   SystemIndicator;     /* 1:12bit FAT, 4:16bit FAT, 6:16bit FAT,32bit SectorNumber */
    byte   EndingSectorHeadNumber;
    byte   EndingSector;        /* 2 high bits of cylinder # */
    byte   EndingCylinder;      /* low order bits of cylinder */
    dword  SctPrePar;
    dword  SctInPar;
} PDT;
#pragma pack()

#define MAXBUF 56U

static FILE *fp = NULL;
byte buf[MAXBUF*512*2];
byte *bufp,*mbrbuf,*pbrbuf;

FDBS *pbrp;
PDT *PDTp;
int numhed,numsct;

int locked = -1;
int drvno = -1;
int adjust = 0;
int reduce = 0;
int n = 0;
int ep = -1;
int numbuf;
int CvCyl,CvHed,CvSct;
word lastNonZero, usedCluster;
dword totsct;

char *cmd;
char *device;
char *fname;
FILE *image;

void usage(void );
int diskio(int cmd,int drvno, byte *buf,int cyl,int hed,int sct, int len);
dword PhysicalCopy(int cyl,int hed,int sct,int cyl1,int hed1,int sct1,int numhed,int maxsct);
void WriteStab(int sct);
#ifdef VCPPDBG
#define int1317(a,b)
#define xexit(a) exit(a)
#else
int int1317(int drvno, int mode);
void xexit(int code);
#endif
int lock(int drive);
int unlock(int drive);
void LBNtoCHS(dword lbn,int *cylp,int *hedp,int *sctp);
dword CHStoLBN(int cyl,int hed,int sct);
dword getUsedSctInPar(dword lbn);
char *getcmd(int argc,char *argv[]);
void ShowPartition(void);
#ifdef DEBUG
void put1sct(char *name,byte *p,char *type);
#endif

void main(int argc, char *argv[])
{
    int mode;
    int cyl0,cyl1,hed0,hed1,sct0,sct1,stabsct;
    int numcyl,cyl;
    char *p;

    printf("getbtimg - get boot media image for making bootable CD\n");
    printf("18-Jun-97 imaizumi@nisiq.net Ver.beta006\n");

    if ((device = getcmd(argc,argv)) == NULL)
        usage();

    if (stricmp(device,"a:") == 0) drvno = 0;
    if (stricmp(device,"b:") == 0) drvno = 1;
    if (stricmp(device,"HD0:") == 0) drvno = 0x80;
    if (stricmp(device,"HD1:") == 0) drvno = 0x81;
    if (stricmp(device,"HD2:") == 0) drvno = 0x82;
    if (stricmp(device,"HD3:") == 0) drvno = 0x83;
    if (drvno == -1) {
        if ((image = fopen(device,"rb")) == NULL) {
            printf("\n*Error - can't open boot media image file -- '%s' !\n",device);
            xexit(1);
        }
    }
    if ((fname = getcmd(argc,argv)) == NULL)
        usage();

    if ((cmd = getcmd(argc,argv)) != NULL) {
        printf("*Error - Too many argument.\n");
        usage();
    }

#ifndef VCPPDBG
    if ((drvno & 0x1000) == 0) { /* physical */
        word buflen;
        unsigned long phyAdr;
        struct SREGS sr;

        /* adjust buffer location to avoid segment boundary */
        segread( &sr );
        phyAdr = (unsigned)&buf[0] + ((unsigned long)sr.ds << 4);
        buflen =(unsigned) (0x10000L-(phyAdr & 0xffffL));
        if (buflen > (MAXBUF*512)) {
            bufp = &buf[0];
        } else {
            bufp = &buf[buflen];
            buflen = MAXBUF*512*2 - buflen;
        }
        numbuf = buflen/512 - 2;
        mbrbuf = &buf[numbuf*512];
        pbrbuf = &buf[numbuf*512+512];
#ifdef DEBUG
        printf("phyAdr %lX, %lX\n",phyAdr,phyAdr + MAXBUF*512L*2);
        printf("numbuf:%d, buflen:0x%04x, bufp:0x%04x, mbrbuf:0x%04x , pbrbuf:0x%04x\n"
            ,numbuf,buflen,bufp,mbrbuf,pbrbuf);
#endif
    } else {
#endif
        bufp = &buf[0];
        numbuf = MAXBUF*2 - 2;
        mbrbuf = &buf[numbuf*512];
        pbrbuf = &buf[numbuf*512+512];
        fseek(image,0L,SEEK_END);
        switch (ftell(image)/512) {
        case 1440:
        case 2400:
        case 2880:
        case 5760:
            drvno = 0x1000;
            break;
        default:
            drvno = 0x1080;
            break;
        }
#ifndef VCPPDBG
    }
#endif
    if ( (drvno & 0x80) && (drvno > 0) ){ /* hdd */
        if (diskio(PHY_READ,drvno,mbrbuf,0,0,1,1) == -1 ) {
            printf("*Error - can't read '%s'\n",device);
            xexit(1);
        }
#ifdef DEBUG
        put1sct(fname,mbrbuf,".mbr");
#endif
        if ( (*(mbrbuf+0x1FE) != 0x55) || (*(mbrbuf+0x1FF) != 0xAA)) {
            printf("*Error - partition table missing in master boot record.\n");
            xexit(1);
        }
        PDTp = (PDT *)(mbrbuf+0x1BE);
        PDTp = PDTp + n;    /* n'th */
        do {
            if (PDTp->SystemIndicator == 0) {
                printf("*Error - Invalid partition table format.\n");
                xexit(1);
            }

            ShowPartition();

            cyl0 = PDTp->BeginningCylinder + ((PDTp->BeginningSector&0xC0)<<2);
            hed0 = PDTp->BeginningSectorHeadNumber;
            sct0 = PDTp->BeginningSector&0x3F;
            cyl1 = PDTp->EndingCylinder + ((PDTp->EndingSector&0xC0)<<2);
            hed1 = PDTp->EndingSectorHeadNumber;
            sct1 = PDTp->EndingSector&0x3F;

            numcyl = cyl1+1;
            numhed = hed1+1;    /* assume */
            numsct = sct1;  /* assume */
            if (diskio(PHY_READ,drvno,pbrbuf,cyl0,hed0,sct0,1) == -1 ) {
                printf("*Error - can't read %s\n",device);
                xexit(1);
            }
#ifdef DEBUG
            put1sct(fname,pbrbuf,".pbr");
#endif
            if ( (*(pbrbuf+0x1FE) != 0x55) || (*(pbrbuf+0x1FF) != 0xAA)) {
                printf("*Error - partition boot record missing.\n");
                xexit(1);
            }
            if (PDTp->SystemIndicator == 5)  { /* DOS extended partition */
                if (ep < 0) {
                    printf("*Error - DOS Extended partition. use -e option.\n");
                    xexit(1);
                }
                printf("\nDOS Extended partition found ...\n\n");
#ifdef DEBUG
                put1sct(fname,pbrbuf,".ebr");
#endif
                memcpy(mbrbuf+0x1BE,pbrbuf+0x1BE,sizeof(PDT)*4);
                PDTp = (PDT *)(mbrbuf+0x1BE);
                PDTp = PDTp + ep;
                *(pbrbuf+0x1FE) = 0;	/* clear flag */
            }
        } while (*(pbrbuf+0x1FE) != 0x55);
        pbrp = (FDBS *)(pbrbuf);
        numhed = pbrp->NumberOfHeads;
        numsct = stabsct = pbrp->SectorsPerTrack;
        totsct = (pbrp->NumberOfSectors != 0) ? (dword)pbrp->NumberOfSectors : pbrp->NumberOfSectorsExt;
        if ((numhed == 0)||(numsct == 0)||(totsct == 0)) {
            printf("*Error - illegual partition boot record format.\n");
            xexit(1);
        }
        if (CvHed == 0)
            CvHed = numhed;
        if (CvSct == 0)
            CvSct = numsct;

#ifdef DEBUG
        printf("Total sector %8ld, heads %d, sector %d\n",totsct,pbrp->NumberOfHeads,pbrp->SectorsPerTrack);
#endif
        if ( adjust ) {
            printf("\nAdjusting ...\n");
            if ( reduce ) {
                if ((PDTp->SystemIndicator == 4) ||(PDTp->SystemIndicator == 6)) {
                    /* FIPS like cutoff routine */
                    PDTp->SctInPar = getUsedSctInPar(CHStoLBN(cyl0,hed0,sct0));
                    LBNtoCHS(CHStoLBN(cyl0,hed0,sct0) + PDTp->SctInPar - 1L,&cyl1,&hed1,&sct1);
                    if (lastNonZero!=usedCluster)
                        printf("*Info - Save %dKB to use defrag.\n",(lastNonZero-usedCluster)*pbrp->SectorsPerCluster/2);
                } else {
                    printf("\n*Info - Not FAT File System, '-r' option ignored.\n");
                }
            }
            printf("\n");
            memcpy(mbrbuf+0x1BE,PDTp,sizeof(PDT));
            PDTp = (PDT *)(mbrbuf+0x1BE);
            memset((char *)(PDTp+1),0,sizeof(PDT)*3);
            cyl = (int)((PDTp->SctInPar + CvHed*CvSct + CvSct - 1)/(CvHed*CvSct));
            totsct = PDTp->SctInPar = (dword)cyl * (dword)CvHed * (dword)CvSct-CvSct;
            if (PDTp->SctInPar <= 65535L) {
                pbrp->NumberOfSectors = (word)PDTp->SctInPar;
                pbrp->NumberOfSectorsExt = 0L;
            } else {
                pbrp->NumberOfSectors = 0;
                pbrp->NumberOfSectorsExt = PDTp->SctInPar;
            }
            pbrp->NumberOfHeads = (word)CvHed;
            pbrp->SectorsPerTrack = (word)CvSct;

            /*  PDTp->BootIndicator = 0x80;*/
            PDTp->BeginningCylinder = 0;
            PDTp->BeginningSectorHeadNumber = 1;
            PDTp->BeginningSector = 1;
            PDTp->EndingCylinder = (byte)(cyl-1);
            PDTp->EndingSectorHeadNumber = (byte)(CvHed-1);
            PDTp->EndingSector = (byte)(CvSct | ((cyl & 0x300) >>2 ));
            PDTp->SctPrePar = CvSct;

            ShowPartition();

        } else {
            if (numhed != 64)
                printf("*Warnning - NumberOfHeads not 64.\n");
            if (numsct != 32)
                printf("*Warnning - SectorsPerTrack not 32.\n");
            if (totsct != PDTp->SctInPar)
                printf("*Warnning - Total Sector != SectorsInPartition\n");
        }
        printf("\n");
        if ((fp = fopen(fname,"wb")) == NULL) {
            fprintf(stderr,"can't open image file to output -- '%s'.\n",fname);
            xexit(1);
        }
        if (adjust) {
            /* write MBR */
            if (fwrite(mbrbuf,512,1,fp) != 1) {
                printf("*Error - MBR Write.\n");
                xexit(1);
            }
            WriteStab((int)PDTp->SctPrePar-1);
            totsct -= PhysicalCopy(cyl0,hed0,sct0,cyl1,hed1,sct1,numhed,numsct);
#ifdef DEBUG
			printf("pos:0x%lx\n",ftell(fp));
			printf("WriteStab %ld\n",totsct);
#endif
            WriteStab((int)totsct); 
            if (fseek(fp,CvSct*512L,SEEK_SET) != 0) {
                printf("\n*Error - Seek PBR!\n");
                exit(1);
            }
            if (fwrite(pbrbuf,512,1,fp) != 1) {
                printf("*Error - PBR Write.\n");
                xexit(1);
            }
        } else {
            (void) PhysicalCopy(0,0,1,cyl1,hed1,sct1,numhed,numsct);
        }
    } else { /* floppy */
        for (mode = 3 ; mode <=5 ; ++mode) {
            int1317(drvno,mode);
            if (diskio(PHY_READ,drvno,bufp,0,0,1,1) == 0 )
                break;
        }
        if (mode > 5) {
            printf("*Error - can't read '%s'\n",device);
            xexit(1);
        }
#ifdef DEBUG
        put1sct(fname,bufp,".mbr");
#endif
        pbrp = (FDBS *)bufp;
        switch(pbrp->NumberOfSectors) {
        case 1440:
            p ="720K";
            break;
        case 2400:
            p ="1.2M";
            break;
        case 2880:
            p ="1.44M";
            break;
        case 5760:
            p ="2.88M";
            break;
        default:
            p ="unknown ??";
            break;
        }
        printf("Media Type - %s\n",p);
        if ((numhed = pbrp->NumberOfHeads) * (numsct = pbrp->SectorsPerTrack))
            numcyl = pbrp->NumberOfSectors/(numhed*numsct);
        if ((numcyl != 80) || (numhed != 2)){
            printf("*Error - illegal floppy geometry.\n");
            xexit(1);
        }
        if ((fp = fopen(fname,"wb")) == NULL) {
            fprintf(stderr,"can't open image file to output -- '%s'.\n",fname);
            xexit(1);
        }
        PhysicalCopy(0,0,1,numcyl-1,numhed-1,numsct,numhed,numsct);
    }
    printf(" - dump complete.\n");
    xexit(0);
}

int diskio(int cmd,int drvno, byte *buf,int cyl,int hed,int sct, int len)
{
#ifndef VCPPDBG
    union REGS rgi, rgo;
    struct SREGS sr;
    int retry;

    if (drvno & 0x1000) { /* file access */
#endif
        if (fseek(image,CHStoLBN(cyl,hed,sct)*512L,SEEK_SET) != 0) {
            printf("\n*Error - Seek !\n");
            exit(1);
        }
        if (cmd == PHY_READ) {
            if (fread(buf,len,512,image) != 512) {
                printf("\n*Error - Read(0x%x) !\n",drvno);
                xexit(1);
            }
        } else {
            if (fwrite(buf,len,512,image) != 512) {
                printf("\n*Error - Write(0x%x) !\n",drvno);
                xexit(1);
            }
        }
        return(0);
#ifndef VCPPDBG
    } else {
        switch (cmd) {
        case PHY_READ:
            rgi.h.ah = 0x02;                        /* seek and read */
            break;
        case PHY_WRITE:
            rgi.h.ah = 0x03;                        /* write */
            break;
        default:
            printf("\ndiskio:??? Unknown function request ???\n");
            xexit(1);
        }
        for (retry=3;retry;--retry) {
            rgi.h.al = (char) len;                  /* sector */
            rgi.x.bx = (unsigned)buf;               /* buff. addr */
            rgi.h.ch = (char) cyl;
            rgi.h.cl = (char) ((sct & 0x3f) | ((cyl & 0x300) >> 2));
            rgi.h.dh = (char) hed;
            rgi.h.dl = (char) drvno;                /* drive no. */
            segread( &sr );
            sr.es = sr.ds;
            int86x( 0x13, &rgi, &rgo, &sr );        /* call FDD-BIOS */
            if( rgo.x.cflag == 0 )
                return( 0 );
#ifdef DEBUG
            printf( "diskio:Error ! AH = %02x, AL = %02x\n", rgo.h.ah, rgo.h.al );
#endif
            if ((rgo.x.ax == 5) && (locked == -1))
                locked = lock(drvno);
            continue;
        }
        return( -1 );
    }
#endif
}

#ifndef VCPPDBG
int int1317(int drvno, int mode)
{
    union REGS rgi, rgo;

    rgi.h.ah = 0x17;                            /* set FDD mode */
    rgi.h.al = (char) mode;                     /* FDD mode */
    rgi.h.dl = (char) drvno;                    /* drive no.    */
    int86( 0x13, &rgi, &rgo );                  /* call FDD-BIOS */
    if( rgo.h.ah == 6 ){                        /* media changed ? */
        int86( 0x13, &rgi, &rgo );              /* re-do command */
    }
    if( rgo.x.cflag != 0 ){
#ifdef DEBUG
        printf( "Error ! AH = %02x, AL = %02x\n", rgo.h.ah, rgo.h.al );
#endif
        return(-1);
    }
    return 0;
}

int lock(int drive)
{
    union REGS rgi, rgo;
#ifdef DEBUG
    printf( "lock\n");
#endif
    rgi.x.ax = 0x440d;  /* lock physical volume */
    rgi.x.cx = 0x084B;
    rgi.h.bl = (char)drive;
    rgi.h.bh = 1;       /* locklevel */
    rgi.x.dx = 1;       /* disallow new file mappings */
    intdos( &rgi, &rgo);
    if( rgo.x.cflag == 0)
        return(0);
#ifdef DEBUG
    printf( "Error ! AH = %02x, AL = %02x\n", rgo.h.ah, rgo.h.al );
#endif
    return( rgo.h.al );
}

int unlock(int drive)
{
    union REGS rgi, rgo;

#ifdef DEBUG
    printf( "unlock\n");
#endif
    rgi.x.ax = 0x440d;  /* unlock physical volume */
    rgi.x.cx = 0x086B;
    rgi.h.bl = (char)drive;
    intdos( &rgi, &rgo );
    if( rgo.x.cflag == 0)
        return(0);
#ifdef DEBUG
    printf( "Error ! AH = %02x, AL = %02x\n", rgo.h.ah, rgo.h.al );
#endif
    return( rgo.h.al );
}
void xexit(int code)
{
    if (locked == 0)
        unlock(drvno);
    exit(code);
}
#endif

dword PhysicalCopy(int cyl,int hed,int sct,int cyl1,int hed1,int sct1,int maxhed,int maxsct)
{
    int sctcount,restsct;
    dword count = 0;

#ifdef DEBUG
			printf("DEBUG - Physical Copy cyl0:%d, hed0:%d ,sct0:%d ,cyl1:%d, hed1:%d ,sct1:%d, maxhed:%d, maxsct:%d\n"
				,cyl,hed,sct,cyl1,hed1,sct1,maxhed,maxsct);
#endif

    for (;cyl<=cyl1;cyl++) {
        if (cyl == cyl1)
            maxhed = hed1+1;
        for ( ;hed <maxhed; hed++) {
            if ( (cyl == cyl1) && (hed == hed1) )
                maxsct = sct1;
            restsct = maxsct-sct+1;
            while(restsct) {
                sctcount = (restsct <= numbuf) ? restsct : numbuf;
#ifdef DEBUG
                printf("\rCylinder:Head:Sector(count) = %2d:%2d:%2d(%2d)",cyl,hed,sct,sctcount);
#else
                printf("\rCylinder = %2d/%2d",cyl,cyl1);
#endif
                fflush(stdout);
                if (diskio(PHY_READ,drvno,bufp,cyl,hed,sct,sctcount) == -1 ) {
                    printf("*Error - Read.\n");
                    xexit(1);
                }
                if (fwrite(bufp,sctcount*512,1,fp) != 1) {
                    printf("*Error - Write.\n");
                    xexit(1);
                }
                sct += sctcount;
                count += sctcount;
                restsct -= sctcount;
            }
            sct = 1;
        }
        hed = 0;
    }
    return count;
}
/* write stab */
void WriteStab(int sct)
{
    int sctcount;

    memset(bufp,0,((sct > numbuf) ? numbuf : sct)*512);
    while (sct) {
        sctcount = (sct > numbuf) ? numbuf : sct;
        if (fwrite(bufp,512*sctcount,1,fp) != 1) {
            printf("*Error - Stab Write.\n");
            xexit(1);
        }
        sct -= sctcount;
    }
}

#ifdef DEBUG
void put1sct(char *name,byte *buf,char *type)
{
    char *p,namebuf[128];
    FILE *ofp;

    strcpy(namebuf,name);
    if ( (p = strrchr(namebuf,'.')) != NULL)
        *p = '\0';
    strcat(namebuf,type);
    if ((ofp = fopen(namebuf,"wb")) == NULL) {
        fprintf(stderr,"can't open file %s to output -- '%s'.\n",namebuf);
        xexit(1);
    }
    if (fwrite(buf,512,1,ofp) != 1) {
        printf("*Error - Write.\n");
        xexit(1);
    }
    fclose(ofp);
}
#endif

void LBNtoCHS(dword lbn,int *cylp,int *hedp,int *sctp)
{
    *cylp = (int) (lbn/(numhed*numsct));
    *hedp = (int) ((lbn%(numhed*numsct))/numsct);
    *sctp = (int) (lbn - *cylp *numhed*numsct - *hedp *numsct +1);
}
dword CHStoLBN(int cyl,int hed,int sct)
{
    return ((((long)cyl*(long)numhed)+hed)*(long)numsct+sct-1L);
}

dword getUsedSctInPar(dword lbn)
{
    dword NumberOfClusters;
    int cyl,sct,hed;
    word i,j,k;

    /* FAT */
    lastNonZero = usedCluster = 0;
    NumberOfClusters = (
    (pbrp->NumberOfSectors != 0) ? (dword)pbrp->NumberOfSectors : pbrp->NumberOfSectorsExt
        - pbrp->NumberOfReservedSct
        - pbrp->NumberOfFAT*pbrp->SectorsPerFAT
        - (pbrp->DirectorySize - 1) / 16 + 1 
        )/pbrp->SectorsPerCluster;
    lbn += pbrp->NumberOfReservedSct;
    for(i=0,k=(word)NumberOfClusters;i<pbrp->SectorsPerFAT;i++,lbn++,k-=256) {
        LBNtoCHS(lbn,&cyl,&hed,&sct);
        if (diskio(PHY_READ,drvno,bufp,cyl,hed,sct,1) == -1 ) {
            printf("*Error - can't read FAT\n");
            xexit(1);
        }
        for (j=0;j< (( k>256U) ? 256U:k) ;j++) {
            if ( (*((word *)bufp + j) != 0) && (( *((word *)bufp + j) < 0xFFF1) || ( *((word *)bufp + j) >0xFFF7) )) {
                lastNonZero =(word)(i*256 + j + 1);
                usedCluster++;
            }
        }
    }
#ifdef DEBUG
    printf("DEBUG - SectorsPerFAT %d\n",pbrp->SectorsPerFAT);
    printf("DEBUG - SectorsPerCluster %d\n",pbrp->SectorsPerCluster);
    printf("Cluster Used/Last/All = %u/%u/%u\n",usedCluster,lastNonZero,(word)NumberOfClusters);
#endif
    return pbrp->NumberOfReservedSct + pbrp->NumberOfFAT*pbrp->SectorsPerFAT
        + ((pbrp->DirectorySize - 1) / 16 + 1) + ((dword)lastNonZero-2L)*pbrp->SectorsPerCluster;
}

static int argn = 1;

char *getcmd(int argc,char *argv[])
{
    char *p = NULL;

    do {
        if (argn >= argc)
            return NULL;
        p = argv[argn++];

        if (*p == '-') {
            switch(toupper(*(p + 1))) {
                /*          case 'C':
                                sscanf(p+2,"%d",&CvCyl);
                                break;*/
            case 'E':
                sscanf(p+2,"%d",&ep);
                if ((ep < 0) || (ep >3))
                    usage();
                adjust++;
                break;
            case 'P':
                sscanf(p+2,"%d",&n);
                if ((n < 0) || (n >3))
                    usage();
                adjust++;
                break;
            case 'H':
                sscanf(p+2,"%d",&CvHed);
                if ((CvHed < 1) || (CvHed >255))
                    usage();
                adjust++;
                break;
            case 'S':
                sscanf(p+2,"%d",&CvSct);
                if ((CvSct < 1) || (CvSct >63))
                    usage();
                adjust++;
                break;
            case 'A':
                CvHed = 64;
                CvSct = 32;
                adjust++;   /* auto */
                break;
            case 'R':
                adjust++;
                reduce++;
                break;
            default:
                printf("\n* Error - illegal option type/position '%s'\n",p);
                usage();
                break;
            }
            p=NULL;
        }
    } while (p == NULL);
    return(p);
}
void ShowPartition(void)
{
    printf("BootIndicator:0x%02x - %sbootable.\n",PDTp->BootIndicator
        ,PDTp->BootIndicator == 0x80 ? "" : "non ");
    printf("BeginningSector Cyl:%03d, Hed:%02d, Sct:%02d\n",
    PDTp->BeginningCylinder + ((PDTp->BeginningSector&0xC0)<<2),
    PDTp->BeginningSectorHeadNumber,
    PDTp->BeginningSector&0x3F);
    printf("EndingSector    Cyl:%03d, Hed:%02d, Sct:%02d\n",
    PDTp->EndingCylinder + ((PDTp->EndingSector&0xC0)<<2),
    PDTp->EndingSectorHeadNumber,
    PDTp->EndingSector&0x3F);
    printf("SectorsPrecedingPartition:%ld\n",PDTp->SctPrePar);
    printf("SectorsInPartition:%ld\n",PDTp->SctInPar);
}
void usage()
{
    printf("usage:\n");
    printf(" Syntax:\n");
    printf("  getbtimg device filename\n");
    printf("   device := A: | B: | HDn: | imagefile\n");
    printf(" Options:\n");
    printf("  -Pn  partition n\n");
    printf("  -En  dos extended partition n\n");
    printf("         partition := 0 | 1 | 2 | 3\n");
    printf("  -r   reduce partition size.\n");
    printf("  -a   adjust 64Heads, 32Sectors\n");
    printf("  -Hnn adjust heads to nn\n");
    printf("  -Snn adjust sectors to nn\n");
    printf("example:\n");
    printf("  getbtimg A: floppy14.img\n");
    printf("  getbtimg B: floppy12.img\n");
    printf("  getbtimg HD0: dsk0pat0.img\n");
    printf("  getbtimg HD1: -r dsk1pat0.img\n");
    printf("  getbtimg HD0: -a dsk0pt0a.img\n");
    printf("  getbtimg HD0: dsk0p1e0a.img -a -p1 -e0\n");
    printf("mailto:gigo@yk.rim.or.jp\n");
    printf("http://www1.yk.rim.or.jp/~gigo/\n");
    xexit(1);
}
