#undef DEBUG
#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/param.h>
#include <dirent.h>
#include <errno.h>
#include "../include/stats.h"
#define USERFILE
#include "../include/userfile.h"
#undef USERFILE
#include "../include/sysconfig.h"
char *trim( char *str );

char datapath[ MAXPATHLEN+1 ];

struct GROUP
{
        char  name[ 20 ];
        int   members;
        int   files_up;
        ulong bytes_up;
        int   files_up_wk;
        ulong bytes_up_wk;
	int   files_up_day;
	ulong bytes_up_day;
        int   files_up_month;
        ulong bytes_up_month;
} group[ 80 ];

int num_groups = 0;

char usergroup[ 40 ][ 15 ];
char usergroup_desc[ 40 ][ 40 ];
char privgroup[ 20 ][ 15 ];
char privgroup_desc[ 20 ][ 40 ];

/***************************************************************************
	CLEAR_USERS
***************************************************************************/

int 
clear_users( void )
{
   int x;
   int ct;										
#ifdef DEBUG
	fprintf( stdout, "clear_users()\n" );
#endif	
	
   num_users = 0;

   for ( x = 0; x < NUM_USERS; x++ )
   {
      memset( user[ x ].username, '\0', 25 );
      user[ x ].bytes_up = 0L;
      user[ x ].bytes_down = 0U;
      user[ x ].transfers = 0;
      user[ x ].uploads = 0;
      user[ x ].downloads = 0;
      user[ x ].total_uptime = (time_t)0L;
      user[ x ].total_downtime = (time_t)0L;
      user[ x ].total_time = (time_t)0L;
      user[ x ].upspeed = 0.0;
      user[ x ].downspeed = 0.0;
   for ( ct = 0; ct < 10; ct++ )
      bzero( uf.group_user[ ct ], sizeof( uf.group_user[ct]) );
                
   for ( ct = 0; ct < 5; ct++ ) 
      bzero( uf.group_priv[ ct ], sizeof( uf.group_priv[ct]) );

   }

   return 0;
}
/*-- end of clear_users() ------------------------------------------------*/






/***************************************************************************
	QS_LIST_UP
***************************************************************************/

void 
qs_list_up( struct USER item[], int left, int right )
{
   register int i;
   register int j;
   size_t x;
   struct USER temp;
										  
#ifdef DEBUG
	fprintf( stdout, "qs_list_up()\n" );
#endif	
	
   i = left;
   j = right;
   x = item[ ( left + right ) / 2 ].bytes_up;

   do
   {
      while ( item[ i ].bytes_up < x && i < right )
         i++;
      while ( item[ j ].bytes_up > x && j > left )
         j--;
      if ( i <= j )
      {
         temp = item[ i ];
         item[ i ] = item[ j ];
         item[ j ] = temp;
         i++;
         j--;
      }
   } while ( i <= j );

   if ( left < j )
      qs_list_up( item, left, j );

   if ( i < right )
      qs_list_up( item, i, right );
}
/*-- end of qs_list_up() -------------------------------------------------*/


/***************************************************************************
	QS_LIST_DOWN
***************************************************************************/

void 
qs_list_down( struct USER item[], int left, int right )
{
   register int i;
   register int j;
   size_t x;
   struct USER temp;
										 
#ifdef DEBUG
	fprintf( stdout, "qs_list_down()\n" );
#endif	
	
   i = left;
   j = right;
   x = item[ ( left + right ) / 2 ].bytes_down;

   do
   {
      while ( item[ i ].bytes_down < x && i < right )
         i++;
      while ( item[ j ].bytes_down > x && j > left )
         j--;
      if ( i <= j )
      {
         temp = item[ i ];
         item[ i ] = item[ j ];
         item[ j ] = temp;
         i++;
         j--;
      }
   } while ( i <= j );

   if ( left < j )
      qs_list_down( item, left, j );

   if ( i < right )
      qs_list_down( item, i, right );
}
/*-- end of qs_list_down() -----------------------------------------------*/
																		

/***************************************************************************
  STRREV
  Reverses a string in place
***************************************************************************/

char *
strrev (char *str)
{
  char *p1, *p2;

  if (!str || !*str)
    return str;

  for (p1 = str, p2 = str + strlen (str) - 1; p2 > p1; ++p1, --p2)
    {
      *p1 ^= *p2;
      *p2 ^= *p1;
      *p1 ^= *p2;
    }
  return str;
}
/*-- end of strrev() -----------------------------------------------------*/


/***************************************************************************
	PRINT_UP
***************************************************************************/

int 
print_up( void )
{
   int    x;
   int    num = 1;
	char   numbuf1[ BUFSIZ ];
	char   numbuf2[ BUFSIZ ];
	char   numbuf3[ BUFSIZ ];
											
#ifdef DEBUG
	fprintf( stdout, "print_up()\n" );
#endif	
	
   if ( num_users == 0 || user[ num_users - 1 ].bytes_up == 0L )
   {				
	fprintf( message, "" );
      return 0;
   }

   for ( x = num_users - 1; x > num_users - NUM_LIST - 1; x-- )
   {
      if ( user[ x ].bytes_up != 0L )
      {
			commafmt( numbuf1, BUFSIZ, user[x].uploads );
			strrev( numbuf1 );
			while ( strlen( numbuf1 ) < 7 )
				strcat( numbuf1, " " );
			strrev( numbuf1 );
					  				
			strrev( numbuf2 );
			while ( strlen( numbuf2 ) < 7 )
				strcat( numbuf2, " " );
			strrev( numbuf2 );
#ifdef VDR
			fprintf( message, "!h!5 %02d %-9.9s %-33.33s %.4s %8.0fMb %4.0fKbs !0\n",
				num++, user[x].username, user[x].tagline, numbuf1, 
				(double)( user[ x ].bytes_up / 1024.0 ), (double)user[ x ].upspeed );
#else
			fprintf( message, "!G[!g%02d!G] !D%-9.9s !E%-30.30s !g%-6s !G%8.0fMb !g%4.0fKBs !0\n",
				num++, user[x].username, user[x].tagline, numbuf1,
				(double)( user[ x ].bytes_up / 1024.0 ), (double)user[ x ].upspeed );
#endif
      }
      else return 0;
   }

   return 0;
}
/*-- end of print_up() ---------------------------------------------------*/





/***************************************************************************
	PRINT_DOWN
***************************************************************************/

int 
print_down( void )
{
   int    x;
   int    num = 1;
	char   numbuf1[ BUFSIZ ];
	char   numbuf2[ BUFSIZ ];
	char   numbuf3[ BUFSIZ ];
									  
#ifdef DEBUG
	fprintf( stdout, "print_down()\n" );
#endif	
	
   if ( num_users == 0 || user[ num_users - 1 ].bytes_down == 0L )
   {
	fprintf( message, "" );
      return 0;
   }

   for ( x = num_users - 1; x > num_users - NUM_LIST - 1; x-- )
   {
      if ( user[ x ].bytes_down != 0L )
      {
			commafmt( numbuf1, BUFSIZ, user[x].downloads );
			strrev( numbuf1 );
			while ( strlen( numbuf1 ) < 7 )
				strcat( numbuf1, " " );
			strrev( numbuf1 );
					  				
			strrev( numbuf2 );
			while ( strlen( numbuf2 ) < 7 )
				strcat( numbuf2, " " );
			strrev( numbuf2 );
			
#ifdef VDR
			fprintf( message, "!h!5 %02d %-9.9s %-33.33s %.4s %8.0fMb %4.0fKbs !0\n",
				num++, user[x].username, user[x].tagline, numbuf1, 
				(double)( user[ x ].bytes_down / 1024.0 ), (double)user[ x ].downspeed );
#else
			fprintf( message, "!G[!g%02d!G] !D%-9.9s !E%-30.30s !g%6s !G%8.0fMb !g%4.0fKBs !0\n",
				num++, user[x].username, user[x].tagline, numbuf1, 
				(double)( user[ x ].bytes_down / 1024.0 ), (double)user[ x ].downspeed );
#endif
      }
      else return 0;
   }

   return 0;
}
/*-- end of print_down() --------------------------------------------------*/
										 

/***************************************************************************
	UF_INTO_USER
***************************************************************************/

void 
uf_into_user( void )
{											 
#ifdef DEBUG
	fprintf( stdout, "uf_into_user()\n" );
#endif	

	if ( num_users >= NUM_USERS )
		return;

	memcpy( user[ num_users ].username, uf.name, 24 );
	memcpy( user[ num_users ].tagline, uf.tagline, 63 );
	if ( uf.tagline[ 0 ] == '\0' || strcmp( uf.tagline, DEFAULT_TAGLINE ) == 0 )
		memset( user[ num_users ].tagline, '\0', 64 );

	user[ num_users ].bytes_up = uf.bytes_up;
	user[ num_users ].bytes_down = uf.bytes_down;

	if ( user[ num_users ].bytes_down > 5000 )
		user[ num_users ].bytes_down -= 5000;

	user[ num_users ].transfers = uf.files_up + uf.files_down;
	user[ num_users ].uploads = uf.files_up;
	user[ num_users ].downloads = uf.files_down;
	user[ num_users ].total_time = uf.seconds_up + uf.seconds_down;
	user[ num_users ].total_uptime = uf.seconds_up;
	user[ num_users ].total_downtime = uf.seconds_down;

   if ( user[ num_users ].total_uptime != 0L )
   	user[ num_users ].upspeed = (double)((double)(user[ num_users ].bytes_up) / (double)(user[ num_users ].total_uptime));
   if ( user[ num_users ].total_downtime != 0L )
      user[ num_users ].downspeed = (double)((double)(user[ num_users ].bytes_down) / (double)(user[ num_users ].total_downtime));

	num_users++;

   return;
}
/*-- end of uf_into_user() -----------------------------------------------*/


/***************************************************************************
	UF_INTO_USER_WK
***************************************************************************/

void 
uf_into_user_wk( void )
{											
#ifdef DEBUG
	fprintf( stdout, "uf_into_user_wk()\n" );
#endif	

	if ( num_users >= NUM_USERS )
		return;

#ifdef DEBUG
	fprintf( stdout, "  part 1 (%s)\n", uf.name );
#endif	

	memcpy( user[ num_users ].username, uf.name, sizeof( user[num_users].username) );
	memcpy( user[ num_users ].tagline, uf.tagline, sizeof( user[num_users].tagline ) );
	if ( uf.tagline[ 0 ] == '\0' || strcmp( uf.tagline, DEFAULT_TAGLINE ) == 0 )
		bzero( user[ num_users ].tagline, sizeof( user[num_users].tagline ) );
	user[ num_users ].bytes_up = uf.bytes_up_wk;
	user[ num_users ].bytes_down = uf.bytes_down_wk;
									  
#ifdef DEBUG
	fprintf( stdout, "  part 2\n" );
#endif	
	
	if ( user[ num_users ].bytes_down > 5000 )
		user[ num_users ].bytes_down -= 5000;
									  
#ifdef DEBUG
	fprintf( stdout, "  part 3\n" );
#endif	
		
	user[ num_users ].transfers = uf.files_up_wk + uf.files_down_wk;
	user[ num_users ].uploads = uf.files_up_wk;
	user[ num_users ].downloads = uf.files_down_wk;
	user[ num_users ].total_time = uf.seconds_up_wk + uf.seconds_down_wk;
	user[ num_users ].total_uptime = uf.seconds_up_wk;
	user[ num_users ].total_downtime = uf.seconds_down_wk;
									  
#ifdef DEBUG
	fprintf( stdout, "  part 4\n" );
#endif	
	
   if ( user[ num_users ].total_uptime != 0L )
   	user[ num_users ].upspeed = (double)((double)(user[ num_users ].bytes_up) / (double)(user[ num_users ].total_uptime));
   if ( user[ num_users ].total_downtime != 0L )
      user[ num_users ].downspeed = (double)((double)(user[ num_users ].bytes_down) / (double)(user[ num_users ].total_downtime));

	num_users++;
									  
#ifdef DEBUG
	fprintf( stdout, "  leaving...\n" );
#endif
	
   return;
}
/*-- end of uf_into_user_wk() --------------------------------------------*/

/***************************************************************************
	UF_INTO_USER_MONTH
***************************************************************************/

void 
uf_into_user_month( void )
{											
#ifdef DEBUG
	fprintf( stdout, "uf_into_user_month()\n" );
#endif	

	if ( num_users >= NUM_USERS )
		return;

#ifdef DEBUG
	fprintf( stdout, "  part 1 (%s)\n", uf.name );
#endif	

	memcpy( user[ num_users ].username, uf.name, sizeof( user[num_users].username) );
	memcpy( user[ num_users ].tagline, uf.tagline, sizeof( user[num_users].tagline ) );
	if ( uf.tagline[ 0 ] == '\0' || strcmp( uf.tagline, DEFAULT_TAGLINE ) == 0 )
		bzero( user[ num_users ].tagline, sizeof( user[num_users].tagline ) );
	user[ num_users ].bytes_up = uf.bytes_up_month;
	user[ num_users ].bytes_down = uf.bytes_down_month;
									  
#ifdef DEBUG
	fprintf( stdout, "  part 2\n" );
#endif	
	
	if ( user[ num_users ].bytes_down > 5000 )
		user[ num_users ].bytes_down -= 5000;
									  
#ifdef DEBUG
	fprintf( stdout, "  part 3\n" );
#endif	
		
	user[ num_users ].transfers = uf.files_up_month + uf.files_down_month	;
	user[ num_users ].uploads = uf.files_up_month;
	user[ num_users ].downloads = uf.files_down_month;
	user[ num_users ].total_time = uf.seconds_up_month + uf.seconds_down_month;
	user[ num_users ].total_uptime = uf.seconds_up_month;
	user[ num_users ].total_downtime = uf.seconds_down_month;
									  
#ifdef DEBUG
	fprintf( stdout, "  part 4\n" );
#endif	
	
   if ( user[ num_users ].total_uptime != 0L )
   	user[ num_users ].upspeed = (double)((double)(user[ num_users ].bytes_up) / (double)(user[ num_users ].total_uptime));
   if ( user[ num_users ].total_downtime != 0L )
      user[ num_users ].downspeed = (double)((double)(user[ num_users ].bytes_down) / (double)(user[ num_users ].total_downtime));

	num_users++;
									  
#ifdef DEBUG
	fprintf( stdout, "  leaving...\n" );
#endif
	
   return;
}
/*-- end of uf_into_user_wk() --------------------------------------------*/
/***************************************************************************
	UF_INTO_USER_DAY
***************************************************************************/

void 
uf_into_user_day( void )
{											
#ifdef DEBUG
	fprintf( stdout, "uf_into_user_day()\n" );
#endif	

	if ( num_users >= NUM_USERS )
		return;

#ifdef DEBUG
	fprintf( stdout, "  part 1 (%s)\n", uf.name );
#endif	

	memcpy( user[ num_users ].username, uf.name, sizeof( user[num_users].username) );
	memcpy( user[ num_users ].tagline, uf.tagline, sizeof( user[num_users].tagline ) );
	if ( uf.tagline[ 0 ] == '\0' || strcmp( uf.tagline, DEFAULT_TAGLINE ) == 0 )
		bzero( user[ num_users ].tagline, sizeof( user[num_users].tagline ) );
	user[ num_users ].bytes_up = uf.bytes_up_day;
	user[ num_users ].bytes_down = uf.bytes_down_day;
									  
#ifdef DEBUG
	fprintf( stdout, "  part 2\n" );
#endif	
	
	if ( user[ num_users ].bytes_down > 5000 )
		user[ num_users ].bytes_down -= 5000;
									  
#ifdef DEBUG
	fprintf( stdout, "  part 3\n" );
#endif	
		
	user[ num_users ].transfers = uf.files_up_day + uf.files_down_day;
	user[ num_users ].uploads = uf.files_up_day;
	user[ num_users ].downloads = uf.files_down_day;
	user[ num_users ].total_time = uf.seconds_up_day + uf.seconds_down_day;
	user[ num_users ].total_uptime = uf.seconds_up_day;
	user[ num_users ].total_downtime = uf.seconds_down_day;
									  
#ifdef DEBUG
	fprintf( stdout, "  part 4\n" );
#endif	
	
   if ( user[ num_users ].total_uptime != 0L )
   	user[ num_users ].upspeed = (double)((double)(user[ num_users ].bytes_up) / (double)(user[ num_users ].total_uptime));
   if ( user[ num_users ].total_downtime != 0L )
      user[ num_users ].downspeed = (double)((double)(user[ num_users ].bytes_down) / (double)(user[ num_users ].total_downtime));

	num_users++;
									  
#ifdef DEBUG
	fprintf( stdout, "  leaving...\n" );
#endif
	
   return;
}
/*-- end of uf_into_user_day() --------------------------------------------*/


/***************************************************************************
	BUILD_ALLTIME_INFO
***************************************************************************/

int 
build_alltime_info( void )
{
	DIR    *dirf;
	struct dirent *dn;
	struct stat st;
	char   temppath[ MAXPATHLEN + 1 ];
	
#ifdef DEBUG
	fprintf( stdout, "build_alltime_info()\n" );
#endif	
		            
   sprintf( temppath, "%s/users", cf.datapath );
	dirf = opendir( temppath );
	if ( !dirf )
	{
		fprintf( stderr, "error reading dir \"%s\": %s\n", temppath, strerror( errno ) );
		return 1;
	}

   clear_users();

   while ( 1 )
   {
		dn = readdir( dirf );
		if ( !dn )
			break;		  
			
		sprintf( temppath, "%s/users/%s", cf.datapath, dn->d_name );

		stat( temppath, &st );
		
		if ( temppath[ strlen( temppath ) ] == '~' )
			continue;
		
		if ( S_ISREG( st.st_mode ) ) 
		{
			clear_uf_struct();
			load_userfile( dn->d_name );
			uf_into_user();
		}
   }

  	(void)closedir( dirf );	

   return 0;
}
/*-- end of build_alltime_info() -----------------------------------------*/



/***************************************************************************
	BUILD_WEEKLY_INFO
***************************************************************************/

int 
build_weekly_info(void)
{
	DIR *dirf;
	struct dirent *dn;
	struct stat st;
	char temppath[MAXPATHLEN + 1];

#ifdef DEBUG
	fprintf(stdout, "build_weekly_info()\n");
#endif

	sprintf(temppath, "%s/users", cf.datapath);
	dirf = opendir(temppath);
	if (!dirf) {
		fprintf(stderr, "error reading dir \"%s\": %s\n",
				temppath, strerror(errno));
		return 1;
	}

	clear_users();

	while (1) {
		dn = readdir(dirf);
		if (!dn) {
			break;
		}
		sprintf(temppath, "%s/users/%s", cf.datapath, dn->d_name);
		stat(temppath, &st);
		if (temppath[strlen(temppath)] == '~')
			continue;

		if (S_ISREG(st.st_mode)) {
			clear_uf_struct();
			load_userfile(dn->d_name);
			if (uf.last_on >= weekstart())
				uf_into_user_wk();
		}
	}


	if (dirf)
		(void) closedir(dirf);


	return 0;
}
/*-- end of build_weekly_info() ------------------------------------------*/

/***************************************************************************
	BUILD_DAILY_INFO
***************************************************************************/

int 
build_daily_info(void)
{
	DIR *dirf;
	struct dirent *dn;
	struct stat st;
	char temppath[MAXPATHLEN + 1];

#ifdef DEBUG
	fprintf(stdout, "build_daily_info()\n");
#endif

	sprintf(temppath, "%s/users", cf.datapath);
	dirf = opendir(temppath);
	if (!dirf) {
		fprintf(stderr, "error reading dir \"%s\": %s\n",
				temppath, strerror(errno));
		return 1;
	}

	clear_users();

	while (1) {
		dn = readdir(dirf);
		if (!dn) {
			break;
		}
		sprintf(temppath, "%s/users/%s", cf.datapath, dn->d_name);
		stat(temppath, &st);
		if (temppath[strlen(temppath)] == '~')
			continue;

		if (S_ISREG(st.st_mode)) {
			clear_uf_struct();
			load_userfile(dn->d_name);
			if (uf.last_on >= daystart())
				uf_into_user_day();
		}
	}


	if (dirf)
		(void) closedir(dirf);


	return 0;
}
/*-- end of build_daily_info() ------------------------------------------*/

/***************************************************************************
	BUILD_MONTHLY_INFO
***************************************************************************/

int 
build_monthly_info(void)
{
	DIR *dirf;
	struct dirent *dn;
	struct stat st;
	char temppath[MAXPATHLEN + 1];

#ifdef DEBUG
	fprintf(stdout, "build_weekly_info()\n");
#endif

	sprintf(temppath, "%s/users", cf.datapath);
	dirf = opendir(temppath);
	if (!dirf) {
		fprintf(stderr, "error reading dir \"%s\": %s\n",
				temppath, strerror(errno));
		return 1;
	}

	clear_users();

	while (1) {
		dn = readdir(dirf);
		if (!dn) {
			break;
		}
		sprintf(temppath, "%s/users/%s", cf.datapath, dn->d_name);
		stat(temppath, &st);
		if (temppath[strlen(temppath)] == '~')
			continue;

		if (S_ISREG(st.st_mode)) {
			clear_uf_struct();
			load_userfile(dn->d_name);
			if (uf.last_on >= monthstart())
				uf_into_user_month();
		}
	}


	if (dirf)
		(void) closedir(dirf);


	return 0;
}
/*-- end of build_weekly_info() ------------------------------------------*/


						  
/***************************************************************************
	PRINT_TOTALS
	(for future expansion or whatnot)
***************************************************************************/

void 
print_totals( void )
{
   fprintf( message, "\n" );  
}
/*-- end of print_totals() -----------------------------------------------*/



/***************************************************************************
	LOAD_USERGROUPS
	Loads group data from "<cf.datapath>/groups.user"
***************************************************************************/

void 
load_usergroups( void )
{
	char *comment;
  	char *tokptr;
   FILE *groupfile;
   int  x;
	char linebuf[ BUFSIZ ];
	char fname_buff[ MAXPATHLEN+1 ];
  	uid_t oldid = geteuid();
	
	/*
	 * Clear groups:
	 */
	for ( x = 0; x < 40; x++ )
		bzero( usergroup[ x ], sizeof( usergroup[ x ] ) ); 
				  
	/*
	 * Open the groupfile
	 */		 
	seteuid( 0 );
   sprintf( fname_buff, "%s/groups.user", cf.datapath );
   if ( ( groupfile = fopen( fname_buff, "r" ) ) == NULL )
	{									
		seteuid( oldid );
      return;
	}
									
	/*
	 * Read lines one at a time and fill in struct
	 */
   while ( 1 )
   {
      if ( fgets( linebuf, sizeof( linebuf ), groupfile ) == NULL )
      {				 
         fclose( groupfile );
			seteuid( oldid );
         return;
      }
				 						  
		/*
		 * Clip out comments, they'll eventually be lost anyway :)
		 */
		if ( ( comment = strchr( linebuf, '#' ) ) != NULL )
			*comment = '\0';

		/*
		 * Trim the buffer 
		 */					
		(void)trim( linebuf ); 

		if ( !isalpha( linebuf[ 0 ] ) )
			continue;
		for ( x = 0; x < 40 && usergroup[x][0] != '\0'; x++ )
			;

  		tokptr = strtok (linebuf, " ");
		if ( tokptr )
			strncpy( usergroup[x], tokptr, sizeof( usergroup[x] ) );
		else
			continue;
				 
		strcpy( usergroup_desc[x], "\0" );
	  	tokptr = strtok ('\0', " ");
		while ( tokptr )
		{
			if ( usergroup_desc[0] != '\0' )
				strcat( usergroup_desc[x], " " );
			strcat( usergroup_desc[x], tokptr );
	  		tokptr = strtok ('\0', " ");
		}
   }

	seteuid( oldid );
   return;
}
/*-- end of load_usergroups() --------------------------------------------*/
						


/***************************************************************************
	LOAD_PRIVGROUPS
	Loads group data from "<cf.datapath>/groups.priv"
***************************************************************************/

void 
load_privgroups( void )
{
	char *comment;
   FILE *groupfile;  
	char *tokptr;
   int  x;
	char linebuf[ BUFSIZ ];
	char fname_buff[ MAXPATHLEN+1 ];
  	uid_t oldid = geteuid();
	
	/*
	 * Clear groups:
	 */				 
	for ( x = 0; x < 20; x++ )
		bzero( privgroup[ x ], sizeof( privgroup[ x ] ) ); 
				  
	/*
	 * Open the groupfile
	 */		 
	seteuid( 0 );
   sprintf( fname_buff, "%s/groups.priv", cf.datapath );
   if ( ( groupfile = fopen( fname_buff, "r" ) ) == NULL )
	{									
		seteuid( oldid );
      return;
	}
									
	/*
	 * Read lines one at a time and fill in struct
	 */
   while ( 1 )
   {
      if ( fgets( linebuf, sizeof( linebuf ), groupfile ) == NULL )
      {				 
         fclose( groupfile );
			seteuid( oldid );
         return;
      }
				 						  
		/*
		 * Clip out comments, they'll eventually be lost anyway :)
		 */
		if ( ( comment = strchr( linebuf, '#' ) ) != NULL )
			*comment = '\0';
										
		/*
		 * Trim the buffer 
		 */					
		(void)trim( linebuf ); 
											 
		if ( !isalpha( linebuf[ 0 ] ) )
			continue;
					
		for ( x = 0; x < 20 && privgroup[x][0] != '\0'; x++ )
			;
						
  		tokptr = strtok (linebuf, " ");
		if ( tokptr )
			strncpy( privgroup[x], tokptr, sizeof( privgroup[x] ) );
		else
			continue;
			
		strcpy( privgroup_desc[x], "\0" );
	  	tokptr = strtok ('\0', " ");
		while ( tokptr )
		{
			if ( privgroup_desc[0] != '\0' )
				strcat( privgroup_desc[x], " " );
			strcat( privgroup_desc[x], tokptr );
	  		tokptr = strtok ('\0', " ");
		}
   }
									
	seteuid( oldid );
   return;
}
/*-- end of load_privgroups() --------------------------------------------*/



/***************************************************************************
	LOAD_GROUPS
	Loads group data from <cf.datapath>/groups.user and <cf.datapath>/groups.priv
***************************************************************************/

void
load_groups( void )
{
	load_privgroups();
	load_usergroups();

	return;
}
/*-- end of load_groups() ------------------------------------------------*/




/****************************************************************************
    CLEAR_GROUP
	 Clears group stats in a given array slot.
****************************************************************************/
										
void
clear_group( int which )
{
	bzero( group[which].name, sizeof( group[which].name ) );
	group[which].members = 0;
	group[which].files_up = 0;
	group[which].bytes_up = 0UL;
	group[which].files_up_wk = 0;
	group[which].bytes_up_wk = 0UL;
						  
	return;
}
/*--- end of clear_group() -----------------------------------------------*/



/****************************************************************************
	UPDATE_GROUP
	Looks at uf.group_user[0] and adds the current values in 'uf' to the 
	group array.
****************************************************************************/

void
update_group( void )
{
	int ct;

	for ( ct = 0; ct <= num_groups; ct++ )
	{
		if ( ct == num_groups )
		{
			/* Add a new group */
			clear_group( ct );
			
			strcpy( group[ct].name, uf.group_user[0] );
			group[ct].members = 1;
			group[ct].files_up = uf.files_up;
			group[ct].bytes_up = uf.bytes_up;

                        
                        if ( uf.last_on >= daystart() )
                        {
                                group[ct].files_up_day = uf.files_up_day;
                                group[ct].bytes_up_day = uf.bytes_up_day;
			}
			

                        
                        if ( uf.last_on >= monthstart() )
                        {
                                group[ct].files_up_month = uf.files_up_month;
                                group[ct].bytes_up_month = uf.bytes_up_month;
			}

			if ( uf.last_on >= weekstart() )
			{
				group[ct].files_up_wk = uf.files_up_wk;
				group[ct].bytes_up_wk = uf.bytes_up_wk;
			}
			
			num_groups++;
			return;
		}
		else if ( !strcasecmp( group[ct].name, uf.group_user[0] ) )
		{
			/* Update this group */
			group[ct].members++;
			group[ct].files_up += uf.files_up;
			group[ct].bytes_up += uf.bytes_up;
			
			if ( uf.last_on >= weekstart() )
			{
				group[ct].files_up_wk += uf.files_up_wk;
				group[ct].bytes_up_wk += uf.bytes_up_wk;
			}
			
                        if ( uf.last_on >= daystart() )
                        {
                                group[ct].files_up_day = uf.files_up_day;
                                group[ct].bytes_up_day = uf.bytes_up_day;
                        }
                                                        
                        if ( uf.last_on >= monthstart() )
                        {
                                group[ct].files_up_month = uf.files_up_month;
                                group[ct].bytes_up_month = uf.bytes_up_month;
                        }
			return;
		}
	}
}
/*-- end of update_group() -----------------------------------------------*/


/***************************************************************************
	QS_LIST_GUP_ALLTIME
***************************************************************************/

void 
qs_list_gup_alltime( struct GROUP item[], int left, int right )
{
   register int i;
   register int j;
   double x;
   struct GROUP temp;
										  
   i = left;
   j = right;
   x = item[ ( left + right ) / 2 ].bytes_up;

   do
   {
      while ( item[ i ].bytes_up > x && i < right )
         i++;
      while ( item[ j ].bytes_up < x && j > left )
         j--;
      if ( i <= j )
      {
         temp = item[ i ];
         item[ i ] = item[ j ];
         item[ j ] = temp;
         i++;
         j--;
      }
   } while ( i <= j );

   if ( left < j )
      qs_list_gup_alltime( item, left, j );

   if ( i < right )
      qs_list_gup_alltime( item, i, right );
}
/*-- end of qs_list_gup_alltime() ------------------------------------------*/
											 	 


/***************************************************************************
	QS_LIST_GUP_WEEKLY
***************************************************************************/

void 
qs_list_gup_weekly( struct GROUP item[], int left, int right )
{
   register int i;
   register int j;
   double x;
   struct GROUP temp;
										  
   i = left;
   j = right;
   x = item[ ( left + right ) / 2 ].bytes_up_wk;

   do
   {
      while ( item[ i ].bytes_up_wk > x && i < right )
         i++;
      while ( item[ j ].bytes_up_wk < x && j > left )
         j--;
      if ( i <= j )
      {
         temp = item[ i ];
         item[ i ] = item[ j ];
         item[ j ] = temp;
         i++;
         j--;
      }
   } while ( i <= j );

   if ( left < j )
      qs_list_gup_weekly( item, left, j );

   if ( i < right )
      qs_list_gup_weekly( item, i, right );
}
/*-- end of qs_list_gup_weekly() -------------------------------------------*/
		  

/****************************************************************************
	OUTPUT_GROUPTOPS_ALLTIME
	Outputs group tops list (to /usr/.phear/grouptops.alltime)
****************************************************************************/
			
void
output_grouptops_alltime( void )
{
	FILE *fp;
	int  ct;
	int  x; 
	int  found = -1;
	
	fp = fopen( "/usr/.phear/stats/grouptop", "w" );
	if ( fp == NULL )	  
		return;			  
																						 
	for ( ct = 0; ct < num_groups && ct < 5; ct++ )
	{
		for ( x = 0; x < 40 && usergroup[x][0] != '\0'; x++ )
		{
			if ( !strcasecmp( group[ct].name, usergroup[x] ) )
			{
				found = x;
				break;
			}
		}
#ifdef VDR
		if ( found < 0 )
			fprintf( fp, "!h!5 %2d %-10.10s %-32.32s %6d %10.1fMb %3d  !0\n",
                  ct+1, group[ct].name,"",group[ct].files_up,
                  (double)( group[ct].bytes_up / 1024.0 ), group[ct].members);
		else
			fprintf( fp, "!h!5 %2d %-10.10s %-32.32s %7d %10.1fMb %2d !0\n",
                  ct+1, usergroup[found],usergroup_desc[found],group[ct].files_up,
                  (double)( group[ct].bytes_up / 1024.0 ), group[ct].members);
	}
#else	
		if ( found < 0 )
			fprintf( fp, "!G[!g%2d!G] !D%-10.10s !E%-39.39s !G%4d %5.0fMb !g%3d !0\n",
                  ct+1, group[ct].name,"",group[ct].files_up,
                  (double)( group[ct].bytes_up / 1024.0 ), group[ct].members);
		else
			fprintf( fp, "!G[!g%2d!G] !D%-10.10s !E%-39.39s !G%4d %5.0fMb !g%3d !0\n",
                  ct+1, usergroup[found],usergroup_desc[found],group[ct].files_up,
                  (double)( group[ct].bytes_up / 1024.0 ), group[ct].members);
	}
#endif	
	fclose( fp );
}									 
/*-- end of output_grouptops_alltime() -----------------------------------*/
	 

/****************************************************************************
	OUTPUT_GROUPTOPS_WEEKLY
	Outputs group tops list (to /usr/.phear/grouptops.weekly)
****************************************************************************/
			
void
output_grouptops_weekly( void )
{
	FILE *fp;
	int  ct; 
	int x;
	int found = -1;
	
	fp = fopen( "/usr/.phear/stats/wkgrouptop", "w" );
	if ( fp == NULL )
		return;
																						 
	for ( ct = 0; ct < num_groups && ct < 5; ct++ )
	{
		for ( x = 0; x < 40 && usergroup[x][0] != '\0'; x++ )
			if ( !strcasecmp( group[ct].name, usergroup[x] ) )
			{
				found = x;
				break;
			}
#ifdef VDR
		if ( found < 0 )
			fprintf( fp, "!h!5 %2d %-10.10s %-33.33s %6d %10.0fMb %2d !0\n",
      	         ct+1, group[ct].name,"",group[ct].files_up_wk,
         	      (double)( group[ct].bytes_up_wk / 1024.0 ), group[ct].members);
		else
			fprintf( fp, "!h!5 %2d %-10.10s %-33.33s %6d %10.0fMb %2d !0\n",
                  ct+1, usergroup[found],usergroup_desc[found],group[ct].files_up_wk,
                  (double)( group[ct].bytes_up_wk / 1024.0 ), group[ct].members);
	}
#else
	
		if ( found < 0 )
			fprintf( fp, "!G[!g%2d!G] !D%-10.10s !E%-39.39s !G%4d %5.0fMb !g%3d !0\n",
      	         ct+1, group[ct].name,"",group[ct].files_up_wk,
         	      (double)( group[ct].bytes_up_wk / 1024.0 ), group[ct].members);
		else
			fprintf( fp, "!G[!g%2d!G] !D%-10.10s !E%-39.39s !G%4d %5.0fMb !g%3d !0\n",
                  ct+1, usergroup[found],usergroup_desc[found],group[ct].files_up_wk,
                  (double)( group[ct].bytes_up_wk / 1024.0 ), group[ct].members);
	}
#endif
	fclose( fp );
}									 
/*-- end of output_grouptops_weekly() ------------------------------------*/

	

/***************************************************************************
	ACCUM_STATS
	Reads all userfiles, taking the FIRST entry for group_user and adding 
	that user's stats to the group entry.
***************************************************************************/
										
void
accum_stats( void )
{
	char   temppath[ MAXPATHLEN ];
  	char   username[ MAXPATHLEN ];
	char   tempbuf[ BUFSIZ ];
	char   *dotptr;
  	DIR    *dirf;
  	struct dirent *dn;
  	struct stat st;
	int    ct;
	
  	sprintf (temppath, "/usr/.phear/users" );
  	dirf = opendir (temppath);
  	if (!dirf)
   {	  																			  
		/* Error opening directory?? */
		fprintf( stderr, "grouptop: error opening dir '%s': %s\n", temppath, strerror( errno ) );
      return;
   }
	
  	while (1)
   {
      dn = readdir (dirf);
      if (!dn)
			break;

      sprintf (temppath, "/usr/.phear/users/%s", dn->d_name);

      strncpy (username, dn->d_name, sizeof (username));

      stat (temppath, &st);

      if ( S_ISREG (st.st_mode) && st.st_uid != 99 && st.st_gid != 99 )
		{
		  	if ((dotptr = strchr (username, '.')) != NULL)
	   		*dotptr = '\0';
   		sprintf (tempbuf, " %-8.8s ", username);
			load_userfile( username );
			
			if ( uf.group_user[0][0] != '\0' )
			{
				/* User is in a group! */
				/* update_group knows where to get the info & where to put it */
				update_group();
			}
		}
	}

  	(void) closedir (dirf);
}
/*-- end of accum_stats() ------------------------------------------------*/


/***************************************************************************
	MAIN
***************************************************************************/

int
main( )
{     
   char tempname[ MAXPATHLEN+1 ];
        struct tm *ptr;
        time_t timenow = time (NULL);
   char buff[BUFSIZ];
   int quiet = 0;
   char tempname2[ MAXPATHLEN+1 ];
   
	load_sysconfig();  
	clear_users();

	num_users = 0;
	if ( build_weekly_info() != 0 )
	{
	   	fprintf( stderr, "stats: error building alltime list\n" );
		fclose( message );
		return 1;
	}
	   
	if ( num_users != 0 )
		qs_list_up( user, 0, num_users - 1 );
        ptr = localtime (&timenow);
        strftime (buff, 64, "%m-%d-%Y.weekup", ptr);

	sprintf( tempname, "%s/stats/weekly/%s", cf.datapath, buff );
	if ( ( message = fopen( tempname, "w" ) ) == NULL )
	{
		fprintf( stderr, "stats: unable to open '%s': %s\n", tempname, strerror(errno) );
		fclose( xferlog );
		return 1;
	}
	print_up();			
	fclose( message );
        sprintf( tempname2, "%s/stats/weekup", cf.datapath  );
        link(tempname, tempname2);
	if ( num_users != 0 )
		qs_list_down( user, 0, num_users - 1 );
        ptr = localtime (&timenow);
        strftime (buff, 64, "%m-%d-%Y.weekdown", ptr);
	sprintf( tempname, "%s/stats/weekly/%s", cf.datapath, buff );
	if ( ( message = fopen( tempname, "w" ) ) == NULL )
	{
		fprintf( stderr, "stats: unable to open '%s': %s\n", tempname, strerror(errno) );
		fclose( xferlog );
		return 1;
	}  
   
	print_down();
	fclose( message );
        sprintf( tempname2, "%s/stats/weekdown", cf.datapath  );
        link(tempname, tempname2);
	clear_users();

/* Daily */

	num_users = 0;
	if ( build_daily_info() != 0 )
	{
	   	fprintf( stderr, "stats: error building daily list\n" );
		fclose( message );
		return 1;
	}
	   
	if ( num_users != 0 )
		qs_list_up( user, 0, num_users - 1 );
        ptr = localtime (&timenow);
        strftime (buff, 64, "%m-%d-%Y.dayup", ptr);

	sprintf( tempname, "%s/stats/daily/%s", cf.datapath, buff );
	if ( ( message = fopen( tempname, "w" ) ) == NULL )
	{
		fprintf( stderr, "stats: unable to open '%s': %s\n", tempname, strerror(errno) );
		fclose( xferlog );
		return 1;
	}
	print_up();			
	fclose( message );
        sprintf( tempname2, "%s/stats/dayup", cf.datapath );
        link(tempname, tempname2);
	if ( num_users != 0 )
		qs_list_down( user, 0, num_users - 1 );
        ptr = localtime (&timenow);
        strftime (buff, 64, "%m-%d-%Y.daydown", ptr);
	sprintf( tempname, "%s/stats/daily/%s", cf.datapath, buff );
	if ( ( message = fopen( tempname, "w" ) ) == NULL )
	{
		fprintf( stderr, "stats: unable to open '%s': %s\n", tempname, strerror(errno) );
		fclose( xferlog );
		return 1;
	}  
   
	print_down();
	fclose( message );
        sprintf( tempname2, "%s/stats/daydown", cf.datapath  );
        link(tempname, tempname2);
	clear_users();

/* Monthly */
	num_users = 0;
	if ( build_monthly_info() != 0 )
	{
	   	fprintf( stderr, "stats: error building alltime list\n" );
		fclose( message );
		return 1;
	}
	   
	if ( num_users != 0 )
		qs_list_up( user, 0, num_users - 1 );
        ptr = localtime (&timenow);
        strftime (buff, 64, "%m-%d-%Y.monthup", ptr);

	sprintf( tempname, "%s/stats/monthly/%s", cf.datapath, buff );
	if ( ( message = fopen( tempname, "w" ) ) == NULL )
	{
		fprintf( stderr, "stats: unable to open '%s': %s\n", tempname, strerror(errno) );
		fclose( xferlog );
		return 1;
	}
	print_up();			
	fclose( message );
        sprintf( tempname2, "%s/stats/monthup", cf.datapath  );
        link(tempname, tempname2);
	if ( num_users != 0 )
		qs_list_down( user, 0, num_users - 1 );
        ptr = localtime (&timenow);
        strftime (buff, 64, "%m-%d-%Y.monthdown", ptr);
	sprintf( tempname, "%s/stats/monthly/%s", cf.datapath, buff );
	if ( ( message = fopen( tempname, "w" ) ) == NULL )
	{
		fprintf( stderr, "stats: unable to open '%s': %s\n", tempname, strerror(errno) );
		fclose( xferlog );
		return 1;
	}  
   
	print_down();
	fclose( message );
        sprintf( tempname2, "%s/stats/monthdown", cf.datapath  );
        link(tempname, tempname2);
	clear_users();

/* Alltime */
	num_users = 0;
	if ( build_alltime_info() != 0 )
	{
		fprintf( stderr, "stats: error building alltime list\n" );
		fclose( message );
		return 1;
	}
   
	if ( num_users != 0 )
		qs_list_up( user, 0, num_users - 1 );
        ptr = localtime (&timenow);
        strftime (buff, 64, "%m-%d-%Y.allup", ptr);
	sprintf( tempname, "%s/stats/alltime/%s", cf.datapath, buff );
	if ( ( message = fopen( tempname, "w" ) ) == NULL )
	{
		fprintf( stderr, "stats: unable to open '%s': %s\n", tempname, strerror(errno) );
		fclose( xferlog );
		return 1;
	}
	print_up();
	fclose( message );
	sprintf( tempname2, "%s/stats/allup", cf.datapath  );
	link(tempname, tempname2);
	if ( num_users != 0 )
		qs_list_down( user, 0, num_users - 1 );
        strftime (buff, 64, "%m-%d-%Y.alldown", ptr);
	sprintf( tempname, "%s/stats/alltime/%s", cf.datapath, buff );
	if ( ( message = fopen( tempname, "w" ) ) == NULL )
	{
		fprintf( stderr, "stats: unable to open '%s': %s\n", tempname, strerror(errno) );
		fclose( xferlog );
		return 1;
	}
	print_down();
	fclose( message );
        sprintf( tempname2, "%s/stats/alldown", cf.datapath );
        link(tempname, tempname2);
	num_groups = 0;
	load_groups();
	accum_stats();


        if ( num_groups != 0 )
                qs_list_gup_alltime( group, 0, num_groups - 1 );
        output_grouptops_alltime();

        if ( num_groups != 0 )
                qs_list_gup_weekly( group, 0, num_groups - 1 );

        output_grouptops_weekly();
   return 0;   
}
