/* Heh yea right... this don work a bit. */
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <syslog.h>
#include <linux/unistd.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ctype.h>
#include "../include/userfile.h"
#include "../include/sysconfig.h"


/***************************************************************************
	TRIM
***************************************************************************/

char *
trim( char *str )
{
	char *ibuf;
	char *obuf;

   if ( str )
   {
   	for ( ibuf = obuf = str; *ibuf; )
      {
        	while ( *ibuf && ( isspace ( *ibuf ) ) )
         	ibuf++;
        	if ( *ibuf && ( obuf != str ) )
            *( obuf++ ) = ' ';
        	while ( *ibuf && ( !isspace ( *ibuf ) ) )
            *( obuf++ ) = *( ibuf++ );
      }
      *obuf = '\0';
   }
   return( str );
}
/*-- end of trim() -------------------------------------------------------*/

/***************************************************************************
	CLEAR_CONFIG_STRUCT
***************************************************************************/
												
void
clear_config_struct( void )
{						 
	/* Set default configuration values */
	strncpy( config.datapath, "/.ftp-data", sizeof( config.datapath ) );
	config.max_users = 15;
	config.tag_file[ 0 ] = '\0';
	config.welcome_msg[ 0 ] = '\0';
	config.show_diz = 1;
	config.default_ratio = 6;
	config.free_ratio_amount = (ulong)51200000L;
	config.dupe_check_days = 7;
	strncpy( config.default_restrict, "/tmp", sizeof( config.default_restrict ) );
	strncpy( config.default_tagline, "I love bleach-ftpd!", sizeof( config.default_restrict ) );
	config.default_num_logins = 2;
	config.default_level = 1;
	config.caps_first_letter = 0;
	strncpy( config.email, "[UNKNOWN]", sizeof( config.email ) );
	config.banner[ 0 ] = '\0';
	strncpy( config.sitename, "UNKNOWN", sizeof( config.email ) );
	strncpy( config.dividerline, "--=-------------------------------------------------------------------=--", sizeof( config.dividerline ) );
   config.show_newsfile = 1;
}
/*-- end of clear_config_struct() ----------------------------------------*/


/***************************************************************************
	SYSCONFIG_PARSEVAL
***************************************************************************/

void 
sysconfig_parseval( char *lvalue, char *rvalue )
{
   /* Here we parse all values */
   if ( strcasecmp( lvalue, "datapath" ) == 0 )
   {
		strncpy( config.datapath, rvalue, sizeof( config.datapath ) );
      return;
   }
   
   if ( strcasecmp( lvalue, "max_users" ) == 0 )
   {												 
		config.max_users = atoi( rvalue );
      return;
   }

   if ( strcasecmp( lvalue, "tag_file" ) == 0 )
   {
		strncpy( config.tag_file, rvalue, sizeof( config.tag_file ) );
      return;
   }

   if ( strcasecmp( lvalue, "welcome_msg" ) == 0 )
   {
		strncpy( config.welcome_msg, rvalue, sizeof( config.welcome_msg ) );
      return;
   }
	
   if ( strcasecmp( lvalue, "show_diz" ) == 0 )
   {											 
		config.show_diz = atoi( rvalue );
		if ( config.show_diz != 0 && config.show_diz != 1 )
			config.show_diz = 1;  			/* Default */
      return;
   }	  
	
   if ( strcasecmp( lvalue, "default_ratio" ) == 0 )
   {											 
		config.default_ratio = atoi( rvalue );
      return;
   }										 
	
   if ( strcasecmp( lvalue, "free_ratio_amount" ) == 0 )
   {											 
      config.free_ratio_amount = strtoul( rvalue, (char **)NULL, 0 );
      return;
   }										 		 
	
   if ( strcasecmp( lvalue, "dupe_check_days" ) == 0 )
   {											 
      config.dupe_check_days = atoi( rvalue );
      return;
   }
	
   if ( strcasecmp( lvalue, "default_restrict" ) == 0 )
   {								  
		strncpy( config.default_restrict, rvalue, sizeof( config.default_restrict ) );
      return;
   }										 
	
   if ( strcasecmp( lvalue, "default_tagline" ) == 0 )
   {											 
		strncpy( config.default_tagline, rvalue, sizeof( config.default_tagline ) );
      return;
   }			 
	
   if ( strcasecmp( lvalue, "default_num_logins" ) == 0 )
   {											 
		config.default_num_logins = atoi( rvalue );
      return;
   }									 
	
   if ( strcasecmp( lvalue, "default_level" ) == 0 )
   {											 
		config.default_level = atoi( rvalue );
      return;
   }
	
   if ( strcasecmp( lvalue, "caps_first_letter" ) == 0 )
   {											   
		config.caps_first_letter = atoi( rvalue );
      return;
   }

   if ( strcasecmp( lvalue, "email" ) == 0 )
   {											 
		strncpy( config.email, rvalue, sizeof( config.email ) );
      return;
   }

   if ( strcasecmp( lvalue, "banner" ) == 0 )
   {								  
		strncpy( config.banner, rvalue, sizeof( config.banner ) );
      return;
   }										
	
   if ( strcasecmp( lvalue, "sitename" ) == 0 )
   {								  
		strncpy( config.sitename, rvalue, sizeof( config.sitename ) );
      return;
   }
   
   if ( strcasecmp( lvalue, "dividerline" ) == 0 )
   {
		strncpy( config.dividerline, rvalue, sizeof( config.dividerline ) );
      return;
   }
   
   if ( strcasecmp( lvalue, "show_newsfile" ) == 0 )
   {											 
		config.show_newsfile = atoi( rvalue );
      return;
   }										 
}
/*-- end of sysconfig_parseval() ------------------------------------------*/



/***************************************************************************
	LOAD_SYSCONFIG
***************************************************************************/

void 
load_sysconfig( void )
{
   FILE *configfile;
   char lvalue[ 64 ];
   char rvalue[ MAXPATHLEN ];
   int  x, y;
	char work_buff[ MAXPATHLEN ];

   clear_config_struct();

   sprintf( work_buff, "/etc/phear.conf" );

   if ( ( configfile = fopen( work_buff, "r" ) ) == NULL )
	{
		fprintf( stderr, "bad or missing '/etc/phear.conf', using defaults\n" );
      return;
	}

   while ( 1 )
   {
      if ( fgets( work_buff, sizeof( work_buff ), configfile ) == NULL )
      {
         fclose( configfile );
         return;
      }

      /* Clip out comments */
      for ( x = 0; x < strlen( work_buff ); x++ )
         if ( work_buff[ x ] == '#' )
            work_buff[ x ] = '\0';
				
		/* Trim */
		(void)trim( work_buff );
      
      /* Clear out old values */
      memset( lvalue, '\0', sizeof( lvalue ) );
      memset( rvalue, '\0', sizeof( rvalue ) );
													 
		/* The file allows spaces embedded, but clears leading & trailing 
			spaces */
		
      /* Parse lvalue */
      y = 0;
      for ( x = 0; x < strlen( work_buff ) && work_buff[ x ] != ' '; x++ )
         if ( isprint( work_buff[ x ] ) )
            lvalue[ y++ ] = work_buff[ x ];

      /* Parse rvalue */
      y = 0; x++;
      for ( ; x < strlen( work_buff ); x++ )
         if ( isprint( work_buff[ x ] ) )
            rvalue[ y++ ] = work_buff[ x ];

      sysconfig_parseval( lvalue, rvalue );
   }

   return;
}
/*-- end of load_sysconfig() ----------------------------------------------*/

/***************************************************************************
	UPDATE_USER
	Writes a user's info file back out.
***************************************************************************/

void 
update_user( void )
{
   int  fdes = -1;						/* File descriptor */
   int  ct;									/* Generic counter */
	char work_buff[ MAXPATHLEN+1 ];		/* Work buffer */

	/*
	 * (Attempt to) open the file
	 */
   sprintf( work_buff, "%s", uf.name );
   fdes = open( work_buff, O_CREAT | O_WRONLY | O_TRUNC, 0666 );
   if ( fdes < 0 )
   {
      fprintf( stdout, "opening '%s': %s\n", work_buff, strerror( errno ) );
      return;
   }
				 
	/*
	 * Lock the file
	 */
   while ( flock( fdes, LOCK_EX ) ) 
   {
      fprintf( stderr, "flocking '%s': %s", work_buff, strerror( errno ) );
      sleep( 1 );
   }
				  
	/*
	 * Return to beginning of file
	 */
   lseek( fdes, 0, L_SET );
		
	/*
	 * General information fields:
	 */
		  													 
   sprintf( work_buff, "# General information:\n" );
   write( fdes, work_buff, strlen( work_buff ) );
	 
   sprintf( work_buff, "ratio %d\n", uf.ratio );
   write( fdes, work_buff, strlen( work_buff ) );
										
   sprintf( work_buff, "level %d\n", uf.level );
   write( fdes, work_buff, strlen( work_buff ) );
	
   sprintf( work_buff, "restrict %s\n", uf.restrict );
   write( fdes, work_buff, strlen( work_buff ) );
											
   sprintf( work_buff, "tagline %s\n", uf.tagline );
   write( fdes, work_buff, strlen( work_buff ) );
						 
   sprintf( work_buff, "num_logins %d\n", uf.num_logins );
   write( fdes, work_buff, strlen( work_buff ) );
													
   sprintf( work_buff, "exempt_from_limit %d\n", uf.exempt_from_limit );
   write( fdes, work_buff, strlen( work_buff ) );
	
   sprintf( work_buff, "credits %lu\n\n", uf.credits );
   write( fdes, work_buff, strlen( work_buff ) );
	  											  
	
	/*
	 * Xfer information fields:
	 */
													  
   sprintf( work_buff, "# Xfer information:\n" );
   write( fdes, work_buff, strlen( work_buff ) );
	 
   sprintf( work_buff, "files_up %d\n", uf.files_up );
   write( fdes, work_buff, strlen( work_buff ) );
	
   sprintf( work_buff, "bytes_up %lu\n", uf.bytes_up );
   write( fdes, work_buff, strlen( work_buff ) );
	
   sprintf( work_buff, "seconds_up %ld\n", uf.seconds_up );
   write( fdes, work_buff, strlen( work_buff ) );
										
	
   sprintf( work_buff, "files_down %d\n", uf.files_down );
   write( fdes, work_buff, strlen( work_buff ) );

   sprintf( work_buff, "bytes_down %lu\n", uf.bytes_down );
   write( fdes, work_buff, strlen( work_buff ) );

   sprintf( work_buff, "seconds_down %ld\n", uf.seconds_down );
   write( fdes, work_buff, strlen( work_buff ) );


   sprintf( work_buff, "files_up_wk %d\n", uf.files_up_wk );
   write( fdes, work_buff, strlen( work_buff ) );

   sprintf( work_buff, "bytes_up_wk %lu\n", uf.bytes_up_wk );
   write( fdes, work_buff, strlen( work_buff ) );
	   	
   sprintf( work_buff, "seconds_up_wk %ld\n", uf.seconds_up_wk );
   write( fdes, work_buff, strlen( work_buff ) );
	
   sprintf( work_buff, "files_down_wk %d\n", uf.files_down_wk );
   write( fdes, work_buff, strlen( work_buff ) );
   
   sprintf( work_buff, "bytes_down_wk %lu\n", uf.bytes_down_wk );
   write( fdes, work_buff, strlen( work_buff ) );
   
   sprintf( work_buff, "seconds_down_wk %ld\n\n", uf.seconds_down_wk );
   write( fdes, work_buff, strlen( work_buff ) );
	  
										 
   sprintf( work_buff, "# Time-related information:\n" );
   write( fdes, work_buff, strlen( work_buff ) );
								 
   sprintf( work_buff, "last_on %ld\n", uf.last_on );
   write( fdes, work_buff, strlen( work_buff ) );
   
   sprintf( work_buff, "time_limit %d\n", uf.time_limit );
   write( fdes, work_buff, strlen( work_buff ) );

   sprintf( work_buff, "time_on_today %d\n", uf.time_on_today );
   write( fdes, work_buff, strlen( work_buff ) );
	  		               
   sprintf( work_buff, "last_nuked %ld\n\n", uf.last_nuked );
   write( fdes, work_buff, strlen( work_buff ) );
   
   sprintf( work_buff, "# Approved IP's for %s:\n", uf.name );
   write( fdes, work_buff, strlen( work_buff ) );
	 
	
	/*
	 * User IPs:
	 */
   for ( ct = 0; ct < 10; ct++ )
      if ( uf.ip[ ct ][ 0 ] != '\0' )
      {
         sprintf( work_buff, "ip %s\n", uf.ip[ ct ] );
         write( fdes, work_buff, strlen( work_buff ) );
      }
	
	/*
	 * Unlock & close
	 */
   flock( fdes, LOCK_UN );
   close( fdes );
	
	fprintf( stderr, "done.\n" );
}
/*-- end of update_user() ------------------------------------------------*/



/***************************************************************************
	CLEAR_UF_STRUCT
	Clears uf struct, setting default values where applicable.
***************************************************************************/

void 
clear_uf_struct( void )
{
   int ct;

   memset( uf.name, '\0', sizeof( uf.name ) );
	
   uf.ratio = config.default_ratio;
	uf.level = config.default_level;
   strncpy( uf.restrict, config.default_restrict, sizeof( uf.restrict ) );
	strncpy( uf.tagline, config.default_tagline, sizeof( uf.tagline ) );
	uf.num_logins = config.default_num_logins;
	uf.exempt_from_limit = 0;
	uf.credits = config.free_ratio_amount;
	
   uf.files_up = 0;
   uf.bytes_up = 0L;
   uf.seconds_up = (time_t)0;
	
   uf.files_down = 0;
   uf.bytes_down = 0L;
   uf.seconds_down = (time_t)0;
	
   uf.files_up_wk = 0;
   uf.bytes_up_wk = 0L;
   uf.seconds_up_wk = (time_t)0;
	           
   
   uf.files_down_wk = 0;
   uf.bytes_down_wk = 0L;
   uf.seconds_down_wk = (time_t)0;
						  
   uf.last_on = (time_t)0;
   uf.time_limit = 0;
   uf.time_on_today = 0;
   uf.last_nuked = 0;
	
   for ( ct = 0; ct < 10; ct++ )
      memset( uf.ip[ ct ], '\0', 128 );
	
   return;
}
/*-- end of clear_uf_struct() --------------------------------------------*/
										  
/***************************************************************************
	PARSEVAL
	Parses values in user datafile.
***************************************************************************/

void 
userfile_parseval( char *lvalue, char *rvalue )
{
	int ct;
	
   if ( strcasecmp( lvalue, "ratio" ) == 0 )
   {
      uf.ratio = atoi( rvalue );
      return;
   }  
	
   if ( strcasecmp( lvalue, "level" ) == 0 )
   {
      uf.level = atoi( rvalue );
      return;
   }

   if ( strcasecmp( lvalue, "restrict" ) == 0 )
   {
      strncpy( uf.restrict, rvalue, sizeof( uf.restrict ) );
		/* Strip trailing '/' */
      if ( uf.restrict[ strlen( uf.restrict ) - 1 ] == '/' )
         uf.restrict[ strlen( uf.restrict ) ] = '\0';
      return;
   }									
	
   if ( strcasecmp( lvalue, "tagline" ) == 0 )
   {
      strncpy( uf.tagline, rvalue, sizeof( uf.tagline ) );
      return;
   }
	
   if ( strcasecmp( lvalue, "num_logins" ) == 0 )
   { 												
		uf.num_logins = atoi( rvalue );
      return;
   }											 
	
   if ( strcasecmp( lvalue, "exempt_from_limit" ) == 0 )
   { 												
		uf.exempt_from_limit = atoi( rvalue );
      return;
   }
	
   if ( strcasecmp( lvalue, "credits" ) == 0 )
   {
      uf.credits = strtoul( rvalue, (char **)NULL, 0 );
		if ( errno == ERANGE )
			fprintf( stderr, "*WARNING*: credits out of range for '%s'", uf.name );
      return;
   }

   if ( strcasecmp( lvalue, "files_up" ) == 0 )
   {
      uf.files_up = atoi( rvalue );
      return;
   }

   if ( strcasecmp( lvalue, "bytes_up" ) == 0 )
   {
      uf.bytes_up = strtoul( rvalue, (char **)NULL, 0 );
		if ( errno == ERANGE )
			fprintf( stderr, "*WARNING*: bytes_up out of range for '%s'",	uf.name );
      return;
   }
	
   if ( strcasecmp( lvalue, "seconds_up" ) == 0 )
   {
      uf.seconds_up = strtol( rvalue, (char **)NULL, 0 );
      return;
   }
	
   if ( strcasecmp( lvalue, "files_down" ) == 0 )
   {
      uf.files_down = atoi( rvalue );
      return;
   }

   if ( strcasecmp( lvalue, "bytes_down" ) == 0 )
   {
      uf.bytes_down = strtoul( rvalue, (char **)NULL, 0 );
		if ( errno == ERANGE )
			fprintf( stderr, "*WARNING*: bytes_down out of range for '%s'",	uf.name );
      return;
   }

   if ( strcasecmp( lvalue, "seconds_down" ) == 0 )
   { 
      uf.seconds_down = strtol( rvalue, (char **)NULL, 0 );
      return;
   }
	
   if ( strcasecmp( lvalue, "files_up_wk" ) == 0 )
   {
      uf.files_up_wk = atoi( rvalue );
      return;
   }

   if ( strcasecmp( lvalue, "bytes_up_wk" ) == 0 )
   {
      uf.bytes_up_wk = strtoul( rvalue, (char **)NULL, 0 );
		if ( errno == ERANGE )
			fprintf( stderr, "*WARNING*: bytes_up_wk out of range for '%s'",	uf.name );
      return;
   }
	
   if ( strcasecmp( lvalue, "seconds_up_wk" ) == 0 )
   {
      uf.seconds_up_wk = strtol( rvalue, (char **)NULL, 0 );
      return;
   }
                                     

   if ( strcasecmp( lvalue, "files_down_wk" ) == 0 )
   {
      uf.files_down_wk = atoi( rvalue );
      return;
   }

   if ( strcasecmp( lvalue, "bytes_down_wk" ) == 0 )
   {
      uf.bytes_down_wk = strtoul( rvalue, (char **)NULL, 0 );
		if ( errno == ERANGE )
			fprintf( stderr, "*WARNING*: bytes_down_wk out of range for '%s'",	uf.name );
      return;
   }

   if ( strcasecmp( lvalue, "seconds_down_wk" ) == 0 )
   { 
      uf.seconds_down_wk = strtol( rvalue, (char **)NULL, 0 );
      return;
   }  
	
   if ( strcasecmp( lvalue, "last_on" ) == 0 )
   {
      uf.last_on = atol( rvalue );
      return;
   }

   if ( strcasecmp( lvalue, "time_limit" ) == 0 )
   {
      uf.time_limit = atoi( rvalue );
      return;
   }

   if ( strcasecmp( lvalue, "time_on_today" ) == 0 )
   {
      uf.time_on_today = atoi( rvalue );
      return;
   }                         
   
   if ( strcasecmp( lvalue, "last_nuked" ) == 0 )
   {
      uf.last_nuked = atol( rvalue );
      return;
   }
   
   if ( strcasecmp( lvalue, "ip" ) == 0 )
	{
		for ( ct = 0; ct < 10; ct++ )
			if ( uf.ip[ ct ][ 0 ] == '\0' )
			{
				strncpy( uf.ip[ ct ], rvalue, sizeof( uf.ip[ ct ] ) );
            trim( uf.ip[ ct ] );
				return;
			}
	}
}  
/*-- end of userfile_parseval() -------------------------------------------*/



/***************************************************************************
	LOAD_USERFILE
	Loads user data for user "username".
***************************************************************************/

void 
load_userfile( char *username )
{
	char *comment;
   FILE *userfile;
   char lvalue[ 64 ];
   char rvalue[ BUFSIZ ];
   int  x, y;
	char linebuf[ BUFSIZ ];
	char fname_buff[ MAXPATHLEN+1 ];
		
	/*
	 * Clear "uf" structure
	 */
   clear_uf_struct();
	
	/*
	 * Set the uf.name to the user's name
	 */
   strncpy( uf.name, username, sizeof( uf.name ) ) ;
									  
	/*
	 * Open the userfile
	 */
   sprintf( fname_buff, "%s", username );
   if ( ( userfile = fopen( fname_buff, "r" ) ) == NULL )
	{									
		/* We need code to read "default" user */
      return;
	}

	/*
	 * Read lines one at a time, parse lvalue & rvalue, and fill in struct
	 */
   while ( 1 )
   {
      if ( fgets( linebuf, sizeof( linebuf ), userfile ) == NULL )
      {				 
         fclose( userfile );
         return;
      }
				 
		/*
		 * Clip out comments, they'll eventually be lost anyway :)
		 */
		if ( ( comment = strchr( linebuf, '#' ) ) != NULL )
			*comment = '\0';
			
		/*
		 * Trim the buffer 
		 */					
		(void)trim( linebuf );
      	
		/* 
		 * Make sure our lvalue & rvalue are empty
		 */
      memset( lvalue, '\0', sizeof( lvalue ) );
      memset( rvalue, '\0', sizeof( rvalue ) );
			
		/*
		 * Parse lvalue 
		 */										 
      y = 0;
      for ( x = 0; x < strlen( linebuf ) && linebuf[ x ] != ' '; x++ )
         if ( isprint( linebuf[ x ] ) )
            lvalue[ y++ ] = linebuf[ x ];
			
		/*
		 * Parse rvalue
		 */				
      y = 0; x++;
      for ( ; x < strlen( linebuf ); x++ )
         if ( isprint( linebuf[ x ] ) )
            rvalue[ y++ ] = linebuf[ x ];
			
		/*
		 * Call 'parseval' to load structure based on lvalue & rvalue
		 */					
      userfile_parseval( lvalue, rvalue );
   }

   return;
}
/*-- end of load_userfile() ----------------------------------------------*/



/***************************************************************************
	DO_UPDATE
***************************************************************************/
				
void
do_update( void )
{
	uf.credits = uf.credits / 1024L;
	uf.bytes_up = uf.bytes_up / 1024L;
	uf.bytes_down = uf.bytes_down / 1024L;
	uf.bytes_up_wk = uf.bytes_up_wk / 1024L;
	uf.bytes_down_wk = uf.bytes_down_wk / 1024L;
}							  
/*-- end of do_update() --------------------------------------------------*/




/***************************************************************************
	MAIN
***************************************************************************/
																						  
int
main( int argc, char **argv )
{
	int x;

	if ( argc < 2 )
	{
		fprintf( stdout, "Usage: moduser [userfilename(s)/wildcard(s)]\n" );
		return( EXIT_FAILURE );
	}
	
	load_sysconfig();
	
	for ( x=1; x < argc; x++ )
	{
		if ( argv[ x ][ 0 ] != '.' )
		{
			fprintf( stdout, "Processing %s: ", argv[ x ] );
			load_userfile( argv[ x ] );
			do_update();
			update_user();
		}
	}
	 
	return( EXIT_SUCCESS );
}
/*-- end of main() -------------------------------------------------------*/
	

