struct GROUP
{
 	char  name[ 20 ];
	int   members;
	int   files_up;
	ulong bytes_up;
	int   files_up_wk;
	ulong bytes_up_wk;
} group[ 80 ]; 

int num_groups = 0;

char usergroup[ 40 ][ 15 ];
char usergroup_desc[ 40 ][ 40 ];
char privgroup[ 20 ][ 15 ];
char privgroup_desc[ 20 ][ 40 ];

char *trim( char *str );


/***************************************************************************
	LOAD_USERGROUPS
	Loads group data from "<datapath>/groups.user"
***************************************************************************/

void 
load_usergroups( void )
{
	char *comment;
  	char *tokptr;
   FILE *groupfile;
   int  x;
	char linebuf[ BUFSIZ ];
	char fname_buff[ MAXPATHLEN+1 ];
  	uid_t oldid = geteuid();
	
	/*
	 * Clear groups:
	 */				 
	for ( x = 0; x < 40; x++ )
		bzero( usergroup[ x ], sizeof( usergroup[ x ] ) ); 
				  
	/*
	 * Open the groupfile
	 */		 
	seteuid( 0 );
   sprintf( fname_buff, "%s/groups.user", datapath );
   if ( ( groupfile = fopen( fname_buff, "r" ) ) == NULL )
	{									
		seteuid( oldid );
      return;
	}
									
	/*
	 * Read lines one at a time and fill in struct
	 */
   while ( 1 )
   {
      if ( fgets( linebuf, sizeof( linebuf ), groupfile ) == NULL )
      {				 
         fclose( groupfile );
			seteuid( oldid );
         return;
      }
				 						  
		/*
		 * Clip out comments, they'll eventually be lost anyway :)
		 */
		if ( ( comment = strchr( linebuf, '#' ) ) != NULL )
			*comment = '\0';

		/*
		 * Trim the buffer 
		 */					
		(void)trim( linebuf ); 

		if ( !isalpha( linebuf[ 0 ] ) )
			continue;

		for ( x = 0; x < 40 && usergroup[x][0] != '\0'; x++ )
			;

  		tokptr = strtok (linebuf, " ");
		if ( tokptr )
			strncpy( usergroup[x], tokptr, sizeof( usergroup[x] ) );
		else
			continue;
				 
		strcpy( usergroup_desc[x], "\0" );
	  	tokptr = strtok ('\0', " ");
		while ( tokptr )
		{
			if ( usergroup_desc[0] != '\0' )
				strcat( usergroup_desc[x], " " );
			strcat( usergroup_desc[x], tokptr );
	  		tokptr = strtok ('\0', " ");
		}
   }

	seteuid( oldid );
   return;
}
/*-- end of load_usergroups() --------------------------------------------*/
						


/***************************************************************************
	LOAD_PRIVGROUPS
	Loads group data from "<datapath>/groups.priv"
***************************************************************************/

void 
load_privgroups( void )
{
	char *comment;
   FILE *groupfile;  
	char *tokptr;
   int  x;
	char linebuf[ BUFSIZ ];
	char fname_buff[ MAXPATHLEN+1 ];
  	uid_t oldid = geteuid();
	
	/*
	 * Clear groups:
	 */				 
	for ( x = 0; x < 20; x++ )
		bzero( privgroup[ x ], sizeof( privgroup[ x ] ) ); 
				  
	/*
	 * Open the groupfile
	 */		 
	seteuid( 0 );
   sprintf( fname_buff, "%s/groups.priv", datapath );
   if ( ( groupfile = fopen( fname_buff, "r" ) ) == NULL )
	{									
		seteuid( oldid );
      return;
	}
									
	/*
	 * Read lines one at a time and fill in struct
	 */
   while ( 1 )
   {
      if ( fgets( linebuf, sizeof( linebuf ), groupfile ) == NULL )
      {				 
         fclose( groupfile );
			seteuid( oldid );
         return;
      }
				 						  
		/*
		 * Clip out comments, they'll eventually be lost anyway :)
		 */
		if ( ( comment = strchr( linebuf, '#' ) ) != NULL )
			*comment = '\0';
										
		/*
		 * Trim the buffer 
		 */					
		(void)trim( linebuf ); 
											 
		if ( !isalpha( linebuf[ 0 ] ) )
			continue;
					
		for ( x = 0; x < 20 && privgroup[x][0] != '\0'; x++ )
			;
						
  		tokptr = strtok (linebuf, " ");
		if ( tokptr )
			strncpy( privgroup[x], tokptr, sizeof( privgroup[x] ) );
		else
			continue;
			
		strcpy( privgroup_desc[x], "\0" );
	  	tokptr = strtok ('\0', " ");
		while ( tokptr )
		{
			if ( privgroup_desc[0] != '\0' )
				strcat( privgroup_desc[x], " " );
			strcat( privgroup_desc[x], tokptr );
	  		tokptr = strtok ('\0', " ");
		}
   }
									
	seteuid( oldid );
   return;
}
/*-- end of load_privgroups() --------------------------------------------*/



/***************************************************************************
	LOAD_GROUPS
	Loads group data from <datapath>/groups.user and <datapath>/groups.priv
***************************************************************************/

void
load_groups( void )
{
	load_privgroups();
	load_usergroups();

	return;
}
/*-- end of load_groups() ------------------------------------------------*/




/****************************************************************************
    CLEAR_GROUP
	 Clears group stats in a given array slot.
****************************************************************************/
										
void
clear_group( int which )
{
	bzero( group[which].name, sizeof( group[which].name ) );
	group[which].members = 0;
	group[which].files_up = 0;
	group[which].bytes_up = 0UL;
	group[which].files_up_wk = 0;
	group[which].bytes_up_wk = 0UL;
						  
	return;
}
/*--- end of clear_group() -----------------------------------------------*/



/****************************************************************************
	UPDATE_GROUP
	Looks at uf.group_user[0] and adds the current values in 'uf' to the 
	group array.
****************************************************************************/

void
update_group( void )
{
	int ct;

	for ( ct = 0; ct <= num_groups; ct++ )
	{
		if ( ct == num_groups )
		{
			/* Add a new group */
			clear_group( ct );
			
			strcpy( group[ct].name, uf.group_user[0] );
			group[ct].members = 1;
			group[ct].files_up = uf.files_up;
			group[ct].bytes_up = uf.bytes_up;
			
			if ( uf.last_on >= weekstart() )
			{
				group[ct].files_up_wk = uf.files_up_wk;
				group[ct].bytes_up_wk = uf.bytes_up_wk;
			}
			
			num_groups++;
			return;
		}
		else if ( !strcasecmp( group[ct].name, uf.group_user[0] ) )
		{
			/* Update this group */
			group[ct].members++;
			group[ct].files_up += uf.files_up;
			group[ct].bytes_up += uf.bytes_up;
			
			if ( uf.last_on >= weekstart() )
			{
				group[ct].files_up_wk += uf.files_up_wk;
				group[ct].bytes_up_wk += uf.bytes_up_wk;
			}
			
			return;
		}
	}
}
/*-- end of update_group() -----------------------------------------------*/


/***************************************************************************
	QS_LIST_UP_ALLTIME
***************************************************************************/

void 
qs_list_up_alltime( struct GROUP item[], int left, int right )
{
   register int i;
   register int j;
   double x;
   struct GROUP temp;
										  
   i = left;
   j = right;
   x = item[ ( left + right ) / 2 ].bytes_up;

   do
   {
      while ( item[ i ].bytes_up > x && i < right )
         i++;
      while ( item[ j ].bytes_up < x && j > left )
         j--;
      if ( i <= j )
      {
         temp = item[ i ];
         item[ i ] = item[ j ];
         item[ j ] = temp;
         i++;
         j--;
      }
   } while ( i <= j );

   if ( left < j )
      qs_list_up_alltime( item, left, j );

   if ( i < right )
      qs_list_up_alltime( item, i, right );
}
/*-- end of qs_list_up_alltime() ------------------------------------------*/
											 	 


/***************************************************************************
	QS_LIST_UP_WEEKLY
***************************************************************************/

void 
qs_list_up_weekly( struct GROUP item[], int left, int right )
{
   register int i;
   register int j;
   double x;
   struct GROUP temp;
										  
   i = left;
   j = right;
   x = item[ ( left + right ) / 2 ].bytes_up_wk;

   do
   {
      while ( item[ i ].bytes_up_wk > x && i < right )
         i++;
      while ( item[ j ].bytes_up_wk < x && j > left )
         j--;
      if ( i <= j )
      {
         temp = item[ i ];
         item[ i ] = item[ j ];
         item[ j ] = temp;
         i++;
         j--;
      }
   } while ( i <= j );

   if ( left < j )
      qs_list_up_weekly( item, left, j );

   if ( i < right )
      qs_list_up_weekly( item, i, right );
}
/*-- end of qs_list_up_weekly() -------------------------------------------*/
		  

/****************************************************************************
	OUTPUT_GROUPTOPS_ALLTIME
	Outputs group tops list (to /usr/.phear/grouptops.alltime)
****************************************************************************/
			
void
output_grouptops_alltime( void )
{
	FILE *fp;
	int  ct;
	int  x; 
	int  found = -1;
	
	fp = fopen( "/usr/.phear/tops/grouptop", "w" );
	if ( fp == NULL )	  
		return;			  
																						 
	for ( ct = 0; ct < num_groups && ct < 5; ct++ )
	{
		for ( x = 0; x < 40 && usergroup[x][0] != '\0'; x++ )
		{
			if ( !strcasecmp( group[ct].name, usergroup[x] ) )
			{
				found = x;
				break;
			}
		}
#ifdef VDR
		if ( found < 0 )
			fprintf( fp, "!h!5 %2d %-10.10s %-32.32s %6d %10.1fMb %3d  !0\n",
                  ct+1, group[ct].name,"",group[ct].files_up,
                  (double)( group[ct].bytes_up / 1024.0 ), group[ct].members);
		else
			fprintf( fp, "!h!5 %2d %-10.10s %-32.32s %7d %10.1fMb %2d !0\n",
                  ct+1, usergroup[found],usergroup_desc[found],group[ct].files_up,
                  (double)( group[ct].bytes_up / 1024.0 ), group[ct].members);
	}
#else	
		if ( found < 0 )
			fprintf( fp, "!H!5 %2d %-10.10s %-33.33s %6d %10.1fMb %3d  !0\n",
                  ct+1, group[ct].name,"",group[ct].files_up,
                  (double)( group[ct].bytes_up / 1024.0 ), group[ct].members);
		else
			fprintf( fp, "!H!5 %2d %-10.10s %-32.32s %7d %10.1fMb %3d !0\n",
                  ct+1, usergroup[found],usergroup_desc[found],group[ct].files_up,
                  (double)( group[ct].bytes_up / 1024.0 ), group[ct].members);
	}
#endif	
	fclose( fp );
}									 
/*-- end of output_grouptops_alltime() -----------------------------------*/
	 

/****************************************************************************
	OUTPUT_GROUPTOPS_WEEKLY
	Outputs group tops list (to /usr/.phear/grouptops.weekly)
****************************************************************************/
			
void
output_grouptops_weekly( void )
{
	FILE *fp;
	int  ct; 
	int x;
	int found = -1;
	
	fp = fopen( "/usr/.phear/tops/wkgrouptop", "w" );
	if ( fp == NULL )
		return;
																						 
	for ( ct = 0; ct < num_groups && ct < 5; ct++ )
	{  	 															  
		for ( x = 0; x < 40 && usergroup[x][0] != '\0'; x++ )
			if ( !strcasecmp( group[ct].name, usergroup[x] ) )
			{
				found = x;
				break;
			}
#ifdef VDR
		if ( found < 0 )
			fprintf( fp, "!h!5 %2d %-10.10s %-33.33s %6d %10.0fMb %2d !0\n",
      	         ct+1, group[ct].name,"",group[ct].files_up_wk,
         	      (double)( group[ct].bytes_up_wk / 1024.0 ), group[ct].members);
		else
			fprintf( fp, "!h!5 %2d %-10.10s %-33.33s %6d %10.0fMb %2d !0\n",
                  ct+1, usergroup[found],usergroup_desc[found],group[ct].files_up_wk,
                  (double)( group[ct].bytes_up_wk / 1024.0 ), group[ct].members);
	}
#else
	
		if ( found < 0 )
			fprintf( fp, "!e|!h %2d %-10.10s %-33.33s %6d %10.1fMb %3d !0\n",
      	         ct+1, group[ct].name,"",group[ct].files_up_wk,
         	      (double)( group[ct].bytes_up_wk / 1024.0 ), group[ct].members);
		else
			fprintf( fp, "!H!5 %2d %-10.10s %-40.40s %4d %5.0fMb %3d !0\n",
                  ct+1, usergroup[found],usergroup_desc[found],group[ct].files_up_wk,
                  (double)( group[ct].bytes_up_wk / 1024.0 ), group[ct].members);
	}
#endif
	fclose( fp );
}									 
/*-- end of output_grouptops_weekly() ------------------------------------*/

	

/***************************************************************************
	ACCUM_STATS
	Reads all userfiles, taking the FIRST entry for group_user and adding 
	that user's stats to the group entry.
***************************************************************************/
										
void
accum_stats( void )
{
	char   temppath[ MAXPATHLEN ];
  	char   username[ MAXPATHLEN ];
	char   tempbuf[ BUFSIZ ];
	char   *dotptr;
  	DIR    *dirf;
  	struct dirent *dn;
  	struct stat st;
	int    ct;
	
  	sprintf (temppath, "/usr/.phear/users" );
  	dirf = opendir (temppath);
  	if (!dirf)
   {	  																			  
		/* Error opening directory?? */
		fprintf( stderr, "grouptop: error opening dir '%s': %s\n", temppath, strerror( errno ) );
      return;
   }
	
  	while (1)
   {
      dn = readdir (dirf);
      if (!dn)
			break;

      sprintf (temppath, "/usr/.phear/users/%s", dn->d_name);

      strncpy (username, dn->d_name, sizeof (username));

      stat (temppath, &st);

      if ( S_ISREG (st.st_mode) && st.st_uid != 99 && st.st_gid != 99 )
		{
		  	if ((dotptr = strchr (username, '.')) != NULL)
	   		*dotptr = '\0';
   		sprintf (tempbuf, " %-8.8s ", username);
			load_userfile( username );
			
			if ( uf.group_user[0][0] != '\0' )
			{
				/* User is in a group! */
				/* update_group knows where to get the info & where to put it */
				update_group();
			}
		}
	}

  	(void) closedir (dirf);
}
/*-- end of accum_stats() ------------------------------------------------*/


