#define  KILLMINUTES 15       /* Change this to change idle kill value */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <errno.h>
#include <ctype.h>
#include <sys/types.h>
#include <syslog.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/param.h>
#include <dirent.h>
#include <signal.h>
#define SYSCONFIG 
#include "../include/sysconfig.h"
#undef SYSCONFIG

/* Structure which holds information regarding users currently online.. */
/* This is the same structure written to/read from pid files. */
struct ONLINE
{
  char   username[35];
  char   status[41];
  char   host[256];
  char   currentdir[ MAXPATHLEN ];
  time_t login_time;
  time_t last_update;
  pid_t  procid;
  struct ONLINE *next;
  struct ONLINE *prev;
};

int  dl = 0;
int  ul = 0;
 

/***************************************************************************
	TRIM
***************************************************************************/

char *
trim( char *str )
{
	char *ibuf;
	char *obuf;

   if ( str )
   {
   	for ( ibuf = obuf = str; *ibuf; )
      {
        	while ( *ibuf && ( isspace ( *ibuf ) ) )
         	ibuf++;
        	if ( *ibuf && ( obuf != str ) )
            *( obuf++ ) = ' ';
        	while ( *ibuf && ( !isspace ( *ibuf ) ) )
            *( obuf++ ) = *( ibuf++ );
      }
      *obuf = '\0';
   }
   return( str );
}
/*-- end of trim() -------------------------------------------------------*/
				 

/***************************************************************************
	LOAD_SYSCONFIG
	Loads data from system configuration file.
***************************************************************************/

void 
load_sysconfig( void )
{
   FILE *configfile;
   char lvalue[ 64 ];
   char rvalue[ MAXPATHLEN ];
   int  x, y;
	char work_buff[ MAXPATHLEN ];

 sprintf( work_buff, "/etc/phear.conf" );

   if ( ( configfile = fopen( work_buff, "r" ) ) == NULL )
	{
		fprintf( stderr, "bad or missing '/etc/phear.conf', using defaults" );
      return;
	}

   while ( 1 )
   {
      if ( fgets( work_buff, sizeof( work_buff ), configfile ) == NULL )
      {
         fclose( configfile );
         return;
      }

      /* Clip out comments */
      for ( x = 0; x < strlen( work_buff ); x++ )
         if ( work_buff[ x ] == '#' )
            work_buff[ x ] = '\0';
				
		/* Trim */
		(void)trim( work_buff );
      
      /* Clear out old values */
      memset( lvalue, '\0', sizeof( lvalue ) );
      memset( rvalue, '\0', sizeof( rvalue ) );
													 
		/* The file allows spaces embedded, but clears leading & trailing 
			spaces */
		
      /* Parse lvalue */
      y = 0;
      for ( x = 0; x < strlen( work_buff ) && work_buff[ x ] != ' '; x++ )
         if ( isprint( work_buff[ x ] ) )
            lvalue[ y++ ] = work_buff[ x ];

      /* Parse rvalue */
      y = 0; x++;
      for ( ; x < strlen( work_buff ); x++ )
         if ( isprint( work_buff[ x ] ) )
            rvalue[ y++ ] = work_buff[ x ];
      
      if ( strcasecmp( lvalue, "datapath" ) == 0 )
	   	strncpy( cf.datapath, rvalue, sizeof( cf.datapath ) );
   }

   return;
}
/*-- end of load_sysconfig() ----------------------------------------------*/


char hmsbuf[50];			


/***************************************************************************
   PID_HMS_FORMAT
***************************************************************************/
                              
void
pid_hms_format( time_t testtime )
{
   time_t timenow = time( NULL );
   time_t difftime;
   int    days = 0;
   int    hours = 0;
   int    minutes = 0;
	int    seconds = 0;

#ifdef DEBUG
	syslog( LOG_INFO, "[BB] hms_format()" );
	debugfn();
#endif
   
   difftime = timenow - testtime;
   
   while ( difftime >= (time_t)3600 )
   {
      difftime -= (time_t)3600;
      hours++;
   }          
   
   while ( difftime >= (time_t)60 )
   {
      difftime -= (time_t)60;
      minutes++;
   }
   
   if ( hours != 0 )
      sprintf( hmsbuf, "%02d:%02d:%02d", hours, minutes, difftime );
   else
      sprintf( hmsbuf, "   %02d:%02d", minutes, difftime );
}
/*-- end of pid_hms_format() ---------------------------------------------*/




/***************************************************************************
  CHECKUSERS
***************************************************************************/

int
checkusers(void)
{
  DIR *dirf;
  struct dirent *dn;
  struct stat st;
  char temppath[256];
  FILE *fp;
  struct ONLINE newuser;
  int found = 0;
  int killthis = 0;
  char statbuf[ 500 ];
  char pidbuf[ 10 ];
															
  /*
   * Open directory
   */							
	sprintf( temppath, "%s/pids", cf.datapath );
  	dirf = opendir (temppath);
  	if (!dirf)
    {
      syslog (LOG_ERR, "[b/b]: Error opening dir '%s': %m", temppath);
      return 0;
    }
  
  /*
   * Scroll thru /.ftp-data/pids looking for files (processes)
   */
  
  	while (1)
   {
   	dn = readdir (dirf);	/* Read directory entry */
      if (!dn)			/* We done yet? */
			break;
      
      if (!strcmp (dn->d_name, ".") || !strcmp (dn->d_name, ".."))
			continue;

      sprintf (temppath, "%s/pids/%s", cf.datapath, dn->d_name);
      stat (temppath, &st);	/* Stat file */
      
      if (S_ISREG (st.st_mode))	/* Found one? */
		{
	  		/* open the pidfile */
	  		if ((fp = fopen (temppath, "r")) == NULL)
	    	{
	      	if (errno != ENOENT)
				{
		  			syslog (LOG_ERR, "[b/b]: Error opening file '%s': %m", 
			  				  temppath);
				}
				
	      	continue;
	    	}
	  
	  		fread (&newuser, sizeof( struct ONLINE ), 1, fp );
	  		fclose( fp );
			
			if ( kill( newuser.procid, 0 ) != 0 )
				killthis = 1;
			else
				killthis = 0; 
				
			trim( newuser.status );
			trim( newuser.host );
			sprintf( pidbuf, "%d", newuser.procid );
			pid_hms_format( newuser.last_update );
																				 
      	if (memcmp (newuser.status, "STOR", 4) == 0)
			{
				sprintf( statbuf, "Up: %-17.17s", newuser.status+5 );
				ul++;
			}
	      /* Downloading */
	      else if (memcmp (newuser.status, "RETR", 4) == 0)
			{
				sprintf( statbuf, "Dn: %s", newuser.status+5 );
				dl++;
			}
	      /* Logging in */
   	   else if (memcmp (newuser.username, "          ", 10) == 0)
			{
				sprintf( statbuf, "Logging in" );
			}
			else if (memcmp( newuser.status, "PASS", 4) == 0)
			{
				sprintf( statbuf, "Entering Password" );
			}
	      /* Idling */
   	   else if (memcmp (newuser.status, "IDLE", 4) == 0)
			{
				sprintf( statbuf, "Idle: %-8.8s", hmsbuf );
			}
   	   /* Doing something else... */
	      else
			{
				sprintf( statbuf, "\"%s\"", newuser.status );
			}

			fprintf( stdout, "| %-8.8s %c %-5.5s | %-8.8s | %-21.21s | %-20.20s |\n",
						newuser.username, (killthis)?'K':'|', pidbuf, hmsbuf, statbuf, 
						newuser.host );
			
	  		found++;
		}
  	}
  
  (void) closedir (dirf);
  
  return (found);
}
/*-- end of checkusers() -------------------------------------------------*/


/***************************************************************************
	MAIN
***************************************************************************/
                                   
int
main( int argc, char **argv )
{
   int numusers = 0;
	char uldlbuf[80];
   
	openlog( "ftpwho", LOG_PID | LOG_NDELAY, LOG_DAEMON );
	
	load_sysconfig();
	
	fprintf( stdout, "      _________\n" );
	fprintf( stdout, " _____\\      _/____________ ______________________________________\n" );
	fprintf( stdout, "|      \\      \\    _______/___   _      /      _      \\   _______/___\n" );
	fprintf( stdout, "|      |\\     _\\_____        /   /_____/.      /______/\\____        /\n" );
	fprintf( stdout, "|____________/        ______/______     |______|      /      ______/\n" );
	fprintf( stdout, ".---------- /_________| --------- |_____| ---------- /_______| ---- ONLINE! -.\n" );
	fprintf( stdout, "| Username | PID   | Idle     | Action                | From                 |\n" );
	fprintf( stdout, "|----------+-------+----------+-----------------------+----------------------|\n" );

	numusers = checkusers();
   					  
	sprintf( uldlbuf, "(%d uploading, %d downloading)", ul, dl );
	fprintf( stdout, "|----------+-------+----------+-----------------------+----------------------|\n" );
	fprintf( stdout, "| %3d %s  %-40.40s                |\n", 
		numusers, (numusers==1)?"user online. ":"users online.", uldlbuf );
	fprintf( stdout, "`----------------------------------------------------------------------------'\n" );
//   fprintf( stdout, "\n* %d users online.\n", numusers );
      
   return 0;
}
/*-- end of main() -------------------------------------------------------*/

