/*
 * dupebd.c
 *			
 * This program should run once a day, after midnight, and will
 * update your dupe check database.  Note the variable 'site_prefix'
 * which you will NEED to edit in order for this to work properly!!
 *
 * Also note that your dirs must be in the format "MMDD" (i.e. 0417) for
 * this one to work.
 *
 * bleachboy 1996
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/param.h>
#include <dirent.h>
					 

FILE *fp;			/* File pointer to output (dupe database) file */
char *site_prefix = "/home/.cache/.site";
char *dupefilename = "/.ftp-data/dupe.database";


													 


/***************************************************************************
	ADD_DAY_ENTRY
***************************************************************************/

void
add_day_entry( char *dirname )
{
	DIR    *dirf;
	struct dirent *dn;
	struct stat st;
	struct stat dizst;
	int    ct;
	char   temppath[ MAXPATHLEN + 1 ];
	char   zipfilename[ MAXPATHLEN + 1 ];
	char   *lfptr;
	char 	 linebuf[ BUFSIZ ];
	char   datestr[ 20 ];
	struct tm *ptr;
	FILE 	 *diz;
	
	dirf = opendir( dirname );
	if ( !dirf )
	{
		fprintf( stderr, "error reading dir!" );
		return;
	}
	
	/*
	 * Get first filename containing ZIP
	 */

   while ( 1 )
   {
		dn = readdir( dirf );
		if ( !dn )
			break;
					
		sprintf( temppath, "%s/%s", dirname, dn->d_name );

		stat( temppath, &st );
		
		if ( S_ISREG( st.st_mode ) )
		{									 
			/* Capitalize string */
			strncpy( zipfilename, strrchr( temppath, '/' ) + 1, sizeof( zipfilename ) );
			for ( ct = 0; ct < strlen( zipfilename ); ct++ )
				zipfilename[ ct ] = toupper( zipfilename[ ct ] );
			if ( strstr( zipfilename, "ZIP" ) != NULL )
				break;
		}
   }
	
	printf( "zipfilename=[%s]\n", zipfilename );

  	(void)closedir( dirf );
	
	sprintf( temppath, "%s/FILE_ID.DIZ", dirname );
	if ( stat( temppath, &dizst ) )
	{
		/* No FILE_ID.DIZ! */
		return;
	}
	
	ptr = localtime( &dizst.st_atime );
	strftime( datestr, MAXPATHLEN, "%m-%d-%y", ptr );
					
	diz = fopen( temppath, "r" );
	 
   if ( diz )
   {
		while ( fgets( linebuf, 255, diz ) != NULL )
		{
			if ( ( lfptr = strchr( linebuf, '\r' ) ) != NULL )
				*lfptr = '\0';
		   if ( ( lfptr = strchr( linebuf, '\n' ) ) != NULL )
		     *lfptr = '\0';
					  
			if ( strlen( linebuf ) > 3 )
			fprintf( fp, "%s | %s | %s\n", zipfilename, datestr, linebuf );
		}
		fclose( diz );
   }
	
   return;
}
/*-- end of add_day_entry() ----------------------------------------------*/



/***************************************************************************
	ADD_DUPE_DAY
***************************************************************************/

void
add_dupe_day( void )
{
	DIR    *dirf;
	struct dirent *dn;
	struct stat st;
	char   temppath[ MAXPATHLEN + 1 ];
	char   daypath[ MAXPATHLEN + 1 ];
	struct tm *ptr;
	time_t timenow = time( NULL );
	
	ptr = localtime( &timenow );
	strftime( temppath, MAXPATHLEN, "%m%d", ptr );
	sprintf( daypath, "%s/%s", site_prefix, temppath );
	
	dirf = opendir( daypath );
	if ( !dirf )
	{
		fprintf( stderr, "error reading dir!" );
		return;
	}

   while ( 1 )
   {
		dn = readdir( dirf );
		if ( !dn )
			break;		  
					
		sprintf( temppath, "%s/%s", daypath, dn->d_name );

		stat( temppath, &st );
		
		if ( S_ISDIR( st.st_mode ) ) 
		{
			add_day_entry( temppath );
		}
   }

  	(void)closedir( dirf );	

   return;
}
/*-- end of add_dupe_day() ------------------------------------------------*/




/***************************************************************************
	MAIN
***************************************************************************/

int 
main( int argc, char **argv )
{	 	  
	/*
	 * Open dupe database file
	 */
	if ( ( fp = fopen( dupefilename, "a" ) ) == NULL )
	{
		fprintf( stderr, "dupebd: could not open '%s': %s", 
			dupefilename, strerror( errno ) );
		return EXIT_FAILURE;
	}
	
	add_dupe_day();
	
	fclose( fp );
	
   return 0;   
}
