#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <syslog.h>
#ifdef __linux__
#include <linux/unistd.h>
#endif
#include <sys/file.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <dirent.h>
#include <signal.h>
#include <fcntl.h>
#include <ctype.h>
#include "../include/userfile.h"
#include "../include/sysconfig.h"

extern void reply(int n, char *fmt, ...);
extern void lreply(int n, char *fmt, ...);

/***************************************************************************
	CHECK_ZIP
	Returns 0 if zipfile "name" is okay, 1 otherwise.
	This function also extracts the FILE_ID.DIZ.
***************************************************************************/
int 
check_zip(name)
	const char *name;
{
	char syscall_buff[MAXPATHLEN + 256];
	int x;
	char outbuff[90];
	char actname[MAXPATHLEN];
	int sys_retval = 0;
	char last_three[4];
	struct stat st;
	uid_t oldid = geteuid();

	if (strrchr(name, '/') == NULL)
		strncpy(actname, name, sizeof(actname));
	else
		strncpy(actname, strrchr(name, '/') + sizeof(char), sizeof(actname));

	/* Extract extension of file */
	last_three[0] = tolower(name[strlen(name) - 3]);
	last_three[1] = tolower(name[strlen(name) - 2]);
	last_three[2] = tolower(name[strlen(name) - 1]);
	last_three[3] = '\0';

	/* Check ZIP file for errors, simultaneously extracting the FILE_ID.DIZ */
	lreply(226, "!G!5.-----------------------------------------------------------------------.!0");
	if (!strcmp(last_three, "zip")) {
		sprintf(outbuff, "!G!5Processing ZIP file \"%s\":", actname);
		lreply(226, "!G!5|!D!5 %-76.76s!G!5|", outbuff);
		lreply(226, "!G!5|-----------------------------------------------------------------------!e|");

		lreply(226, "!e|!h Checking ZIP file integrity...                                        !e|");
		sprintf(syscall_buff, "%s/unzip -tqq %s >/dev/null 2>&1", cf.datapath, name);
		sys_retval = system(syscall_buff);
		wait(0);
		if ((sys_retval != 0) && (sys_retval != 127)) {
			sprintf(outbuff, "!G!5File \"%s\" failed ZIP check.", actname);
			lreply(226, "!G!5|!D!5 %-76.76s!G!5|", outbuff);
			lreply(226, "!G!5`-----------------------------------------------------------------------'!0");
			return (sys_retval);		/* FAILED! */
		}

		lreply(226, "!G!5|!D!5 Extracting FILE_ID.DIZ/NFO files...                                   !G!5|");
		sprintf(syscall_buff, "%s/unzip -Cpoqq %s file_id.diz >FILE_ID.DIZ 2>/dev/null", cf.datapath, name);
		(void) system(syscall_buff);
		wait(0);

		/* Now we extract all NFO files: */
		sprintf(syscall_buff, "%s/unzip -Coqq %s *.nfo >/dev/null 2>&1", cf.datapath, name);
		(void) system(syscall_buff);
		wait(0);

		if (nfos[0][0] == '\0')
			lreply(226, "!G!5|!D!5 Extracted NFO files: None found...                                    !G!5|");
		else
			lreply(226, "!G!5|!D!5 Extracted NFO files: %-45.45s    !G!5|!0", nfos[0]);

		for (x = 1; x < 5; x++)
			if (nfos[x][0] != '\0')
				lreply(226, "!G!5|!D!5                      %-45.45s    !G!5|!0", nfos[1]);

		/*
		 * Call script <datapath>/zipscript $1 $2
		 * where $1 is the full pathname and $2 is the username
		 */
		seteuid(0);
		sprintf(syscall_buff, "%s/zipscript", cf.datapath);
		if (!stat(syscall_buff, &st)) {
			lreply(226, "!e|!h Tagging ZIP...                                                        !e|");
			sprintf(syscall_buff, "%s/zipscript %s", cf.datapath, name);
			(void) system(syscall_buff);
			wait(0);
		}

	}

	/* lreply(226, "!G!5|-----------------------------------------------------------------------!G!5|"); */
	sprintf(outbuff, "!HFile \"%s\" passed ZIP check.", actname);
	lreply(226, "!G!5|!D!5 %-76.76s!e|", outbuff);
	lreply(226, "!G!5`-----------------------------------------------------------------------'");

	seteuid(oldid);

	return (0);
}
/*-- end of check_zip() ---------------------------------------------------*/
