#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <syslog.h>
#include <sys/param.h>
#include <dirent.h>
#include "../include/sysconfig.h"
#include "../include/userfile.h"

extern void reply( int n, char *fmt, ... );
extern void lreply( int n, char *fmt, ... );
extern char *trim( char *str );

static int found;
	

/****************************************************************************
    STRUPR
****************************************************************************/

char *strupr( char *string )
{
	char *s;

   if ( string )
   {
   	for ( s = string; *s; ++s )
      	*s = toupper( *s );
   } 
	
   return string;
} 
/*--- end of strupr() -----------------------------------------------------*/
			 

/****************************************************************************
    STRLWR
****************************************************************************/

char *strlwr( char *string )
{
	char *s;

   if ( string )
   {
   	for ( s = string; *s; ++s )
      	*s = tolower( *s );
   }
	
   return string;
}
/*--- end of strlwr() -----------------------------------------------------*/



/****************************************************************************
    SHOW_FILES_BYTES  
****************************************************************************/

void
show_files_bytes( int msgcode, const char *dirname )
{  						 
	int    files = 0;
	ulong  bytes = 0UL;
	int    subdirs = 0;
	DIR    *dirf;
	struct stat st;
	struct dirent *dr;
   char   curpath[ MAXPATHLEN ];
	time_t earlydate = 0;
	char   datebuf[ 30 ];
	
	dirf = opendir( dirname );
   while ( 1 )
   {
	  	dr = readdir( dirf );
		if ( !dr )
			break;
   
      if ( !strcmp( dr->d_name, "." ) || !strcmp( dr->d_name, ".." ) )
         continue;

      sprintf( curpath, "%s/%s", dirname, dr->d_name );

		if ( stat( curpath, &st ) < 0 )
         continue;                                 /* Could not stat? */

		if ( S_ISDIR( st.st_mode ) )
		{				 
			subdirs++;
		}
		else
		{
			if ( ( st.st_mtime < earlydate ) || ( earlydate == 0 ) )
				earlydate = st.st_mtime;
			files++;
			bytes += (ulong)st.st_size;
		}
   }
  	(void)closedir( dirf ); 
		 						
	sprintf( datebuf, "%.2s %.3s %.4s", 
			   ctime( &earlydate ) + 8, 
			   ctime( &earlydate ) + 4, 
				ctime( &earlydate ) + 20 );
				
	if ( files == 0 )
		strcpy( datebuf, "No files" );
	
	lreply( msgcode, "!H%s !C(!E%d!Cf/!E%.1lf!Cm/!E%s!C)!0", 
			  dirname + (int)strlen( cf.default_restrict ), files, 
           (double)(bytes / 1024000.0), datebuf );

	found++;

   return;
}
/*--- end of show_files_bytes() -------------------------------------------*/


/****************************************************************************
    MATCHSTR   
****************************************************************************/
							 
int
matchstr( const char *dirname, const char *searchstr )
{
	char dirbuf[ MAXPATHLEN ];
	char searchbuf[ BUFSIZ ];
	char *dirptr;

	strncpy( searchbuf, searchstr, BUFSIZ );
	strupr( searchbuf );

	strncpy( dirbuf, dirname, MAXPATHLEN );
	strupr( dirbuf );

	dirptr = strrchr( dirbuf, '/' );

	if ( dirptr )
	{
#ifdef LOCATEDEBUG	
		syslog( LOG_INFO, "[pheard] Is [%s] in [%s]?",
			searchstr, dirptr );
#endif						 
		if ( strstr( dirptr+1, searchbuf ) )
			return 1;
	}
	else
	{
#ifdef LOCATEDEBUG	
		syslog( LOG_INFO, "[pheard] Is [%s] in [%s]?",
			searchstr, dirbuf );
#endif		
		if ( strstr( dirbuf, searchbuf ) )
			return 1;
	}

	return 0;
}
/*--- end of matchstr() ---------------------------------------------------*/



/****************************************************************************
    SEARCHTREE 
****************************************************************************/

int
searchtree( int msgcode, const char *dirname, const char *searchstr )
{  
	int    matches = 0;
	DIR    *dirf;
	struct stat st;
	struct dirent *dr;
   char   curpath[ MAXPATHLEN ];
							
	if ( matchstr( dirname, searchstr ) )
	{
		matches++;	  
		show_files_bytes( msgcode, dirname );
	}

	dirf = opendir( dirname );
   while ( 1 )
   {
	  	dr = readdir( dirf );
		if ( !dr )
			break;
   
      if ( !strcmp( dr->d_name, "." ) || !strcmp( dr->d_name, ".." ) )
         continue;

      sprintf( curpath, "%s/%s", dirname, dr->d_name );

		if ( stat( curpath, &st ) < 0 )
         continue;                                 /* Could not stat? */

		if ( S_ISDIR( st.st_mode ) )
		{
         matches = searchtree( msgcode, curpath, searchstr );
		}
   }
  	(void)closedir( dirf ); 
	
   return( matches );
}
/*--- end of searchtree() -------------------------------------------------*/


/****************************************************************************
    SLOCATE    
****************************************************************************/
										
void
slocate( int msgcode, char *searchstr )
{  
	found = 0;
	
	trim( searchstr );

	lreply( msgcode, "!HDoing case-insensitive substring search for '!C%s!H':!0", searchstr );
	lreply( msgcode, "!A(Values displayed after dir names are files/megs/earliest filedate)!0" );
	lreply( msgcode, "" );

 	searchtree( msgcode, cf.default_restrict, searchstr );

	lreply( msgcode, "" );
	reply( msgcode, "!C%d!H directories found.!0", found );
}
/*--- end of slocate() ----------------------------------------------------*/
