#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <syslog.h>
#ifdef __linux__
#include <linux/unistd.h>
#endif
#include <sys/file.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <dirent.h>
#include <signal.h>
#include <fcntl.h>
#include <ctype.h>
#include <syslog.h>
#include "../include/userfile.h"
#include "../include/sysconfig.h"
 
extern int match( char *s, char *p );
		 
/***************************************************************************
	VALIDIP
	Checks to make sure that this ident@IP matches one in one of the user-
	files.
	Returns 1 if IP is allowed, 0 if not.
***************************************************************************/
												 
int
validip( char *host_name, char *host_ip, char *auth_user )
{																	
	int 	 ct;
	int    x;
	DIR    *dirf;
	struct dirent *dn;
	struct stat st;
	char   temppath[ BUFSIZ+1 ];
	
   sprintf( temppath, "%s/users", cf.datapath );
	dirf = opendir( temppath );
	if ( !dirf )
	{
		syslog( LOG_ERR, "[pheard]: Error opening dir: %s: %m", temppath );
		return 0;  						/* Return failure (take no chances) */
	}

   while ( 1 )
   {
		dn = readdir( dirf );
		if ( !dn )
			break;		  
			
		sprintf( temppath, "%s/users/%s", cf.datapath, dn->d_name );
				
		stat( temppath, &st );
					  
		/* Ignore stupid emacs backups :)  */
		if ( temppath[ strlen( temppath ) ] == '~' )
			continue;
													  
      if ( S_ISREG (st.st_mode) && st.st_uid != 99 && st.st_gid != 99 )
		{
			if ( load_userfile( dn->d_name ) )
				syslog( LOG_ERR, "[pheard] Calling function was validip()" );
			
			if ( check_user_ip_list( host_name, host_ip, auth_user ) )
			{
#ifdef DEBUG			
				syslog( LOG_INFO, "[bb] %s@%s (%s) matched user %s", 
					auth_user, host_name, host_ip, dn->d_name );
#endif					
				return 1;					/* The IP is valid */
			}
		}
   }

  	(void)closedir( dirf );	
	
	return 0;								/* The IP is not valid */
}
/*-- end of validip() ----------------------------------------------------*/

 		 
/***************************************************************************
	CHECK_USER_IP_LIST
	Checks to make sure that this ident@IP is allowed for this login.
	Returns 1 if IP is allowed, 0 if not.
***************************************************************************/

int
check_user_ip_list( char *host_name, char *host_ip, char *auth_user )
{
	int  ct;	
	int  x;
	int  foundat;
	char usermask[ 50 ];
	char hostmask[ 50 ];

   for ( ct = 0; ct < 10 && uf.ip[ ct ][ 0 ] != '\0'; ct++ )
	{
		bzero( usermask, sizeof( usermask ) );
		bzero( hostmask, sizeof( hostmask ) );
		foundat = 0;

		/* Parse usermask & hostmask */
		strncpy( usermask, uf.ip[ct], sizeof( usermask ));
		for ( x=0; x < strlen( usermask ); x++ )
			if ( usermask[x] == '@' )
			{
				usermask[x] = '\0';
				foundat = 1;
			} 

		if ( !foundat )
			strcpy( usermask, "*" );

		if ( strrchr( uf.ip[ct], '@' ) == NULL )
		 	strncpy( hostmask, uf.ip[ct], sizeof( hostmask ) );
		else
			strncpy( hostmask, strrchr( uf.ip[ct], '@' ) + 1, sizeof( hostmask ) );
			
		if ( match( auth_user, usermask ) )
		{
			/* Check hostname (fqdn) versus IP list... */
			if ( match( host_name, hostmask ) )
				return 1;

			/* Check host IP (numeric) versus IP list... */
			if ( match( host_ip, hostmask ) )
				return 1;
		}
	}

	return 0;					/* No matches */
}
/*-- end of check_user_ip_list() -----------------------------------------*/



/***************************************************************************
	CHECK_IP
	Checks to make sure that this is a decently secure IP.
	Returns:  1 = IP is okay.
	          2 = Need a usermask.
				 3 = Need a hostmask.
				 4 = Risky usermask.
				 5 = Risky hostmask.
***************************************************************************/

int
check_ip( char *testip )
{	 
	int  x;
	int  foundat = 0;
	char usermask[ 50 ];
	char hostmask[ 50 ];

	bzero( usermask, sizeof( usermask ) );
	bzero( hostmask, sizeof( hostmask ) );

	/* Parse usermask & hostmask */
	strncpy( usermask, testip, sizeof( usermask ));
	for ( x=0; x < strlen( usermask ); x++ )
		if ( usermask[x] == '@' )
		{
			usermask[x] = '\0';
			foundat = 1;
		} 

	if ( strrchr( testip, '@' ) == NULL )
	 	strncpy( hostmask, testip, sizeof( hostmask ) );
	else
		strncpy( hostmask, strrchr( testip, '@' ) + 1, sizeof( hostmask ) );
	
	if ( match( "XXX.XXX.XXX.XXX", hostmask ) )
	{
		return 5;				/* Risky hostmask */
	}
		
	if ( !foundat )
	{
		return 2;				/* Need a usermask */
	}
		
	if ( !strlen( hostmask ) )
	{
	 	return 3;				/* Need a hostmask */
	}
	
	return 1;					/* IP is good! */
}
/*-- end of check_ip() ---------------------------------------------------*/

