/* FLOC - File location database system
	Adapted to PhearD by Bill Johnson */

/* Data types */
#define DTYPE_STRING 2
#define DTYPE_LONG 3

typedef struct _FLIST floclist;
typedef struct _FLOC floc;
typedef struct _FDATA flocdata;
typedef long floc_t;
typedef int dtype_t;

struct _FLIST {
	char field[9];
	floc_t mbr;
	floclist *next;
};

struct _FLOC {
	FILE *dat;
	FILE *floc;
	floclist *worklist;
	floc_t end;
};

struct _FDATA {
	dtype_t datatype;
	size_t datasize;
	void *datamem;
};

floc *floc_open( char *fname );
void floc_work( floc *v, char *prefix );
void floc_workdone( floc *v );
floc_t floc_best( floc *v, char *goal );
floc_t floc_worksearch( floclist *workl, char *goal );
floc_t floc_search( floc *v, char *goal);
char *floc_readstr_alloc( floc *v, floc_t where );
int floc_readstr( floc *v, floc_t where, char *stor );
long floc_readlong( floc *v, floc_t where );
void floc_readraw( floc *v, floc_t where, int *dt_mem, size_t *ds_mem, void **data_mem );
void floc_seekend( floc *v );
void floc_terminate( floc *v );
floc_t floc_addrec( floc *v, char *thename );
void floc_write( floc *v, floc_t where, dtype_t dt, long ds, void *dat );
void floc_hdr ( floc *v, floc_t where, dtype_t dt, long ds );
const char *dbuid( char *field );
const char *dbfield( char *field );
void add_field( floc *v, char *user, char *field);
void set_strfield( floc *v, char *user, char *field, char *newstr, long dasize);
void set_longfield( floc *v, char *user, char *field, long newlong);
void get_strfield( floc *v, char *user, char *field, char *mem);
long get_longfield( floc *v, char *user, char *field );
int uname_to_id( char *idfile, char *uname, char *idvar );
int next_id( char *idfile );
int write_id( char *idfile, char *uname, int id );
void floc_close( floc *v );
