/*	FLOC - File Location Database System
	(c)1997 Bill Johnson
	Modified for PhearD			*/

#include <stdio.h>
#include <stdlib.h>
#include <fnmatch.h>
#include "flocdb.h"

/*******
	floc_open( filename )
	Opens the FLOC database given by filename. Returns a pointer to an allocated
	floc structure, or NULL if you're too lame to enter a correct filename :)
*******/

floc *floc_open( char *fname ) {
	floc *v; char *flocname;
	v=(floc *)malloc( sizeof (floc) );
	flocname=(char *)malloc((strlen(fname)+6) * sizeof(char) );
	strcpy(flocname, fname); strcat(flocname,".floc");
	if ( (v->floc = fopen( flocname, "w+" )) == NULL ) {
		free(v); free(flocname); return NULL;
	}
	if ( (v->dat = fopen( fname, "w+" )) == NULL ) {
		free(v); free(flocname); return NULL;
	}
	v->end = -1;
	return v;
}

void floc_close( floc *v )
{
	fclose(v->floc);
	fclose(v->dat);
	floc_workdone(v);
}

/*******
	floc_work( floc, prefix )
*******/
void floc_work( floc *v, char *prefix )
{
	char current[9]; long theptr; floclist *thenew, *thelist;
	thelist=v->worklist;
	/* Read flocs and append matches to the list. */
	rewind(v->floc);
	while(1) {
		if (feof(v->floc)) break;
		fread (current, sizeof(char), (size_t)8, v->floc); current[8]='\0';
		if (!strncmp(current,"\n\n\n\n\n\n\n\n", 8)) break;
		if (!fread(&theptr, sizeof(long), (size_t)1, v->floc)) break;
		if (!fnmatch(prefix, current, 0)) {
			/* allocate a new floc. */
			thenew=malloc(sizeof(floclist));
			thenew->mbr=(floc_t)theptr; strncpy(thenew->field, current, 8);
			thenew->field[8]='\0';
			thenew->next=thelist; thelist=thenew;
		}
	}
	v->worklist=thelist;
}

/**********
	floc_workdone( floc )
**********/
void floc_workdone( floc *v )
{
	floclist *q, *r;
	for (q = v->worklist; q != NULL; ) { r=q->next; free(q); q=r; }
	v->worklist = NULL;
}

floc_t floc_best( floc *v, char *goal )
{
	floc_t ret;
	if(v->worklist)
		if((ret=floc_worksearch(v->worklist,goal)) > -1)
			return ret;
	return (floc_search(v,goal));
}

floc_t floc_worksearch ( floclist *workl, char *goal )
{
	floc_t ret=-1; floclist *tgt;
	for (tgt=workl; tgt!=NULL; tgt=tgt->next) {
		if(!fnmatch( goal, tgt->field, 0)) { ret = tgt->mbr; break; }
	}
	return ret;
}

floclist *floc_workiter ( floc *v, floclist **temp )
{
	floclist *ret=NULL;
	if ( *temp == NULL ) *temp = v->worklist;
	ret=*temp; *temp=(*temp)->next;
	return ret;
}

char *floc_workname ( floclist *what ) { return what->field; }

floc_t floc_workpoint ( floclist *what ) { return what->mbr; }

floc_t floc_search ( floc *v, char *goal )
{
	floc_t ret=-1; char current[9]; long theptr;
	rewind(v->floc);
	while(1) {
		if (feof(v->floc)) break;
        	fread (current, sizeof(char), (size_t)8, v->floc); current[8]='\0';
        	if (!strncmp(current,"\n\n\n\n\n\n\n\n", 8)) break;
        	if (!fread(&theptr, sizeof(long), (size_t)1, v->floc)) break;
        	if (!fnmatch(goal, current, 0)) { ret=(floc_t)theptr; break; }
	}
	return ret;
}

char *floc_readstr_alloc( floc *v, floc_t where )
{
	char *ret; dtype_t datat; size_t datasz;
	fseek(v->dat, (long)where, SEEK_SET);
	if(!fread(&datat, sizeof(int), (size_t)1, v->dat)) return NULL;
	if(!fread(&datasz, sizeof(long), (size_t)1, v->dat)) return NULL;
	if ( datat != DTYPE_STRING ) return NULL;
	ret = malloc( (long)datasz * sizeof(char) );
	if(!fread(ret, sizeof(char), (size_t)datasz, v->dat)) { free(ret); return NULL; }
	ret[(datasz)]='\0';
	return ret;
}

int floc_readstr( floc *v, floc_t where, char *stor )
{
	dtype_t datat; size_t datasz;
	fseek(v->dat, (long)where, SEEK_SET);
	if(!fread(&datat, sizeof(int), (size_t)1, v->dat)) return 0;
        if(!fread(&datasz, sizeof(long), (size_t)1, v->dat)) return 0;
        if ( datat != DTYPE_STRING ) return 0;
	if(!fread(stor, sizeof(char), datasz, v->dat)) return 0;
	stor[(datasz)]='\0';
	return 1;
}


long floc_readlong( floc *v, floc_t where )
{
	long ret; dtype_t datat; size_t datasz;
	fseek(v->dat, (long)where, SEEK_SET);
	fread(&datat, sizeof(int), (size_t)1, v->dat);
        fread(&datasz, sizeof(long), (size_t)1, v->dat);
        fread(&ret, sizeof(char), (size_t)datasz, v->dat);
        return ret;
}

void floc_readraw( floc *v, floc_t where, int *dt_mem, size_t *ds_mem, void **data_mem )
{
	void *unf;
	fseek(v->dat, (long)where, SEEK_SET);
	fread(dt_mem, sizeof(int), (size_t)1, v->dat);
	fread(ds_mem, sizeof(long), (size_t)1, v->dat);
	unf = malloc( (*ds_mem*sizeof(char)) );
	fread(unf, sizeof(char), *ds_mem, v->dat);
	*data_mem = unf;
}

void floc_seekend( floc *v )
{
	char current[9];
	fseek(v->dat,0,SEEK_END); /* seek to eof */
	if ( v->end != -1 ) { fseek(v->floc, v->end, SEEK_SET); return; }
	rewind(v->floc);
	while(1) {
                if (feof(v->floc)) break;
                fread (current, sizeof(char), (size_t)8, v->floc); current[8]='\0';
                if (!strncmp(current,"\n\n\n\n\n\n\n\n", 8)) {
			fseek(v->floc, -8, SEEK_CUR); v->end=ftell(v->floc); break;
		}
        }
	if (v->end == -1 ) v->end=ftell(v->floc);
}

void floc_terminate( floc *v )
{
	floc_seekend(v);
	fwrite("\n\n\n\n\n\n\n\n", sizeof(char), (size_t)8, v->floc);
}

floc_t floc_addrec( floc *v, char *thename )
{
	long q; floc_t ret;
	floc_seekend(v);
	fwrite(thename, sizeof(char), (size_t)8, v->floc);
	q=ftell(v->dat); ret=(floc_t)q;
	fwrite(&q, sizeof(long), (size_t)1, v->floc);
	v->end=ftell(v->floc);
	return ret;
}

void floc_write( floc *v, floc_t where, dtype_t dt, long ds, void *dat )
{
	fseek(v->dat, (long)where, SEEK_SET);
	fwrite(&dt, sizeof(int), (size_t)1, v->dat);
	fwrite(&ds, sizeof(long), (size_t)1, v->dat);
	fwrite(dat, sizeof(char), (size_t)ds, v->dat);
}

void floc_hdr ( floc *v, floc_t where, dtype_t dt, long ds )
{
	fseek(v->dat, (long)where, SEEK_SET);
	if ( dt != -1 ) fwrite(&dt, sizeof(int), (size_t)1, v->dat);
	if ( ds != -1 ) fwrite(&ds, sizeof(long), (size_t)1, v->dat);
}

const char *dbuid( char *field )
{
	static char unf[5];
	strncpy(unf, field, 5); unf[5]='\0';
	return unf;
}

const char *dbfield( char *field )
{
	static char unf2[3]; char *suxer;
	suxer=field+6; strncpy(unf2, suxer, 3); unf2[3]='\0';
	return unf2;
}

void add_field( floc *v, char *user, char *field)
{
	char uname[5]; char fld[3]; char unf[8];
	strncpy(uname, user, 5); strncpy(fld, field, 3);
	strcat(unf,uname); strcat(unf,fld);
	floc_addrec(v,unf);
}

void set_strfield( floc *v, char *user, char *field, char *newstr, long dasize)
{
        char uname[5]; char fld[3]; char unf[9]; floc_t whe;
        strncpy(uname, user, 5); strncpy(fld, field, 3);
        strcat(unf,uname); strcat(unf,fld); strcat(unf,"*");
	whe = floc_best(v, unf);
	floc_write(v, whe, DTYPE_STRING, (size_t)dasize, newstr);
}

void set_longfield( floc *v, char *user, char *field, long newlong)
{
        char uname[5]; char fld[3]; char unf[9]; floc_t whe;
        strncpy(uname, user, 5); strncpy(fld, field, 3);
        strcat(unf,uname); strcat(unf,fld); strcat(unf,"*");
        whe = floc_best(v, unf);
        floc_write(v, whe, DTYPE_LONG, sizeof(long), &newlong);
}

void get_strfield( floc *v, char *user, char *field, char *mem)
{
        char uname[5]; char fld[3]; char unf[9]; floc_t whe;
        strncpy(uname, user, 5); strncpy(fld, field, 3);
        strcat(unf,uname); strcat(unf,fld); strcat(unf,"*");
        whe = floc_best(v, unf);
	floc_readstr(v, whe, mem);
}

long get_longfield( floc *v, char *user, char *field )
{
        char uname[5]; char fld[3]; char unf[9]; floc_t whe; long ret;
        strncpy(uname, user, 5); strncpy(fld, field, 3);
        strcat(unf,uname); strcat(unf,fld); strcat(unf,"*");
        whe = floc_best(v, unf);
	ret=floc_readlong(v, whe);
	return ret;
}

int uname_to_id( char *idfile, char *uname, char *idvar )
{
	FILE *fp; char inname[20]; char uid[6];
	fp=fopen(idfile,"r");
	while(1) {
	if(feof(fp)) break;
	fgets(inname, 20, fp); inname[12]='\0';
	fgets(uid, 6, fp); uid[5]='\0';
 printf("Chexoring: %s %s\n", inname, uid);
	if(!strcmp(inname,uname)) {strcpy(idvar,uid); fclose(fp); return 1;}
	}
	fclose(fp);
	return 0;
}

int next_id( char *idfile )
{
	int q=0, z;char bs[50]; FILE *fp;
	fp=fopen(idfile,"r");
	while(1) {
		if(feof(fp)) break;
		fgets(bs, 20, fp);
		fgets(bs, 6, fp);
		z=atoi(bs); if ( z > q ) q = z + 1;
	}
	fclose(fp);
	return q;
}

int write_id( char *idfile, char *uname, int id )
{
	char phearme[13]; FILE *fp;
	fp=fopen(idfile,"a");
	strncpy(phearme,uname,12); phearme[12]='\0';
	fprintf(fp,"%s\n%05d\n",phearme,id);
	fclose(fp);
}

		
