#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <syslog.h>
#ifdef __linux__
#include <linux/unistd.h>
#endif
#include <sys/file.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <dirent.h>
#include <signal.h>
#include <fcntl.h>
#include <ctype.h>
#include "../include/userfile.h"
#include "../include/sysconfig.h"

extern void reply(int n, char *fmt, ...);
extern void lreply(int n, char *fmt, ...);

static char nfos[5][50];

/***************************************************************************
	CHECK_NFOS
	Scrolls thru current directory, looking for files called "*.NFO".  If
	it is owned by root and less than 5k, it gets the axe.  if it is owned
	by root and greater than 5k, it is chowned to curuid.
***************************************************************************/
void
check_nfos(curuid)
	uid_t curuid;
{
	DIR *dirf;
	struct dirent *dn;
	struct stat st;
	int ct;
	int on_line = 0;
	int on_item = 0;
	char namebuf[20];
	
	bzero(nfos[0], sizeof(nfos[0]));
	bzero(nfos[1], sizeof(nfos[1]));
	bzero(nfos[2], sizeof(nfos[2]));
	bzero(nfos[3], sizeof(nfos[3]));
	bzero(nfos[4], sizeof(nfos[4]));

#ifdef DEBUG
	syslog(LOG_INFO, "[pheard] check_nfos()");
	debugfn();
#endif

	dirf = opendir(".");
	if (!dirf) {
		syslog(LOG_ERR, "[pheard] %s: show_bytes, error opening dir: %m", uf.name);
		return;
	}

	while (1) {
		dn = readdir(dirf);
		if (!dn)
			break;

		stat(dn->d_name, &st);
		if (S_ISREG(st.st_mode)) {
			/* Regular file */
			int len = strlen(dn->d_name);

			if ((dn->d_name[len-4] == '.')
				&& ((dn->d_name[len-3] == 'n') || (dn->d_name[len-3] == 'N'))
				&& ((dn->d_name[len-2] == 'f') || (dn->d_name[len-2] == 'F'))
				&& ((dn->d_name[len-1] == 'o') || (dn->d_name[len-1] == 'O'))) {
				if ((st.st_uid == (uid_t) 0) && (st.st_size < 5012)) {
					unlink(dn->d_name);
				} else {
					if (on_item == 3) {
						on_line++;
						on_item = 0;
					}

					if (on_line < 5) {
						sprintf(namebuf, "%-15.15s", dn->d_name);
						strcat(nfos[on_line], namebuf);
						on_item++;
					}

					(void) chmod(dn->d_name, S_IROTH|S_IRGRP|S_IWGRP|S_IRUSR|S_IWUSR);
					(void) chown(dn->d_name, 0, (gid_t) 0);
				}
			}
		}
	}

	(void) closedir(dirf);
	return;
}
/*--- end of check_nfos() ------------------------------------------------*/


/***************************************************************************
	CHECK_ZIP
	Returns 0 if zipfile "name" is okay, 1 otherwise.
	This function also extracts the FILE_ID.DIZ.
***************************************************************************/
int 
check_zip(name)
	const char *name;
{
	char syscall_buff[MAXPATHLEN + 256];
	int x;
	char outbuff[90];
	char actname[MAXPATHLEN];
	int sys_retval = 0;
	char last_three[4];
	struct stat st;
	uid_t oldid = geteuid();

	if (strrchr(name, '/') == NULL)
		strncpy(actname, name, sizeof(actname));
	else
		strncpy(actname, strrchr(name, '/') + sizeof(char), sizeof(actname));

	/* Extract extension of file */
	last_three[0] = tolower(name[strlen(name) - 3]);
	last_three[1] = tolower(name[strlen(name) - 2]);
	last_three[2] = tolower(name[strlen(name) - 1]);
	last_three[3] = '\0';
	if ((!strcmp(last_three, "nfo"))||!strcmp(last_three, "diz")) {
		return (0);
	}
	/* Check ZIP file for errors, simultaneously extracting the FILE_ID.DIZ */
	lreply(226, "!G!5.-----------------------------------------------------------------------.!0");
	if (!strcmp(last_three, "zip")) {
		sprintf(outbuff, "Processing ZIP file \"!g!5%s!E!5\":", actname);
		lreply(226, "!G!5|!E!5 %-78.78s!G!5|!0", outbuff);
		lreply(226, "!G!5|-----------------------------------------------------------------------|!0");

		lreply(226, "!G!5|!D!5 Checking ZIP file integrity...                                        !G!5|");
		sprintf(syscall_buff, "%s/unzip -tqq %s >/dev/null 2>&1", cf.datapath, name);
		sys_retval = system(syscall_buff);
		wait(0);
		if ((sys_retval != 0) && (sys_retval != 127)) {
			sprintf(outbuff, "File \"%s\" failed ZIP check.", actname);
			lreply(226, "!G!5|!D!5 %-73.73s!G!5|", outbuff);
			lreply(226, "!G!5`-----------------------------------------------------------------------'!0");
			return (sys_retval);		/* FAILED! */
		}

		lreply(226, "!G!5|!D!5 Extracting FILE_ID.DIZ/NFO files...                                   !G!5|");
		sprintf(syscall_buff, "%s/unzip -Cpoqq %s file_id.diz >FILE_ID.DIZ 2>/dev/null", cf.datapath, name);
		(void) system(syscall_buff);
		wait(0);

		/* Now we extract all NFO files: */
		sprintf(syscall_buff, "%s/unzip -LCoqq %s *.nfo >/dev/null 2>&1", cf.datapath, name);
		(void) system(syscall_buff);
		wait(0);
		seteuid(0);
		check_nfos(oldid); 

		if (nfos[0][0] == '\0')
			lreply(226, "!G!5|!D!5 Extracted NFO files: !g!5None found...                                    !G!5|");
		else
			lreply(226, "!G!5|!D!5 Extracted NFO files: !g!5%-45.45s    !G!5|!0", nfos[0]);

		for (x = 1; x < 5; x++)
			if (nfos[x][0] != '\0')
				lreply(226, "!G!5|!D!5                      !g!5%-45.45s    !G!5|!0", nfos[1]);

		/*
		 * Call script <datapath>/zipscript $1 $2
		 * where $1 is the full pathname and $2 is the username
		 */
		sprintf(syscall_buff, "%s/zipscript", cf.datapath);
		if (!stat(syscall_buff, &st)) {
			lreply(226, "!G!5|!D!5 Tagging ZIP...                                                        !G!5|");
			sprintf(syscall_buff, "%s/zipscript %s", cf.datapath, name);
			(void) system(syscall_buff);
			wait(0);
		}

		lreply(226, "!G!5|!D!5 Setting modes on extracted file...                                    !G!5|");
		(void) chmod("FILE_ID.DIZ", S_IROTH|S_IRGRP|S_IWGRP|S_IRUSR|S_IWUSR);
		(void) chown("FILE_ID.DIZ", 0, (gid_t) 3000);
	}

	/* lreply(226, "!G!5|-----------------------------------------------------------------------!G!5|"); */
	sprintf(outbuff, "File \"%s\" passed ZIP check.", actname);
	lreply(226, "!G!5|!D!5 %-70.70s!G!5|", outbuff);
	lreply(226, "!G!5`-----------------------------------------------------------------------'");

	seteuid(oldid);

	return (0);
}
/*-- end of check_zip() ---------------------------------------------------*/
