/***************************************************************************
	MONTHSTART
***************************************************************************/

time_t
monthstart( void )
{
        struct tm *timebuf;                     /* "struct tm" time buffer */
        time_t    curtime;                      /* Current time */
        time_t   midnight;                      /* Time at midnight */
        int       offset;                               /* # of days since sunday */
        char      daybuf[ 4 ];          /* Day of week expressed as a string */
        char      *days[7] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };

#ifdef DEBUG
        syslog( LOG_INFO, "[pheard] monthstart()" );
        debugfn();
#endif

        time( &curtime );                                                       /* Get current time */

        timebuf = localtime( &curtime );                /* Fill tm struct */

	timebuf->tm_mday = 1;
        timebuf->tm_hour = 0;                                   /* Set tm struct to midnight */
        timebuf->tm_min = 0;
        timebuf->tm_sec = 0;

        midnight = mktime( timebuf );                   /* Get time_t from tm struct */

        sprintf( daybuf, "%.3s",
                ctime( &midnight ) );                           /* Get day of week as string */

        for ( offset = 0;
                        strcmp( days[ offset ], daybuf ) && offset < 7;
                        offset++ );

        return ( midnight - ( offset * 86400 ) );
}
/*-- end of monthstart() --------------------------------------------------*/

/***************************************************************************
	WEEKSTART
	Returns the time_t value for Midnight of this previous Sunday.
***************************************************************************/

time_t 
weekstart( void )
{
	struct tm *timebuf;			/* "struct tm" time buffer */
	time_t    curtime;			/* Current time */
	time_t 	 midnight;			/* Time at midnight */
	int       offset;				/* # of days since sunday */
	char      daybuf[ 4 ];		/* Day of week expressed as a string */
	char      *days[7] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
												
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] weekstart()" );
	debugfn();
#endif
	
	time( &curtime );							/* Get current time */
  
	timebuf = localtime( &curtime );		/* Fill tm struct */
	
	timebuf->tm_hour = 0;					/* Set tm struct to midnight */
	timebuf->tm_min = 0;
	timebuf->tm_sec = 0;
	
	midnight = mktime( timebuf );			/* Get time_t from tm struct */
	
	sprintf( daybuf, "%.3s", 
		ctime( &midnight ) ); 				/* Get day of week as string */
													/* Get days since Sunday */
	for ( offset = 0; 
			strcmp( days[ offset ], daybuf ) && offset < 7; 
			offset++ );

	return ( midnight - ( offset * 86400 ) );
}
/*-- end of weekstart() --------------------------------------------------*/

/***************************************************************************
	DAYSTART
***************************************************************************/

time_t
daystart( void )
{
        struct tm *timebuf;                     /* "struct tm" time buffer */
        time_t    curtime;                      /* Current time */
        time_t   midnight;                      /* Time at midnight */
        int       offset;                               /* # of days since sunday */
        char      daybuf[ 4 ];          /* Day of week expressed as a string */
        char      *days[7] = { "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };

#ifdef DEBUG
        syslog( LOG_INFO, "[pheard] daystart()" );
        debugfn();
#endif

        time( &curtime );                                                       /* Get current time */

        timebuf = localtime( &curtime );                /* Fill tm struct */

        timebuf->tm_hour = 0;                                   /* Set tm struct to midnight */
        timebuf->tm_min = 0;
        timebuf->tm_sec = 0;

        midnight = mktime( timebuf );                   /* Get time_t from tm struct */

        return ( midnight );
}
/*-- end of daystart() --------------------------------------------------*/


