#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <syslog.h>
#ifdef __linux__
#include <linux/unistd.h>
#endif
#include <sys/file.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <stdarg.h>
#include <dirent.h>
#include <signal.h>
#include <fcntl.h>
#include <ctype.h>
#include "../include/userfile.h"
#include "../include/sysconfig.h"

extern void reply( int n, char *fmt, ... );
extern void lreply( int n, char *fmt, ... );
extern void send_msg( int msgcode, char *msgstr, int send_reply );
extern int isuser( char *checkname );
extern size_t commafmt( char *buf, int	bufsize, unsigned long N );
extern int load_userfile( char *username );
extern void update_user( void );
extern char *trim( char *str );
extern int isdeluser( char *checkname );
extern int check_ip( char *testip );
extern void showuser (int msgcode, char *args);
extern uid_t userid; 

/***************************************************************************
   HOWMANYUSERS
	List # of users on site.
***************************************************************************/

int
howmanyusers( void )
{		
  	DIR *dirf;
  	struct dirent *dn;
  	struct stat st;
  	char temppath[MAXPATHLEN + 1];
  	int numusers = 0;
  	uid_t oldid = geteuid();
	int ct;
											 
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] howmanyusers()" );
	debugfn();
#endif
  				 
	seteuid( 0 );

  	sprintf (temppath, "%s/users", cf.datapath);
  	dirf = opendir (temppath);
  	if (!dirf)
   {
   	syslog (LOG_ERR, "[pheard] %s: userlist, error opening user dir: %m",
	      uf.name);
		seteuid( oldid );
      return 0;
   }

  	while (1)
   {
      dn = readdir (dirf);
      if (!dn)
			break;
      sprintf (temppath, "%s/users/%s", cf.datapath, dn->d_name);
      stat (temppath, &st);
      if ( S_ISREG (st.st_mode) && st.st_uid != 99 && st.st_gid != 99 )
		  	numusers++;
	}

  	(void) closedir (dirf);
  
  	seteuid( oldid );
	
  	return (numusers);
}
/*-- end of howmanyusers() ------------------------------------------------*/



/***************************************************************************
   SYSOPLOG
	Writes a line to the sysop log file
***************************************************************************/

void
sysoplog( char *fmt, ... )
{           
   char    linebuf[ MAXPATHLEN ];
	char    pidbuf[ 10 ];
 	va_list argp;  
   FILE    *lf;
   char    temppath[ MAXPATHLEN+1 ];
   time_t  curtime = time( NULL );
  uid_t oldid = geteuid();

#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] sysoplog()" );
	debugfn();
#endif
	
	va_start( argp, fmt );
	vsprintf( linebuf, fmt, argp );
	va_end( argp );
   			 
	seteuid( 0 );
	
   sprintf( temppath, "%s/logs/sysop.log", cf.datapath );
   lf = fopen( temppath, "a" );
   if ( lf != NULL )
   {							
		sprintf( pidbuf, "%d", getpid() );
      fprintf( lf, "%.24s [%-6.6s] %s\n", ctime( &curtime ), pidbuf, linebuf );
      fclose( lf );
   }				 
	
	seteuid( oldid );
}
/*-- end of sysoplog() ---------------------------------------------------*/
			  


/***************************************************************************
   ADDUSER
***************************************************************************/
                
void
adduser( int msgcode, char *args )
{
   char *tokptr;
   char username[ BUFSIZ ];
   char *password;
   char sysbuff[ BUFSIZ ];
   char curruser[ BUFSIZ ];
   mode_t oldmask;
   uid_t oldid = geteuid();
	int pass_was_chosen = 0;
                                   
#ifdef DEBUG
   syslog( LOG_INFO, "[pheard] adduser()" );
   debugfn();
#endif

   /*
    * Get username to add
    */   
   tokptr = strtok( args, " " );    
   strncpy( username, tokptr, sizeof( username ) );
   if ( isuser( username ) )
   {
      reply( msgcode, "!GUser already exists!0");
      return;
   }
   
   /*
    * Get password
    */
   tokptr = strtok( '\0', " " );
   if ( tokptr == NULL )
   {
   	reply( msgcode, "!GEnter a password!0");
	return;
   } else {
	password = tokptr;
   }
	
   seteuid(0);
   sprintf( sysbuff, "%s/ua %s %s", cf.datapath, password, username );
      
   system( sysbuff );
   wait( 0 );
   seteuid( oldid );
   strncpy( curruser, uf.name, sizeof( curruser ) );
   if ( load_userfile( "default.user" ) )
		syslog( LOG_ERR, "[pheard] Calling function was adduser(1)" );
   strncpy( uf.name, username, sizeof( uf.name ) );
   update_user();
   if ( load_userfile( curruser ) )
		syslog( LOG_ERR, "[pheard] Calling function was adduser(2)" );
   
   sprintf( sysbuff, "%s/users/%s", cf.datapath, username );
   oldmask = umask(0000);
   chmod( sysbuff, S_IROTH|S_IWOTH|S_IRGRP|S_IWGRP|S_IRUSR|S_IWUSR );
   umask( oldmask );

   sysoplog( "'%s' added user '%s'.", uf.name, username );
   reply( msgcode, "!GUser added!0." ); return;
}
/*-- end of adduser() ----------------------------------------------------*/
                  


/***************************************************************************
   DELUSER
***************************************************************************/

void
deluser( int msgcode, char *args )
{
   char *tokptr;
   char username[ BUFSIZ ];
   char sysbuff[ BUFSIZ ];
   char curruser[ BUFSIZ ];
   int  mylevel;
   uid_t oldid = geteuid();
   FILE *byefile;
                                  
#ifdef DEBUG
   syslog( LOG_INFO, "[pheard] deluser()" );
   debugfn();
#endif
   
   /*
    * Get username to add
    */   
   tokptr = strtok( args, " " );    
   strncpy( username, tokptr, sizeof( username ) );
   strncpy( curruser, uf.name, sizeof( curruser ) );
   if ( !isuser( username ) )                         /* Does user exist? */
   {
      reply( msgcode, "!GUser does not exist!0", username );
      return;
   }
                
   mylevel = uf.level;
   if ( load_userfile( username ) )
		syslog( LOG_ERR, "[pheard] Calling function was deluser(1)" );
   if ( uf.level >= mylevel )
   {
      reply( msgcode, "!DInvalid Access. !GYou cannot delete levels with a higher level!0" );
      if ( load_userfile( curruser ) )
			syslog( LOG_ERR, "[pheard] Calling function was deluser(2)" );
      return;
   }

   seteuid(0);
   uf.level = 0;
   update_user();
   if ( load_userfile( curruser ) )
		syslog( LOG_ERR, "[pheard] Calling function was deluser(3)" );
   
   sprintf( sysbuff, "%s/users/%s", cf.datapath, username );
   chown( sysbuff, (pid_t)99, (uid_t)99 );
   
                             
   sprintf( sysbuff, "%s/byefiles/%s.bye", cf.datapath, username );
   byefile = fopen( sysbuff, "w" );
   if ( byefile )
   {               
      sprintf( sysbuff, "%%!%s/byefiles/default.bye\n", cf.datapath );
      fputs( sysbuff, byefile );
      fclose( byefile );
   }
   
   seteuid( oldid );
   
   sysoplog( "'%s' deleted user '%s'.", uf.name, username );

   reply( msgcode, "User removed." );      
}
/*-- end of deluser() ----------------------------------------------------*/



/***************************************************************************
   READD
***************************************************************************/

void
readd( int msgcode, char *args )
{		                
   char *tokptr;
   char username[ BUFSIZ ];
	char workbuf[ BUFSIZ ];
   char currentuser[ 40 ];
	uid_t oldid = geteuid();
   										 
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] readd()" );
	debugfn();
#endif
	
	/*
	 * Get username to change
	 */	
	tokptr = strtok( args, " " );	 
	strncpy( username, tokptr, sizeof( username ) );
   if ( !isdeluser( username ) )
   {
      reply( msgcode, "!GInvalid User.!0");
      return;
   }	  
	
	seteuid( 0 );
   
   strcpy( currentuser, uf.name );
   if ( load_userfile( username ) )
		syslog( LOG_ERR, "[pheard] Calling function was readd(1)" );
	uf.level = 1;
   update_user();
								  
	sprintf( workbuf, "%s/byefiles/%s.bye", cf.datapath, uf.name );
	unlink( workbuf );
	
	sprintf( workbuf, "%s/users/%s", cf.datapath, uf.name );
	chown( workbuf, (uid_t)0, (gid_t)0 );
	
   if ( load_userfile( currentuser ) )
		syslog( LOG_ERR, "[pheard] Calling function was readd(2)" );
	
	seteuid( oldid );
   
   sysoplog( "'%s' readded '%s'.", uf.name, username );
   reply( msgcode, "!GUser readded.!0");
}
/*-- end of readd() ------------------------------------------------------*/


/***************************************************************************
   ADDIP
***************************************************************************/

void
addip( int msgcode, char *args )
{		                
   char *tokptr;
   char username[ BUFSIZ ];
   char ip_to_add[ BUFSIZ ];
   char currentuser[ 40 ];
   int  ct;
   int  done = 0;
	int  ipcheck;
   										 
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] addip()" );
	debugfn();
#endif
	
	/*
	 * Get username to change
	 */	
	tokptr = strtok( args, " " );	 
	strncpy( username, tokptr, sizeof( username ) );
   if ( !isuser( username ) )
   {
      reply( msgcode, "!GUnknown User.!0");
      return;
   }
   
   /*
    * Get IP
    */
   tokptr = strtok( '\0', " " );
   if ( tokptr == NULL )
   {
      reply( msgcode, "!GYou must suppliy an IP.");
      return;
   }
   strncpy( ip_to_add, tokptr, sizeof( ip_to_add ) );
   trim( ip_to_add );
   strcpy( currentuser, uf.name );
   if ( load_userfile( username ) )
		syslog( LOG_ERR, "[pheard] Calling function was addip(1)" );
   for ( ct = 0; ct < 20 && !done; ct++ )
   {
      if ( uf.ip[ ct ][ 0 ] == '\0' )
      {
         strncpy( uf.ip[ ct ], ip_to_add, sizeof( uf.ip[ ct ] ) );
         done = 1;
      }
   }

   update_user();
   if ( load_userfile( currentuser ) )
		syslog( LOG_ERR, "[pheard] Calling function was addip(2)" );
   
   if ( !done )
   {
      reply( msgcode, "!GUser has maximum number of IPS currently (!g20!G)!0");
      return;
   }
          
   sysoplog( "'%s' added ip '%s' to '%s'", uf.name, ip_to_add, username );
   reply( msgcode, "!GIP Successfully added.!0");
}
/*-- end of addip() ------------------------------------------------------*/
                                                                



/***************************************************************************
   DELIP
***************************************************************************/

void
delip( int msgcode, char *args )
{		                
   char *tokptr;
   char username[ BUFSIZ ];
   char ip_to_del[ BUFSIZ ];
   int  whichip = 999;
   char currentuser[ 40 ];
   char old_ip[ BUFSIZ ];
   									  
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] delip()" );
	debugfn();
#endif
	
	/*
	 * Get username to change
	 */	
	tokptr = strtok( args, " " );	 
	strncpy( username, tokptr, sizeof( username ) );
   if ( !isuser( username ) )
   {
      reply( msgcode, "!GInvalid User.!0");
      return;
   }
   
   /*
    * Get IP
    */
   tokptr = strtok( '\0', " " );
   if ( tokptr == NULL )
   {
      reply( msgcode, "!GSpecify which IP to delete (!g1-20!G)!0");
      return;
   }
	strncpy( ip_to_del, tokptr, sizeof( ip_to_del ) );
   trim( ip_to_del );
   whichip = atoi( ip_to_del );
  if ( whichip >> 20 ) {
	reply( msgcode, "!GIP must be between 0 and 20!0");
  	return;
  }
   
   strcpy( currentuser, uf.name );           /* Save current user name */
   if ( load_userfile( username ) )          /* Load user to alter */
		syslog( LOG_ERR, "[pheard] Calling function was delip(1)" );
	
   strncpy( old_ip, uf.ip[whichip], sizeof( old_ip ) );
   uf.ip[ whichip ][ 0 ] = '\0';             /* Delete IP */
   update_user();                            /* Update user */
   if ( load_userfile( currentuser ) )       /* Reload current user */
		syslog( LOG_ERR, "[pheard] Calling function was delip(2)" );
   
   if ( old_ip[ 0 ] == '\0' )
      reply( msgcode, "!GUser does not have that many IPs!0");
   else     
   {
      sysoplog( "'%s' removed ip '%s' from '%s'", uf.name, old_ip, username );
      reply( msgcode, "!GIP removed.!0");
   }
}
/*-- end of delip() ------------------------------------------------------*/

/***************************************************************************
    GADMIN
***************************************************************************/

void
gadmin(msgcode, args)
	int msgcode;
	char *args;
{
        char *tokptr;
        char currentuser[40];
		char addargs[BUFSIZ];
        int currentlevel;
        char user_name[BUFSIZ];
	char command[BUFSIZ];
        char arg[BUFSIZ];
	char grun[BUFSIZ];
        int ct;
        int okay = 0;
	int usringrp = 0;

#ifdef DEBUG
        syslog(LOG_INFO, "[pheard] ufchange()");
        debugfn();
#endif

	strncpy(grun, uf.gadmin, sizeof(grun));
	strncpy(currentuser, uf.name, sizeof(currentuser));
	currentlevel = uf.level;
        update_user();
        /* Get/check user_name */
        tokptr = strtok(args, " ");
        strncpy(command, tokptr, sizeof(command));
	if ((tokptr = strtok(NULL, " ")) == NULL)
	{
		reply(msgcode, "!BInsufficient Parameters.!0");
		return;
	}
        strncpy(user_name, tokptr, sizeof(user_name));

	if(strncasecmp(command, "ADDUSER", 7) == 0)
	{

	        tokptr = strtok(NULL, " ");
		strncpy(arg, tokptr, sizeof(arg));
		if (arg[0] == '\0') {
			reply(msgcode, "!GInsufficient Parameters!0");
			return;
		}
		strcat(addargs, user_name);
		strcat(addargs, " ");
		strcat(addargs, arg);
		adduser(msgcode, addargs);
	        if (!isuser(user_name)) {
                	reply(msgcode, "!GInvalid User!0");
        	        return;
	        }
	        /* save old values and load in values for the user we're modding */
	        strncpy(currentuser, uf.name, sizeof(currentuser));
	        currentlevel = uf.level;
        	update_user();
		clear_uf_struct();
        	if ( load_userfile(user_name) )
        	        syslog( LOG_ERR, "[pheard] Calling function was ufchange(1)" );

		uf.glock = 1;
		strncpy(uf.group_user[ 0 ], grun, sizeof( uf.group_user[ 0 ] ) );
        	update_user();
        	if ( load_userfile(currentuser) )
        	        syslog( LOG_ERR, "[pheard] Calling function was ufchange(9)" );

	}
	if (strncasecmp(command, "DELUSER", 7) == 0)
	{
		if (!isuser(user_name)) {
			reply(msgcode, "!GInvalid User!0");
			return;
		}

		if ( load_userfile(user_name) )
			syslog( LOG_ERR, "[pheard] Calling function was ufchange(1)" );

        	for (ct = 0; ct < 10; ct++)
		{
        	        if (!strcmp(uf.group_user[ct], grun))
				usringrp = 1;
                }
		if (usringrp == 0) 
		{
        	        if ( load_userfile(currentuser) )
                	        syslog( LOG_ERR, "[pheard] Calling function was ufchange(9)" );
			reply(msgcode, "!GUser not in group %s", grun);
			return;
		}
		if ( load_userfile(currentuser) )
			syslog( LOG_ERR, "[pheard] Calling function was ufchange(9)" );

		deluser(msgcode, user_name);
	}
        if (strncasecmp(command, "ADDIP", 7) == 0)
        {
        tokptr = strtok(NULL, " ");
        strncpy(arg, tokptr, sizeof(arg));
                if (arg[0] == '\0') {
                        reply(msgcode, "!GInsufficient Parameters!0");
                        return;
                }
                strcat(addargs, user_name);
                strcat(addargs, " ");
                strcat(addargs, arg);

                if (!isuser(user_name)) {
                        reply(msgcode, "!GInvalid User!0");
                        return;
                }   

                if ( load_userfile(user_name) )
                        syslog( LOG_ERR, "[pheard] Calling function was ufchange(1)" );

                for (ct = 0; ct < 10; ct++)
                {
                        if (!strcmp(uf.group_user[ct], grun))
                                usringrp = 1;
                }
                if (usringrp == 0)
                {
                        if ( load_userfile(currentuser) )
                                syslog( LOG_ERR, "[pheard] Calling function was ufchange(9)" );
			reply(msgcode, "!GUser not in group %s", grun);
                        return;
                }
                if ( load_userfile(currentuser) )
                        syslog( LOG_ERR, "[pheard] Calling function was ufchange(9)" );

		addip(msgcode, addargs);
        }
        if (strncasecmp(command, "DELIP", 7) == 0)
        {
        tokptr = strtok(NULL, " ");
        strncpy(arg, tokptr, sizeof(arg));
                if (arg[0] == '\0') {
                        reply(msgcode, "!GInsufficient Parameters!0");
                        return;
                }
                strcat(addargs, user_name);
                strcat(addargs, " ");
                strcat(addargs, arg);
                if (!isuser(user_name)) {
                        reply(msgcode, "!GInvalid User!0");
                        return;
                }   

                if ( load_userfile(user_name) )
                        syslog( LOG_ERR, "[pheard] Calling function was ufchange(1)" );

                for (ct = 0; ct < 10; ct++)
                {
                        if (!strcmp(uf.group_user[ct], grun))
                                usringrp = 1;
                }
                if (usringrp == 0)
                {
                        if ( load_userfile(currentuser) )
                                syslog( LOG_ERR, "[pheard] Calling function was ufchange(9)" );
			reply(msgcode, "!GUser not in group %s", grun);
                        return;
                }
                if ( load_userfile(currentuser) )
                        syslog( LOG_ERR, "[pheard] Calling function was ufchange(9)" );

        	delip(msgcode, addargs);
        }
}

#define NUM_FIELDS 9

char *fields[ NUM_FIELDS ] =
   { "ratio",
     "tagline",
     "num_logins",
     "exempt_from_limit",
     "credits",
     "level",
     "color",
     "glock",
     "gadmin" };
     
char *field_help[ NUM_FIELDS ] =
   { "[0-9] The user's ratio",
     "[Str] The user's tagline",
     "[0-9] Max concurrent connections for user (0=unlimited)",
     "[0,1] 1=User can log in even if site is full, 0 otherwise",
     "[Kb] User's Ratio Credits (use SITE GIVE to ADD)",
     "[0,1] Color for User??",
     "[0,1] 0=User can change group freely, 1=user locked into current group"
     "[Str] Group user has admin control over (none for none)" };

/***************************************************************************
   UFCHANGE
***************************************************************************/

void
ufchange(msgcode, args)
	int msgcode;
	char *args;
{
	char *tokptr;
	char currentuser[40];
	int currentlevel;
	char user_name[BUFSIZ];
	char field[BUFSIZ];
	char value[BUFSIZ];
	int ct;
	int okay = 0;

#ifdef DEBUG
	syslog(LOG_INFO, "[pheard] ufchange()");
	debugfn();
#endif

	/* Get/check user_name */
	tokptr = strtok(args, " ");
	strncpy(user_name, tokptr, sizeof(user_name));

	/* check for SITE SYSOP HELP */
	if (strncasecmp(user_name, "HELP", 4) == 0) {
		lreply(msgcode, "Valid fields & descriptions:");
		lreply(msgcode, "");
		for (ct = 0; ct < NUM_FIELDS; ct++)
			lreply(msgcode, "!G%-17.17s !g%s!0", fields[ct], field_help[ct]);
		lreply(msgcode, "");

		reply(msgcode, "Command successful.", field);
		return;
	}

    /* check if user exists, may not need to continue */
	if (!isuser(user_name)) {
		reply(msgcode, "!GInvalid User!0");
		return;
	}

	/* Get <field> value or show user info */
	if ((tokptr = strtok(NULL, " ")) == NULL) {
		/* No <field>, show user information */
		showuser(msgcode, user_name);
		return;
	}
	strncpy(field, tokptr, sizeof(field));

	/* Get <value> or show field help */
	value[0] = '\0';
	do {
		if (tokptr = strtok(NULL, " ")) {
			strcat(value, tokptr);
			strcat(value, " ");
		}
	} while (tokptr);
	trim(value);

	if (value[0] == '\0') {
		/* No <value>, show help on field */
		for (ct = 0; ct < NUM_FIELDS; ct++) {
			if (strcmp(field, fields[ct]) == 0) {
				reply(msgcode, "!G%s  !g%s", fields[ct], field_help[ct]);
				return;
			}
		}
		lreply(msgcode, "!GValid fields:!0");
		lreply(msgcode, "");
		for (ct = 0; ct < NUM_FIELDS; ct++)
			lreply(msgcode, "!E%-17.17s !g%s!0", fields[ct], field_help[ct]);
		reply(msgcode, "");
		return;
	}

	/* check for valid field */
	for (ct = 0; ct < NUM_FIELDS; ct++) {
		if (strcmp(field, fields[ct]) == 0) { okay = 1; }
	}

	/* field not valid */
	if (okay == 0) {
		lreply(msgcode, "!GValid fields:!0");
		lreply(msgcode, "");
		for (ct = 0; ct < NUM_FIELDS; ct++)
			lreply(msgcode, "!E%-17.17s !g%s", fields[ct], field_help[ct]);
		lreply(msgcode, "");
		reply(msgcode, "!GInvalid Field!0");
		return;
	}

	/* save old values and load in values for the user we're modding */
	strncpy(currentuser, uf.name, sizeof(currentuser));
	currentlevel = uf.level;
	update_user();
	if ( load_userfile(user_name) )
		syslog( LOG_ERR, "[pheard] Calling function was ufchange(1)" );

	/* Do the appropriate thing for each field */
	if (strcmp(field, "color") == 0) {
		int itmp = atoi(value);
		if ( (itmp < 0) || (itmp > 1) ) {
                	reply(msgcode, "!GInvalid Value. (!g0/1!G)!0", itmp);
                	if ( load_userfile(currentuser) )
                		syslog( LOG_ERR, "[pheard] Calling function was ufchange(5)" );
                	return;
                }
                uf.use_color = itmp;
        }
	if (strcmp(field, "level") == 0) {
		int itmp = atoi(value);
		if ( currentlevel < itmp ) {
			reply(msgcode, "!DInvalid Access. !GCannot set levels higher than your own.!0");
			if ( load_userfile(currentuser) )
				syslog( LOG_ERR, "[pheard] Calling function was ufchange(2)" );
			return;
		}
		if ( (itmp < 1) || (itmp > 25) ) {
			reply(msgcode, "!GInvalid Level.!0");
			if ( load_userfile(currentuser) )
				syslog( LOG_ERR, "[pheard] Calling function was ufchange(5)" );
			return;
		}
		sysoplog("'%s' changed level for '%s' from '%d' to '%d'", currentuser, user_name, uf.level, itmp );
		uf.level = itmp;
	}
	if (strcmp(field, "ratio") == 0) {
		int itmp = atoi(value);

		if (currentlevel < 15) {
			reply(msgcode, "!DInvalid Access. !GYou cannot set ratios.!0");
			if ( load_userfile(currentuser) )
				syslog( LOG_ERR, "[pheard] Calling function was ufchange(2)" );
			return;
		}

		if ((itmp < 0) || (itmp > 9)) {
			reply(msgcode, "!GInvalid Ratio.!0");
			if ( load_userfile(currentuser) )
				syslog( LOG_ERR, "[pheard] Calling function was ufchange(5)" );
			return;
		}

		sysoplog("'%s' changed ratio for '%s' from '%d' to '%d'",
			currentuser, user_name, uf.ratio, itmp);
		uf.ratio = itmp;
	}

	else if (strcmp(field, "tagline") == 0) {
		sysoplog("'%s' changed tagline for '%s' from '%s' to '%s'",
			currentuser, user_name, uf.tagline, value);
		strncpy(uf.tagline, value, sizeof(uf.tagline));
	}                    

	else if (strcmp(field, "num_logins") == 0) {
		int itmp = atoi(value);
		if ((itmp < 0) || (itmp > 15)) {
			reply(msgcode, "!GInvalid Number.!0");
				syslog( LOG_ERR, "[pheard] Calling function was ufchange(6)" );
			return;
		}
		sysoplog("'%s' changed num_logins for '%s' from '%d' to '%d'",
			currentuser, user_name, uf.num_logins, itmp);
		uf.num_logins = itmp;
	}

	else if (strcmp(field, "exempt_from_limit") == 0) {
		int itmp = atoi(value);
		if ((itmp != 0) && (itmp != 1)) {
			reply(msgcode, "!GInvalid Value. (!g0/1!G)!0");
			if ( load_userfile(currentuser) )
				syslog( LOG_ERR, "[pheard] Calling function was ufchange(7)" );
			return;
		}
		sysoplog("'%s' changed exempt_from_limit for '%s' from '%d' to '%d'",
			currentuser, user_name, uf.exempt_from_limit, itmp);
		uf.exempt_from_limit = itmp;
	}

	else if (strcmp(field, "credits") == 0) {
		ulong ultmp = strtoul(value, NULL, 0);

		if (errno == ERANGE) {
			lreply(msgcode, "!GInvalid Value. Resized.!0");
		}
		sysoplog("'%s' changed credits for '%s' from '%lu' to '%lu'",
			currentuser, user_name, uf.credits, ultmp);
		uf.credits = ultmp;
	}

	else if (strcmp(field, "glock") == 0) {
		int newval = atoi(value);
		if ((newval != 0) && (newval != 1)) {
			reply(msgcode, "!BInvalid Value (!b0/1!B)!0");
                        if ( load_userfile(currentuser) )
                                syslog( LOG_ERR, "[pheard] Calling function was ufchange(7)" );
                        return;
                }
                sysoplog("'%s' changed glock for '%s' from '%d' to '%d'",
			currentuser, user_name, uf.glock, newval);
		uf.glock = newval;
	}

        else if (strcmp(field, "gadmin") == 0) {
                sysoplog("'%s' changed gadmin for '%s' from '%s' to '%s'",
                        currentuser, user_name, uf.gadmin, value);
                strncpy(uf.gadmin, value, sizeof(uf.gadmin));
        }
	/* save the updates and then reload our info */
	update_user();
	if ( load_userfile(currentuser) )
		syslog( LOG_ERR, "[pheard] Calling function was ufchange(9)" );

	reply(msgcode, "!GSuccessfully Changed.!0");
}
/*-- end of ufchange() -------------------------------------------------------*/

