#include <stdio.h> 
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <syslog.h>
#include <time.h>
#include <pwd.h>
#include <grp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/param.h>
#include <arpa/ftp.h>
#include <paths.h>
#include <unistd.h>
#include "../include/userfile.h"
#include "../include/sysconfig.h"

extern char	hostname[ MAXHOSTNAMELEN ];
extern char	remotehost[ MAXHOSTNAMELEN ];
extern int dl_this_call;
extern int ul_this_call;
extern ulong dlbytes_this_call;
extern ulong ulbytes_this_call;
extern char hmsbuf[ 20 ];
extern time_t logintime;
extern int show_requests (int msgcode);
extern size_t commafmt( char *buf, int	bufsize, unsigned long N );
extern void lreply( int n, char *fmt, ... );
extern int howmanytimes( char *which );
extern int build_online_info( void );
extern void show_newx( int msgcode, char *reqdir, char *numtimes );
extern int show_oneliners (int msgcode);
extern void pid_hms_format( time_t testtime );
extern char *trim( char *str );
extern void show_stats( int use_lreply );
extern int lshow_stats( int msgcode );
extern uid_t userid; 

static char lldhmbuf[ 40 ];

/***************************************************************************
   LL_HMS_FORMAT
***************************************************************************/
                              
void
ll_hms_format( time_t dirtime )
{
   time_t timenow = time( NULL );
   time_t difftime;
   int    days = 0;
   int    hours = 0;
   int    minutes = 0;

#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] ll_hms_format()" );
	debugfn();
#endif
   
   difftime = timenow - dirtime;
   
   while ( difftime >= (time_t)86400 )
   {
      difftime -= (time_t)86400;
      days++;
   }
   
   while ( difftime >= (time_t)3600 )
   {
      difftime -= (time_t)3600;
      hours++;
   }          
   
   while ( difftime >= (time_t)60 )
   {
      difftime -= (time_t)60;
      minutes++;
   }
   
   if ( days != 0 )
      sprintf( lldhmbuf, "%d day%s, %d hour%s, %d minute%s", 
					days, (days==1)?"":"s",
					hours, (hours==1)?"":"s",
					minutes, (minutes==1)?"":"s" ); 
   else if ( hours != 0 )
      sprintf( lldhmbuf, "%d hour%s, %d minute%s", 
					hours, (hours==1)?"":"s",
					minutes, (minutes==1)?"":"s" );
   else
      sprintf( lldhmbuf, "%d minute%s", 
					minutes, (minutes==1)?"":"s" );
}
/*-- end of ll_hms_format() -----------------------------------------------*/



/****************************************************************************
	COOKIEFMT
	Formats 'inbuf' into 'outbuf', replacing magic cookies properly...
****************************************************************************/

void
cookiefmt( int msgcode, char *inbuf, char *outbuf, struct stat st )
{
   char 	  	 *inptr = inbuf;
   char 	  	 *outptr = outbuf;
	char      numbuff[ 65 ];
	struct tm *ptr;
   time_t 	 curtime;
	time_t    timediff;

#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] cookiefmt()" );
	debugfn();
#endif

   (void)time( &curtime );

	while ( *inptr ) 
   {
		if ( *inptr != '%' )
      {
         *outptr++ = *inptr;
      }
      else 
      {
         switch ( *++inptr ) 
         {
				case 'a': /* ANSI/vt test No 1 */
					sprintf( outptr, "%c[1;34mF%c[1;35mU%c[1;36mC%c[1;37mK",
						27,27,27,27 );
					break;
					
            case 'E':	/* %E: Email address */
					sprintf( outptr, "%s", cf.email );
					break;
					
            case 'N': 	/* %N: Max # of users allowed online */
					sprintf( outptr, "%d", cf.max_users );
               break;
					
				case 'Q':   /* %Q: Total number of times logged in */
					sprintf( outptr, "%d", uf.login_times );
					break;

            case 'M':	/* %M: Max # of simultaneous logins for user */
					if ( uf.num_logins == 0 )
						strcpy( outptr, "unlimited" );
					else
						sprintf( outptr, "%d", uf.num_logins );
					break;		
					
				case 'B':	/* %B: Number of users currently logged in */
					sprintf( outptr, "%d", (build_online_info()+1) );
					break;
							
				case 'S':	/* %S: Number of times current user is logged in */
					sprintf( outptr, "%d", 
                  ( msgcode == 230 ) 
                     ? howmanytimes( uf.name ) + 1
                     : howmanytimes( uf.name ) - 1 );
					break;
					
            case 'T':	/* %T: Current time/date */
					sprintf( outptr, "%.24s", ctime( &curtime ) );
					break;	 
					
				case 'D': 	/* %M: Date/time current file was last modified */
					sprintf( outptr, "%.24s", ctime( &st.st_mtime ) );
					break;
					  
				case 'O':   /* %O: Time online this call */
					pid_hms_format( logintime );
					trim( hmsbuf );
					sprintf( outptr, "%s", hmsbuf );
					break;
					
				case 'I':   /* %I: Time online today */
					pid_hms_format( (time_t)( logintime - uf.time_on_today ) );
					trim( hmsbuf );
					sprintf( outptr, "%s", hmsbuf );
					break;
            							 
				case 'o':   /* %o: Time online this call, long format */
					pid_hms_format( logintime );
					trim( hmsbuf );
					sprintf( outptr, "%s", hmsbuf );
					break;
					
				case 'i':   /* %i: Time online today, long format */
					pid_hms_format( (time_t)( logintime - uf.time_on_today ) );
					trim( hmsbuf );
					sprintf( outptr, "%s", hmsbuf );
					break;
					
				case 'R':	/* %R: Remotehost */			
					strcpy( outptr, remotehost );
					break;

            case 'L':	/* %L: Hostname */
					strcpy( outptr, hostname );
               break;

            case 'U':	/* %U: Username */
					strcpy( outptr, uf.name );
					break;
					
				case 'V': 	/* %V: Current user's access level */
					sprintf( outptr, "%d", uf.level );
					break;
					
				case 'r':	/* %r: Ratio (in format 1:x or "unlimited") */
					if ( uf.ratio )
						sprintf( outptr, "1:%d", uf.ratio );
					else
						strcpy( outptr, "unlimited" );
					break;
					
				case 'u':	/*	%u: # of files uploaded */
					sprintf( outptr, "%d", uf.files_up );
					break;
					
				case 'C':	/*	%C: # of files uploaded this call */
					sprintf( outptr, "%d", ul_this_call );
					break;

				case 'w':	/* %w: # of files uploaded this week */
					sprintf( outptr, "%d", uf.files_up_wk );
					break;
					
				case 'b': 	/* %b: # of bytes uploaded */
					commafmt( numbuff, 64, uf.bytes_up * 1024U );
					strcpy( outptr, numbuff );
					break;
					
				case '1': 	/* %1: # of bytes uploaded this week */
					commafmt( numbuff, 64, uf.bytes_up_wk * 1024U );
					strcpy( outptr, numbuff );
					break;			
					
				case 'X': 	/* %X: # of bytes uploaded this call */
					commafmt( numbuff, 64, ulbytes_this_call );
					strcpy( outptr, numbuff );
					break;
					
					
				case 'd': 	/* %d: # of files downloaded */
					sprintf( outptr, "%d", uf.files_down );
					break;
					
#ifdef NOT_USED_ANYMORE					
				case 'h':   /* Current 'hot' directory */
					curtime = time( NULL );
					ptr = localtime( &curtime );
					strftime( numbuff, 64, "%m%d", ptr );
					sprintf( outptr, "%s", numbuff );
					break;  
#endif					
					
				case 'k':	/* %k: # of files downloaded this week */
					sprintf( outptr, "%d", uf.files_down_wk );
					break;		  
					
				case 'K':	/* %K: # of files downloaded this call */
					sprintf( outptr, "%d", dl_this_call );
					break;
					
				case '2':	/* %2: # of bytes downloaded */
					commafmt( numbuff, 64, uf.bytes_down * 1024U );
					strcpy( outptr, numbuff );
					break;										
					
				case '3':	/* %3: # of bytes downloaded this week */
					commafmt( numbuff, 64, uf.bytes_down_wk * 1024U );
					strcpy( outptr, numbuff );
					break;
													 
				case 'Y':	/* %3: # of bytes downloaded this call */
					commafmt( numbuff, 64, dl_this_call );
					strcpy( outptr, numbuff );
					break;
					
				case '4':	/* %4: Avg k/sec (uploads only) */
					if ( uf.seconds_up != 0 )
						sprintf( outptr, "%.2f",
							(float)( uf.bytes_up / uf.seconds_up ));
					else
						strcpy( outptr, "---" );
					break;
					
				case '5':	/* %5: Avg k/sec (downloads only) */
					if ( uf.seconds_down != 0 )
						sprintf( outptr, "%.2f", 
							(float)( uf.bytes_down / uf.seconds_down ));
					else
						strcpy( outptr, "---" );
					break;
					
				case '6':	/* %6: Avg k/sec (overall) */
					if ( uf.seconds_up + uf.seconds_down != 0 )
						sprintf( outptr, "%.2f", 
							(float)( (uf.bytes_up+uf.bytes_down) / 
								(uf.seconds_up+uf.seconds_down) ) );
					else
						strcpy( outptr, "---" );
					break;
					
				case 't':	/* %t: User's tagline */
					strcpy( outptr, uf.tagline );
					break;

				case 'l':	/* %l: Last time/date online for user */
					ll_hms_format( uf.last_on );
					sprintf( outptr, "%s", lldhmbuf );
					break;										
							
				case 's':	/* %s: Number of simultaneous logins allowed */
					if ( uf.num_logins == 0 )
						strcpy( outptr, "unlimited" );
					else
						sprintf( outptr, "%d", uf.num_logins );
					break;									
					
				case 'c': 	/* %c: Amount of credit (before ratio kicks in) */
					if ( uf.ratio != 0 )
					{
						commafmt( numbuff, 64, uf.credits * 1024U );
						strcpy( outptr, numbuff );
					}
					else
					{
						strcpy( outptr, "unlimited" );
					}
					break;

            case '%':	/* %%: Literal '%' */
					*outptr++ = '%';
					*outptr = '\0';
					break;
					
            default:
					*outptr++ = '%';
					*outptr++ = '?';
					*outptr = '\0';
					break;
         } 
         
			while ( *outptr )
				outptr++;
      }
      inptr++;
   }
   *outptr = (char)NULL;
}
/*-- end of cookiefmt() ---------------------------------------------------*/ 


						  


/****************************************************************************
	SHOW_FILE
	Shows a file
	Returns number of lines outputted
	Returns -1 if file contains no lines but does exist
****************************************************************************/
										  
int
show_nuke_file( int msgcode, char *showname )
{
	FILE *infile;
	char linebuf[ 1024 ];
	char outbuf[ 1024 ];
	char *crptr;
	int  lines_disp = 0;
	struct stat st;
  uid_t oldid = geteuid();
												
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] show_file()" );
	debugfn();
#endif
				 
	seteuid( 0 );

	if ( stat( showname, &st ) )
	{
		seteuid( oldid );
		return 0;			
	}
	
   infile = fopen( showname, "r" );
   if ( infile )
   {
		while ( fgets( linebuf, 255, infile ) != NULL )
		{
			/*
			 * Strip trailing newline, if any
			 */
			if ( ( crptr = strchr( linebuf, '\n' ) ) != NULL )
				*crptr = ' ';
			if ( ( crptr = strchr( linebuf, '\r' ) ) != NULL )
				*crptr = ' ';
				
			/*
			 * Don't format for cookies if it's a tops list...to keep users
			 * from possibly doing anything malicious regarding cookies in their
			 * taglines...
			 */				
			if ( memcmp( showname, "tops.", 5 ) == 0 )
				strcpy( outbuf, linebuf );
			else
				cookiefmt( msgcode, linebuf, outbuf, st );
#ifdef VDR
			lreply( msgcode, "!G!5%s!0", outbuf );
#else
			lreply( msgcode, "!G%s!0", outbuf );
#endif
			lines_disp++;
		}
		fclose( infile );
   }
	
	seteuid( oldid );
 						  
	if ( lines_disp == 0 )
		lines_disp = -1;
		
	return( lines_disp );
}										
/*-- end of show_nukefile() ---------------------------------------------------*/
/****************************************************************************
	SHOW_FILE
	Shows a file
	Returns number of lines outputted
	Returns -1 if file contains no lines but does exist
****************************************************************************/
										  
int
show_file( int msgcode, char *showname )
{
	FILE *infile;
	char linebuf[ 1024 ];
	char outbuf[ 1024 ];
	char *crptr;
	int  lines_disp = 0;
	struct stat st;
  uid_t oldid = geteuid();
												
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] show_file()" );
	debugfn();
#endif
				 
	seteuid( 0 );

	if ( stat( showname, &st ) )
	{
		seteuid( oldid );
		return 0;			
	}
	
   infile = fopen( showname, "r" );
   if ( infile )
   {
		while ( fgets( linebuf, 255, infile ) != NULL )
		{
			/*
			 * Strip trailing newline, if any
			 */
			if ( ( crptr = strchr( linebuf, '\n' ) ) != NULL )
				*crptr = ' ';
			if ( ( crptr = strchr( linebuf, '\r' ) ) != NULL )
				*crptr = ' ';
				
			/*
			 * Don't format for cookies if it's a tops list...to keep users
			 * from possibly doing anything malicious regarding cookies in their
			 * taglines...
			 */				
			if ( memcmp( showname, "tops.", 5 ) == 0 )
				strcpy( outbuf, linebuf );
			else
				cookiefmt( msgcode, linebuf, outbuf, st );
			lreply( msgcode, "%s", outbuf );
			lines_disp++;
		}
		fclose( infile );
   }
	
	seteuid( oldid );
 						  
	if ( lines_disp == 0 )
		lines_disp = -1;
		
	return( lines_disp );
}										
/*-- end of show_file() ---------------------------------------------------*/ 
												 

	

/****************************************************************************
	SHOW_LVL_LESSTHAN
	Shows a file if the user's level is less than the first three digits of
	the "fname".
	Returns number of lines outputted
****************************************************************************/
										  
int
show_lvl_lessthan( int msgcode, char *fname )
{
	FILE *infile;
	char linebuf[ 1024 ];
	char showname[ 1024 ];
	char outbuf[ 1024 ];
	char *crptr;
	int  lines_disp = 0;
	struct stat st;
  	uid_t oldid = geteuid();
	int  numlevel;
												
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] show_lvl_lessthan()" );
	debugfn();
#endif

	strcpy( showname, fname + 3 );
	linebuf[ 0 ] = fname[ 0 ];
	linebuf[ 1 ] = fname[ 1 ];
	linebuf[ 2 ] = fname[ 2 ];
	linebuf[ 3 ] = '\0';
	
	numlevel = atoi( linebuf );
	if ( numlevel <= uf.level )
		return 0;
				 
	seteuid( 0 );

	if ( stat( showname, &st ) )
	{
		seteuid( oldid );
		return 0;			
	}
	
   infile = fopen( showname, "r" );
   if ( infile )
   {
		while ( fgets( linebuf, 255, infile ) != NULL )
		{
			/*
			 * Strip trailing newline, if any
			 */
			if ( ( crptr = strchr( linebuf, '\n' ) ) != NULL )
				*crptr = '\0';
				
			/*
			 * Don't format for cookies if it's a tops list...to keep users
			 * from possibly doing anything malicious regarding cookies in their
			 * taglines...
			 */				
			if ( memcmp( showname, "tops.", 5 ) == 0 )
				strcpy( outbuf, linebuf );
			else
				cookiefmt( msgcode, linebuf, outbuf, st );
			lreply( msgcode, "%s", outbuf );
			lines_disp++;
		}
		fclose( infile );
   }
	
	seteuid( oldid );
 
	return( lines_disp );
}										
/*-- end of show_lvl_lessthan() -------------------------------------------*/ 


/****************************************************************************
	SHOW_LVL_EQUAL
	Shows a file if the user's level is equal to the first three digits of
	the "fname".
	Returns number of lines outputted
****************************************************************************/
										  
int
show_lvl_equal( int msgcode, char *fname )
{
	FILE *infile;
	char linebuf[ 1024 ];
	char showname[ 1024 ];
	char outbuf[ 1024 ];
	char *crptr;
	int  lines_disp = 0;
	struct stat st;
  	uid_t oldid = geteuid();
	int  numlevel;
												
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] show_lvl_equal()" );
	debugfn();
#endif

	strcpy( showname, fname + 3 );
	linebuf[ 0 ] = fname[ 0 ];
	linebuf[ 1 ] = fname[ 1 ];
	linebuf[ 2 ] = fname[ 2 ];
	linebuf[ 3 ] = '\0';
	
	numlevel = atoi( linebuf );
	if ( numlevel != uf.level )
		return 0;
				 
	seteuid( 0 );

	if ( stat( showname, &st ) )
	{
		seteuid( oldid );
		return 0;			
	}
	
   infile = fopen( showname, "r" );
   if ( infile )
   {
		while ( fgets( linebuf, 255, infile ) != NULL )
		{
			/*
			 * Strip trailing newline, if any
			 */
			if ( ( crptr = strchr( linebuf, '\n' ) ) != NULL )
				*crptr = '\0';
				
			/*
			 * Don't format for cookies if it's a tops list...to keep users
			 * from possibly doing anything malicious regarding cookies in their
			 * taglines...
			 */				
			if ( memcmp( showname, "tops.", 5 ) == 0 )
				strcpy( outbuf, linebuf );
			else
				cookiefmt( msgcode, linebuf, outbuf, st );
			lreply( msgcode, "%s", outbuf );
			lines_disp++;
		}
		fclose( infile );
   }
	
	seteuid( oldid );
 
	return( lines_disp );
}										
/*-- end of show_lvl_equal() ----------------------------------------------*/ 
						 


/****************************************************************************
	SHOW_LVL_GREATERTHAN
	Shows a file if the user's level is greater than the first three digits of
	the "fname".
	Returns number of lines outputted
****************************************************************************/
										  
int
show_lvl_greaterthan( int msgcode, char *fname )
{
	FILE *infile;
	char linebuf[ 1024 ];
	char showname[ 1024 ];
	char outbuf[ 1024 ];
	char *crptr;
	int  lines_disp = 0;
	struct stat st;
  	uid_t oldid = geteuid();
	int  numlevel;
												
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] show_lvl_greaterthan()" );
	debugfn();
#endif

	strcpy( showname, fname + 3 );
	linebuf[ 0 ] = fname[ 0 ];
	linebuf[ 1 ] = fname[ 1 ];
	linebuf[ 2 ] = fname[ 2 ];
	linebuf[ 3 ] = '\0';
	
	numlevel = atoi( linebuf );
	if ( numlevel >= uf.level )
		return 0;
				 
	seteuid( 0 );

	if ( stat( showname, &st ) )
	{
		seteuid( oldid );
		return 0;			
	}
	
   infile = fopen( showname, "r" );
   if ( infile )
   {
		while ( fgets( linebuf, 255, infile ) != NULL )
		{
			/*
			 * Strip trailing newline, if any
			 */
			if ( ( crptr = strchr( linebuf, '\n' ) ) != NULL )
				*crptr = '\0';
			if ( ( crptr = strchr( linebuf, '\r' ) ) != NULL )
				*crptr = '\0';
				
			/*
			 * Don't format for cookies if it's a tops list...to keep users
			 * from possibly doing anything malicious regarding cookies in their
			 * taglines...
			 */				
			if ( memcmp( showname, "tops.", 5 ) == 0 )
				strcpy( outbuf, linebuf );
			else
				cookiefmt( msgcode, linebuf, outbuf, st );
			lreply( msgcode, "%s", outbuf );
			lines_disp++;
		}
		fclose( infile );
   }
	
	seteuid( oldid );
 
	return( lines_disp );
}										
/*-- end of show_lvl_greaterthan() ----------------------------------------*/ 



/****************************************************************************
	SHOW_MESSAGE
	Shows a message to the user.  
	mode = 0, normal
	returns the number of lines outputted
****************************************************************************/

int
show_message( int msgcode, char *msgname )
{								
	FILE *infile;
	char linebuf[ 1024 ];
	char outbuf[ 1024 ];
	char *crptr;
	int  lines_disp = 0;
	struct stat st;
	char seekmsg[ MAXPATHLEN+1 ];
   char tempname[ MAXPATHLEN+1 ];
	int  msgct = 0;  
	int  rnum;
  uid_t oldid = geteuid();
												
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] show_message()" );
	debugfn();
#endif		 

	seteuid( 0 );
	
	if ( stat( msgname, &st ) )
	{
		seteuid( oldid );
		return 0;
	}
			 
	do
	{
		sprintf( seekmsg, "%s.%d", msgname, msgct+1 );
		msgct++;
	} while( !stat( seekmsg, &st ) );
    
	
	if ( msgct )
	{			  
		rnum = time( NULL ) % msgct;
		if ( rnum == 0 )
			strcpy( seekmsg, msgname );
		else
			sprintf( seekmsg, "%s.%d", msgname, rnum );
	     
	}
						
   infile = fopen( seekmsg, "r" );
   if ( infile )
   {
		while ( fgets( linebuf, 255, infile ) != NULL )
		{	 
			/*
			 * Strip trailing newline, if any
			 */
			if ( ( crptr = strchr( linebuf, '\n' ) ) != NULL )
				*crptr = '\0';
			if ( ( crptr = strchr( linebuf, '\r' ) ) != NULL )
				*crptr = '\0';
				
			/*
			 * Replace these special cookies with entire files
			 */				
			if ( !memcmp( linebuf, "%REQS", 5 ) )
	 {
	 			lines_disp += show_requests( msgcode );
	 }
			else if ( !memcmp( linebuf, "%ONEL", 5 ) )
         {
				lines_disp += show_oneliners( msgcode );
         }		 
			else if ( !memcmp( linebuf, "%USTATS", 7 ) )
	 {
				lines_disp += lshow_stats( msgcode );
	 }
			else if ( !memcmp( linebuf, "%NUKES", 6 ) )
         {	  
				char nukefile[ MAXPATHLEN+1 ];
				char tempname[ MAXPATHLEN+1 ];
				struct tm *ptr;
				time_t timenow = time( NULL );
				int nukedf = 0;
				
				ptr = localtime( &timenow );
				strftime( tempname, 64, "/dupes/%m-%d-%Y.nuked", ptr );
			   sprintf( nukefile, "%s%s", cf.datapath, tempname );
								  
				nukedf = show_nuke_file( msgcode, nukefile );
				
				if ( !nukedf )
				{
					lreply( msgcode, "!GNo nukes today" );
					nukedf = 1;
				}
				lines_disp += nukedf;
         }
			else if ( !memcmp( linebuf, "%NEW", 4 ) )
         {
				char numbuff[3];
				
				numbuff[0]=linebuf[4];
				numbuff[1]=linebuf[5];
				numbuff[2]='\0';
				
            show_newx( msgcode, linebuf + 6, numbuff );
            lines_disp += 5;
         }										
 			else if ( !memcmp( linebuf, "%<", 2 ) )
			 	lines_disp += show_lvl_lessthan( msgcode, linebuf + 2 );
			else if ( !memcmp( linebuf, "%>", 2 ) )
			 	lines_disp += show_lvl_greaterthan( msgcode, linebuf + 2 );
			else if ( !memcmp( linebuf, "%=", 2 ) )
			 	lines_disp += show_lvl_equal( msgcode, linebuf + 2 );
			else if ( !memcmp( linebuf, "%!", 2 ) )
			 	lines_disp += show_file( msgcode, linebuf + 2 );
			else
			{
				cookiefmt( msgcode, linebuf, outbuf, st );
				lreply( msgcode, "%s", outbuf );
				lines_disp++;
			}
		}
		fclose( infile );
   }
								
	seteuid( oldid );
	
	return( lines_disp );
}
/*-- end of show_message() ------------------------------------------------*/ 


/****************************************************************************
	SHOW_HELP
	Shows the file <datapath>/help/<helpname>.
	Just a shortcut.  It calls show_message() so that you can use additional
	cookies.
****************************************************************************/
			  
void
show_help( int msgcode, const char *helpname )
{
	char namebuf[ MAXPATHLEN ];
	
	sprintf( namebuf, "%s/help/%s", cf.datapath, helpname );
	show_message( msgcode, namebuf );
	
	return;
}
/*-- end of show_help() ---------------------------------------------------*/ 


/****************************************************************************
	SHOW_TEXT
	Shows the file <datapath>/text/<helpname>.
	Just a shortcut.  It calls show_message() so that you can use additional
	cookies.
****************************************************************************/
			  
void
show_text( int msgcode, const char *helpname )
{
	char namebuf[ MAXPATHLEN ];
	
	sprintf( namebuf, "%s/text/%s", cf.datapath, helpname );
	show_message( msgcode, namebuf );
	
	return;
}
/*-- end of show_text() ---------------------------------------------------*/ 

