#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <syslog.h>
#ifdef __linux__
#include <linux/unistd.h>
#endif
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <signal.h>
#include <fcntl.h>
#include <ctype.h>
#include <sys/param.h>
#include "../include/sysconfig.h"
#include "../include/userfile.h"

struct msgpath
{
   char pathspec[ BUFSIZ ];
   int  seen;
   struct msgpath *next;
   struct msgpath *prev;
};

static struct msgpath *first = NULL;
static struct msgpath *last = NULL;

extern uid_t userid; 
extern int show_message( int msgcode, char *msgname );
extern char *trim( char *str );
   
 
/***************************************************************************
   SHOW_MSGPATH
   If "checkpath" is in the '<datapath>/msgpath' file, the file specified
   in msgpath will be displayed.
***************************************************************************/
                                  
void
show_msgpath( char *checkpath )
{
  int  x, y;
  char lvalue[ BUFSIZ ];
  char rvalue[ BUFSIZ ];
  struct msgpath *npath;


#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] show_msgpath()" );
	debugfn();
#endif
  
  npath = first;
   
  while ( npath )
    {
      bzero( lvalue, sizeof( lvalue ) );
      bzero( rvalue, sizeof( rvalue ) );
      
      y = 0;
        for ( x = 0; x < strlen( npath->pathspec ) 
	      && npath->pathspec[ x ] != ' '; x++ )
	if ( isprint( npath->pathspec[ x ] ) )
	  lvalue[ y++ ] = npath->pathspec[ x ];
      y = 0; x++;
      for ( ; x < strlen( npath->pathspec ); x++ )
	if ( isprint( npath->pathspec[ x ] ) )
	  rvalue[ y++ ] = npath->pathspec[ x ];
      if ( !strcasecmp( checkpath, lvalue ) )
	{

	  show_message( 250, rvalue );
	}
      
      npath = npath->next;
    }

}
/*-- end of show_msgpath() -----------------------------------------------*/
             



/****************************************************************************
	MSGPATH_STORE
	Adds a pathspec to the msgpath structure.
****************************************************************************/

void 
msgpath_store( struct msgpath *i, struct msgpath **start, struct msgpath **finish )
{
  struct msgpath *old = NULL;
  struct msgpath *p;
  													
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] msgpath_store()" );
	debugfn();
#endif
  
  if ( *finish == NULL )
    {
      /* 
       * First element in list?
       */
      i->next = NULL;
      i->prev = NULL;
      *finish = i;
      *start = i;
      return;
    }
  
  /*
   * Start at top of list
   */
  p = *start;
  
  while ( p )
    {
      if ( strcmp( p->pathspec, i->pathspec ) < 0 )
	{
	  old = p;
	  p = p->next;
	}
      else
	{
	  if ( p->prev )
	    {
	      p->prev->next = i;
	      i->next = p;
	      i->prev = p->prev;
	      p->prev = i;
	      return;
	    }
	  i->next = p;
	  i->prev = NULL;
	  p->prev = i;
	  *start = i;
	  return;
	}
    }
  
  old->next = i;
  i->next = NULL;
  i->prev = old;
  *finish = i;
}
/*-- end of msgpath_store() -----------------------------------------------*/	
                


/****************************************************************************
   FREE_MSGPATH_STRUCT
****************************************************************************/

void
free_msgpath_struct( void )
{
  struct msgpath *ips;
  													 
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] free_msgpath_struct()" );
	debugfn();
#endif
  
  ips = first;
  
  while ( ips )
    {          
      ips = ips->next;
      free( ips );
    }
  
  free( ips );
  
  first = last = NULL;
}
/*-- END of free_msgpath_struct() ----------------------------------------*/

                               

/***************************************************************************
   LOAD_MSGPATHS
***************************************************************************/
                                                                            
void
load_msgpaths( void )
{     
  char *comment;
  FILE *fp;
  char linebuf[ BUFSIZ ];
  char tempname[ MAXPATHLEN+1 ];
  struct msgpath *newpath;
  uid_t oldid = geteuid();
  															 
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] load_msgpaths()" );
	debugfn();
#endif
 
  /* Clear out the structure if one exists */
  free_msgpath_struct();
  				  
  seteuid( 0 );
   /* Open the file */
   sprintf( tempname, "%s/msgpath", cf.datapath );
   if ( ( fp = fopen( tempname, "r" ) ) == NULL )
	{
		seteuid( oldid );
      return;
	}

   /* Read /.ftp-data/msgpath */
   while ( 1 )
   {
      if ( fgets( linebuf, sizeof( linebuf ), fp ) == NULL )
      {
         fclose( fp );
			seteuid( oldid );
         return;
      }

		/*
		 * Clip out comments
		 */
		if ( ( comment = strchr( linebuf, '#' ) ) != NULL )
			*comment = '\0';

		/*
		 * Trim the buffer 
		 */
		(void)trim( linebuf );

      if ( strlen( linebuf ) > 5 )
      {
  	      newpath = (struct msgpath *)malloc( sizeof( struct msgpath ) );
         if ( newpath == NULL )
         {
            syslog( LOG_ERR, "[pheard] Out of memory in load_msgpaths()" );
         }
         else
         {
            strncpy( newpath->pathspec, linebuf, sizeof( newpath->pathspec ) );
            newpath->seen = 0;
           	msgpath_store( newpath, &first, &last );
         }
      }
   }
	
	seteuid( oldid );
}
/*-- end of load_msgpaths() ----------------------------------------------*/
 
