#include <stdarg.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>

#include <sys/param.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <sys/file.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#define	FTP_NAMES
#include <arpa/ftp.h>
#include <arpa/inet.h>
#include <arpa/telnet.h>
#include <stdio.h>
#include <grp.h>
#include <signal.h>
#include <fcntl.h>
#include <time.h>
#include <dirent.h>
#include <shadow.h>
#include <pwd.h>
#include <setjmp.h>
#include <netdb.h>
#include <errno.h>
#include <syslog.h>
#include <stdarg.h>
#include <unistd.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <paths.h>
#include "../include/userfile.h"
#include "../include/sysconfig.h"

extern struct tab cmdtab[];
extern struct tab sitetab[];

/*
 * File containing login names
 * NOT to be used on this machine.
 * Commonly used to disallow uucp.
 */
extern	int errno;
extern	char version[];
extern	char *home;		/* pointer to home directory for glob */
extern	FILE *ftpd_popen(), *fopen(), *freopen();
extern	int  ftpd_pclose(), fclose();
extern	char *getline();
extern	char cbuf[];
extern	off_t restart_point;

extern char hideuser[25][25];
extern char authuser[100];
extern int authenticated;
							 
struct	sockaddr_in ctrl_addr;
struct	sockaddr_in data_source;
struct	sockaddr_in data_dest;
struct	sockaddr_in his_addr;
struct	sockaddr_in pasv_addr;

int   seen_welcome = 0;
int   doing_dir = 0;
int	data;
jmp_buf	errcatch, urgcatch;
int	logged_in = 0;
struct	passwd *pw;
int	debug;
int	timeout = 2600;      /* timeout after 15 minutes of inactivity */
int	logging;
int	type;
int	form;
time_t logintime;
int	stru;			/* avoid C keyword */
int	mode;
int	usedefault = 1;		/* for data transfers */
int	pdata = -1;		/* for passive mode */
int	transflag;
off_t	file_size;
off_t	byte_count;
#if !defined( CMASK ) || CMASK == 0
#undef CMASK
#define CMASK 022
#endif
int	defumask = CMASK;		/* default umask value */
char	tmpline[ 7 ];
char	hostname[ MAXHOSTNAMELEN ];
char	remotehost[ MAXHOSTNAMELEN ];
char  remoteip[ 17 ];
static char ttyline[ 20 ];

int dl_this_call = 0;
int ul_this_call = 0;
ulong dlbytes_this_call = 0UL;
ulong ulbytes_this_call = 0UL;

uid_t userid = 0;

/*
 * Timeout intervals for retrying connections
 * to hosts that don't accept PORT cmds.  This
 * is a kludge, but given the problems with TCP...
 */
#define	SWAITMAX	90	/* wait at most 90 seconds */
#define	SWAITINT	5	/* interval between retries */

int	swaitmax = SWAITMAX;
int	swaitint = SWAITINT;
int   usecolor = 0;

static char *onefile[] = 
{
	"",
	0
};

void	lostconn(), myoob();
FILE	*getdatasock(), *dataconn();
int login_attempts;			/* number of failed login attempts */
int askpasswd;					/* had user command, ask for passwd */

char	**Argv = NULL;			/* pointer to argument vector */
char	*LastArgv = NULL;		/* end of argv */
char	proctitle[4096];	/* initial part of title */
char  matchdir[ MAXPATHLEN + 1 ];

char  msgpath[ 20 ][ MAXPATHLEN ];

/*
 * Function declarations:
 */
void lostconn( void );
char *sgetsave( char *s );
struct passwd *sgetpwnam( char *name );
void user( char *name );
void end_login( void );
void pass( char *passwd );
void retrieve( char *cmd, char *name );
void store( char *name, char *mode, int unique );
FILE *getdatasock( char *mode );
FILE *dataconn( char *name, off_t size, char *mode );
void send_data( FILE *instr, FILE *outstr, off_t blksize );
int receive_data( FILE *instr, FILE *outstr );
void statfilecmd( char *filename );
void statcmd( void );
void fatal( char *s );
void reply( int n, char *fmt, ... );
void lreply( int n, char *fmt, ... );
void ack( char *s );
void nack( char *s);
void yyerror( char *s );
void _delete( char *name );
void cwd( char *path );
void makedir( char *name );
void removedir( char *name ) ;
void pwd( void );
void parse_passthru( void );
char *renamefrom( char *name );
void renamecmd( char *from, char *to );
void dolog( struct sockaddr_in *sin );
void dologout( int status );
void myoob( void );
void passive( void );
char *gunique( char *local );
void perror_reply( int code, char *string );
void setproctitle( char *fmt, ... );
void show_stats( int use_lreply );
int lshow_stats( int msgcode );

extern int load_userfile( char *username );
extern int check_user_ip_list( char *host_name, char *host_ip, char *auth_user );
extern int validip( char *host_name, char *host_ip, char *auth_user );
extern void load_sysconfig( void );
extern void show_message( int msgcode, char *msgname );
extern int show_file( int msgcode, char *showname );
extern time_t weekstart( void );
extern size_t commafmt( char *buf, int	bufsize, unsigned long N );
extern int msg_waiting( void );
extern void show_bytes( int msgcode );
extern void show_msgpath( char *checkpath );
extern void load_hideusers( void );
extern int logdir( char *name );
extern void logwtmp( char *line, char *name, char *host );
extern void update_user( void );
extern int ratio_okay( ulong filesize );
extern int check_dupe( char *file_to_check );
extern int check_zip( const char *name );
extern void add_dupe( char *addfilename, int is_a_dir );
extern void delete_dupe( char *file_to_delete );
extern void free_online_struct( void );
extern void free_msgpath_struct( void );
extern void free_gpath_struct( void );
extern int build_online_info( void );
extern int howmanytimes( char *which );
extern void load_msgpaths( void );
extern void load_gpaths( void );
extern void load_groups( void );
extern void colorformat( char *outbuf );

/****************************************************************************
	RUPDATE
****************************************************************************/
void
rupdate( void )
{
	char syscall_buff[ MAXPATHLEN ];

	sprintf( syscall_buff, "%s/scripts/rupdate", cf.datapath);
	(void) system(syscall_buff);
}
/***************************************************************************
        WHOAMI
        Displays pertinent information about user status.
***************************************************************************/
               
void
whoami( void )
{
        lreply( 200, "!HUsername: !C%s!0", uf.name );
        lreply( 200, "!H    EUID: !C%d!0", geteuid() );
        lreply( 200, "!H    EGID: !C%d!0", getegid() );
        
        if ( geteuid() == 0 )
                reply( 200, "!B*** WARNING, EUID SET TO ROOT ***!0" );
        else
                reply( 200, "!HEverything looks okay here.!0" );
}
/*-- end of whoami() -----------------------------------------------------*/

/****************************************************************************
	MATCH_DIR
****************************************************************************/

int 
match_dir( char *dirname, char *matchstr )
{
   DIR *dp;
   struct dirent *dir;
   struct stat st;
   int cctr;

   matchdir[ 0 ] = '\0';
				
	/*
	 * First, trim matchstr
	 */
   for ( cctr = 0; cctr < strlen( matchstr ); cctr++ )
      if ( matchstr[ cctr ] == '*' )
         matchstr[ cctr ] = '\0';

   if ( ( dp = opendir( dirname ) ) == NULL )
   {
      return 0;
   }

   rewinddir( dp );

   while ( 1 ) 
   {
      if ( ( dir = readdir( dp ) ) == NULL )
      {
         closedir( dp );
         return 0;
      }

      if ( strlen( matchstr ) > strlen( dir->d_name ) )
         continue;

      if ( strncasecmp( dir->d_name, matchstr, strlen( matchstr ) ) == 0 )
      {
         /* Check to make sure it's a dir */
         if ( stat( dir->d_name, &st ) == 0 )
         {
            if ( S_ISDIR( st.st_mode ) )
            {
               closedir( dp );
               strncpy( matchdir, dir->d_name, MAXPATHLEN );
               return 1;
            }
         }
      }
   }
}
/*-- end of match_dir() ---------------------------------------------------*/


/****************************************************************************
	REALPATH
****************************************************************************/

char *
real_path(char *pathname, char *result)
{
	struct stat sbuf;
	char curpath[MAXPATHLEN];
	char workpath[MAXPATHLEN];
	char linkpath[MAXPATHLEN];
	char namebuf[MAXPATHLEN];
	char *where;
	char *ptr;
	char *last;
	int len;
	uid_t oldid;

#ifdef DEBUG
	syslog(LOG_INFO, "[pheard] real_path()");
	debugfn();
#endif

	/* store a copy of pathname in curpath */
	strcpy(curpath, pathname);

	/* grab workpath, the directory to work in */
	if (*pathname != '/') {
		if (!getwd(workpath)) {		/* directory not readable so, become root */
			oldid = geteuid();
			seteuid(0);
			if (!getwd(workpath)) {		/* failure as root, so result to "." */
				strcpy(result, ".");
				seteuid(oldid);
				return(NULL);
			}
			seteuid(oldid);
		}
	} else {
		/* may want to set workpath to uf.restrict */
		/* *workpath = (char) NULL; */
		(void) strcpy(workpath, uf.restrict);
	}

	/* curpath is the path we're still resolving */
	/* linkpath is the path a symbolic link points to */
	/* workpath is the path we've resolved */

	loop:
		where = curpath;
		while (*where != (char) NULL) {
			/* base case? */
			if (!strcmp(where, ".")) {
				where++;
				continue;
			}

			/* deal with "./" */
			if (!strncmp(where, "./", 2)) {
				where += 2;
				continue;
			}

			/* deal with "../" */
			if (!strncmp(where, "../", 3)) {
				where += 3;
				ptr = last = workpath;

				/* locate last '/' in workpath */
				while (*ptr) {
					if (*ptr == '/')
						last = ptr;
					ptr++;
				}

				/* get rid of everything past the last '/' in workpath */
				/* simulates "../" */
				*last = (char) NULL;
				continue;
			}

			/* find '/' in where */
			ptr = strchr(where, '/');
			/* no more '/' to deal with */
			if (!ptr)
				ptr = where + strlen(where) - 1;
			else
				*ptr = (char) NULL;

			strcpy(namebuf, workpath);
			for (last = namebuf; *last; last++)
				continue;
			if (*--last != '/')
				strcat(namebuf, "/");
			strcat(namebuf, where);

			where = ++ptr;
			if (lstat(namebuf, &sbuf) == -1) {
				strcpy(result, namebuf);
				return(NULL);
			}
			if ((sbuf.st_mode & S_IFMT) == S_IFLNK) {
				len = readlink(namebuf, linkpath, MAXPATHLEN);
				if (len == 0) {
					strcpy(result, namebuf);
					return(NULL);
				}
				*(linkpath + len) = '\0';   /* readlink doesn't null-terminate result */
				if (*linkpath == '/')
					*workpath = '\0';
				if (*where) {
					strcat(linkpath, "/");
					strcat(linkpath, where);
				}
				strcpy(curpath, linkpath);
				goto loop;
			}
			if ((sbuf.st_mode & S_IFDIR) == S_IFDIR) {
				strcpy(workpath, namebuf);
				continue;
			}
			if (*where) {
				strcpy(result, namebuf);
				return( NULL );      /* path/notadir/morepath */
			} else {
				strcpy( workpath, namebuf );
			}
		}

		strcpy(result, workpath);
		return(result);
}
/*-- end of real_path() ----------------------------------------------------*/



/****************************************************************************
	LOSTCONN
****************************************************************************/

void
lostconn( void )
{
	if ( debug )
		syslog( LOG_DEBUG, "lost connection" );
	dologout( -1 );
}
/*-- end of lostconn() ----------------------------------------------------*/
			  

/****************************************************************************
	SGETSAVE
	Helper function for sgetpwnam
****************************************************************************/

char *
sgetsave( char *s )
{
	char *new = malloc( (unsigned)strlen( s ) + 1 );

	if ( new == NULL ) 
	{
		perror_reply( 421, "Local resource failure: malloc" );
		dologout( 1 );
		/* NOTREACHED */
	}
	(void)strcpy( new, s );
	return( new );
}
/*-- end of sgetsave() ----------------------------------------------------*/
			  

/****************************************************************************
	SGETPWNAM
	Save the result of a getpwnam.  Used for USER command, since
	the data returned must not be clobbered by any other command
	(e.g., globbing).
****************************************************************************/

struct passwd *
sgetpwnam( char *name )
{
	static struct passwd save;
	register struct passwd *p;
	char *sgetsave();
	struct spwd *sp;

	if ( ( p = getpwnam( name ) ) == NULL )
	{
		syslog( LOG_ERR, "User unknown: %s", name );
		return( p );
	}	       

	if ( save.pw_name ) 
	{
		free( save.pw_name );
		free( save.pw_passwd );
		free( save.pw_gecos );
		free( save.pw_dir );
		free( save.pw_shell );
	}
	
	save = *p;
	save.pw_name   = sgetsave( p->pw_name );
	save.pw_passwd = sgetsave( p->pw_passwd );
	save.pw_gecos  = sgetsave( p->pw_gecos );
	save.pw_dir    = sgetsave( p->pw_dir );
	save.pw_shell  = sgetsave( p->pw_shell );

	if ( ( sp = getspnam( name ) ) )
		save.pw_passwd = sgetsave( sp->sp_pwdp );
	return( &save );
}
/*-- end of sgetpwnam() ---------------------------------------------------*/
			   				  

/****************************************************************************
	USER
	Sets global passwd pointer pw if named account exists and is acceptable;
	sets askpasswd if a PASS command is expected.  If logged in previously,
	need to reset state.  If name is "ftp" or "anonymous", the name is not
	in	_PATH_FTPUSERS, and ftp account exists, set guest and pw, then just
	return.	If account doesn't exist, ask for passwd anyway.  Otherwise, 
	check user requesting login privileges.  Disallow anyone who does not 
	have a standard shell as returned by getusershell().  Disallow anyone 
	mentioned in the file _PATH_FTPUSERS to allow people such as root and 
	uucp to be avoided.
****************************************************************************/
					  
void
user(char *name) {
	register char *cp;
	char *shell;
	char *getusershell();

#ifdef DEBUG
	syslog(LOG_INFO, "[pheard] user()");
	if (uf.name[0] == '\0')
		syslog(LOG_INFO, "[pheard] uf.name was NULL in the preceding function.");
#endif

	if (logged_in)
		end_login();


	if ((pw = sgetpwnam(name))) {
		if (cp == NULL) {
			reply(530, "User %s access denied.", name);
			if (logging)
				syslog(LOG_NOTICE, "FTP LOGIN REFUSED FROM %s, %s",
						remotehost, name);
			pw = (struct passwd *) NULL;
			return;
		}
	}


	reply(331, "Password required for %s.", name);
	askpasswd = 1;

	/*
	 * Delay before reading passwd after first failed
	 * attempt to slow down passwd-guessing programs.
	 */
	if (login_attempts)
		sleep((unsigned) login_attempts);
}
/*-- end of user() --------------------------------------------------------*/


/****************************************************************************
	END_LOGIN
	Terminate login as previous user, if any, resetting state;  used when
	USER command is given, or login fails.
****************************************************************************/
  
void
end_login( void )
{
	(void)seteuid( (uid_t)0 );
	
	if ( logged_in )
		logwtmp( ttyline, "", "" );
		
	pw = NULL;
	logged_in = 0;
}
/*-- end of end_login() ---------------------------------------------------*/
										

/***************************************************************************
   LOGINLOG
	Writes a line to the login log file
***************************************************************************/

void
loginlog( char *fmt, ... )
{           
   char    linebuf[ MAXPATHLEN ];
	char    pidbuf[10];
 	va_list argp;  
   FILE    *lf;
   char    temppath[ MAXPATHLEN+1 ];
   time_t  curtime = time( NULL );
   uid_t oldid = geteuid();

#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] loginlog()" );
	debugfn();
#endif

	va_start( argp, fmt );
	vsprintf( linebuf, fmt, argp );
	va_end( argp );

	seteuid( 0 );

   sprintf( temppath, "%s/logs/login.log", cf.datapath );
   lf = fopen( temppath, "a" );
   if ( lf != NULL )
   {						 
		sprintf( pidbuf, "%d", getpid() );
      fprintf( lf, "%.24s [%-6.6s] %s\n", ctime( &curtime ), pidbuf, linebuf );
      fclose( lf );
   }

	seteuid( oldid );
}
/*-- end of loginlog() ---------------------------------------------------*/




/****************************************************************************
	PASS
****************************************************************************/
/* check out these: initgroups(), logwtmp(), loginlog(), updateuser() 
   for the >8 character bug */

void
pass(char *passwd) {
	char *xpasswd;
	char *salt;
	int nu;
	char tempname[MAXPATHLEN+1];

#ifdef DEBUG
	syslog(LOG_INFO, "[pheard] pass()");
	debugfn();
#endif

	if (logged_in || askpasswd == 0) {
		reply(503, "Login with USER first.");
		return;
	}


	askpasswd = 0;
	if (pw == NULL)
		salt = "xx";
	else
		salt = pw->pw_passwd;
	xpasswd = (char *) pw_encrypt(passwd, salt);
	/* The strcmp does not catch null passwords! */
	if (pw == NULL || *pw->pw_passwd == '\0'
			|| strcmp(xpasswd, pw->pw_passwd)) {
		syslog(LOG_NOTICE, "[pheard] Login failure from %s as \"%s\" (%s)",
				remotehost, pw->pw_name, passwd);
		loginlog("%s: %s@%s (%s): Login failure.",
				pw->pw_name, authuser, remotehost, remoteip);
		reply(530, "Login incorrect.");
		pw = NULL;
		if (login_attempts++ >= 5) {
			loginlog("%s: %s@%s (%s): Repeated login failures.",
					pw->pw_name, authuser, remotehost, remoteip);
			syslog(LOG_NOTICE, "[pheard] Repeated login failures from %s", remotehost);
			free_online_struct();
			free_msgpath_struct();
			free_gpath_struct();
			exit(EXIT_FAILURE);
		}
		return;
	}

	login_attempts = 0;		/* this time successful */
	(void) setegid((gid_t) pw->pw_gid);
	(void) initgroups(pw->pw_name, pw->pw_gid);

	/* open wtmp before chroot */
	(void) sprintf(ttyline, "ftp%d", getpid());
	logwtmp(ttyline, pw->pw_name, remotehost);
	if ( load_userfile(pw->pw_name) )
		syslog( LOG_ERR, "[pheard] Calling function was pass()" );
	load_msgpaths();
	load_gpaths();
	logged_in = 1;
	usecolor = uf.use_color;
	if (uf.level >= 5)
		timeout = 3600;   /* 60 minute timeout for level 5 or greater */

	if (chdir(uf.restrict) < 0) {
		if (chdir("/") < 0) {
			reply(530, "User %s: can't change directory to %s.",
					pw->pw_name, pw->pw_dir);
			goto bad;
		} else {
			lreply(230, "No directory! Logging in with home=/");
		}
	}
	userid = (uid_t) pw->pw_uid;
	if (uf.level >= 25)
		userid = (uid_t) 0;

	if (seteuid(userid) < 0) {
		reply(550, "Can't set uid.");
		goto bad;
	}

	/*
	 * Check to make sure user's IP is in the list of valid IP's
	 */

	if (!check_user_ip_list(remotehost, remoteip, authuser)) {
		reply(530, "\"%s@%s\" is not valid for the account specified.",
				authuser, remoteip);
		syslog(LOG_INFO, "[pheard] %s: %s@%s (%s) refused (bad IP)",
				uf.name, authuser, remotehost, remoteip);
		loginlog("%s: %s@%s (%s): Bad user@host.", uf.name, authuser, 
				remotehost, remoteip);
		goto bad;
	}

	/*
	 * Check max # users
	 */
/* memory leak here, need to clean up after building online info. */
	nu = build_online_info();
	if (!uf.exempt_from_limit && (cf.max_users && (nu > cf.max_users))) {
		reply(530, "!BSorry, the server is full. !h(max !E%d !husers)!0",
				cf.max_users);
		goto bad;
	}

	/*
	 * Check simultaneous logins for this user
	 */	
/*	if (uf.num_logins && (howmanytimes(uf.name) + 1 > uf.num_logins)) { */
	if ( uf.num_logins && ( howmanytimes( uf.name )+1 > uf.num_logins ) ) {
		reply(530, "!GSorry, your account is restricted to %d simultaneous logins.!0",
				uf.num_logins);
/*
		syslog(LOG_NOTICE, "[pheard]: %s denied access (%d simultaneous logins)",
				uf.name, uf.num_logins);
*/
		goto bad;
	}

	if (uf.level == 0) {
		sprintf(tempname, "%s/byefiles/%s.bye", cf.datapath, uf.name);
		show_message(530, tempname);
		reply(221, "!BGoodbye.!0");
		sysoplog("'[CRC]: '%s' tried to login but has been deleted.", uf.name);
		loginlog("%s: %s@%s (%s): Deleted.", uf.name, authuser,
				remotehost, remoteip);
		show_message(230, tempname);
		dologout(0);
	}

	show_message(230, cf.welcome_msg);

	reply(230, "User %s logged in.", pw->pw_name);
	time(&logintime);

	sprintf(proctitle, "%s: %s", remotehost, pw->pw_name);
	syslog(LOG_INFO, "[pheard] LOGIN FROM %s@%s, %s", (authenticated) ? authuser : "<UNKNOWN>", remotehost,
			pw->pw_name);

	/*
	 * Clear out weekly upload statistics if necessary
	 */
	if (uf.last_on < weekstart()) {
		uf.files_up_wk = 0;
		uf.bytes_up_wk = (ulong) 0L;
		uf.seconds_up_wk = (time_t) 0;

		uf.files_down_wk = 0;
		uf.bytes_down_wk = (ulong) 0L;
		uf.seconds_down_wk = (time_t) 0;
	}

	uf.last_on = time(NULL);
	update_user();

	home = pw->pw_dir;		/* home dir for globbing */
	(void) umask(defumask);
	return;

bad:
	/* Forget all about it... */
	end_login();
}
/*-- end of pass() --------------------------------------------------------*/


/****************************************************************************
	RETRIEVE
****************************************************************************/	
void
retrieve(cmd, name)
	char *cmd;
	char *name;
{
	FILE *fin;
	FILE *dout;
	int oldtype = type;

	struct stat st;
	int (*closefunc)();
	char namebuf[MAXPATHLEN + 1], tempbuf[MAXPATHLEN + 1];
	time_t start_time = time(NULL);
	/* Make sure this file is not outside of our restrict path */
	real_path(name, namebuf);
	/* Bullshit workaround reporting in */
/*	load_userfile( uf.name ); */

	if (uf.restrict[0] != '\0') {
		if (strncasecmp(namebuf, uf.restrict, strlen(uf.restrict)) != 0) {
			reply(553, "%s: Permission denied.", name);
			return;
		}
	}

	if (cmd == 0) {
		fin = fopen(namebuf, "r"), closefunc = fclose;
		st.st_size = 0;
	} 
	else 
	{

		char line[BUFSIZ];
		(void) sprintf(line, cmd, name), name = line;
		fin = ftpd_popen(line, "r"), closefunc = ftpd_pclose;
		st.st_size = -1;
		st.st_blksize = BUFSIZ;
/*		type = TYPE_A; */
	} 
	
	if (fin == NULL) {
		if (errno != 0) { perror_reply(550, name); }
	/*	type = oldtype; */
		return;
	}

	if (cmd == 0 &&
		(fstat(fileno(fin), &st) < 0 || (st.st_mode & S_IFMT) != S_IFREG)) {
		reply( 550, "%s: not a plain file.", name );
		goto done;
	}

	/* Check ratio */
	if (!ratio_okay(st.st_size) && S_ISREG(st.st_mode)) {
		reply(550, "!GInsufficient Credits.!0");
		syslog(LOG_NOTICE, "[pheard] %s: ratio out of balance", uf.name);
	/*	type = oldtype; */
		return;
	}

	if (restart_point) {
		if (type == TYPE_A) {
			register int i, n, c;

			n = restart_point;
			i = 0;
			while (i++ < n) {
				if ((c = getc(fin)) == EOF) {
					perror_reply(550, name);
					goto done;
				}

				if (c == '\n')
					i++;
			}
		} else if (lseek(fileno(fin), restart_point, L_SET) < 0) {
			perror_reply(550, name);
			goto done;
		}
	}
	dout = dataconn(name, st.st_size, "w");
	if (dout == NULL)
		goto done;

	send_data(fin, dout, st.st_blksize);
	(void) fclose(dout);
/*	type = oldtype; */

	/* Update user datafile */
	if (st.st_size > (off_t) 51200) {
		time_t diffsecs = (time_t) (time(NULL) - start_time);

		dl_this_call++;
		dlbytes_this_call += (ulong) st.st_size;

		if (diffsecs < 0 || diffsecs > 10000)
			diffsecs = 0;

		if ( load_userfile(pw->pw_name) )
			syslog( LOG_ERR, "[pheard] Calling function was retrieve()" );
		if (diffsecs) uf.seconds_down += diffsecs;
		uf.files_down++;
		uf.bytes_down += (ulong) (st.st_size / 1024U);
		if (diffsecs) uf.seconds_down_wk += diffsecs;
		uf.files_down_wk++;
		uf.bytes_down_wk += (ulong) (st.st_size / 1024U);
		uf.files_down_month++;
		uf.bytes_down_month += (ulong) (st.st_size / 1024U);
		if (diffsecs) uf.seconds_down_month += diffsecs;
		uf.files_down_day++;
		uf.bytes_down_day += (ulong) (st.st_size / 1024U);
		if (diffsecs) uf.seconds_down_day += diffsecs;
		if ((uf.ratio != 0) && (uf.credits >= (ulong) (st.st_size / 1024U)))
			uf.credits -= (ulong) (st.st_size / 1024U);
		update_user();
        show_stats( 1 );
        reply(226, "Transfer complete.");
	}


	data = -1;
	pdata = -1;

done:
/*	type = oldtype; */
	(*closefunc)(fin);
}
/*-- end of retrieve() ----------------------------------------------------*/
	 

/****************************************************************************
	PATH_OKAY
   Returns 1 if the path is okay, 0 otherwise.
****************************************************************************/
	
int 
path_okay( char *reqpath )
{
	char namebuf[ MAXPATHLEN + 1 ];
   									 
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] path_okay()" );
	if ( uf.name[ 0 ] == '\0' )
		syslog( LOG_INFO, "[pheard] uf.name was NULL in the preceding function." );
#endif
	
	real_path( reqpath, namebuf );	  
   if ( uf.restrict[ 0 ] != '\0' &&
        strncasecmp( namebuf, uf.restrict, strlen( uf.restrict ) ) != 0 )
      return 0;
   return 1;        
}
/*-- end of path_okay() ---------------------------------------------------*/


/****************************************************************************
	STORE
****************************************************************************/
void
store(name,mode,unique)
char *name;
char *mode;
int unique;
{
FILE *fout, *din;
struct stat st;
int (*closefunc) ();
char *gunique(char *local);
time_t start_time = time(NULL);
struct aclmember *entry = NULL;
char namebuf[MAXPATHLEN + 1];
char numbuff[65];
char *where;
char *ptr;
char *last;
int len;
int fdout;
int overwrite = 0;
int open_flags = (O_RDWR | O_CREAT | ((mode != NULL && *mode == 'a') ? O_APPEND : O_TRUNC));
mode_t oldmask;
int f_mode = -1,
dir_mode,
match_value = -1;
uid_t uid;
gid_t gid;
uid_t oldid;
int valid = 0;
int oldtype = type;
int cnt;
   for ( cnt = 0; cnt < strlen( name ); cnt++ )
      name[ cnt ] = tolower( name[ cnt ] );

	if (unique && stat(name, &st) == 0 &&
	(name = gunique(name)) == NULL)
	return;
	if ( (fn_check(name)) <= 0 )
	return;
/* 	while (getaclentry("overwrite", &entry) && ARG0 && ARG1 != NULL) {
		if (type_match(ARG1))
		if (strcmp(ARG0, "yes") != 0) {
			overwrite = 0;
			open_flags |= O_EXCL;
		}
	}*/
	if (!overwrite && !stat(name, &st)) {
		reply(553, "%s: Permission denied. (Overwrite)", name);
		return;
	}

	if ( (match_value = upl_check(name, &uid, &gid, &f_mode, &valid)) < 0 )
	        return;
	oldid = geteuid();
	delay_signaling(); /* we can't allow any signals while euid==0: kinch */
	(void) seteuid((uid_t) 0);
	if ((check_dupe(name)) != 0) {
		(void) seteuid(oldid);
		enable_signaling(); /* we can allow signals once again: kinch */
		return;
	}
	(void) seteuid(oldid);
	enable_signaling(); /* we can allow signals once again: kinch */
	if (restart_point)
		open_flags &= ~O_TRUNC;
	if (f_mode >= 0) 
	{
		oldmask = umask(0000);
		fdout = open(name, open_flags, f_mode);
		umask(oldmask);
	} 
	else
		fdout = open(name, open_flags, 0666);
	if (fdout < 0) {
		perror_reply(553, name);
		return;
	}
	/* Signalling will keep the hackers at wraps while as root */
	if (valid > 0) {
		oldid = geteuid();
		delay_signaling(); /* we can't allow any signals while euid==0: kinch */
		(void) seteuid((uid_t) 0);
		if ((fchown(fdout, uid, gid)) < 0) {
			(void) seteuid(oldid);
			enable_signaling(); /* we can allow signals once again: kinch */
			perror_reply(550, "fchown");
			return;
		}
		(void) seteuid(oldid);
		enable_signaling(); /* we can allow signals once again: kinch */
	}
	if (restart_point && (open_flags & O_APPEND) == 0)
		mode = "r+";

	fout = fdopen(fdout, mode);
	closefunc = fclose;
	if (fout == NULL) {
		perror_reply(553, name);
		return;
	}

	if (restart_point) {
		if (type == TYPE_A) {
			register int i, n, c;

			n = restart_point;
			i = 0;
			while (i++ < n) {
				if ((c = getc(fout)) == EOF) {
					perror_reply(550, name);
					goto done;
				}
				if (c == '\n')
					i++;
			}
			if (fseek(fout, 0L, L_INCR) < 0) {
				perror_reply(550, name);
				goto done;
			}
		} else if (lseek(fileno(fout), restart_point, L_SET) < 0) {
			perror_reply(550, name);
			goto done;
		}
	}

        din = dataconn(name, (off_t) - 1, "r");
        if (din == NULL) goto done;
        if (receive_data(din, fout) == 0) { }
        (void) fclose(din);
        data = -1;
        pdata = -1;

done:
	/* Is this an nfo?  If is is, do dat shit... */
	real_path(name, namebuf);

	/* Do ZIP check */
 	if (check_zip(namebuf) != 0) { 
		unlink(name);
		reply(226, "Bad zip.  No credit given.");
		(void) umask(oldmask); 
	} else {
		time_t diffsecs = (time_t) (time(NULL) - start_time);

		if ((diffsecs < 0) || (diffsecs > 10000))
			diffsecs = 0;

		add_dupe(name, 0);

		if ( load_userfile(pw->pw_name) )
			syslog( LOG_ERR, "[pheard] Calling function was store()" );

		load_userfile( uf.name );
		if (strncasecmp(namebuf, cf.requestdir, sizeof (namebuf)))
		{

			uf.seconds_up += diffsecs;
			uf.files_up++;
			uf.bytes_up += (ulong) (byte_count / 1024U);
			uf.seconds_up_wk += diffsecs;
			uf.files_up_wk++;
			uf.bytes_up_wk += (ulong) (byte_count / 1024U);
			uf.files_up_day++;
			uf.bytes_up_day += (ulong) (byte_count / 1024U);
			uf.seconds_up_day += diffsecs;
			uf.files_up_month++;
			uf.bytes_up_month += (ulong) (byte_count / 1024U);
			uf.seconds_up_month += diffsecs;
		} 

		ul_this_call++;
		ulbytes_this_call += (ulong)byte_count;
		uf.credits += (((ulong) byte_count * (ulong) uf.ratio) / 1024U);
		update_user();
		show_stats( 1 );
		if (unique)
			reply(226, "Transfer complete (unique file name:%s).",
				name);
		else {
			commafmt(numbuff, 64, (byte_count * (size_t) uf.ratio) / 1024);
			if (uf.ratio != 0)
				reply(226, "Transfer complete.");
			else
				reply(226, "Transfer complete.");
		}
 }
	(*closefunc)(fout);
	(void) umask(0000);
 	chmod(namebuf, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH);
	(void) umask(oldmask);
}
/*-- end of store() ------------------------------------------------------*/


/****************************************************************************
	GETDATASOCK
****************************************************************************/

FILE *
getdatasock( char *mode )
{
	int s;
	int on = 1;
	int tries;

	if ( data >= 0 )
		return( fdopen( data, mode ) );
		
	(void)seteuid( (uid_t)0 );
	s = socket( AF_INET, SOCK_STREAM, 0 );
	if ( s < 0 )
		goto bad;
		
	if ( setsockopt(s, SOL_SOCKET, SO_REUSEADDR,
	    (char *)&on, sizeof( on ) ) < 0 )
		goto bad;					
		
	/* anchor socket to avoid multi-homing problems */
	data_source.sin_family = AF_INET;
	data_source.sin_addr = ctrl_addr.sin_addr;
	for ( tries = 1; ; tries++ ) 
	{
		if ( bind( s, (struct sockaddr *)&data_source,
		    sizeof( data_source ) ) >= 0 )
			break;
			
		if ( errno != EADDRINUSE || tries > 10 )
			goto bad;
		sleep( tries );
	}					
	
	(void)seteuid( userid );
	
#ifdef IP_TOS
	on = IPTOS_THROUGHPUT;
	if ( setsockopt( s, IPPROTO_IP, IP_TOS, (char *)&on, sizeof( int ) ) < 0 )
		syslog( LOG_WARNING, "setsockopt (IP_TOS): %m" );
#endif
	return( fdopen( s, mode ) );
bad:
	(void)seteuid( userid );
	(void)close( s );
	return( NULL );
}
/*-- end of getdatasock() -------------------------------------------------*/
			  

/****************************************************************************
	DATACONN
****************************************************************************/

FILE *
dataconn( char *name, off_t size, char *mode )
{
	char sizebuf[ 32 ];
	FILE *file;
	int retry = 0;
	int tos;

	file_size = size;
	byte_count = 0;
	if ( size != (off_t)-1 )
		(void)sprintf( sizebuf, " (%ld bytes)", size );
	else
		(void)strcpy( sizebuf, "" );
		
	if ( pdata >= 0 ) 
	{
		struct sockaddr_in from;
		int s;
		int fromlen = sizeof(from);

		s = accept( pdata, (struct sockaddr *)&from, &fromlen );
		if ( s < 0 )
			{
			reply( 425, "Can't open data connection." );
			(void)close( pdata );
			pdata = -1;
			return( NULL );
		}
		
		(void)close( pdata );
		pdata = s;
#ifdef IP_TOS
		tos = IPTOS_LOWDELAY;
		(void)setsockopt( s, IPPROTO_IP, IP_TOS, (char *)&tos,
		    sizeof(int) );
#endif
		reply( 150, "Opening %s mode data connection for %s%s.!0",
		     type == TYPE_A ? "ASCII" : "BINARY", name, sizebuf );
		return( fdopen( pdata, mode ) );
	}
	
	if ( data >= 0 ) 
	{
		reply( 125, "!HUsing existing data connection for !C%s%s!H.!0", name, sizebuf );
		usedefault = 1;
		return( fdopen( data, mode ) );
	}
	
	if ( usedefault )
		data_dest = his_addr;
		
	usedefault = 1;
	file = getdatasock( mode );
	
	if ( file == NULL ) 
	{
		reply( 425, "Can't create data socket (%s,%d): %s.",
		    inet_ntoa( data_source.sin_addr ),
		    ntohs( data_source.sin_port ), strerror( errno ) );
		return( NULL );
	}
	
	data = fileno( file );
	while ( connect( data, (struct sockaddr *)&data_dest,
	    sizeof ( data_dest ) ) < 0 ) 
	{
		if ( errno == EADDRINUSE || ( errno == EINTR && retry < swaitmax ) ) 
		{
			sleep( (unsigned)swaitint );
			retry += swaitint;
			continue;
		}
		perror_reply( 425, "Can't build data connection" );
		(void)fclose( file );
		data = -1;
		return( NULL );
	}					 
	
	reply( 150, "Opening %s mode data connection for %s%s.",
	     type == TYPE_A ? "ASCII" : "BINARY", name, sizebuf );
	return( file );
}
/*-- end of dataconn() ----------------------------------------------------*/
			  

/****************************************************************************
	SEND_DATA
	Transfer the contents of "instr" to "outstr" peer using the appropriate
	encapsulation of the data subject to Mode, Structure and Type.
****************************************************************************/
  
void
send_data( FILE *instr, FILE *outstr, off_t blksize )
{
	register int c;
	register int cnt;
	register char *buf;
	int netfd;
	int filefd;

	transflag++;
	if ( setjmp( urgcatch ) ) 
	{
		transflag = 0;
		return;
	}	 

	switch ( type )
	{
		case TYPE_A:
			while ( ( c = getc( instr ) ) != EOF ) 
			{
				byte_count++;
				if ( c == '\n' )
				{
					if ( ferror( outstr ) )
						goto data_err;
					(void)putc( '\r', outstr );
				}
				(void)putc( c, outstr );
			}

	 		fflush( outstr );
			transflag = 0;
			if ( ferror( instr ) )
				goto file_err;
			if ( ferror( outstr ) )
				goto data_err;
			if ( doing_dir )
				show_stats( 1 );
			reply( 226, "Transfer complete." );
			return;

		case TYPE_I:
		case TYPE_L:
        if ((buf = (char *) malloc((u_int) blksize)) == NULL) {
            transflag = 0;
            perror_reply(451, "Local resource failure: malloc");
            return;
        }
        netfd = fileno(outstr);
        filefd = fileno(instr);
        while ((cnt = read(filefd, buf, (u_int) blksize)) > 0 &&
               write(netfd, buf, cnt) == cnt)
            byte_count += cnt;
        transflag = 0;
        (void) free(buf);
        if (cnt != 0) {
            if (cnt < 0)
                goto file_err;
            goto data_err;
        }
        return;
		default:
			transflag = 0;
			reply( 550, "Unimplemented TYPE %d in send_data", type );
			return;
	}

data_err:
	transflag = 0;
	perror_reply( 426, "Data connection" );
	return;

file_err:
	transflag = 0;
	perror_reply( 551, "Error on input file" );
}
/*-- end of send_data() ---------------------------------------------------*/
			  

/****************************************************************************
	RECEIVE_DATA
****************************************************************************/
				  
int
receive_data( FILE *instr, FILE *outstr )
{
	register int c;
	int cnt;
	int bare_lfs = 0;
	char buf[ BUFSIZ ];

	transflag++;
	if ( setjmp( urgcatch ) ) 
	{
		transflag = 0;
		return -1;
	}
	
	switch ( type ) 
	{
		case TYPE_I:

		case TYPE_L:
			while ( ( cnt = read( fileno( instr ), buf, sizeof buf ) ) > 0 ) 
			{
				if ( write( fileno( outstr ), buf, cnt ) != cnt )
					goto file_err;
				byte_count += cnt;
			}
			if ( cnt < 0 )
				goto data_err;
			transflag = 0;
			return 0;

		case TYPE_E:
			reply( 553, "TYPE E not implemented." );
			transflag = 0;
			return -1;

		case TYPE_A:
			while ( ( c = getc( instr ) ) != EOF ) 
			{
				byte_count++;
				if ( c == '\n' )
				bare_lfs++;
				while ( c == '\r' ) 
				{
					if ( ferror( outstr ) )
						goto data_err;
					if ( ( c = getc( instr ) ) != '\n' ) 
					{
						(void)putc( '\r', outstr );
						if ( c == '\0' || c == EOF )
							goto contin2;
					}
				}
				(void) putc(c, outstr);
	contin2:	;
			}
			fflush( outstr );
			if ( ferror( instr ) )
				goto data_err;
			if ( ferror( outstr ) )
				goto file_err;
			transflag = 0;
			if ( bare_lfs ) 
			{
				lreply( 230, "WARNING! %d bare linefeeds received in ASCII mode", bare_lfs );
				printf( "   File may not have transferred correctly.\r\n" );
			}
			return (0);
		default:
			reply( 550, "Unimplemented TYPE %d in receive_data", type );
			transflag = 0;
			return -1;
	}

data_err:
	transflag = 0;
	perror_reply( 426, "Data Connection" );
	return -1;

file_err:
	transflag = 0;
	perror_reply( 452, "Error writing file" );
	return -1;
}
/*-- end of receive_data() ------------------------------------------------*/
			  

/****************************************************************************
	STATFILECMD
****************************************************************************/

void
statfilecmd( char *filename )
{									  
	char line[ BUFSIZ ];
	FILE *fin;
	int  c;
	char firstchar[ 2 ];

/*	firstchar = substr(filename,0,0); */
	strncpy( firstchar, filename, 1);
	if (!strcmp(firstchar, "/")) 
		(void)sprintf( line, "/bin/ls -loA %s%s", uf.restrict, filename );
	else {
		(void)sprintf( line, "/bin/ls -loA %s", filename );
	}
	fin = ftpd_popen( line, "r" );
	lreply( 211, "status of %s:", filename );
	while ( ( c = getc( fin ) ) != EOF ) 
	{
		if ( c == '\n' ) 
		{
			if ( ferror( stdout ) )
			{
				perror_reply( 421, "control connection" );
				(void)ftpd_pclose( fin );
				dologout( 1 );
				/* NOTREACHED */
			}
			if ( ferror( fin ) ) 
			{
				perror_reply( 551, filename );
				(void)ftpd_pclose( fin );
				return;
			}
			(void)putc( '\r', stdout );
		}
		(void)putc( c, stdout );
	}
	(void) ftpd_pclose(fin);
	reply(211, "End of Status");
}
/*-- end of statfilecmd() -------------------------------------------------*/
			  

/****************************************************************************
	STATCMD					  
	Sends server statistics via SITE STAT.
****************************************************************************/

void
statcmd( void )
{
	struct sockaddr_in *sin;
	u_char *a, *p;

	lreply( 211, "FTP server status:" );
	printf( "     0.95\r\n" );
	printf( "     Connected to %s", remotehost );
	
	if ( !isdigit( remotehost[ 0 ] ) )
		printf( " (%s)", inet_ntoa( his_addr.sin_addr ) );
		
	printf( "\r\n" );
	if ( logged_in ) 
	{
		printf( "     Logged in as %s\r\n", pw->pw_name );
	} 
	else if ( askpasswd )
	{
		printf( "     Waiting for password\r\n" );
	}
	else
	{
		printf( "     Waiting for user name\r\n" );
	}
	printf( "     TYPE: %s", typenames[ type ] );
	
	if ( type == TYPE_A || type == TYPE_E )
		printf( ", FORM: %s", formnames[ form ] );
	printf( "; STRUcture: %s; transfer MODE: %s\r\n",
	    strunames[ stru ], modenames[ mode ] );
		 
	if ( data != -1 )
	{
		printf( "     Data connection open\r\n" );
	}
	else if ( pdata != -1 ) 
	{
		printf( "     in Passive mode" );
		sin = &pasv_addr;
		goto printaddr;
	} 
	else if ( usedefault == 0 ) 
	{
		printf( "     PORT" );
		sin = &data_dest;
printaddr:
		a = (u_char *)&sin->sin_addr;
		p = (u_char *)&sin->sin_port;
#define UC(b) (((int) b) & 0xff)
		printf( " (%d,%d,%d,%d,%d,%d)\r\n", UC(a[0]),
			UC(a[1]), UC(a[2]), UC(a[3]), UC(p[0]), UC(p[1]));
#undef UC
	} 
	else
	{
		printf( "     No data connection\r\n" );
	}
	
	reply( 211, "End of status" );
}
/*-- end of statcmd() -----------------------------------------------------*/
			  

/****************************************************************************
	FATAL
****************************************************************************/
		
void
fatal( char *s )
{
	reply( 451, "Error in server: %s\n", s );
	reply( 221, "Closing connection due to server error." );
	dologout( 0 );
	/* NOTREACHED */
}
/*-- end of fatal() -------------------------------------------------------*/
			  

/****************************************************************************
	REPLY
****************************************************************************/
				
void
reply( int n, char *fmt, ... )
{
 	va_list argp;
	char outbuf[ BUFSIZ ];
							 
	if ( usecolor ) 
		printf( "%d ", n );
	else
		printf( "%d ", n );
	
	va_start( argp, fmt );
	vsprintf( outbuf, fmt, argp );
	va_end( argp );
					 
	colorformat( outbuf );
	
	if ( usecolor )
		printf( "\r\n" );
	else
		printf( "\r\n" );
	
	(void)fflush( stdout );
}
/*-- end of reply() -------------------------------------------------------*/
			  

/****************************************************************************
	LREPLY
****************************************************************************/
	 
void
lreply( int n, char *fmt, ... )
{
	va_list argp;
	char outbuf[ 2048 ];
	
	if ( usecolor )
		printf( "%d- %c[1;37m", n, 27 );
	else
		printf( "%d- ", n );
	
	va_start( argp, fmt );
	vsprintf( outbuf, fmt, argp );
	va_end( argp );
					 
	colorformat( outbuf );
					 
	if ( usecolor )
		printf( "%c[0m%c[0;37m\r\n", 27, 27 );
	else
		printf( "\r\n" );
	
	(void)fflush( stdout );
}
/*-- end of lreply() ------------------------------------------------------*/
			  

/****************************************************************************
	ACK
****************************************************************************/
				 
void
ack( char *s )
{
	if ( msg_waiting() )
		lreply( 250, "!GYou have new messages. Type !ESITE MSG!G to read them.!0");
	reply( 250, "%s command successful.", s );
}
/*-- end of ack() ---------------------------------------------------------*/
			  

/****************************************************************************
	NACK
****************************************************************************/
		 
void
nack( char *s)
{
	reply( 502, "%s command not implemented.", s );
}
/*-- end of nack() --------------------------------------------------------*/
			  

/****************************************************************************
	YYERROR
****************************************************************************/

void
yyerror( char *s )
{
	char *cp;

	if ( ( cp = index( cbuf,'\n' ) ) )
		*cp = '\0';

		reply( 500, "'%s': command not understood.", cbuf );
}
/*-- end of yyerror() -------------------------------------------------------*/
			  

/****************************************************************************
	DELCMD
****************************************************************************/
						  
void
delcmd(char *name)
{
	struct stat st;
	time_t avg_sec;
	char namebuff[MAXPATHLEN + 1], holdbuff[MAXPATHLEN + 1];
	int reply_sent = 0;
	char numbuff[65];
	uid_t myuid = geteuid();		/* do we need this? */

#ifdef DEBUG
	syslog(LOG_INFO, "[pheard] delcmd()");
	if (uf.name[0] == '\0')
		syslog(LOG_INFO, "[pheard] uf.name was NULL in the preceding function.");
#endif

	/* convert the name to the full path */
	real_path(name, namebuff);

	if (stat(namebuff, &st) < 0) {
		perror_reply(550, name);
		return;
	}
	
	if (st.st_uid != myuid && uf.level < 10) {
		reply(550, "%s: Permission Denied.", name);
		syslog(LOG_INFO, "[B/B] %s tried to delete '%s' owned by %d",
				uf.name, name, st.st_uid);
		return;
	}

	if ((st.st_mode & S_IFMT) == S_IFDIR) {
		if (rmdir(namebuff) < 0) {
			perror_reply(550, name);
			return;
		}
		reply(250, "DELE command successful.");
		return;
	}
	
	if (unlink(namebuff) < 0) {
		perror_reply(550, name);
		return;
	}

	/*
	 * Remove credits!  Un-dupe!
	 */

	strcpy(holdbuff, uf.name);
	if ( load_userfile(pw->pw_name) )
		syslog( LOG_ERR, "[pheard] Calling function was delcmd()" );
	if (uf.files_up > 0) {
		avg_sec = (time_t) (uf.seconds_up / uf.files_up);
		uf.files_up--;
		if (uf.bytes_up > (ulong) (st.st_size / 1024U))
			uf.bytes_up -= (ulong) (st.st_size / 1024U);
		else
			uf.bytes_up = 0L;

		if (uf.seconds_up > avg_sec)
			uf.seconds_up -= avg_sec;
		else
			uf.seconds_up = 0;

		if (uf.ratio != 0)
			if (uf.credits > (ulong) (st.st_size * uf.ratio) / 1024U)
				uf.credits -= ((ulong) st.st_size * (ulong) uf.ratio) / 1024U;
			else
				uf.credits = 0;

		commafmt(numbuff, 64, (ulong) st.st_size * (ulong) uf.ratio);
		if (uf.ratio != 0)
			reply(250, "DELE command successful. (%s credits removed)", numbuff);
		else
			reply(250, "DELE command successful.", numbuff);
		reply_sent = 1;
	}

	/* Remove weekly credits if it was this week */
	if (st.st_atime >= weekstart()) {
		if (uf.files_up_wk > 0) {
			avg_sec = (time_t) (uf.seconds_up_wk / uf.files_up_wk);
			uf.files_up_wk--;
			if (uf.bytes_up_wk > (ulong) (st.st_size / 1024U))
				uf.bytes_up_wk -= (ulong) (st.st_size / 1024U);
			else
				uf.bytes_up_wk = 0L;

			if (avg_sec > uf.seconds_up_wk)
				uf.seconds_up_wk -= avg_sec;
			else
				uf.seconds_up_wk = (time_t) 0;
		}
	}
	
	update_user();
	strcpy(holdbuff, name);		/* maybe this should be using the full path? */
	delete_dupe(holdbuff);

	if (!reply_sent)
		reply(250, "DELE command successful.");
}
/*-- end of delcmd() -----------------------------------------------------*/





/***************************************************************************
	CWD
***************************************************************************/
						
void
cwd( char *please_path )
{
	char 	now_path[ MAXPATHLEN + 1 ];
	char 	wannabe_path[ MAXPATHLEN + 1 ];
	char  path[ MAXPATHLEN + 1 ];
	char  endpath[ MAXPATHLEN+1 ];   
	char  tempname[ MAXPATHLEN+1 ];
	int numchk;
 											
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] cwd()" );
	if ( uf.name[ 0 ] == '\0' )
		syslog( LOG_INFO, "[pheard] uf.name was NULL in the preceding function." );
#endif
	
	/* I added support for CWD <newdir#> which is messy */
	numchk = atoi(please_path);
	if ( (numchk > 0) && (numchk < 20) ) {
		cwdx( ".", please_path );
		return;
	}
	/*
	 * This is a bullshit workaround to fix a 0.9 bug
	 */
	 load_userfile( uf.name );
	/*
	 * Get end part of pathname
	 */
	if ( strrchr( please_path, '/' ) == NULL )
	 	strncpy( endpath, please_path, sizeof( endpath ) );
	else
		strncpy( endpath, strrchr( please_path, '/' ) + 1, sizeof( endpath ) );

	/*
	 * So people can use "absolute" pathnames..
	 */
	if ( please_path[ 0 ] == '/' )
	{
		strcpy( path, uf.restrict );
		strcat( path, please_path );
	}
	else
	{
		strcpy( path, please_path );
	}

   if ( !getwd( now_path ) )
	{
   	perror_reply( 550, please_path );
      return;
   }

   if ( chdir( path ) < 0 ) 
   {           
      if ( errno != ENOENT )
      {
         perror_reply( 550, please_path );
         chdir( now_path );
         return;
      }

		/*
		 * Could not change?  Attempt to complete dir name for user
		 */
		if ( match_dir( now_path, path ) == 0 )
      	perror_reply( 550, please_path );
      else
         if ( chdir( matchdir ) >= 0 )
         {				  
				/*
				 * Complete...
				 */
            if ( !getwd( wannabe_path ) )
            {
               perror_reply( 550, please_path );
               chdir( now_path );
            }

            if ( uf.restrict[ 0 ] != '\0' )
            {
               if ( strncasecmp( wannabe_path, uf.restrict, strlen( uf.restrict ) ) != 0 )
               {
                  reply( 550, "%s: No such file or directory.", please_path );
                  chdir( now_path );
                  return;
               }
            }
				
				if ( !check_gpath( wannabe_path ) )
				{
					reply( 550, "%s: Permission denied.", please_path );
					chdir( now_path );
					return;
				}
			    						  
				if ( cf.show_diz )
            {
            	if ( show_file( 250, "FILE_ID.DIZ" ) != 0 )
                  show_bytes( 250 );
            }
					
				if ( cf.show_newsfile && !seen_welcome )
				{
               sprintf( tempname, "%s/newsfile", cf.datapath );
					show_message( 250, tempname );
					seen_welcome = 1;
				}
	
	    		show_msgpath( wannabe_path );
	    
            reply(250, "CWD command successful." );
         }
   } 
   else 
   {
      if ( !getwd( wannabe_path ) )
      {
         perror_reply( 550, please_path );
         chdir( now_path );
      }

      if ( uf.restrict[ 0 ] != '\0' )
      {
         if ( strncasecmp( wannabe_path, uf.restrict, strlen( uf.restrict ) ) != 0 )
         {
            reply( 550, "%s: No such file or directory.", please_path );
            chdir( now_path );
            return;
         }
      }
             
		if ( !check_gpath( wannabe_path ) )
		{
			reply( 550, "%s: Permission denied.", please_path );
			chdir( now_path );
			return;
		}
		
		if ( cf.show_diz )
      {
      	if ( show_file( 250, "FILE_ID.DIZ" ) )
            show_bytes( 250 );
      }
										  
		if ( cf.show_newsfile && !seen_welcome )
		{                       
         sprintf( tempname, "%s/newsfile", cf.datapath );
			show_message( 250, tempname );
			seen_welcome = 1;
		}
	
      show_msgpath( wannabe_path );
      
      ack( "CWD" );
   }
}		
/*-- end of cwd() --------------------------------------------------------*/
			  

/****************************************************************************
	MAKEDIR
****************************************************************************/
		  
void
makedir(char *name)
{
	int oldmask;
	int ct;
	char tempbuf[MAXPATHLEN + 1], workbuf[MAXPATHLEN], *ptr;

#ifdef DEBUG
	syslog(LOG_INFO, "[pheard] makedir()");
	if (uf.name[0] == '\0')
		syslog(LOG_INFO, "[pheard] uf.name was NULL in the preceding function.");
#endif

	(void) strcpy(workbuf, name);

	/* Don't allow SPACES or other NONPRINTABLE CHARS in dirname. */
	for (ct = 0; ct < strlen(name); ct++) {
		if (isspace(name[ct]) || iscntrl(name[ct])) {
			reply(550, "%s: Invalid character(s) in name.", name);
			return;
		}
	}

	/* If it is configured, capitalize the first letter of the dir. */
	if (cf.caps_first_letter) {
		if ((ptr = strrchr(workbuf, '/')) != (char *) NULL) {
			ptr++;
			*ptr = toupper(*ptr);
		} else {
			workbuf[0] = toupper(workbuf[0]);
		}
	}

	/* Check to see if '/' is the first character, if so, add restrict path */
	if (uf.restrict[0] != '\0')
		if (workbuf[0] == '/') {
			(void) strcpy(tempbuf, uf.restrict);
			(void) strcat(tempbuf, workbuf);
			(void) strcpy(workbuf, tempbuf);
		}

	/* remove mask for directory creation so we don't have to chmod after */
  	oldmask = umask(0000);

	/* mkdir */
	if (mkdir(workbuf, 0777) < 0) {
		perror_reply(550, name);
	} else {
		logdir(name);
		reply(257, "MKD command successful.");
	}

	/* reset umask */
  	(void) umask(oldmask);
}
/*-- end of makedir() -----------------------------------------------------*/
			  

/****************************************************************************
	REMOVEDIR
****************************************************************************/
				
void
removedir(char *name)
{
	char workbuf[MAXPATHLEN], tempbuf[MAXPATHLEN];

	/* create a working version of the dir name */
	(void) strcpy(workbuf, name);

	/* Check to see if '/' is the first character, if so, add restrict path */
	if (uf.restrict[0] != '\0')
		if (workbuf[0] == '/') {
			(void) strcpy(tempbuf, uf.restrict);
			(void) strcat(tempbuf, workbuf);
			(void) strcpy(workbuf, tempbuf);
		}

	/* do the dirty work */
	if (rmdir(workbuf) < 0)
		perror_reply(550, name);
	else {
		ack("RMD");
	}
}
/*-- end of removedir() ---------------------------------------------------*/
			  

/***************************************************************************
	PWD
***************************************************************************/
				  
void
pwd( void )
{			
	int x;
	int y = 0;
	char fixedpath[ MAXPATHLEN + 1 ];
	char path[ MAXPATHLEN + 1 ];
			
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] pwd()" );
	if ( uf.name[ 0 ] == '\0' )
		syslog( LOG_INFO, "[pheard] uf.name was NULL in the preceding function." );
#endif
	
   if ( !getwd( path ) )
	{	 
		/*
		 * Make restrict path look like root, if configured..
		 */
		if ( uf.restrict[ 0 ] != '\0' )
		{
			for ( x = strlen( uf.restrict ); x < strlen( path ); x++ )
				fixedpath[ y++ ] = path[ x ];
			fixedpath[ y ] = '\0';
			if ( !y )				 
				strcpy( path, "/" );
			else
				strcpy( path, fixedpath );
		}
		reply(550, "%s.", path);
	}
	else
	{
		/*
		 * Make restrict path look like root, if configured..
		 */
		if ( uf.restrict[ 0 ] != '\0' )
		{
			for ( x = strlen( uf.restrict ); x < strlen( path ); x++ )
				fixedpath[ y++ ] = path[ x ];
			fixedpath[ y ] = '\0';
			if ( !y )				 
				strcpy( path, "/" );
			else
				strcpy( path, fixedpath );
		}
      reply(257, "\"%s\" is current directory.", path);
	}
}
/*-- end of pwd() ---------------------------------------------------------*/
			  

/****************************************************************************
	RENAMEFROM
****************************************************************************/

char *
renamefrom( char *name )
{
	struct stat st;

	if ( stat( name, &st ) < 0 ) 
	{
		perror_reply( 550, name );
		return (char *)0;
	}
	
	reply( 350, "File exists, ready for destination name" );
	return name;
}
/*-- end of renamefrom() --------------------------------------------------*/
			  

/****************************************************************************
	RENAMECMD
****************************************************************************/
			 
void
renamecmd( char *from, char *to )
{
	if ( rename( from, to ) < 0 )
		perror_reply( 550, "rename" );
	else
		ack( "RNTO" );
}
/*-- end of renamecmd() ---------------------------------------------------*/
			  

/****************************************************************************
	DOLOG
****************************************************************************/
		
void
dolog( struct sockaddr_in *sin )
{
	struct hostent *hp = gethostbyaddr((char *)&sin->sin_addr,
		sizeof (struct in_addr), AF_INET);
	time_t t, time();
	extern char *ctime();

	if ( hp )
		(void)strncpy( remotehost, hp->h_name, sizeof( remotehost ) );
	else
		(void)strncpy( remotehost, inet_ntoa( sin->sin_addr ),
		    sizeof( remotehost ) );
			 
	(void)strncpy( remoteip, inet_ntoa( sin->sin_addr ), sizeof( remoteip ) );

	sprintf( proctitle, "%s: connected", remotehost );

	if ( logging ) 
	{
		t = time( NULL );
		syslog( LOG_INFO, "connection from %s at %s",
		    remotehost, ctime( &t ) );
	}
}
/*-- end of dolog() -------------------------------------------------------*/
			  

/****************************************************************************
	DOLOGOUT
	Record logout in wtmp file and exit with supplied status.
****************************************************************************/
  
void
dologout( int status )
{
	char fname[MAXPATHLEN];
	char datenow[30];
	time_t timenow = time(NULL);

#ifdef DEBUG
	syslog(LOG_INFO, "[pheard] dologout()");
	if (uf.name[0] == '\0')
		syslog(LOG_INFO, "[pheard] uf.name was NULL in the preceding function.");
#endif

	if (logged_in) {
		(void) seteuid((uid_t) 0);
		logwtmp(ttyline, "", "");
		
		uf.login_times++;
		sprintf(fname, "%-24.24s", ctime(&logintime));
		sprintf(datenow, "%-24.24s", ctime(&timenow));

		if (!memcmp(fname, datenow, 10))
			uf.time_on_today += (timenow - logintime);
		else
			uf.time_on_today = (timenow - logintime);

		update_user();
	}	
	  
	/* Can't hurt to do these, too */	
	free_online_struct();
	free_msgpath_struct();
	free_gpath_struct();
	
	sprintf(fname, "%s/pids/%d", cf.datapath, getpid());
	unlink(fname);

	/* beware of flushing buffers after a SIGPIPE */
	_exit(status);
}
/*-- end of dologout() ----------------------------------------------------*/


/****************************************************************************
	MYOOB
****************************************************************************/

void
myoob( void )
{
	char *cp;
	int  ct;

	/* Only process if transfer occurring */
	if ( !transflag )
		return;
		
	cp = tmpline;
	if ( getline( cp, 7, stdin ) == NULL )
	{
		dologout( 0 );
	}
	
	for ( ct = 0; ct < strlen( cp ); cp++ )
		cp[ ct ] = toupper( cp[ ct ] );
		
	if ( strcmp( cp, "ABOR\r\n" ) == 0 ) 
	{
		tmpline[ 0 ] = '\0';
		reply( 426, "Transfer aborted. Data connection closed." );
		reply( 226, "Abort successful" );
		longjmp( urgcatch, 1 );
	}
	
	if ( strcmp( cp, "STAT\r\n" ) == 0 ) 
	{
		if ( file_size != (off_t) -1 )
			reply( 213, "Status: %lu of %lu bytes transferred",
			    byte_count, file_size );
		else
			reply( 213, "Status: %lu bytes transferred", byte_count );
	}
}
/*-- end of myoob() -------------------------------------------------------*/
			  

/****************************************************************************
	PASSIVE
****************************************************************************/
			 
void
passive( void )
{
	int len;
	register char *p;
	register char *a;

	pdata = socket( AF_INET, SOCK_STREAM, 0 );
	if ( pdata < 0 ) 
	{
		perror_reply( 425, "Can't open passive connection" );
		return;
	}	 
	
	pasv_addr = ctrl_addr;
	pasv_addr.sin_port = 0;
	(void)seteuid( (uid_t)0 );
	
	if ( bind( pdata, (struct sockaddr *)&pasv_addr, sizeof( pasv_addr ) ) < 0 ) 
	{
		(void)seteuid( (uid_t)pw->pw_uid );
		goto pasv_error;
	}				 
	
	(void)seteuid( (uid_t)pw->pw_uid );
	len = sizeof( pasv_addr );
	
	if ( getsockname(pdata, (struct sockaddr *)&pasv_addr, &len ) < 0 )
		goto pasv_error;
	if ( listen(pdata, 1) < 0 )
		goto pasv_error;
	a = (char *)&pasv_addr.sin_addr;
	p = (char *)&pasv_addr.sin_port;

#define UC(b) (((int) b) & 0xff)

	reply( 227, "Entering Passive Mode (%d,%d,%d,%d,%d,%d)", UC(a[0]),
		UC(a[1]), UC(a[2]), UC(a[3]), UC(p[0]), UC(p[1]) );
	return;

pasv_error:
	(void)close( pdata );
	pdata = -1;
	perror_reply( 425, "Can't open passive connection" );
	return;
}
/*-- end of passive() -----------------------------------------------------*/
			  

/****************************************************************************
	GUNIQUE
	Generate unique file name for file with basename "local".  The file
	named "local" is already known to exist.  Generates failure reply on
	error.
****************************************************************************/

char *
gunique( char *local )
{
	static char new[ MAXPATHLEN ];
	struct stat st;
	char *cp = rindex( local, '/' );
	int count = 0;

	if ( cp )
		*cp = '\0';
		
	if ( stat( cp ? local : ".", &st ) < 0 ) 
	{
		perror_reply( 553, cp ? local : "." );
		return( (char *)0 );
	}
	
	if ( cp )
		*cp = '/';
		
	(void)strcpy( new, local );
	cp = new + strlen( new );
	*cp++ = '.';
	
	for ( count = 1; count < 100; count++ ) 
	{
		(void)sprintf( cp, "%d", count );
		if ( stat( new, &st ) < 0 )
			return( new );
	}

	reply( 452, "Unique file name cannot be created." );
	return( (char *)0 );
}
/*-- end of gunique() -----------------------------------------------------*/


/****************************************************************************
	PERROR_REPLY
	Format and send reply containing system error number.
****************************************************************************/

void
perror_reply( int code, char *string )
{
	reply( code, "!H%s!h: !B%s!h.!0", string, strerror( errno ) );
}
/*-- end of perror_reply() ------------------------------------------------*/
			  

/****************************************************************************
	SETPROCTITLE
	Clobber argv so ps will show what we're doing.
	(stolen from sendmail)
	Warning: Since this is usually started from inetd.conf, it often doesn't 
				have much of an environment or arglist to overwrite.
****************************************************************************/
			 
void
setproctitle( char *fmt, ... )
{
	register char *p;
	register char *bp;
	register char ch;
	register int i;
	char buf[ BUFSIZ ];
 	va_list argp;
													  
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] setproctitle()" );
	if ( uf.name[ 0 ] == '\0' )
		syslog( LOG_INFO, "[pheard] uf.name was NULL in the preceding function." );
#endif
	
	/*
	 * Build "buf" out of variable args
	 */
	va_start( argp, fmt );
	vsprintf( buf, fmt, argp );
	va_end( argp );
		 
	/*
	 * Make "ps" print our process name
	 */
	p = Argv[ 0 ];
	*p++ = '[';
	*p++ = 'b';
	*p++ = '/';
	*p++ = 'b';
	*p++ = ']';
	*p++ = ':';
	*p++ = ' ';

	i = strlen( buf );
	if ( i > LastArgv - p - 2 ) 
	{
		i = LastArgv - p - 2;
		buf[ i ] = '\0';
	}			 
	
	bp = buf;
	while ( ( ch = *bp++ ) )
		if ( ch != '\n' && ch != '\r' )
			*p++ = ch;
	while ( p < LastArgv )
		*p++ = ' ';
}
/*-- end of setproctitle() ------------------------------------------------*/



/****************************************************************************
	SHOW_STATS
****************************************************************************/

int 
lshow_stats( int msgcode )
{				 
	ulong  total_bytes;
	time_t total_seconds;
	float  avg_rate = 0.0;
	char   rate_str[ 50 ];
	char   up_str[ 50 ];
	char   down_str[ 50 ];
	char   ratio_str[ 50 ] = "None";
	char   credit_str[ 50 ] = "None";
	char   work_buff[ 128 ];
													
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] show_stats()" );
	if ( uf.name[ 0 ] == '\0' )
		syslog( LOG_INFO, "[pheard] uf.name was NULL in the preceding function." );
#endif
	
	if ( uf.ratio != 0 )										  
		sprintf( ratio_str, "1:%d", uf.ratio );
	
	if ( uf.ratio != 0 )
	{
		sprintf( credit_str, "%lu", (ulong)( uf.credits / (ulong)1024L ) ); 
		
		/* Strip off a trailing ".0" */
		if ( credit_str[ strlen( credit_str ) - 1 ] == '0' &&
			  strlen( credit_str ) != 1 )
		{
			if ( credit_str[ strlen( credit_str ) - 2 ] == '.' )			  
				credit_str[ strlen( credit_str ) - 2 ] = '\0';
		}
	}
	  
	/* Get rate */
	total_bytes = uf.bytes_up + uf.bytes_down;
	total_seconds = uf.seconds_up + uf.seconds_down;
	if ( total_seconds != 0 )
		avg_rate = (float)( total_bytes / total_seconds );
	sprintf( rate_str, "%.2f k/sec", avg_rate );
	
	sprintf( up_str, "%.1f", (float)( uf.bytes_up / 1024.0 ) );
	sprintf( down_str, "%.1f", (float)( uf.bytes_down / 1024.0 ) );
	
	/* Strip off trailing ".0"s */				
	if ( up_str[ strlen( up_str ) - 1 ] == '0' )
		up_str[ strlen( up_str ) - 2 ] = '\0';
	if ( down_str[ strlen( down_str ) - 1 ] == '0' )
		down_str[ strlen( down_str ) - 2 ] = '\0';
		
	/* Now clean up */
	if ( uf.bytes_up == 0 )
		strcpy( up_str, "None" );
	else
		strcat( up_str, " mb" );
		
	if ( uf.bytes_down == 0 )
		strcpy( down_str, "None" );
	else
		strcat( down_str, " mb" );
		
	if ( uf.ratio == 0 )
		strcpy( credit_str, "None" );
	else
		strcat( credit_str, " mb" );

	sprintf( work_buff, "!e[!G>>!g%s!e][!G<<!g%s!e][!GCredits: !g%s!e][!GRatio: !g%s!e][!GSpeed: !g%s!e]!0",
		up_str, down_str, credit_str, ratio_str, rate_str );

	lreply( msgcode, "%s!0", work_buff );
	return;
}
/*-- end of lshow_stats() --------------------------------------------------*/
/****************************************************************************
	SHOW_STATS
****************************************************************************/

void 
show_stats( int use_lreply )
{				 
	ulong  total_bytes;
	time_t total_seconds;
	float  avg_rate = 0.0;
	char   rate_str[ 50 ];
	char   up_str[ 50 ];
	char   down_str[ 50 ];
	char   ratio_str[ 50 ] = "None";
	char   credit_str[ 50 ] = "None";
	char   work_buff[ 128 ];
													
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] show_stats()" );
	if ( uf.name[ 0 ] == '\0' )
		syslog( LOG_INFO, "[pheard] uf.name was NULL in the preceding function." );
#endif
	
	if ( uf.ratio != 0 )										  
		sprintf( ratio_str, "1:%d", uf.ratio );
	
	if ( uf.ratio != 0 )
	{
		sprintf( credit_str, "%lu", (ulong)( uf.credits / (ulong)1024L ) ); 
		
		/* Strip off a trailing ".0" */
		if ( credit_str[ strlen( credit_str ) - 1 ] == '0' &&
			  strlen( credit_str ) != 1 )
		{
			if ( credit_str[ strlen( credit_str ) - 2 ] == '.' )			  
				credit_str[ strlen( credit_str ) - 2 ] = '\0';
		}
	}
	  
	/* Get rate */
	total_bytes = uf.bytes_up + uf.bytes_down;
	total_seconds = uf.seconds_up + uf.seconds_down;
	if ( total_seconds != 0 )
		avg_rate = (float)( total_bytes / total_seconds );
	sprintf( rate_str, "%.2f k/sec", avg_rate );
	
	sprintf( up_str, "%.1f", (float)( uf.bytes_up / 1024.0 ) );
	sprintf( down_str, "%.1f", (float)( uf.bytes_down / 1024.0 ) );
	
	/* Strip off trailing ".0"s */				
	if ( up_str[ strlen( up_str ) - 1 ] == '0' )
		up_str[ strlen( up_str ) - 2 ] = '\0';
	if ( down_str[ strlen( down_str ) - 1 ] == '0' )
		down_str[ strlen( down_str ) - 2 ] = '\0';
		
	/* Now clean up */
	if ( uf.bytes_up == 0 )
		strcpy( up_str, "None" );
	else
		strcat( up_str, " mb" );
		
	if ( uf.bytes_down == 0 )
		strcpy( down_str, "None" );
	else
		strcat( down_str, " mb" );
		
	if ( uf.ratio == 0 )
		strcpy( credit_str, "None" );
	else
		strcat( credit_str, " mb" );

	sprintf( work_buff, "!e[!G>>!g%s!e][!G<<!g%s!e][!GCredits: !g%s!e][!GRatio: !g%s!e][!GSpeed: !g%s!e]!0",
		up_str, down_str, credit_str, ratio_str, rate_str );

	if ( msg_waiting() )
		lreply( 226, "!EYou have new messages to read. !0");
										  
	if ( use_lreply )
		lreply( 226, "%s!0", work_buff );
	else
		reply( 226, "%s!0", work_buff );
}
/*-- end of show_stats() --------------------------------------------------*/
						  
/****************************************************************************
	MAIN
****************************************************************************/

int
main( int argc, char **argv, char **envp )
{
	int addrlen, on = 1, tos;
	char *cp;
	/*
	 * LOG_NDELAY sets up the logging connection immediately,
	 * necessary for anonymous ftp's that chroot and can't do it later.
	 */
	openlog( "Phear", LOG_PID | LOG_NDELAY, LOG_LOCAL1 );
	addrlen = sizeof( his_addr );
	
	if ( getpeername( 0, (struct sockaddr *)&his_addr, &addrlen ) < 0 ) 
	{
		syslog( LOG_ERR, "getpeername (%s): %m", argv[ 0 ] );
		exit( EXIT_FAILURE );
	}						  
	
	addrlen = sizeof( ctrl_addr );
	if ( getsockname( 0, (struct sockaddr *)&ctrl_addr, &addrlen ) < 0 ) 
	{
		syslog( LOG_ERR, "getsockname (%s): %m", argv[ 0 ] );
		exit( EXIT_FAILURE );
	}
#ifdef IP_TOS
	tos = IPTOS_LOWDELAY;
	if ( setsockopt( 0, IPPROTO_IP, IP_TOS, (char *)&tos, sizeof(int) ) < 0 )
		syslog( LOG_WARNING, "setsockopt (IP_TOS): %m" );
#endif
	data_source.sin_port = htons( ntohs( ctrl_addr.sin_port ) - 1 );
	debug = 0; 

	/*
	 *  Save start and extent of argv for setproctitle.
	 */
	Argv = argv;
	while ( *envp )
		envp++;
	LastArgv = envp[ -1 ] + strlen( envp[ -1 ] );

	argc--, argv++;
	while ( argc > 0 && *argv[ 0 ] == '-' ) 
	{
		for ( cp = &argv[ 0 ][ 1 ]; *cp; cp++ ) 
		{
			switch ( *cp )
			{
				case 'v':
					debug = 1;
					break;

				case 'd':
					debug = 1;
					break;

				case 'l':
					logging = 1;
					break;

				case 't':
					timeout = atoi(++cp);
					goto nextopt;

				case 'T':
					goto nextopt;

				case 'u':
				    {
						int val = 0;

						while ( *++cp && *cp >= '0' && *cp <= '9' )
							val = val*8 + *cp - '0';
						if ( *cp )
							fprintf( stderr, "ftpd: Bad value for -u\n" );
						else
							defumask = val;
						goto nextopt;
				    }

				default:
					fprintf( stderr, "ftpd: Unknown flag -%c ignored.\n", *cp );
					break;
			}
		}
nextopt:
		argc--, argv++;
	}
	(void)freopen( _PATH_DEVNULL, "w", stderr );
	(void)signal( SIGPIPE, (void *)lostconn );
	(void)signal( SIGCHLD, SIG_IGN );
	
	if ( (int)signal( SIGURG, (void *)myoob ) < 0 )
		syslog( LOG_ERR, "signal: %m" );

	/* Try to handle urgent data inline */
#ifdef SO_OOBINLINE
	if ( setsockopt( 0, SOL_SOCKET, SO_OOBINLINE, (char *)&on, sizeof(on)) < 0 )
		syslog( LOG_ERR, "setsockopt: %m" );
#endif

#ifdef	F_SETOWN
	if ( fcntl( fileno( stdin ), F_SETOWN, getpid() ) == -1 )
		syslog( LOG_ERR, "fcntl F_SETOWN: %m" );
#endif
	dolog( &his_addr );
	/*
	 * Set up default state
	 */
	data = -1;
	type = TYPE_A;
	form = FORM_N;
	stru = STRU_F;
	mode = MODE_S;
	tmpline[ 0 ] = '\0';
	(void)gethostname( hostname, sizeof( hostname ) );
	load_sysconfig();
	load_groups();
	load_hideusers();
	authenticate();		 
   show_message( 220, cf.banner ); 
   reply( 220, "PhearD (0.94) ready." );
	
	(void)setjmp( errcatch );
	for (;;)
		(void)yyparse();
	/* NOTREACHED */
}
/*-- end of main() --------------------------------------------------------*/

