%{
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/ftp.h>
#include <signal.h>
#include <setjmp.h>
#include <syslog.h>
#include <time.h>
#include <stdio.h>
#include <pwd.h>
#include <unistd.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include "../include/userfile.h"
#include "../include/sysconfig.h"

extern char version[];
extern int doing_dir;
extern struct sockaddr_in data_dest;
extern int logged_in;
extern struct passwd *pw;
extern int logging;
extern int type;
extern int form;
extern int debug;
extern int timeout;
extern int pdata;
extern char hostname[], remotehost[];
extern char proctitle[];
char mystatus[BUFSIZ];		/* My current status for WHO */
extern char *globerr;
extern int usedefault;
extern int transflag;
extern char tmpline[];
char **ftpglob();

struct tab cmdtab[];
struct tab sitetab[];
extern void show_newx( int msgcode, char *reqdir, char *numtimes );
extern int show_file( int msgcode, char *showname );
extern void show_stats( int use_lreply );
extern void who( int msgcode );
extern void read_msgs( int msgcode );
extern void send_msg( int msgcode, char *msgstr, int send_reply );
extern int msg_waiting( void );
extern void give_credits( int msgcode, char *args );
extern int userlist( int msgcode );
extern void showuser( int msgcode, char *username );
extern long sitedupe( int msgcode, char *search_str );
extern void addip( int msgcode, char *args );
extern void delip( int msgcode, char *args );
extern void ufchange( int msgcode, char *args );
extern int check_users( int msgcode );
extern int build_online_info( void );
extern void swho( int msgcode );
extern void iwho( int msgcode );
extern void deluser( int msgcode, char *args );
extern void show_oneliners( int msgcode );
extern void add_oneliner( char *oneliner );
extern void show_requests( int msgcode);
extern void add_request( char *request );
extern void request_filled( char *arg );
extern void whoami( void );
extern int list_deleted_users (int msgcode);
extern void readd( int msgcode, char *args );
extern void list_nukes( void );       
extern void list_old_nukes( int daysback );
extern void setgroup( int msgcode, char *args );
extern void list_groups( int msgcode );
extern void sgroup( int msgcode, char *argus );
extern void slocate( int msgcode, char *searchstr );
extern void show_help( int msgcode, const char *helpname );
extern void show_text( int msgcode, const char *helpname );
extern void setcolor( int msgcode, char *args );
extern void ls( char *parms );
extern void nls( char *parms );
extern void seen_user( int msgcode, char *user );
extern void killuser( int msgcode, char *user );
extern int usecolor;

extern uid_t userid;
off_t	restart_point;

static	int cmd_type;
static	int cmd_form;
static 	int cmd_bytesz;
char	cbuf[512];
char	*fromname;
char	*dirname;
int	*i;
%}

%token
	A	B	C	E	F	I
	L	N	P	R	S	T

	SP	CRLF	COMMA	STRING	NUMBER

	USER	PASS	ACCT	REIN	QUIT	PORT
	PASV	TYPE	STRU	MODE	RETR	STOR
	APPE	MLFL	MAIL	MSND	MSOM	MSAM
	MRSQ	MRCP	ALLO	REST	RNFR	RNTO
	ABOR	DELE	CWD	LIST	NLST	SITE
	STAT	HELP	NOOP	MKD	RMD	PWD
	CDUP	STOU	SMNT	SYST	SIZE	MDTM

  	UNFO    WEEKUP	WEEKDOWN ALLUP ALLDOWN 
	VERS    WHO     MSG     GIVE    WELCOME 	RULES
	NUKE    TIME    NUKES   USER    DUPE 		DISPLAY
	NEW     ADDIP   DELIP   CHANGE  UCHANGES
	UMASK	CHMOD   SWHO    KILL	KILLPID    ADDUSER 	DELUSER
	WHOAMI  READD   CHAT 	REQUEST REQFILLED 	SEEN
	GROUP	CHGRP   GROUPMEM    GALLUP  GWEEKUP    	LOCATE
	GINFO   LOGINS  COLOR 	DELDUPE	GADMIN

	LEXERR

%union 
{
    char *String;
    int Number;
}

%type <String>  STRING password pathname pathstring username
%type <Number>  NUMBER byte_size check_login form_code mode_code octal_number
%type <Number>  struct_code

%start	cmd_list

%%

cmd_list:	/* empty */
	|	cmd_list cmd = 
		{
			fromname = (char *)0;
			restart_point = (off_t)0;
		}
	|	cmd_list rcmd
	;

cmd:		USER SP username CRLF
		= {
			user((char *) $3);
			free((char *) $3);
		}
	|	PASS SP password CRLF
		= {
			pass((char *) $3);
			free((char *) $3);
		}
	|	PORT SP host_port CRLF
		= {
			usedefault = 0;
			if (pdata >= 0) {
				(void) close(pdata);
				pdata = -1;
			}
			reply(200, "PORT command successful.");
		}
	|	PASV CRLF
		= {
			passive();
		}
	|	TYPE SP type_code CRLF
		= {
			switch (cmd_type) {

			case TYPE_A:
				if (cmd_form == FORM_N) {
					reply(200, "Type set to A.");
					type = cmd_type;
					form = cmd_form;
				} else
					reply(504, "Form must be N.");
				break;

			case TYPE_E:
				reply(504, "Type E not implemented.");
				break;

			case TYPE_I:
				reply(200, "Type set to I.");
				type = cmd_type;
				break;

			case TYPE_L:
#if NBBY == 8
				if (cmd_bytesz == 8) {
					reply(200,
					    "Type set to L (byte size 8).");
					type = cmd_type;
				} else
					reply(504, "Byte size must be 8.");
#else /* NBBY == 8 */
				UNIMPLEMENTED for NBBY != 8
#endif /* NBBY == 8 */
			}
		}
	|	STRU SP struct_code CRLF
		= {
			switch ($3) {

			case STRU_F:
				reply(200, "STRU F ok.");
				break;

			default:
				reply(504, "Unimplemented STRU type.");
			}
		}
	|	MODE SP mode_code CRLF
		= {
			switch ($3) {

			case MODE_S:
				reply(200, "MODE S ok.");
				break;

			default:
				reply(502, "Unimplemented MODE type.");
			}
		}
	|	ALLO SP NUMBER CRLF
		= {
			reply(202, "ALLO command ignored.");
		}
	|	ALLO SP NUMBER SP R SP NUMBER CRLF
		= {
			reply(202, "ALLO command ignored.");
		}
	|	RETR check_login SP pathname CRLF
		= {	
			if ($2 && $4 != NULL)
				retrieve((char *) 0, (char *) $4);
			if ($4 != NULL)
				free((char *) $4);
		}
	|	STOR check_login SP pathname CRLF
		= {
			if ($2 && $4 != NULL)
				store((char *) $4, "w", 0);
			if ($4 != NULL)
				free((char *) $4);
		}
	|	APPE check_login SP pathname CRLF
		= {
			if ($2 && $4 != NULL)
				store((char *) $4, "a", 0);
			if ($4 != NULL)
				free((char *) $4);
		}
	|	NLST check_login CRLF
		= {	
			doing_dir = 1;
			if ($2)
				retrieve("/bin/ls", "");
			doing_dir = 0;
		}
	|	NLST check_login SP STRING CRLF
		= {				  
			doing_dir = 1;
			if ($2 && $4 != NULL) 
				nls( $4 );
			if ($4 != NULL)
				free((char *) $4);
			doing_dir = 0;
		}
	|	LIST check_login CRLF
		= {
			int oldtype = type;
			doing_dir = 1;
			if ($2)		  
				if ( usecolor )
					retrieve("/bin/ls --color -loAp", "");
				else
					retrieve("/bin/ls -loA", "");
			doing_dir = 0;
		}
        |       LIST check_login SP STRING CRLF
                = {
                        doing_dir = 1;
                        if ($2) {
				ls( $4 );
			}
			doing_dir = 0;
                }
	|	STAT check_login SP pathname CRLF
		= {
			if ($2 && $4 != NULL)
				statfilecmd((char *) $4);
			if ($4 != NULL)
				free((char *) $4);
		}
	|	STAT CRLF
		= {
			statcmd();
		}
	|	DELE check_login SP pathname CRLF
		= {
			if ($2 && $4 != NULL)
				delcmd((char *) $4);
			if ($4 != NULL)
				free((char *) $4);
		}
	|	RNTO SP pathname CRLF
		= {
			if (fromname) {
				renamecmd(fromname, (char *) $3);
				free(fromname);
				fromname = (char *) 0;
			} else {
				reply(503, "Bad sequence of commands.");
			}
			free((char *) $3);
		}
	|	ABOR CRLF
		= {
			reply(225, "ABOR command successful.");
		}
	|	CWD check_login CRLF
		= {
			if ($2)
				cwd(pw->pw_dir);
		}
	|	CWD check_login SP pathname CRLF
		= {
			if ($2 && $4 != NULL)
				cwd((char *) $4);
			if ($4 != NULL)
				free((char *) $4);
		}
	|	HELP CRLF
		= {
			help(cmdtab, (char *) 0);
		}
	|	HELP SP STRING CRLF
		= {
			register char *cp = (char *)$3;

			if (strncasecmp(cp, "SITE", 4) == 0) {
				cp = (char *)$3 + 4;
				if (*cp == ' ')
					cp++;
				if (*cp)
					help(sitetab, cp);
				else
					help(sitetab, (char *) 0);
			} else
				help(cmdtab, (char *) $3);
		}
	|	NOOP CRLF
		= {
			reply(200, "NOOP command successful.");
		}
	|	MKD check_login SP pathname CRLF
		= {
			if ($2 && $4 != NULL)
				makedir($4);
			if ($4 != NULL)
				free($4);
		}
	|	RMD check_login SP pathname CRLF
		= {
			if ($2 && $4 != NULL)
				removedir($4);
			if ($4 != NULL)
				free($4);
		}
	|	PWD check_login CRLF
		= {
			if ($2)
				pwd();
		}
	|	CDUP check_login CRLF
		= {
			if ($2)
				cwd("..");
		}
	|	SITE SP HELP CRLF	
		= 
		{
			if ( logged_in )
			{
				show_help( 200, "site.help" );
				if ( uf.level >= 5 )
					show_help( 200, "site.help.level5" );
		                if ( uf.level >= 10 )
					show_help( 200, "site.help.level10" );
                                if ( uf.level >= 15 )
                                        show_help( 200, "site.help.level15" );
                                if ( uf.level >= 20 )
					show_help( 200, "site.help.level20" );
				lreply( 200, "" );
				reply( 200, "Use \"SITE HELP <command>\" for syntax help." );
			}
			else
				reply(530, "Please Login First.");
		}       			
		
		
	|  SITE SP KILLPID CRLF = 
		{		 
			if ( logged_in && uf.level >= 20 )
			{
				show_help( 200, "site.killpid" );
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else if ( logged_in && uf.level < 20 )
				reply( 200, "You do not have access to this command." );
			else
				reply( 530, "Please Login First." );
		}
		
		
	|  SITE SP KILLPID SP STRING CRLF = 
		{	
			if ( logged_in && uf.level >= 20 )
			{ 
				if ( $5 != NULL )
               dokill( 200, $5 );
			}
         else if ( logged_in )
				reply(530, "You do not have access to this command.");
			else
				reply(530, "Please Login First.");
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}
		
        |  SITE SP KILL CRLF =
                {                
                        if ( logged_in && uf.level >= 10 ) 
                        {
                                show_help( 200, "site.kill" );
                                lreply( 200, "" );
                                reply( 200, "Command successful." );
                        }
                        else if ( logged_in && uf.level < 10 )
                                reply( 200, "You do not have access to this command." );
                        else
                                reply( 530, "Please Login First." );
                }
                
                
        |  SITE SP KILL SP STRING CRLF =
                {
                        if ( logged_in && uf.level >= 20 )
                        {
                                if ( $5 != NULL )
					killuser( 200, $5 );
                        }  
         else if ( logged_in )
                                reply(530, "You do not have access to this command.");
                        else
                                reply(530, "Please Login First.");

                        if ( $5 != NULL )
                                free( (char *) $5 );
                }
		
	|  SITE SP ADDUSER CRLF = 
		{		 
			if ( logged_in && uf.level >= 20 )
			{ 
				show_help( 200, "site.adduser" );
			   lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else if ( logged_in && uf.level < 20 )
				reply( 200, "You do not have access to this command." );
			else
				reply( 530, "Please Login First." );
		}
		
		
	|  SITE SP ADDUSER SP STRING CRLF = 
		{	
			if ( logged_in && uf.level >= 20 )
			{ 
				if ( $5 != NULL )
            {
               adduser( 200, $5 );
				}
			}
         else if ( logged_in )
				reply(530, "You do not have access to this command.");
			else
				reply(530, "Please Login First.");
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}						  
		
      
	|  SITE SP DELUSER CRLF = 
		{		 
			if ( logged_in && uf.level >= 20 )
			{
				show_help( 200, "site.deluser" );
			   lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else if ( logged_in && uf.level < 20 )
				reply( 200, "You do not have access to this command." );
			else
				reply( 530, "Please Login First." );
		}
										  
		
	|  SITE SP DELUSER SP STRING CRLF = 
		{	
			if ( logged_in && uf.level >= 20 )
			{ 
				if ( $5 != NULL )
            {
            	deluser( 200, $5 );
				}
			}
         else if ( logged_in )
				reply(530, "You do not have access to this command.");
			else
				reply(530, "Please Login First.");
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}
		
		
	|  SITE SP READD CRLF = 
		{		 
			if ( logged_in && uf.level >= 20 )
			{     
			   int numdeleted;
						  
				show_help( 200, "site.readd.top" );
			   if ( !list_deleted_users( 200 ) )
			   	lreply( 200, "<None>" );
				show_help( 200, "site.readd.bottom" );
			   lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else if ( logged_in && uf.level < 15 )
				reply( 200, "You do not have access to this command." );
			else
				reply( 530, "Please Login First." );
		}
		
		
	|  SITE SP READD SP STRING CRLF = 
		{	
			if ( logged_in && uf.level >= 20 )
			{ 
				if ( $5 != NULL )
            {
            	readd( 200, $5 );
				}
			}
         else if ( logged_in )
				reply(530, "You do not have access to this command.");
			else
				reply(530, "Please Login First.");
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}
		
		
	|  SITE SP CHGRP CRLF = 
		{		 
			if ( logged_in && uf.level >= 10 )
			{ 		 
				show_help( 200, "site.sgrp" );
				lreply( 200, "" );
			   reply( 200, "Command successful." );
			}
			else if ( logged_in && uf.level < 10 )
				reply( 200, "You do not have access to this command." );
			else
				reply( 530, "Please Login First." );
		}
		
		
	|  SITE SP CHGRP SP STRING CRLF = 
		{	
			if ( logged_in && uf.level >= 10 )
			{ 
				if ( $5 != NULL )
            {
               sgroup( 200, $5 );
				}
			}
         else if ( logged_in )
				reply(530, "You do not have access to this command.");
			else
				reply(530, "Please Login First.");
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}
		
		
	|	SITE SP HELP SP STRING CRLF = 
		{
			help(sitetab, (char *) $5);
		}
		
		
	|  SITE SP VERS CRLF = 
		{		
			if ( logged_in )
			{
				lreply( 200, "PhearD 0.91." );
				reply( 200, "Command successful." );
			}
			else
				reply(530, "Please Login First.");
		}  	
		
						  
	|  SITE SP NUKES CRLF = 
		{		
			if ( logged_in )
			{  
				list_nukes();
			}
			else
				reply(530, "Please Login First.");
		}

	|  SITE SP NUKES SP STRING CRLF = 
               {
                        if ( logged_in )
                        {
                                if ( $5 != NULL )
				{
						int daysback = atoi($5);
						list_old_nukes( daysback );
                                }
                        }
			else
                                reply(530, "Please Login First.");

                        if ( $5 != NULL )
                                free( (char *) $5 );
                }
		 
	|  SITE SP LOGINS CRLF = 
		{
			if ( logged_in && uf.level >= 10 )
			{
            char tempname[ MAXPATHLEN+1 ];
				
				lreply( 200, "" );
            sprintf( tempname, "%s/logs/login.log", cf.datapath );
				if ( !show_file( 200, tempname ) )
				{
					lreply( 200, "login.log is an empty file." );
				}
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else if ( logged_in )
				reply( 200, "You do not have access to this command." );
         else
				reply(530, "Please Login First.");
		}
		
		
	|  SITE SP UCHANGES CRLF = 
		{
			if ( logged_in && uf.level >= 10 )
			{
            char tempname[ MAXPATHLEN+1 ];
				
				lreply( 200, "" );
            sprintf( tempname, "%s/logs/sysop.log", cf.datapath );
				if ( !show_file( 200, tempname ) )
				{
					lreply( 200, "sysop.log is an empty file." );
				}
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else if ( logged_in )
				reply( 200, "You do not have access to this command." );
         else
				reply(530, "Please Login First.");
		}
		
		
	|  SITE SP WEEKUP CRLF = 
		{
			if ( logged_in )
			{
            char tempname[ MAXPATHLEN+1 ];
            
				show_text( 200, "weekup.head" );
            sprintf( tempname, "%s/tops/weekup", cf.datapath );
				if ( !show_file( 200, tempname ) )
				{
                                        sprintf( tempname, "%s/tops/weekup.last", cf.datapath );
				}
				show_text( 200, "weekup.foot" );
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else
				reply(530, "Please Login First.");
		}
		
		
	|  SITE SP WEEKDOWN CRLF = 
		{
			if ( logged_in )
			{
            char tempname[ MAXPATHLEN+1 ];
            
				show_text( 200, "weekdown.head" );
            sprintf( tempname, "%s/tops/weekdown", cf.datapath );
				if ( !show_file( 200, tempname ) )
				{
                                        sprintf( tempname, "%s/tops/weekdown.last", cf.datapath );
				}
				show_text( 200, "weekdown.foot" );
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else
				reply(530, "Please Login First.");
		}
		
		
	|  SITE SP ALLUP CRLF = 
		{
			if ( logged_in )
			{
            char tempname[ MAXPATHLEN+1 ];
            
				show_text( 200, "allup.head" );
            sprintf( tempname, "%s/tops/allup", cf.datapath );
				if ( !show_file( 200, tempname ) )
				{
                                        sprintf( tempname, "%s/tops/allup.last", cf.datapath );
				}
				show_text( 200, "allup.foot" );
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else
				reply(530, "Please Login First.");
		}
		
		
	|  SITE SP ALLDOWN CRLF = 
		{
			if ( logged_in )
			{		
            char tempname[ MAXPATHLEN+1 ];
            
				show_text( 200, "alldown.head" );
            sprintf( tempname, "%s/tops/alldown", cf.datapath );
				if ( !show_file( 200, tempname ) )
				{
                                        sprintf( tempname, "%s/tops/alldown.last", cf.datapath );
				}
				show_text( 200, "alldown.foot" );
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else
				reply(530, "Please Login First.");
		}
		
		
	|  SITE SP WELCOME CRLF = 
		{
			if ( logged_in )
			{		
				if ( !show_message( 200, cf.welcome_msg ) )
				{
					reply( 200, "No welcome message found!" );
				}
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else
				reply(530, "Please Login First.");
		}
		
		
	|  SITE SP RULES CRLF = 
		{
			if ( logged_in )
			{		
            char tempname[ MAXPATHLEN+1 ];
            
            sprintf( tempname, "%s/site.rules", cf.datapath );
				if ( !show_file( 200, tempname ) )
				{
					reply( 200, "No rules file found!" );
				}
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else
				reply(530, "Please Login First.");
		}
		 
		
	|  SITE SP GALLUP CRLF = 
		{
			if ( logged_in )
			{		
            char tempname[ MAXPATHLEN+1 ];
            
				show_text( 200, "grouptop.head" );
				
            sprintf( tempname, "%s/tops/grouptop", cf.datapath );
				
				if ( !show_file( 200, tempname ) )
				{
                                        sprintf( tempname, "%s/tops/grouptop.last", cf.datapath );
					lreply( 200, "The group tops list is currently being regenerated." );
					lreply( 200, "Please wait about 15-20 seconds then try again." );
				}
				
				show_text( 200, "grouptop.foot" );
				
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else
				reply(530, "Please Login First.");
		}
		 
		
		
	|  SITE SP GWEEKUP CRLF = 
		{
			if ( logged_in )
			{		
            char tempname[ MAXPATHLEN+1 ];
            
				show_text( 200, "wkgrouptop.head" );
				
            sprintf( tempname, "%s/tops/wkgrouptop", cf.datapath );
				
				if ( !show_file( 200, tempname ) )
				{
                                        sprintf( tempname, "%s/tops/wkgrouptop.last", cf.datapath );
					lreply( 200, "The group tops list is currently being regenerated." );
					lreply( 200, "Please wait about 15-20 seconds then try again." );
				}
				
				show_text( 200, "wkgrouptop.foot" );
				
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else
				reply(530, "Please Login First.");
		}
					
		
	|  SITE SP WHO CRLF =
		{
			if ( logged_in )
			{	
				show_text( 200, "who.head" );
				who( 200 );
			}
			else
				reply( 530, "Please Login First." );
		}
		
		
	|  SITE SP WHOAMI CRLF =
		{
			if ( logged_in )
			{	
         	whoami(); 
			}
			else
				reply( 530, "Please Login First." );
		}  
		
		
	|  SITE SP SWHO CRLF =
		{
			if ( logged_in && uf.level >= 10 )
			{	
            build_online_info(); 
				swho( 200 );
			}
         else if ( logged_in )
				reply( 200, "You do not have access to this command." );
			else
				reply( 530, "Please Login First." );
		}		  
		
		
		
	|  SITE SP UNFO CRLF = 
		{		 
			if ( logged_in )
			{
				lreply( 200, "!GCurrent Unfo: !D%.31s", uf.tagline );
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else
				reply(530, "Please Login First.");
		}
		
		
	|  SITE SP UNFO SP STRING CRLF = 
		{	
			if ( logged_in )
			{ 
				if ( $5 != NULL )
				{
					strncpy( uf.tagline, $5, 63 );
					update_user();
					lreply( 200, "!GNew Unfo: !D%.31s", uf.tagline );
        	                        lreply( 200, "" );
	                                reply( 200, "Command successful." );
				}
			}
			else
				reply(530, "Please Login First.");
			if ( $5 != NULL )
				free( (char *) $5 );
		}
		
		
	|  SITE SP MSG CRLF = 
		{		 
			if ( logged_in )
			{					  
				read_msgs( 200 );
			}
			else
				reply(530, "Please Login First.");
		}
		
		
	|  SITE SP MSG SP STRING CRLF = 
		{	
			if ( logged_in )
			{ 
				if ( $5 != NULL )
				{			  
					send_msg( 200, $5, 1 );
				}
			}
			else
				reply(530, "Please Login First.");
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}
		
		
	|  SITE SP CHAT CRLF = 
		{		 
			if ( logged_in )
			{
				show_text( 200, "chat.head" );
  
  				show_oneliners(200);

				show_text( 200, "chat.foot" );

				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else
				reply(530, "Please Login First.");
		}


	|  SITE SP CHAT SP STRING CRLF = 
		{	
			if ( logged_in )
			{ 
				if ( $5 != NULL )
				{			  
					add_oneliner( $5 );
        	                        lreply( 200, "" );
	                                reply( 200, "Command successful." );
				}
			}
			else
				reply(530, "Please Login First.");
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}
       |  SITE SP REQUEST SP STRING CRLF =
                {
                        if ( logged_in )
                        {
                                if ( $5 != NULL )
                                {
                                        add_request( $5 );
        	                        lreply( 200, "" );
 	                                reply( 200, "Command successful." );
                                }
                        }
                        else
                                reply(530, "Please Login First.");

                        if ( $5 != NULL )
                                free( (char *) $5 );
                }
	|  SITE SP REQUEST CRLF
		{
			if ( logged_in )
			{
				show_text( 200, "request.head" );
				show_requests(200);
				show_text( 200, "request.foot" );
				lreply( 200, "" );
                                reply( 200, "Command successful." );
                        }
                        else
                                reply(530, "Please Login First.");
                }

       |  SITE SP REQFILLED SP STRING CRLF =
                {
                        if ( logged_in )
                        {
                                if ( $5 != NULL )
                                {
                                        request_filled( $5 );
	                                lreply( 200, "" ); 
        	                        reply( 200, "Command successful." );
                                }
                        }
                        else
                                reply(530, "Please Login First.");

                        if ( $5 != NULL )
                                free( (char *) $5 );
                }
	|  SITE SP SEEN CRLF =
		{
			if ( logged_in )
                        {
				lreply( 200, "You must supply a username.");
                                lreply( 200, "" );

                        }
                        else
                                reply(530, "Please Login First.");
                }
	|  SITE SP SEEN SP STRING CRLF =
		{
			if ( logged_in )
			{
				if ( $5 != NULL )
				{
					seen_user( 200, $5 );
				lreply( 200, "" );

                                reply( 200, "Command successful." );
                                }
                        }
                        else
                                reply(530, "Please Login First.");

                        if ( $5 != NULL )
                                free( (char *) $5 );
                }
        |  SITE SP GIVE CRLF = 
		{		 
			if ( logged_in )
			{ 						  
				show_help( 200, "site.give" );
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else
				reply(530, "Please Login First.");
		}
		
		
	|  SITE SP GIVE SP STRING CRLF = 
		{	
			if ( logged_in )
			{ 
				if ( $5 != NULL )
				{			  
					give_credits( 200, $5 );
				}
			}
			else
				reply(530, "Please Login First.");
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}
		
		
	|  SITE SP NUKE CRLF = 
		{		 
			if ( logged_in && uf.level >= 5 )
			{ 			  
				show_help( 200, "site.nuke" );
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else if ( logged_in && uf.level < 5 )
				reply( 200, "You do not have access to this command." );
			else
				reply( 530, "Please Login First." );
		}
		
		
	|  SITE SP NUKE SP STRING CRLF = 
		{	
			if ( logged_in && uf.level >= 5 )
			{ 
				if ( $5 != NULL )
				{			  
					nuke( 200, $5 );
				}
			}
			else if ( logged_in && uf.level < 5 )
			{
				lreply( 200, "Invalid Access.  You cannot use this command" );
                                lreply( 200, "" );
                                reply( 200, "Command successful." );
			}
			else
				reply( 530, "Please Login First." );
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}		  
		
		
		
	|  SITE SP LOCATE CRLF = 
		{		 
			if ( logged_in )
			{
				show_help( 200, "site.locate" );
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else
				reply( 530, "Please Login First." );
		}
		
		
	|  SITE SP LOCATE SP STRING CRLF = 
		{	
			if ( logged_in)
			{ 
				if ( $5 != NULL )
				{			  
					slocate( 200, $5 );
	                                lreply( 200, "" );
        	                        reply( 200, "Command successful." );
				}
			}
			else
				reply( 530, "Please Login First." );

			if ( $5 != NULL )
				free( (char *) $5 );
		}
		
		
		
	|  SITE SP ADDIP CRLF = 
		{		 
			if ( logged_in && uf.level >= 10 )
			{ 
				show_help( 200, "site.addip" );
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else if ( logged_in && uf.level < 10 )
			{
                                lreply( 200, "Invalid Access.  You cannot use this command." );
                                lreply( 200, "" );
                                reply( 200, "Command successful." );
			}
			else
				reply( 530, "Please Login First." );
		}
		
		
	|  SITE SP ADDIP SP STRING CRLF = 
		{	
			if ( logged_in && uf.level >= 10 )
			{ 
				if ( $5 != NULL )
				{			  
					addip( 200, $5 );
				}
			}
			else if ( logged_in && uf.level < 10 )
			{
                                lreply( 200, "Invalid Access.  You cannot use this command." );
                                lreply( 200, "" );
                                reply( 200, "Command successful." );
			}
			else
				reply( 530, "Please Login First." );
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}
		
		
	|  SITE SP DELIP CRLF = 
		{		 
			if ( logged_in && uf.level >= 10 )
			{ 
				show_help( 200, "site.delip" );
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else if ( logged_in && uf.level < 10 )
			{
                                lreply( 200, "Invalid Access.  You cannot use this command." );
                                lreply( 200, "" );
                                reply( 200, "Command successful." );
			}
			else
				reply( 530, "Please Login First." );
		}
		
		
	|  SITE SP DELIP SP STRING CRLF = 
		{	
			if ( logged_in && uf.level >= 10 )
			{ 
				if ( $5 != NULL )
				{			  
					delip( 200, $5 );
				}
			}
			else if ( logged_in && uf.level < 10 )
			{
                                lreply( 200, "Invalid Access.  You cannot use this command." );
                                lreply( 200, "" );
                                reply( 200, "Command successful." );
			}
			else
				reply( 530, "Please Login First." );
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}
		
		
	|  SITE SP CHANGE CRLF = 
		{		 
			if ( logged_in && uf.level >= 15 )
			{ 
				show_help( 200, "site.change" );
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else if ( logged_in && uf.level < 15 )
			{
                                lreply( 200, "Invalid Access.  You cannot use this command." );
                                lreply( 200, "" );
                                reply( 200, "Command successful." );
			}
			else
				reply( 530, "Please Login First." );
		}
		
		
	|  SITE SP CHANGE SP STRING CRLF = 
		{	
			if ( logged_in && uf.level >= 15 )
			{ 
				if ( $5 != NULL )
				{			  
					ufchange( 200, $5 );
				}
			}
			else if ( logged_in && uf.level < 15 )
			{
                                lreply( 200, "Invalid Access.  You cannot use this command." );
                                lreply( 200, "" );
                                reply( 200, "Command successful." );
			}
			else
				reply( 530, "Please Login First." );
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}
		
		
	|  SITE SP USER CRLF = 
		{		 
			if ( logged_in )
			{ 	 
				int retval;
								  		  
				show_text( 200, "user.head" );
				retval = userlist( 200 );
				show_text( 200, "user.foot" );
				lreply( 200, "%d total users on site.", retval );
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else
				reply(530, "Please Login First.");
		}
		
		
	|  SITE SP USER SP STRING CRLF = 
		{	
			if ( logged_in )
			{ 
				if ( $5 != NULL )
				{			  
					showuser( 200, $5 );
				}
			}
			else
				reply( 530, "Please Login First." );
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}
		
		
	|  SITE SP GROUP CRLF = 
		{		 
			if ( logged_in )
			{
				show_text( 200, "groups.head" );
				list_groups( 200 );
				show_text( 200, "groups.foot" );
				lreply( 200, "" );
				reply( 200, "Command successful." );
			}
			else
				reply(530, "Please Login First.");
		}
		
		
	|  SITE SP GROUP SP STRING CRLF = 
		{	
			if (( logged_in )&&( uf.glock == 0 ))
			{ 
				if ( $5 != NULL )
				{			  
					setgroup( 200, $5 );
				}
			}
			else if ( uf.glock == 1 )
				reply( 200, "!BYou cannot change your group.!0");
			else
				reply( 530, "Please Login First." );
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}		  
		
		
	|  SITE SP GADMIN CRLF =
		{
                        if ( logged_in )
                        {
                                show_help( 200, "gadmin.help" );
                                lreply( 200, "" );
                                reply( 200, "Command successful." );
                        }
                        else
                                reply(530, "Please Login First.");
                }
	|  SITE SP GADMIN SP STRING CRLF =
                {
                        if (( logged_in )&&( strcmp(uf.gadmin, "none") ))
                        {
                                if ( $5 != NULL )
                                {
                                        gadmin( 200, $5 );
                                }
                        }
                        else if (!strcmp(uf.gadmin, "none") )
                                reply( 200, "!BYou do not have access to this.!0");
                        else
                                reply( 530, "Please Login First." );

                        if ( $5 != NULL )
                                free( (char *) $5 );
                }
	|  SITE SP COLOR CRLF = 
		{		 
			if ( logged_in )
			{
			 	if ( uf.use_color != 0 	)
				{
					uf.use_color = 0;  
					usecolor = 0;
					lreply( 200, "Color Mode Off." );
        	        		lreply( 200, "" );
	                                reply( 200, "Command successful." );	 				reply( 200, "Colors are now OFF." );
					update_user();
					return;
				}
				else  
				{
					uf.use_color = 1;
					usecolor = 1;
					lreply( 200, "Color Mode On. Note - Directories will be shown in color." );
        	                        lreply( 200, "" );
	                                reply( 200, "Command successful." );
		   			update_user();
					return;
				}
			}
			else
				reply(530, "Please Login First.");
		}
		
	|  SITE SP GROUPMEM CRLF = 
		{		 
			if ( logged_in )
			{ 					  		
				show_help( 200, "site.groupmem" );
			   lreply( 200, "" );
			   reply( 200, "Command successful." );
			}
			else
				reply(530, "Please Login First.");
		}
		
		
	|  SITE SP GROUPMEM SP STRING CRLF = 
		{	
			if ( logged_in )
			{ 
				if ( $5 != NULL )
				{			  
					listmembers( 200, $5 );
				}
			}
			else
				reply( 530, "Please Login First." );
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}
		
				  
	|  SITE SP GINFO CRLF = 
		{		 				
			if ( logged_in && uf.level >= 10 )
			{ 					  		
				show_help( 200, "site.gnfo" );
			   lreply( 200, "" );
			   reply( 200, "Command successful." );
			}
			else if ( logged_in && uf.level < 10 )
				reply( 200, "You do not have access to this command." );
			else
				reply(530, "Please Login First.");
		}
		
		
	|  SITE SP GINFO SP STRING CRLF = 
		{	
			if ( logged_in && uf.level >= 10 )
			{ 
				if ( $5 != NULL )
				{			  
					groupinfo( 200, $5 );
				}
			}
			else if ( logged_in && uf.level < 10 )
				reply( 200, "You do not have access to this command." );
			else
				reply( 530, "Please Login First." );
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}
		
		
	|  SITE SP DUPE CRLF = 
		{		 
			if ( logged_in )
			{ 					  
				show_help( 200, "site.dupe" );
			   lreply( 200, "" );
			   reply( 200, "Command successful." );
			}
			else
				reply(530, "Please Login First.");
		}
		
		
	|  SITE SP DUPE SP STRING CRLF = 
		{	
			if ( logged_in )
			{ 
				if ( $5 != NULL )
				{
					(void)sitedupe( 200, $5 );
					lreply( 200, "" );
					reply( 200, "Command successful." );
				}
			}
			else
				reply( 530, "Please Login First." );
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}
	
	| SITE SP DELDUPE CRLF =
		{
			if ( logged_in )
			  {
				show_help( 200, "site.deldupe" );
				lreply( 200, "" );
				reply( 200, "Command successful." );
                        }
                        else
                                reply( 530, "Please Login First." );
		}	
	|  SITE SP DELDUPE SP STRING CRLF =
		{
			if ( logged_in && uf.level >= 5)
			{
				if ( $5 != NULL )
				{
					if (delete_dupe( $5 )) {
						lreply( 200, "Successful" );
					} else {
						lreply( 200, "Failed" );
					}
                                lreply( 200, "" );
                                reply( 200, "Command successful." );
				}
			}
			else
                                reply( 530, "Please Login First.");
                        if ( $5 != NULL )
                                free( (char *) $5 );
		}
	|  SITE SP DISPLAY CRLF =
		{
                      if ( logged_in )
                        {
                                show_help( 200, "site.dupe" );
                           lreply( 200, "" );
                           reply( 200, "Command successful." );
                        }
                        else
                                reply(530, "Please Login First.");
                }
        |  SITE SP DISPLAY SP STRING CRLF =
                {
                        if ( logged_in )
                        {
                                if ( $5 != NULL )
                                {
					show_file( 200, $5 );
                                        lreply( 200, "" );
                                        reply( 200, "Command successful." );
                                }
                        }
                        else
                                reply( 530, "Please Login First.");
			if ( $5 != NULL )
                                free( (char *) $5 );
                }
		
	|  SITE SP TIME CRLF = 
		{		 			 
			time_t curtime = time( NULL );
			
			if ( logged_in )
			{ 
				reply( 200, "It is %.24s.", ctime( &curtime ) );
			}
			else
				reply(530, "Please Login First.");
		}
		
		
	|  SITE SP NEW CRLF = 
		{		 			 
			if ( logged_in )
			{ 
				show_text( 200, "last5.head" );
				show_newx( 200, ".", "5" );
				show_text( 200, "last5.foot" );
				lreply( 200, "" );
				reply( 200, "Command successful" );
			}
			else
				reply(530, "Please Login First.");
		}
		
	|  SITE SP NEW SP STRING CRLF = 
		{		 			 
			if ( logged_in )
			{ 
				if ( $5 != NULL );
				{			  
					show_text( 200, "last5.head" );
					show_newx( 200, ".", $5 );
					show_text( 200, "last5.foot" );
					lreply( 200, "" );
					reply( 200, "Command successful" );
				}
			}
			else
				reply(530, "Please Login First.");
				
			if ( $5 != NULL )
				free( (char *) $5 );
		}
		
		
	|  SITE SP STAT CRLF = 
		{
			show_stats( 1 );
			reply( 226, "Command successful. " );
		}

	|	SITE SP UMASK check_login CRLF = 
		{
			int oldmask;

			if ($4) {
				oldmask = umask(0);
				(void) umask(oldmask);
				reply(200, "Current UMASK is %03o", oldmask);
			}
		}
		
		
	|	SITE SP UMASK check_login SP octal_number CRLF = 
		{
			int oldmask;

			if ($4) {
				if (($6 == -1) || ($6 > 0777)) {
					reply(501, "Bad UMASK value");
				} else {
					oldmask = umask($6);
					reply(200,
					    "UMASK set to %03o (was %03o)",
					    $6, oldmask);
				}
			}
		}
		
		
	|	SITE SP CHMOD check_login SP octal_number SP pathname CRLF
		= {
			if ($4 && ($8 != NULL)) {
				if ($6 > 0777)
					reply(501,
				"CHMOD: Mode value must be between 0 and 0777");
				else if (chmod((char *) $8, $6) < 0)
					perror_reply(550, (char *) $8);
				else
					reply(200, "CHMOD command successful.");
			}
			if ($8 != NULL)
				free((char *) $8);
		}
	|	STOU check_login SP pathname CRLF
		= {
			if ($2 && $4 != NULL)
				store((char *) $4, "w", 1);
			if ($4 != NULL)
				free((char *) $4);
		}
	|	SYST CRLF
		= {
			reply(215, "UNIX Type: L8" );
		}

		/*
		 * SIZE is not in RFC959, but Postel has blessed it and
		 * it will be in the updated RFC.
		 *
		 * Return size of file in a format suitable for
		 * using with RESTART (we just count bytes).
		 */
	|	SIZE check_login SP pathname CRLF
		= {
			if ($2 && $4 != NULL)
				sizecmd((char *) $4);
			if ($4 != NULL)
				free((char *) $4);
		}

		/*
		 * MDTM is not in RFC959, but Postel has blessed it and
		 * it will be in the updated RFC.
		 *
		 * Return modification time of file as an ISO 3307
		 * style time. E.g. YYYYMMDDHHMMSS or YYYYMMDDHHMMSS.xxx
		 * where xxx is the fractional second (of any precision,
		 * not necessarily 3 digits)
		 */
	|	MDTM check_login SP pathname CRLF
		= {
			if ($2 && $4 != NULL) {
				struct stat stbuf;
				if (stat((char *) $4, &stbuf) < 0)
					perror_reply(550, "%s", (char *) $4);
				else if ((stbuf.st_mode&S_IFMT) != S_IFREG) {
					reply(550, "%s: not a plain file.",
						(char *) $4);
				} else {
					register struct tm *t;
					struct tm *gmtime();
					t = gmtime(&stbuf.st_mtime);
					reply(213,
					    "19%02d%02d%02d%02d%02d%02d",
					    t->tm_year, t->tm_mon+1, t->tm_mday,
					    t->tm_hour, t->tm_min, t->tm_sec);
				}
			}
			if ($4 != NULL)
				free((char *) $4);
		}
	|	QUIT CRLF
		= {	  							  
			/*
			 * Show user-specified goodbye message, if applicable
			 */       
         if ( logged_in )
         {
            char tempname[ MAXPATHLEN+1 ];
            
            sprintf( tempname, "%s/goodbye.msg", cf.datapath );
   			if ( !show_message( 221, tempname ) )
	   			reply( 221, "Goodbye." );
		   	else
			   	reply( 221, "" );
         }
         else
	   	   reply( 221, "Goodbye." );
            								
			sleep( 2 );
			dologout(0);
		}
	|	error CRLF
		= {
			yyerrok;
		}
	;
rcmd:		RNFR check_login SP pathname CRLF
		= {
			char *renamefrom();

			restart_point = (off_t) 0;
			if ($2 && $4) {
				fromname = renamefrom((char *) $4);
				if (fromname == (char *) 0 && $4) {
					free((char *) $4);
				}
			}
		}
	|	REST SP byte_size CRLF
		= {
			long atol();

			fromname = (char *) 0;
			restart_point = $3;
			reply(350, "Restarting at %ld. %s", restart_point,
			    "Send STORE or RETRIEVE to initiate transfer.");
		}
	;
		
username:	STRING
	;

password:	/* empty */
		= {
			*(char **)&($$) = (char *)calloc(1, sizeof(char));
		}
	|	STRING
	;

byte_size:	NUMBER
	;

host_port:	NUMBER COMMA NUMBER COMMA NUMBER COMMA NUMBER COMMA 
		NUMBER COMMA NUMBER
		= {
			register char *a, *p;

			a = (char *)&data_dest.sin_addr;
			a[0] = $1; a[1] = $3; a[2] = $5; a[3] = $7;
			p = (char *)&data_dest.sin_port;
			p[0] = $9; p[1] = $11;
			data_dest.sin_family = AF_INET;
		}
	;

form_code:	N
	= {
		$$ = FORM_N;
	}
	|	T
	= {
		$$ = FORM_T;
	}
	|	C
	= {
		$$ = FORM_C;
	}
	;

type_code:	A
	= {
		cmd_type = TYPE_A;
		cmd_form = FORM_N;
	}
	|	A SP form_code
	= {
		cmd_type = TYPE_A;
		cmd_form = $3;
	}
	|	E
	= {
		cmd_type = TYPE_E;
		cmd_form = FORM_N;
	}
	|	E SP form_code
	= {
		cmd_type = TYPE_E;
		cmd_form = $3;
	}
	|	I
	= {
		cmd_type = TYPE_I;
	}
	|	L
	= {
		cmd_type = TYPE_L;
		cmd_bytesz = NBBY;
	}
	|	L SP byte_size
	= {
		cmd_type = TYPE_L;
		cmd_bytesz = $3;
	}
	/* this is for a bug in the BBN ftp */
	|	L byte_size
	= {
		cmd_type = TYPE_L;
		cmd_bytesz = $2;
	}
	;

struct_code:	F
	= {
		$$ = STRU_F;
	}
	|	R
	= {
		$$ = STRU_R;
	}
	|	P
	= {
		$$ = STRU_P;
	}
	;

mode_code:	S
	= {
		$$ = MODE_S;
	}
	|	B
	= {
		$$ = MODE_B;
	}
	|	C
	= {
		$$ = MODE_C;
	}
	;

pathname:	pathstring
	= {
		/*
		 * Problem: this production is used for all pathname
		 * processing, but only gives a 550 error reply.
		 * This is a valid reply in some cases but not in others.
		 */
		if (logged_in && $1 && strncmp((char *) $1, "~", 1) == 0) {
			*(char **)&($$) = *ftpglob((char *) $1);
			if (globerr != NULL) {
				reply(550, globerr);
				$$ = NULL;
			}
			free((char *) $1);
		} else
			$$ = $1;
	}
	;

pathstring:	STRING
	;

octal_number:	NUMBER
	= {
		register int ret, dec, multby, digit;

		/*
		 * Convert a number that was read as decimal number
		 * to what it would be if it had been read as octal.
		 */
		dec = $1;
		multby = 1;
		ret = 0;
		while (dec) {
			digit = dec%10;
			if (digit > 7) {
				ret = -1;
				break;
			}
			ret += digit * multby;
			multby *= 8;
			dec /= 10;
		}
		$$ = ret;
	}
	;

check_login:	/* empty */
	= {
		if (logged_in)
			$$ = 1;
		else {
			reply(530, "Please Login First.");
			$$ = 0;
		}
	}
	;

%%

extern jmp_buf errcatch;

#define	CMD	0	/* beginning of command */
#define	ARGS	1	/* expect miscellaneous arguments */
#define	STR1	2	/* expect SP followed by STRING */
#define	STR2	3	/* expect STRING */
#define	OSTR	4	/* optional SP then STRING */
#define	ZSTR1	5	/* SP then optional STRING */
#define	ZSTR2	6	/* optional STRING after SP */
#define	SITECMD	7	/* SITE command */
#define	NSTR	8	/* Number followed by a string */

struct tab {
	char	*name;
	short	token;
	short	state;
	short	implemented;	/* 1 if command is implemented */
	char	*help;
};

struct tab cmdtab[] = {		/* In order defined in RFC 765 */
	{ "USER", USER, STR1, 1,	"<sp> username" },
	{ "PASS", PASS, ZSTR1, 1,	"<sp> password" },
	{ "ACCT", ACCT, STR1, 0,	"(specify account)" },
	{ "SMNT", SMNT, ARGS, 0,	"(structure mount)" },
	{ "REIN", REIN, ARGS, 0,	"(reinitialize server state)" },
	{ "QUIT", QUIT, ARGS, 1,	"(terminate service)", },
	{ "PORT", PORT, ARGS, 1,	"<sp> b0, b1, b2, b3, b4" },
	{ "PASV", PASV, ARGS, 1,	"(set server in passive mode)" },
	{ "TYPE", TYPE, ARGS, 1,	"<sp> [ A | E | I | L ]" },
	{ "STRU", STRU, ARGS, 1,	"(specify file structure)" },
	{ "MODE", MODE, ARGS, 1,	"(specify transfer mode)" },
	{ "RETR", RETR, STR1, 1,	"<sp> file-name" },
	{ "STOR", STOR, STR1, 1,	"<sp> file-name" },
	{ "APPE", APPE, STR1, 1,	"<sp> file-name" },
	{ "MLFL", MLFL, OSTR, 0,	"(mail file)" },
	{ "MAIL", MAIL, OSTR, 0,	"(mail to user)" },
	{ "MSND", MSND, OSTR, 0,	"(mail send to terminal)" },
	{ "MSOM", MSOM, OSTR, 0,	"(mail send to terminal or mailbox)" },
	{ "MSAM", MSAM, OSTR, 0,	"(mail send to terminal and mailbox)" },
	{ "MRSQ", MRSQ, OSTR, 0,	"(mail recipient scheme question)" },
	{ "MRCP", MRCP, STR1, 0,	"(mail recipient)" },
	{ "ALLO", ALLO, ARGS, 1,	"allocate storage (vacuously)" },
	{ "REST", REST, ARGS, 1,	"(restart command)" },
	{ "RNFR", RNFR, STR1, 1,	"<sp> file-name" },
	{ "RNTO", RNTO, STR1, 1,	"<sp> file-name" },
	{ "ABOR", ABOR, ARGS, 1,	"(abort operation)" },
	{ "DELE", DELE, STR1, 1,	"<sp> file-name" },
	{ "CWD",  CWD,  OSTR, 1,	"[ <sp> directory-name ]" },
	{ "XCWD", CWD,	OSTR, 1,	"[ <sp> directory-name ]" },
	{ "LIST", LIST, OSTR, 1,	"[ <sp> path-name ]" },
	{ "NLST", NLST, OSTR, 1,	"[ <sp> path-name ]" },
	{ "SITE", SITE, SITECMD, 1,	"site-cmd [ <sp> arguments ]" },
	{ "SYST", SYST, ARGS, 1,	"(get type of operating system)" },
	{ "STAT", STAT, OSTR, 1,	"[ <sp> path-name ]" },
	{ "HELP", HELP, OSTR, 1,	"[ <sp> <string> ]" },
	{ "NOOP", NOOP, ARGS, 1,	"" },
	{ "MKD",  MKD,  STR1, 1,	"<sp> path-name" },
	{ "XMKD", MKD,  STR1, 1,	"<sp> path-name" },
	{ "RMD",  RMD,  STR1, 1,	"<sp> path-name" },
	{ "XRMD", RMD,  STR1, 1,	"<sp> path-name" },
	{ "PWD",  PWD,  ARGS, 1,	"(return current directory)" },
	{ "XPWD", PWD,  ARGS, 1,	"(return current directory)" },
	{ "CDUP", CDUP, ARGS, 1,	"(change to parent directory)" },
	{ "XCUP", CDUP, ARGS, 1,	"(change to parent directory)" },
	{ "STOU", STOU, STR1, 1,	"<sp> file-name" },
	{ "SIZE", SIZE, OSTR, 1,	"<sp> path-name" },
	{ "MDTM", MDTM, OSTR, 1,	"<sp> path-name" },
	{ NULL,   0,    0,    0,	0 }
};
								 
struct tab sitetab[] = {
	{ "UMASK", UMASK, ARGS, 1,	"[ <sp> umask ]" },
	{ "CHMOD", CHMOD, NSTR, 1,	"<sp> mode <sp> file-name" },
	{ "TIME",  TIME,  ARGS, 1, "[ <sp> ]: Show current local time" },
	{ "NEW",   NEW,   OSTR, 1, "[ <sp> num ]: View recent uploads" },
	{ "NUKES", NUKES, OSTR, 1, "[ <sp> num ]: Show nukes from today/yesterday" },
	{ "WHO",   WHO,   ARGS, 1, "[ <sp> ]: Show who's online" },
	{ "SWHO",  SWHO,  ARGS, 1, "[ <sp> ]: Show who's online (PID+TIME+IDLE+ACTION)" },
	{ "STAT",  STAT,  ARGS, 1, "[ <sp> ]: Current server status" },
	{ "WEEKUP",  WEEKUP,  ARGS, 1, "[ <sp> ]: Week Top Uploaders" },
	{ "UCHANGES",  UCHANGES,  ARGS, 1, "[ <sp> ]: View user changes log" },
	{ "LOGINS",  LOGINS,  ARGS, 1, "[ <sp> ]: View login log" },
	{ "WEEKDOWN",  WEEKDOWN,  ARGS, 1, "[ <sp> ]: Week Top Downloaders" },
	{ "ALLUP",  ALLUP,  ARGS, 1, "[ <sp> ]: Top Uploaders" },
	{ "ALLDOWN",  ALLDOWN,  ARGS, 1, "[ <sp> ]: Top Downloaders" },
	{ "WELCOME",  WELCOME,  ARGS, 1, "[ <sp> ]: Read the welcome message" },
	{ "RULES",  RULES,  ARGS, 1, "[ <sp> ]: Read the rules" },
	{ "VERS",  VERS,  ARGS, 1, "[ <sp> ]: Version information" },
	{ "WHOAMI", WHOAMI, ARGS, 1, "[ <sp> ]: User information" },
	{ "HELP",  HELP,  OSTR, 1,	"[ <sp> <string> ]" },
	{ "UNFO",  UNFO,  OSTR, 1, "[ <sp> tagline ]: View/set tagline" },
	{ "MSG",   MSG,   OSTR, 1, "[ <sp> username <sp> message ]: View/send message(s)" },
	{ "KILLPID",  KILLPID,  OSTR, 1, "[ <sp> pidtokill ]: Kill a PID." },
	{ "KILL", KILL, OSTR, 1, "[ <sp> usertokill ]: Kill a user." },
	{ "ADDUSER",  ADDUSER,  OSTR, 1, "[ <sp> username <sp> password ]: Add a user." },
	{ "DELUSER",  DELUSER,  OSTR, 1, "[ <sp> username ]: Delete a user." },
	{ "READD", READD,  OSTR, 1, "[ <sp> username ]: Re-add a deleted user." },
	{ "CHGRP",  CHGRP,  OSTR, 1, "[ <sp> username <sp> group ]: Change a users group(s)." },
	{ "GIVE",  GIVE,  OSTR, 1, "[ <sp> megabytes <sp> username <sp> message (optional)]: View/send message(s)" },
	{ "NUKE",  NUKE,  OSTR, 1, "[ <sp> directory <sp> ratio <sp> message ]: Nuke directory & credits." },
	{ "LOCATE", LOCATE, OSTR, 1, "[ <sp> searchstr ]: Find a file on the site." },
	{ "ADDIP", ADDIP, OSTR, 1,	"[ <sp> username <sp> ip ]: Add new IP to user." },
	{ "DELIP", DELIP, OSTR, 1,	"[ <sp> username <sp> ip# ]: Remove IP from user." },
	{ "CHANGE", CHANGE, OSTR, 1,	"[ <sp> username <sp> field <sp> value ]: Change user information." },
	{ "DUPE",  DUPE,  OSTR, 1, "[ <sp> searchstr ]: Search dupe library." },
	{ "DELDUPE", DELDUPE, OSTR, 1, "[ <sp> delfile ]: Delete a file from the dupe library." },
	{ "DISPLAY", DISPLAY, OSTR, 1, "[ <sp> filename ]: Display a filename."},
	{ "USER",  USER,  OSTR, 1, "[ <sp> username ]: View all users or a specific user." },
	{ "GROUP", GROUP, OSTR, 1, "[ <sp> groupname ]: Change group(s)." },
	{ "GADMIN", GADMIN, OSTR, 1, "[ <sp> action <sp> username <sp> parms ]: Group Administration Functions." },
	{ "COLOR", COLOR, OSTR, 1, "[ <sp> ON|OFF ]: Toggle use of VT-100 color codes." },
	{ "GROUPMEM", GROUPMEM, OSTR, 1, "[ <sp> groupname ]: List users in a specified group." },
	{ "GINFO", GINFO, OSTR, 1, "[ <sp> groupname ]: Show detailed group info." },
	{ "CHAT", CHAT,  OSTR, 1, "[ <sp> message ]: View/Add chat." },
        { "REQFILLED", REQFILLED,  OSTR, 1, "[ <sp> request ]: Mark a request as filled." },
	{ "SEEN", SEEN, OSTR, 1, "[ <sp> user ]: Show last time a user logged on."},
	{ "REQUEST", REQUEST,  OSTR, 1, "[ <sp> request ]: View/Add requests." },
        { "GALLUP",  GALLUP,  ARGS, 1, "[ <sp> ]: Show alltime top groups." },
        { "GWEEKUP",  GWEEKUP,  ARGS, 1, "[ <sp> ]: Show week top groups." },
	{ NULL,   0,    0,    0,	0 }
};

struct tab *
lookup(p, cmd)
	register struct tab *p;
	char *cmd;
{

	for (; p->name != NULL; p++)
		if (strcmp(cmd, p->name) == 0)
			return (p);
	return (0);
}

#include <arpa/telnet.h>

/*
 * getline - a hacked up version of fgets to ignore TELNET escape codes.
 */
char *
getline(s, n, iop)
	char *s;
	register FILE *iop;
{
	register c;
	register char *cs;

	cs = s;
/* tmpline may contain saved command from urgent mode interruption */
	for (c = 0; tmpline[c] != '\0' && --n > 0; ++c) {
		*cs++ = tmpline[c];
		if (tmpline[c] == '\n') {
			*cs++ = '\0';
			if (debug)
				syslog(LOG_DEBUG, "command: %s", s);
			tmpline[0] = '\0';
			return(s);
		}
		if (c == 0)
			tmpline[0] = '\0';
	}
	while ((c = getc(iop)) != EOF) {
		c &= 0377;
		if (c == IAC) {
		    if ((c = getc(iop)) != EOF) {
			c &= 0377;
			switch (c) {
			case WILL:
			case WONT:
				c = getc(iop);
				printf("%c%c%c", IAC, DONT, 0377&c);
				(void) fflush(stdout);
				continue;
			case DO:
			case DONT:
				c = getc(iop);
				printf("%c%c%c", IAC, WONT, 0377&c);
				(void) fflush(stdout);
				continue;
			case IAC:
				break;
			default:
				continue;	/* ignore command */
			}
		    }
		}
		*cs++ = c;
		if (--n <= 0 || c == '\n')
			break;
	}
	if (c == EOF && cs == s)
		return (NULL);
	*cs++ = '\0';
	if (debug)
		syslog(LOG_DEBUG, "command: %s", s);
	return (s);
}

static void
toolong()
{
	time_t now;

	reply( 421, "Timeout (%d seconds): closing control connection.", timeout );
	(void)time( &now );
	if ( logging ) 
   {
		syslog( LOG_INFO, "User %s timed out after %d seconds at %.24s",
			(pw ? pw -> pw_name : "unknown"), timeout, ctime( &now ) );
	}
	dologout( 1 );
}

yylex()
{
	static int cpos, state;
	register char *cp, *cp2;
	register struct tab *p;
	int n;
	char c, *copy();

	for (;;) 
   {
		switch( state ) 
      {
   		case CMD:
	   		(void)signal( SIGALRM, toolong );
		   	(void)alarm( (unsigned)timeout );
            
			
            strncpy( mystatus, "IDLE", sizeof( mystatus ) );
            update_pid();
				
			   if ( getline( cbuf, sizeof( cbuf ) - 1, stdin ) == NULL ) 
            {
	   			dologout( 0 );
		   	}
			   (void)alarm( 0 );
   			if ( strncasecmp( cbuf, "PASS", 4 ) 
                             && strncasecmp( cbuf, "SITE ADDUSER", 9 )
			     && strncasecmp( cbuf, "SITE ADDIP", 10 ) )
	   		{
               strncpy( mystatus, cbuf, sizeof( mystatus ) );
	       update_pid();
   			}
	   		if ( ( cp = index( cbuf, '\r' ) ) ) 
            {
			   	*cp++ = '\n';
				   *cp = '\0';
   			}
   			if ( ( cp = strpbrk( cbuf, " \n" ) ) )
	   			cpos = cp - cbuf;
		   	if ( cpos == 0 )
			   	cpos = 4;
   			c = cbuf[ cpos ];
   			cbuf[ cpos ] = '\0';
   			upper( cbuf );
   			p = lookup( cmdtab, cbuf );
   			cbuf[ cpos ] = c;
   			if ( p != 0 ) 
            {
				   if ( p->implemented == 0 ) 
               {
   					nack(p->name);
	   				longjmp(errcatch,0);
		   			/* NOTREACHED */
			   	}
				   state = p->state;
   				yylval.String = p->name;
	   			return( p->token );
   			}
	   		break;

   		case SITECMD:
		   	if ( cbuf[ cpos ] == ' ' ) 
            {
   				cpos++;
	   			return( SP );
   			}
	   		cp = &cbuf[ cpos ];
   			if ( ( cp2 = strpbrk( cp, " \n" ) ) )
   				cpos = cp2 - cbuf;
	   		c = cbuf[ cpos ];
   			cbuf[ cpos ] = '\0';
   			upper( cp );
   			p = lookup( sitetab, cp );
   			cbuf[ cpos ] = c;
   			if ( p != 0 ) 
            {
				   if ( p->implemented == 0 ) 
               {
   					state = CMD;
	   				nack( p->name );
				   	longjmp( errcatch, 0 );
					   /* NOTREACHED */
   				}
		   		state = p->state;
			   	yylval.String = p->name;
				   return( p->token );
   			}
	   		state = CMD;
		   	break;

   		case OSTR:
	   		if ( cbuf[ cpos ] == '\n' ) 
            {
   				state = CMD;
	   			return( CRLF );
		   	}
   			/* FALLTHROUGH */

	   	case STR1:
		   case ZSTR1:
   		dostr1:
	   		if ( cbuf[ cpos ] == ' ' ) 
            {
		   		cpos++;
   				state = state == OSTR ? STR2 : ++state;
	   			return( SP );
		   	}
   			break;

	   	case ZSTR2:
		   	if ( cbuf[ cpos ] == '\n' ) 
            {
   				state = CMD;
	   			return( CRLF );
   			}
	   		/* FALLTHROUGH */

		   case STR2:
			   cp = &cbuf[ cpos ];
   			n = strlen( cp );
   			cpos += n - 1;
   			/*
	   		 * Make sure the string is nonempty and \n terminated.
		   	 */
			   if ( n > 1 && cbuf[ cpos ] == '\n' ) 
            {
   				cbuf[ cpos ] = '\0';
	   			yylval.String = copy( cp );
		   		cbuf[ cpos ] = '\n';
			   	state = ARGS;
				   return( STRING );
   			}
   			break;

	   	case NSTR:
		   	if ( cbuf[ cpos ] == ' ' ) 
            {
			   	cpos++;
				   return( SP );
   			}
	   		if ( isdigit( cbuf[ cpos ] ) ) 
            {
   				cp = &cbuf[ cpos ];
   				while ( isdigit( cbuf[ ++cpos ] ) )
   					;
			  	 	c = cbuf[ cpos ];
			  	 	cbuf[ cpos ] = '\0';
			  	 	yylval.Number = atoi( cp );
			  	 	cbuf[ cpos ] = c;
			  	 	state = STR1;
			  	 	return( NUMBER );
   			}
	   		state = STR1;
		   	goto dostr1;

   		case ARGS:
	   		if ( isdigit( cbuf[ cpos ] ) ) 
            {
				   cp = &cbuf[ cpos ];
   				while ( isdigit( cbuf[ ++cpos ] ) )
	   				;
		   		c = cbuf[ cpos ];
			   	cbuf[ cpos ] = '\0';
				   yylval.Number = atoi( cp );
   				cbuf[ cpos ] = c;
	   			return( NUMBER );
		   	}
			   switch ( cbuf[ cpos++ ] ) 
            {

      			case '\n':	state = CMD;
               				return( CRLF );

      			case ' ':	return( SP );

      			case ',':	return( COMMA );

      			case 'A':
		      	case 'a':	return( A );

   	   		case 'B':
	   	   	case 'b':	return( B );

      			case 'C':
		      	case 'c':	return( C );

      			case 'E':
		      	case 'e':	return( E );

      			case 'F':
		      	case 'f':	return( F );

      			case 'I':
		      	case 'i':	return( I );

      			case 'L':
		      	case 'l':	return( L );

      			case 'N':
		      	case 'n':	return( N );

      			case 'P':
		      	case 'p':	return( P );

      			case 'R':
		      	case 'r':	return( R );

      			case 'S':
		      	case 's':	return( S );

      			case 'T':
		      	case 't':	return( T );

			   }
			   break;

		      default: fatal( "Unknown state." );
		}
		yyerror( (char *)0 );
		state = CMD;
		longjmp( errcatch, 0 );
	}
}

upper(s)
	register char *s;
{
	while (*s != '\0') {
		if (islower(*s))
			*s = toupper(*s);
		s++;
	}
}

char *
copy(s)
	char *s;
{
	char *p;

	p = malloc((unsigned) strlen(s) + 1);
	if (p == NULL)
		fatal("Ran out of memory.");
	(void) strcpy(p, s);
	return (p);
}

help(ctab, s)
	struct tab *ctab;
	char *s;
{
	register struct tab *c;
	register int width, NCMDS;
	char *type;

	if (ctab == sitetab)
		type = "SITE ";
	else
		type = "";
	width = 0, NCMDS = 0;
	for (c = ctab; c->name != NULL; c++) {
		int len = strlen(c->name);

		if (len > width)
			width = len;
		NCMDS++;
	}
	width = (width + 8) &~ 7;
	if (s == 0) {
		register int i, j, w;
		int columns, lines;

		lreply(214, "The following %scommands are recognized %s.",
		    type, "(* =>'s unimplemented)");
		columns = 76 / width;
		if (columns == 0)
			columns = 1;
		lines = (NCMDS + columns - 1) / columns;
		for (i = 0; i < lines; i++) {
			printf("   ");
			for (j = 0; j < columns; j++) {
				c = ctab + j * lines + i;
				printf("%s%c", c->name,
					c->implemented ? ' ' : '*');
				if (c + lines >= &ctab[NCMDS])
					break;
				w = strlen(c->name) + 1;
				while (w < width) {
					putchar(' ');
					w++;
				}
			}
			printf("\r\n");
		}
		(void) fflush(stdout);
		reply(214, "Direct comments to %s.", cf.email );
		return;
	}
	upper(s);
	c = lookup(ctab, s);
	if (c == (struct tab *)0) {
		reply(502, "Unknown command %s.", s);
		return;
	}
	if (c->implemented)
		reply(214, "Syntax: %s%s %s", type, c->name, c->help);
	else
		reply(214, "%s%-*s\t%s; unimplemented.", type, width,
		    c->name, c->help);
}

sizecmd(filename)
char *filename;
{
	switch (type) {
	case TYPE_L:
	case TYPE_I: {
		struct stat stbuf;
		if (stat(filename, &stbuf) < 0 ||
		    (stbuf.st_mode&S_IFMT) != S_IFREG)
			reply(550, "%s: not a plain file.", filename);
		else
			reply(213, "%lu", stbuf.st_size);
		break;}
	case TYPE_A: {
		FILE *fin;
		register int c;
		register long count;
		struct stat stbuf;
		fin = fopen(filename, "r");
		if (fin == NULL) {
			perror_reply(550, filename);
			return;
		}
		if (fstat(fileno(fin), &stbuf) < 0 ||
		    (stbuf.st_mode&S_IFMT) != S_IFREG) {
			reply(550, "%s: not a plain file.", filename);
			(void) fclose(fin);
			return;
		}

		count = 0;
		while((c=getc(fin)) != EOF) {
			if (c == '\n')	/* will get expanded to \r\n */
				count++;
			count++;
		}
		(void) fclose(fin);

		reply(213, "%ld", count);
		break;}
	default:
		reply(504, "SIZE not implemented for Type %c.", "?AEIL"[type]);
	}
}
