
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include "../include/sysconfig.h"
#include "../include/userfile.h"

extern void reply (int n, char *fmt,...);
extern void lreply (int n, char *fmt,...);
extern char *trim (char *str);
extern int show_message (int msgcode, char *msgname);
extern void send_msg( int msgcode, char *msgstr, int send_reply );
extern uid_t userid;


/****************************************************************************
   DIR_LOG
****************************************************************************/

void
logdir (char *logdir)
{
	char work_buff[MAXPATHLEN];
	char dirlog[MAXPATHLEN];
	FILE *fpout;
	mode_t oldmask;
	uid_t oldid = geteuid();
	oldmask = umask (0000);
	if (strstr( logdir, cf.incomingdir));
	seteuid( 0 );
	sprintf (dirlog, "%s/dirlog", cf.datapath);
	fpout = fopen (dirlog, "a+" );
	if (fpout == NULL)
	{
    		syslog (LOG_ERR, "[pheard] %s: writing '%s': %m", uf.name, dirlog);
		umask (oldmask);
		seteuid( oldid );
		return;
	}
	sprintf (work_buff, "%s %s %s\n", uf.name, uf.group_user[0], logdir);
	fputs (work_buff, fpout);
	fclose (fpout);
	seteuid( oldid );
}
/*--- end of add_oneliner() -----------------------------------------------*/
