#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include "../include/sysconfig.h"
#include "../include/userfile.h"

extern void reply (int n, char *fmt,...);
extern void lreply (int n, char *fmt,...);
extern char *trim (char *str);
extern int show_message (int msgcode, char *msgname);

extern uid_t userid;


/****************************************************************************
  SHOW_ONELINERS
  This one is for the cookie, a slightly different format (less verbose)
****************************************************************************/

int
show_oneliners (int msgcode)
{
  	char linebuf[BUFSIZ];
  	char sent_by[45];
  	char timebuff[25];
  	time_t sent_when;
  	char fname[MAXPATHLEN];
	char buff[20];
  	FILE *fp;
  	int shown = 0;
  	uid_t oldid = geteuid();
						  
  	seteuid( 0 );
  
  	sprintf (fname, "%s/oneliners", cf.datapath);
  	fp = fopen (fname, "r");
  	if ( fp == NULL )
  	{  
	sprintf( buff, "No Oneliners." );
#ifdef VDR
		lreply( msgcode, "!G!5%-78.78s!0", buff );
#else
		lreply( msgcode, "!G%-78.78s!0", buff );
#endif
		seteuid( oldid );
	  	return 0;
  	}

  	while (1)
   {
   	fgets (linebuf, BUFSIZ, fp);
      if (feof (fp))
			break;
      memcpy (sent_by, linebuf, 24);
      memcpy (timebuff, linebuf + 24, 24);
      sent_by[24] = '\0';
      timebuff[24] = '\0';
      trim (sent_by);
      sent_when = (time_t) strtoul (timebuff, (char **) NULL, 0);
      fgets (linebuf, BUFSIZ, fp);
      trim (linebuf);
      linebuf[strlen (linebuf)] = '\0';
#ifdef VDR
      lreply (msgcode, "!E!5 <!D!5%-9.9s!E!5>!H!5 %-61.61s!0", sent_by, linebuf);
#else
	lreply(msgcode, "!G[!E%-9.9s!G] !g%-61.61s!0", sent_by, linebuf);
#endif
      shown++;
   }

  	fclose (fp); 
  
  	seteuid( oldid );
  
  	return( shown );
}
/*--- end of show_oneliners() ---------------------------------------------*/


/****************************************************************************
  ADD_ONELINER
****************************************************************************/

void
add_oneliner (char *oneliner)
{
  char work_buff[MAXPATHLEN];
  char onelfile[MAXPATHLEN];
  char tempfile[MAXPATHLEN];
  char numbuff[25];
  int found = 0;
  FILE *fpin;
  FILE *fpout;
  char line1[BUFSIZ];
  char line2[BUFSIZ];
  mode_t oldmask;
  int x;		  
  int startnum = 0;
  uid_t oldid = geteuid();
  
  struct REQUEST
  {
  		char line1[50];
		char line2[80];
  } oneliners[ 50 ];
  
  oldmask = umask (0000);
  seteuid( 0 );						  
  
  /*
   * (Attempt to) open the temp file
   */
  sprintf (tempfile, "%s/oneliner.%d.temp", cf.datapath, getpid ());
  fpout = fopen (tempfile, "w" );
  if (fpout == NULL)
  {
    	syslog (LOG_ERR, "[pheard] %s: writing '%s': %m", uf.name, tempfile);
    	reply (200, "!BOneliner not added -- system error -- inform siteop.!0");
    	umask (oldmask);
		seteuid( oldid );
    	return;
  }

  /*
   * (Attempt to) open the oneliners file
   */
  sprintf (onelfile, "%s/oneliners", cf.datapath);
  fpin = fopen (onelfile, "r" );
  if (fpin == NULL && errno != ENOENT)
  {
   	unlink (tempfile);
    	syslog (LOG_ERR, "[pheard] %s: reading '%s': %m", uf.name, onelfile);
    	reply (200, "!BOneliner not added -- system error -- inform siteop.!0");
    	umask (oldmask);  
		seteuid( oldid );
    	return;
  }
  umask (oldmask);

   /*
    * Read & write... 
    */
	while (found <= cf.max_oneliners && fpin )
	{
		bzero( line1, BUFSIZ );
		bzero( line2, BUFSIZ );

		fgets( line1, BUFSIZ, fpin );
		if ( feof( fpin ) )
			break;
		fgets( line2, BUFSIZ, fpin );
		if ( feof( fpin ) )
			break;

		strncpy( oneliners[ found ].line1, line1, 50 );
		strncpy( oneliners[ found ].line2, line2, 80 );

	  found++;
	}				
							
	if ( found == cf.max_oneliners )
		startnum = 1;
	if ( startnum < 0 )
		startnum = 0;

	for ( x = startnum; x < found; x++ )
	{
		fputs( oneliners[x].line1, fpout );
		fputs( oneliners[x].line2, fpout );
	}

  sprintf (numbuff, "%ld", time (NULL));
  sprintf (work_buff, "%-24.24s%-24.24s\n", uf.name, numbuff);
  fputs (work_buff, fpout);

  sprintf (work_buff, "%-75.75s\n", oneliner);
  fputs(work_buff, fpout);

  	fclose (fpin);
  	fclose (fpout);

  	unlink (onelfile);
  	rename (tempfile, onelfile);

  	lreply (200, "!HYour oneliner has been added.!0");
  
  	seteuid( oldid );
}
/*--- end of add_oneliner() -----------------------------------------------*/

