
#define SYSCONFIG

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <unistd.h>
#include <syslog.h>
#ifdef __linux__
#include <linux/unistd.h>
#endif
#include <sys/file.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <ctype.h>
#include "../include/sysconfig.h"
#include "../include/userfile.h"

#undef SYSCONFIG 

extern char *trim (char *str);

extern uid_t userid; 

/***************************************************************************
  CLEAR_CONFIG_STRUCT
***************************************************************************/

void
clear_config_struct (void)
{
  /* Set default configuration values */
  strncpy (cf.datapath, "/usr/.phear", sizeof (cf.datapath));
  cf.max_users = 15;
  cf.tag_file[0] = '\0';
  cf.welcome_msg[0] = '\0';
  cf.show_diz = 1;
  cf.default_ratio = 6;
  cf.free_ratio_amount = (ulong) 51200000L;
  cf.dupe_check_days = 7;
  strncpy (cf.requestdir, "/ftpserv/request", sizeof (cf.requestdir));
  strncpy (cf.incomingdir, "/ftpserv/incoming", sizeof (cf.incomingdir));
  strncpy (cf.default_restrict, "/tmp", sizeof (cf.default_restrict));
  strncpy (cf.default_tagline,"Set your unfo!", 
	   sizeof (cf.default_tagline));
  cf.default_num_logins = 1;
  cf.default_level = 1;
  cf.caps_first_letter = 0;
  strncpy (cf.email, "[UNKNOWN]", sizeof (cf.email));
  cf.banner[0] = '\0';
  strncpy (cf.sitename, "UNKNOWN", sizeof (cf.sitename));
  strncpy (cf.dividerline, "--=-------------------------------------------------------------------=--", sizeof (cf.dividerline));
  cf.show_newsfile = 1;
  cf.multiplier_max = 5;
  cf.max_oneliners = 10;
  cf.max_requests = 20;
}
/*-- end of clear_config_struct() ----------------------------------------*/


/***************************************************************************
  SYSCONFIG_PARSEVAL
  Parses values in "sysconfig" file.
***************************************************************************/

void
sysconfig_parseval (char *lvalue, char *rvalue)
{															 
  /* Here we parse all values */
  if (strcasecmp (lvalue, "datapath") == 0)
    {
      strncpy (cf.datapath, rvalue, sizeof (cf.datapath));
      return;
    }

  if (strcasecmp (lvalue, "max_users") == 0)
    {
      cf.max_users = atoi (rvalue);
      return;
    }

  if (strcasecmp (lvalue, "tag_file") == 0)
    {
      strncpy (cf.tag_file, rvalue, sizeof (cf.tag_file));
      return;
    }

  if (strcasecmp (lvalue, "welcome_msg") == 0)
    {
      strncpy (cf.welcome_msg, rvalue, sizeof (cf.welcome_msg));
      return;
    }

  if (strcasecmp (lvalue, "show_diz") == 0)
    {
      cf.show_diz = atoi (rvalue);
      if (cf.show_diz != 0 && cf.show_diz != 1)
	cf.show_diz = 1;	/* Default */
      return;
    }

  if (strcasecmp (lvalue, "default_ratio") == 0)
    {
      cf.default_ratio = atoi (rvalue);
      return;
    }

  if (strcasecmp (lvalue, "free_ratio_amount") == 0)
    {
      cf.free_ratio_amount = strtoul (rvalue, (char **) NULL, 0);
      return;
    }

  if (strcasecmp (lvalue, "dupe_check_days") == 0)
    {
      cf.dupe_check_days = atoi (rvalue);
      return;
    }

  if (strcasecmp (lvalue, "default_restrict") == 0)
    {
      strncpy (cf.default_restrict, rvalue, 
	       sizeof (cf.default_restrict));
      return;
    }

  if (strcasecmp (lvalue, "default_tagline") == 0)
    {
      strncpy (cf.default_tagline, rvalue, 
	       sizeof (cf.default_tagline));
      return;
    }

  if (strcasecmp (lvalue, "default_num_logins") == 0)
    {
      cf.default_num_logins = atoi (rvalue);
      return;
    }

  if (strcasecmp (lvalue, "default_level") == 0)
    {
      cf.default_level = atoi (rvalue);
      return;
    }

  if (strcasecmp (lvalue, "caps_first_letter") == 0)
    {
      cf.caps_first_letter = atoi (rvalue);
      return;
    }

  if (strcasecmp (lvalue, "email") == 0)
    {
      strncpy (cf.email, rvalue, sizeof (cf.email));
      return;
    }

  if (strcasecmp (lvalue, "banner") == 0)
    {
      strncpy (cf.banner, rvalue, sizeof (cf.banner));
      return;
    }

  if (strcasecmp (lvalue, "sitename") == 0)
    {
      strncpy (cf.sitename, rvalue, sizeof (cf.sitename));
      return;
    }

  if ( strcasecmp( lvalue, "multiplier_max") == 0 )
    {
      cf.multiplier_max = atoi( rvalue );
      return;
    }						  
	 
  if ( strcasecmp( lvalue, "max_oneliners") == 0 )
    {
      cf.max_oneliners = atoi( rvalue );
      return;
    }								 
	 
	if ( strcasecmp( lvalue, "requestdir" ) == 0 )
   {
	strncpy (cf.requestdir, rvalue,
	sizeof (cf.requestdir));
	return;
   }
   	if ( strcasecmp( lvalue, "incomingdir" ) == 0 )
   	{
   		strncpy (cf.incomingdir, rvalue, sizeof (cf.incomingdir));
   		return;
   	}
}
/*-- end of sysconfig_parseval() ------------------------------------------*/



/***************************************************************************
  LOAD_SYSCONFIG
  Loads data from system configuration file.
***************************************************************************/

void
load_sysconfig (void)
{
  FILE *configfile;
  char lvalue[64];
  char rvalue[MAXPATHLEN];
  int x, y;
  char work_buff[MAXPATHLEN];
  uid_t oldid = geteuid();
															
  clear_config_struct ();
				  
  seteuid( 0 );
  
  sprintf (work_buff, "/etc/phear.conf");

  if ((configfile = fopen (work_buff, "r")) == NULL)
    {
      syslog (LOG_INFO, "[P] Cant find missing '/etc/phear.conf', using defaults");
		seteuid(oldid );
      return;
    }

  while (1)
    {
      if (fgets (work_buff, sizeof (work_buff), configfile) == NULL)
	{
	  fclose (configfile);
	  seteuid( oldid );
	  return;
	}

      /* Clip out comments */
      for (x = 0; x < strlen (work_buff); x++)
	if (work_buff[x] == '#')
	  work_buff[x] = '\0';

      /* Trim */
      (void) trim (work_buff);

      /* Clear out old values */
      bzero (lvalue, sizeof (lvalue));
      bzero (rvalue, sizeof (rvalue));

      /* The file allows spaces embedded, but clears leading & trailing 
         spaces */

      /* Parse lvalue */
      y = 0;
      for (x = 0; x < strlen (work_buff) && work_buff[x] != ' '; x++)
	if (isprint (work_buff[x]))
	  lvalue[y++] = work_buff[x];

      /* Parse rvalue */
      y = 0;
      x++;
      for (; x < strlen (work_buff); x++)
	if (isprint (work_buff[x]))
	  rvalue[y++] = work_buff[x];

      sysconfig_parseval (lvalue, rvalue);
    }						  
	 
	 seteuid( oldid );

  return;
}
/*-- end of load_sysconfig() ----------------------------------------------*/









