static char * rcsid = "$Id: sigfix.c,v 1.3 1997/01/19 02:53:22 sob Exp $";
#include "../include/config.h.ftpd"
#ifdef NEED_SIGFIX
#include <sys/types.h>
#include <sys/signal.h>
#include <syslog.h>

static sigset_t saved_sigmask;
sigset_t block_sigmask;  /* used in ftpd.c */
static int delaying;
static int init_done;
#endif
/* enable_signaling - deliver delayed signals and disable signal delay */

#ifdef __STDC__
int     enable_signaling(void)
#else
int     enable_signaling()
#endif
{
#ifdef NEED_SIGFIX
    if (delaying != 0) {
        delaying = 0;
        if (sigprocmask(SIG_SETMASK, &saved_sigmask, (sigset_t *) 0) < 0) {
            syslog(LOG_ERR, "sigprocmask: %m");
            return (-1);
        }
    }
#endif
    return (0);
}

/* delay_signaling - save signal mask and block all signals */
#ifdef __STDC__
int     delay_signaling(void)
#else
int     delay_signaling()
#endif
{
#ifdef NEED_SIGFIX
    if (delaying == 0) {
        delaying = 1;
        if (sigprocmask(SIG_BLOCK, &block_sigmask, &saved_sigmask) < 0) {
            syslog(LOG_ERR, "sigprocmask: %m");
            return (-1);
        }
    }
#endif
    return (0);
}


