
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <sys/stat.h>
#include <unistd.h>
#include "../include/sysconfig.h"
#include "../include/userfile.h"

extern void reply (int n, char *fmt,...);
extern void lreply (int n, char *fmt,...);
extern char *trim (char *str);
extern int show_message (int msgcode, char *msgname);
extern void send_msg( int msgcode, char *msgstr, int send_reply );
extern uid_t userid;


/****************************************************************************
  SHOW_REQUESTS
  List the requests file.
****************************************************************************/

int
show_requests (int msgcode)
{
  	char linebuf[BUFSIZ];
  	char sent_by[45];
  	char timebuff[25];
  	time_t sent_when;
  	char fname[MAXPATHLEN];
  	FILE *fp;
    	int shown = 0;
	int curline = 1;
  	uid_t oldid = geteuid();
						  
  	seteuid( 0 );
  
  	sprintf (fname, "%s/requests", cf.datapath);
  	fp = fopen (fname, "r");
  	if ( fp == NULL )
  	{  
  	  	lreply( msgcode, "!H  No requests!0" );
	  	seteuid( oldid );
	  	return 0;
  	}

  	while (1)
   {
   	fgets (linebuf, BUFSIZ, fp);
      if (feof (fp))
			break;
      memcpy (sent_by, linebuf, 24);
      memcpy (timebuff, linebuf + 24, 24);
      sent_by[24] = '\0';
      timebuff[24] = '\0';
      trim (sent_by);
      sent_when = (time_t) strtoul (timebuff, (char **) NULL, 0);
      fgets (linebuf, BUFSIZ, fp);
      trim (linebuf);
      linebuf[strlen (linebuf)] = '\0';
				  	 
      lreply (msgcode, "!e|<!E%-2.2d!e> !H[!F%-9.9s!H] !C%-57.57s !e|!0", curline, sent_by, linebuf);
      curline++;
      shown++;
   }

  	fclose (fp); 
  
  	seteuid( oldid );
  
  	return( shown );
}
/*--- end of show_oneliners() ---------------------------------------------*/

/****************************************************************************
  REQUEST_FILLED
****************************************************************************/

void
request_filled (char *arg)
{
  char work_buff[MAXPATHLEN];
  char *requester;
  char *req;
  char reqfile[MAXPATHLEN];
  char tempfile[MAXPATHLEN];
  char numbuff[25];
  int reqfilled;
  int found = 0;
  FILE *fpin;
  FILE *fpout;
  char line1[BUFSIZ];
  char line2[BUFSIZ];
  char msgbuf[1024];
  mode_t oldmask;
  int gotit =0;
  int x;
  int startnum = 0;
  uid_t oldid = geteuid();

  struct REQUEST
  {	
                char line1[50];
                char line2[80];
  } requests[ 50 ];
  oldmask = umask (0000);
  seteuid( 0 );
  reqfilled=atoi( arg );

  /*
   * (Attempt to) open the temp file
   */
  sprintf (tempfile, "%s/request.%d.temp", cf.datapath, getpid ());
  fpout = fopen (tempfile, "w" );
  if (fpout == NULL)
  {
        syslog (LOG_ERR, "[pheard] %s: writing '%s': %m", uf.name, tempfile);
        reply (200, "!Request not added -- system error -- inform siteop.!0");
        umask (oldmask);
                seteuid( oldid );
        return;
  }

  /*
   * (Attempt to) open the oneliners file
   */
  sprintf (reqfile, "%s/requests", cf.datapath);
  fpin = fopen (reqfile, "r" );
  if (fpin == NULL && errno != ENOENT)
  {
        unlink (tempfile);
        syslog (LOG_ERR, "[pheard] %s: reading '%s': %m", uf.name, reqfile);
        reply (200, "!Request not added -- system error -- inform siteop.!0");
        umask (oldmask);
                seteuid( oldid );
        return;
  }
  umask (oldmask);
   /*
    * Read & write...
    */
        while (found <= 20 && fpin )
        {
                bzero( line1, BUFSIZ );
                bzero( line2, BUFSIZ );

                fgets( line1, BUFSIZ, fpin );
                if ( feof( fpin ) )
                        break;
                fgets( line2, BUFSIZ, fpin );
                if ( feof( fpin ) )
                        break;

                strncpy( requests[ found ].line1, line1, 50 );
                strncpy( requests[ found ].line2, line2, 80 );

          found++;
        }

	reqfilled--;
        for ( x = 0; x < found; x++ )
        {
        	if ( x != reqfilled )
        	{
                	fputs( requests[x].line1, fpout );
                	fputs( requests[x].line2, fpout );
		}
                if ( x == reqfilled )
                {
                	gotit++;
                	requester=strtok(requests[x].line1, " ");
                	req=requests[x].line2;
                	lreply(200, "Request Found. Notifying %s!0", requester);
                	lreply(200, "Thank You For Filling The Request.!0", "");
                }
        }
        reqfilled++;
        if ( gotit == 1 ) {
        sprintf(msgbuf, "%s Your request was filled by %s: ", requester, uf.name );
	send_msg( 200, msgbuf, 2 );
	sprintf(msgbuf, "%s %s", requester, req );
	send_msg( 200, msgbuf, 2 );
	sprintf(msgbuf, "Please download it asap. It will be deleted in 4 days.", "");
	send_msg( 200, msgbuf, 2 );
	}
	else {
	lreply(200, "Invalid Request!!", "");
	}
        fclose (fpin);
        fclose (fpout);
        unlink (reqfile);
        rename (tempfile, reqfile);
        seteuid( oldid );
        }
/*--- end of request_filled() -----------------------------------------------*/

/****************************************************************************
  ADD_ONELINER
****************************************************************************/

void
add_request (char *requestmade)
{
  char work_buff[MAXPATHLEN];
  char reqfile[MAXPATHLEN];
  char tempfile[MAXPATHLEN];
  char numbuff[25];
  int found = 0;
  FILE *fpin;
  FILE *fpout;
  char line1[BUFSIZ];
  char line2[BUFSIZ];
  mode_t oldmask;
  int x;		  
  int startnum = 0;
  uid_t oldid = geteuid();
  
  struct REQUEST
  {
  		char line1[50];
		char line2[80];
  } requests[ 50 ];
  
  oldmask = umask (0000);
  seteuid( 0 );						  
  
  /*
   * (Attempt to) open the temp file
   */
  sprintf (tempfile, "%s/request.%d.temp", cf.datapath, getpid ());
  fpout = fopen (tempfile, "w" );
  if (fpout == NULL)
  {
    	syslog (LOG_ERR, "[pheard] %s: writing '%s': %m", uf.name, tempfile);
    	reply (200, "!Request not ed -- system error -- inform siteop.!0");
    	umask (oldmask);
		seteuid( oldid );
    	return;
  }

  /*
   * (Attempt to) open the oneliners file
   */
  sprintf (reqfile, "%s/requests", cf.datapath);
  fpin = fopen (reqfile, "r" );
  if (fpin == NULL && errno != ENOENT)
  {
   	unlink (tempfile);
    	syslog (LOG_ERR, "[pheard] %s: reading '%s': %m", uf.name, reqfile);
    	reply (200, "!Request not ed -- system error -- inform siteop.!0");
    	umask (oldmask);  
		seteuid( oldid );
    	return;
  }
  umask (oldmask);

   /*
    * Read & write... 
    */
	while (found <= cf.max_requests && fpin )
	{
bzero( line1, BUFSIZ );
bzero( line2, BUFSIZ );
fgets( line1, BUFSIZ, fpin );
if ( feof( fpin ) )
break;
fgets( line2, BUFSIZ, fpin );
if ( feof( fpin ) )
break;
strncpy( requests[ found ].line1, line1, 50 );
strncpy( requests[ found ].line2, line2, 80 );

	  found++;
	}				
							
	if ( found == cf.max_requests )
		startnum = 1;
	if ( startnum < 0 )
		startnum = 0;

	for ( x = startnum; x < found; x++ )
	{
		fputs( requests[x].line1, fpout );
		fputs( requests[x].line2, fpout );
	}

sprintf (numbuff, "%ld", time (NULL));
sprintf (work_buff, "%-24.24s%-24.24s\n", uf.name, numbuff);
fputs (work_buff, fpout);
      
sprintf (work_buff, "%-75.75s\n", requestmade);
fputs(work_buff, fpout);
fclose (fpin);
  	fclose (fpout);

  	unlink (reqfile);
  	rename (tempfile, reqfile);

  	reply (200, "!HYour request has been ed.!0");
  
  	seteuid( oldid );
}
/*--- end of add_oneliner() -----------------------------------------------*/
