#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>
#include <string.h>
#include <unistd.h>
#include <syslog.h>
#ifdef __linux__
#include <linux/unistd.h>
#endif
#include <sys/file.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <stdarg.h>
#include <dirent.h>
#include <signal.h>
#include <fcntl.h>
#include <ctype.h>
#include "../include/userfile.h"
#include "../include/sysconfig.h"

extern void reply( int n, char *fmt, ... );
extern void lreply( int n, char *fmt, ... );
extern void send_msg( int msgcode, char *msgstr, int send_reply );
extern int isuser( char *checkname );
extern size_t commafmt( char *buf, int	bufsize, unsigned long N );
extern int load_userfile( char *username );
extern void update_user( void );
extern char *trim( char *str );
extern int isdeluser( char *checkname );
extern int check_ip( char *testip );
/* extern char *randpass( void );*/

extern uid_t userid; 

/***************************************************************************
   HOWMANYUSERS
	List # of users on site.
***************************************************************************/

int
howmanyusers( void )
{		
  	DIR *dirf;
  	struct dirent *dn;
  	struct stat st;
  	char temppath[MAXPATHLEN + 1];
  	int numusers = 0;
  	uid_t oldid = geteuid();
	int ct;
											 
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] howmanyusers()" );
	debugfn();
#endif
  				 
	seteuid( 0 );

  	sprintf (temppath, "%s/users", cf.datapath);
  	dirf = opendir (temppath);
  	if (!dirf)
   {
   	syslog (LOG_ERR, "[pheard] %s: userlist, error opening user dir: %m",
	      uf.name);
		seteuid( oldid );
      return 0;
   }

  	while (1)
   {
      dn = readdir (dirf);
      if (!dn)
			break;
      sprintf (temppath, "%s/users/%s", cf.datapath, dn->d_name);
      stat (temppath, &st);
      if ( S_ISREG (st.st_mode) && st.st_uid != 99 && st.st_gid != 99 )
		  	numusers++;
	}

  	(void) closedir (dirf);
  
  	seteuid( oldid );
	
  	return (numusers);
}
/*-- end of howmanyusers() ------------------------------------------------*/



/***************************************************************************
   SYSOPLOG
	Writes a line to the sysop log file
***************************************************************************/

void
sysoplog( char *fmt, ... )
{           
   char    linebuf[ MAXPATHLEN ];
	char    pidbuf[ 10 ];
 	va_list argp;  
   FILE    *lf;
   char    temppath[ MAXPATHLEN+1 ];
   time_t  curtime = time( NULL );
  uid_t oldid = geteuid();

#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] sysoplog()" );
	debugfn();
#endif
	
	va_start( argp, fmt );
	vsprintf( linebuf, fmt, argp );
	va_end( argp );
   			 
	seteuid( 0 );
	
   sprintf( temppath, "%s/logs/sysop.log", cf.datapath );
   lf = fopen( temppath, "a" );
   if ( lf != NULL )
   {							
		sprintf( pidbuf, "%d", getpid() );
      fprintf( lf, "%.24s [%-6.6s] %s\n", ctime( &curtime ), pidbuf, linebuf );
      fclose( lf );
   }				 
	
	seteuid( oldid );
}
/*-- end of sysoplog() ---------------------------------------------------*/
			  


/***************************************************************************
   ADDUSER
***************************************************************************/
                
void
adduser( int msgcode, char *args )
{
   char *tokptr;
   char username[ BUFSIZ ];
   char *password;
   char sysbuff[ BUFSIZ ];
   char curruser[ BUFSIZ ];
   mode_t oldmask;
   uid_t oldid = geteuid();
	int pass_was_chosen = 0;
                                   
#ifdef DEBUG
   syslog( LOG_INFO, "[pheard] adduser()" );
   debugfn();
#endif

   /*
    * Get username to add
    */   
   tokptr = strtok( args, " " );    
   strncpy( username, tokptr, sizeof( username ) );
   if ( isuser( username ) )
   {
      reply( msgcode, "!C%s!h: !BUser already exists!!", username );
      return;
   }
   
   /*
    * Get password
    */
   tokptr = strtok( '\0', " " );
   if ( tokptr == NULL )
   {
   	reply( msgcode, "Enter a password!");
	return;
   } else {
	password = tokptr;
   }
	
   seteuid(0);
   sprintf( sysbuff, "%s/ua %s %s", cf.datapath, password, username );
      
   system( sysbuff );
   wait( 0 );
   seteuid( oldid );
   strncpy( curruser, uf.name, sizeof( curruser ) );
   if ( load_userfile( "default.user" ) )
		syslog( LOG_ERR, "[pheard] Calling function was adduser(1)" );
   strncpy( uf.name, username, sizeof( uf.name ) );
   update_user();
   if ( load_userfile( curruser ) )
		syslog( LOG_ERR, "[pheard] Calling function was adduser(2)" );
   
   sprintf( sysbuff, "%s/users/%s", cf.datapath, username );
   oldmask = umask(0000);
   chmod( sysbuff, S_IROTH|S_IWOTH|S_IRGRP|S_IWGRP|S_IRUSR|S_IWUSR );
   umask( oldmask );

   sysoplog( "'%s' added user '%s'.", uf.name, username );
   								
	switch ( pass_was_chosen )
	{
		case 3:
		case 1: reply( msgcode, "User added.  Random password selected: %s", password ); return;
		case 2: reply( msgcode, "User added.  Random password selected: %s (other ignored)", password ); return;
		default: reply( msgcode, "User added." ); return;
	}
}
/*-- end of adduser() ----------------------------------------------------*/
                  


/***************************************************************************
   DELUSER
***************************************************************************/

void
deluser( int msgcode, char *args )
{
   char *tokptr;
   char username[ BUFSIZ ];
   char sysbuff[ BUFSIZ ];
   char curruser[ BUFSIZ ];
   int  mylevel;
   uid_t oldid = geteuid();
   FILE *byefile;
                                  
#ifdef DEBUG
   syslog( LOG_INFO, "[pheard] deluser()" );
   debugfn();
#endif
   
   /*
    * Get username to add
    */   
   tokptr = strtok( args, " " );    
   strncpy( username, tokptr, sizeof( username ) );
   strncpy( curruser, uf.name, sizeof( curruser ) );
   if ( !isuser( username ) )                         /* Does user exist? */
   {
      reply( msgcode, "!C%s!h: !BUser does not exist!!", username );
      return;
   }
                
   mylevel = uf.level;
   if ( load_userfile( username ) )
		syslog( LOG_ERR, "[pheard] Calling function was deluser(1)" );
   if ( uf.level >= mylevel )
   {
      reply( msgcode, "!C%s!h: !BYou may not delete this user!!", username );
      if ( load_userfile( curruser ) )
			syslog( LOG_ERR, "[pheard] Calling function was deluser(2)" );
      return;
   }

   seteuid(0);
   uf.level = 0;
   update_user();
   if ( load_userfile( curruser ) )
		syslog( LOG_ERR, "[pheard] Calling function was deluser(3)" );
   
   sprintf( sysbuff, "%s/users/%s", cf.datapath, username );
   chown( sysbuff, (pid_t)99, (uid_t)99 );
   
                             
   sprintf( sysbuff, "%s/byefiles/%s.bye", cf.datapath, username );
   byefile = fopen( sysbuff, "w" );
   if ( byefile )
   {               
      sprintf( sysbuff, "%%!%s/byefiles/default.bye\n", cf.datapath );
      fputs( sysbuff, byefile );
      fclose( byefile );
   }
   
   seteuid( oldid );
   
   sysoplog( "'%s' deleted user '%s'.", uf.name, username );

   reply( msgcode, "User removed." );      
}
/*-- end of deluser() ----------------------------------------------------*/



/***************************************************************************
   READD
***************************************************************************/

void
readd( int msgcode, char *args )
{		                
   char *tokptr;
   char username[ BUFSIZ ];
	char workbuf[ BUFSIZ ];
   char currentuser[ 40 ];
	uid_t oldid = geteuid();
   										 
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] readd()" );
	debugfn();
#endif
	
	/*
	 * Get username to change
	 */	
	tokptr = strtok( args, " " );	 
	strncpy( username, tokptr, sizeof( username ) );
   if ( !isdeluser( username ) )
   {
      reply( msgcode, "!C%s!h: !BUser unknown.  Use !DSITE USER !Bfor a list.", 
         username );
      return;
   }	  
	
	seteuid( 0 );
   
   strcpy( currentuser, uf.name );
   if ( load_userfile( username ) )
		syslog( LOG_ERR, "[pheard] Calling function was readd(1)" );
	uf.level = 1;
   update_user();
								  
	sprintf( workbuf, "%s/byefiles/%s.bye", cf.datapath, uf.name );
	unlink( workbuf );
	
	sprintf( workbuf, "%s/users/%s", cf.datapath, uf.name );
	chown( workbuf, (uid_t)0, (gid_t)0 );
	
   if ( load_userfile( currentuser ) )
		syslog( LOG_ERR, "[pheard] Calling function was readd(2)" );
	
	seteuid( oldid );
   
   sysoplog( "'%s' readded '%s'.", uf.name, username );
   reply( msgcode, "'!C%s!H' has been readded.", username );
}
/*-- end of readd() ------------------------------------------------------*/


/***************************************************************************
   ADDIP
***************************************************************************/

void
addip( int msgcode, char *args )
{		                
   char *tokptr;
   char username[ BUFSIZ ];
   char ip_to_add[ BUFSIZ ];
   char currentuser[ 40 ];
   int  ct;
   int  done = 0;
	int  ipcheck;
   										 
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] addip()" );
	debugfn();
#endif
	
	/*
	 * Get username to change
	 */	
	tokptr = strtok( args, " " );	 
	strncpy( username, tokptr, sizeof( username ) );
   if ( !isuser( username ) )
   {
      reply( msgcode, "!C%s!h: !BUser unknown.  Use !DSITE USER !Bfor a list.", 
         username );
      return;
   }
   
   /*
    * Get IP
    */
   tokptr = strtok( '\0', " " );
   if ( tokptr == NULL )
   {
      reply( msgcode, "!BYou need to enter an IP to add." );
      return;
   }
	strncpy( ip_to_add, tokptr, sizeof( ip_to_add ) );
	trim( ip_to_add );
		  			 
	ipcheck = check_ip( ip_to_add );

	/* We let level >= 20 users add risky user/host masks, anyone else is
	   denied, but they are ALL logged. */
	switch( ipcheck )
	{
		case 1: /* IP is okay */
				  break;
		
		case 2: /* Need a usermask */
				  sysoplog( "'%s' forgot username: '%s' to '%s'", uf.name, ip_to_add, username );
				  if ( uf.level < 20 )
				  {
	              reply( msgcode, "!BIP must contain a username.  !HType !DSITE ADDIP !Hfor help." );
   	           return;
				  }
				  break;
			
	   case 3: /* Need a hostmask */
				  sysoplog( "'%s' forgot hostname: '%s' to '%s'", uf.name, ip_to_add, username );
				  if ( uf.level < 20 )
				  {
	              reply( msgcode, "!BIP must contain a hostname.  !HType !DSITE ADDIP !Hfor help." );
   	           return;
				  } 
              break;
				  
	   case 4: /* Risky usermask */
				  sysoplog( "'%s' attemped to add risky usermask '%s' to '%s'", uf.name, ip_to_add, username );
				  if ( uf.level < 20 )
				  {
	              reply( msgcode, "!BThat usermask is invalid.  Action logged." );
   	           return;
				  }
				  break;	  
				  
	   case 5: /* Risky hostmask */
				  sysoplog( "'%s' attemped to add risky hostmask '%s' to '%s'", uf.name, ip_to_add, username );
				  if ( uf.level < 20 )
				  {
	              reply( msgcode, "!BThat hostmask is invalid.  Action logged." );
   	           return;
				  }
				  break;	  
	}

   strcpy( currentuser, uf.name );
   if ( load_userfile( username ) )
		syslog( LOG_ERR, "[pheard] Calling function was addip(1)" );
   for ( ct = 0; ct < 10 && !done; ct++ )
   {
      if ( uf.ip[ ct ][ 0 ] == '\0' )
      {
         strncpy( uf.ip[ ct ], ip_to_add, sizeof( uf.ip[ ct ] ) );
         done = 1;
      }
   }

   update_user();
   if ( load_userfile( currentuser ) )
		syslog( LOG_ERR, "[pheard] Calling function was addip(2)" );
   
   if ( !done )
   {
      reply( msgcode, "!BUser already has 10 IP's defined!!  Remove one first!!" );
      return;
   }
          
   sysoplog( "'%s' added ip '%s' to '%s'", uf.name, ip_to_add, username );
   reply( msgcode, "!C%s!h: !HIP added to !C%s!H.", ip_to_add, username );
}
/*-- end of addip() ------------------------------------------------------*/
                                                                



/***************************************************************************
   DELIP
***************************************************************************/

void
delip( int msgcode, char *args )
{		                
   char *tokptr;
   char username[ BUFSIZ ];
   char ip_to_del[ BUFSIZ ];
   int  whichip = 999;
   char currentuser[ 40 ];
   char old_ip[ BUFSIZ ];
   									  
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] delip()" );
	debugfn();
#endif
	
	/*
	 * Get username to change
	 */	
	tokptr = strtok( args, " " );	 
	strncpy( username, tokptr, sizeof( username ) );
   if ( !isuser( username ) )
   {
      reply( msgcode, "!C%s!h: !BUser unknown.  !HUse !DSITE USER !Hfor a list.", 
         username );
      return;
   }
   
   /*
    * Get IP
    */
   tokptr = strtok( '\0', " " );
   if ( tokptr == NULL )
   {
      reply( msgcode, "!BYou need to specify which IP to delete." );
      return;
   }
	strncpy( ip_to_del, tokptr, sizeof( ip_to_del ) );
   trim( ip_to_del );
   if ( !isdigit( ip_to_del[ 0 ] ) || ip_to_del[ 1 ] != '\0' )
   {
      reply( msgcode, "!BIP to delete must be in the range 0-9." );
      return;
   }
   whichip = atoi( ip_to_del );
   
   strcpy( currentuser, uf.name );           /* Save current user name */
   if ( load_userfile( username ) )          /* Load user to alter */
		syslog( LOG_ERR, "[pheard] Calling function was delip(1)" );
	
   strncpy( old_ip, uf.ip[whichip], sizeof( old_ip ) );
   uf.ip[ whichip ][ 0 ] = '\0';             /* Delete IP */
   update_user();                            /* Update user */
   if ( load_userfile( currentuser ) )       /* Reload current user */
		syslog( LOG_ERR, "[pheard] Calling function was delip(2)" );
   
   if ( old_ip[ 0 ] == '\0' )
      reply( msgcode, "'!C%s!H' !Bdoes not have an IP #!C%d!B!!", username, whichip );
   else     
   {
      sysoplog( "'%s' removed ip '%s' from '%s'", uf.name, old_ip, username );
      reply( msgcode, "!C%s!h: !HIP #!C%d !Hremoved from !C%s!H.", old_ip, whichip, username );          
   }
}
/*-- end of delip() ------------------------------------------------------*/




/***************************************************************************
   SUSER_SHOW
***************************************************************************/

void
suser_show( int msgcode, char *args )
{
	char currentuser[ 24 ];
	char queryuser[ 24 ];
	char *tokptr;
	char numbuff[ 30 ];
	char workbuff[ 80 ];
   int  ct;
										  
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] suser_show()" );
	debugfn();
#endif
	
	tokptr = strtok( args, " " );	 
	sprintf( queryuser, "%.23s", tokptr );
   trim( queryuser );

	strncpy( currentuser, uf.name, sizeof( currentuser ) );
	if ( load_userfile( queryuser ) )
		syslog( LOG_ERR, "[pheard] Calling function was suser_show(1)" );

	lreply( msgcode, cf.dividerline );
	lreply( msgcode, "    User statistics for !C%s", queryuser );
	lreply( msgcode, cf.dividerline );
	lreply( msgcode, "             Name: !C%s", uf.name );
	lreply( msgcode,   "      Last online: !C%.24s", ctime( &uf.last_on ) );
  	if ( uf.group_user[0][0] != '\0' )
		lreply (msgcode, "            Group: !C%s", uf.group_user[0] );
  	if ( uf.level >= 10 )
  	{
   	for ( ct = 0; ct < 10 && uf.group_priv[ct][0] != '\0'; ct++ )
	   	lreply (msgcode, "       Priv Group: !C%s", uf.group_priv[ct] );
  	}

	commafmt( numbuff, 30, uf.bytes_up );
	if ( uf.seconds_up != 0 )
		sprintf( workbuff, "%.2f", 
			(float)( ( uf.bytes_up / uf.seconds_up ) / 1024.0) );
	else
		strcpy( workbuff, "---" );
	lreply( msgcode, "         Files up: !C%d !Hin !C%s !Hbytes, avg !C%s !Hk/sec",
		uf.files_up, numbuff, workbuff );

	commafmt( numbuff, 30, uf.bytes_down );
	if ( uf.seconds_down != 0 )
		sprintf( workbuff, "%.2f", 
			(float)( ( uf.bytes_down / uf.seconds_down ) / 1024.0) );
	else
		strcpy( workbuff, "---" );
	lreply( msgcode, "       Files down: !C%d !Hin !C%s !Hbytes, avg !C%s !Hk/sec",
		uf.files_down, numbuff, workbuff );
                    
   /* Information will be displayed to SYSOPs only */
   lreply( msgcode, "" );
   for ( ct = 0; ct < 10; ct++ )
      if ( uf.ip[ ct ][ 0 ] != '\0' )
         lreply( msgcode, "              ip!C%d!H: !C%s", ct, uf.ip[ ct ] );
   
   lreply( msgcode, "" );
	lreply( msgcode, "       Field Name  Value" );
   lreply( msgcode, "-----------------  --------------------------------------------------" );
   if ( uf.ratio == 0 )
      lreply( msgcode, "            ratio  !C0 !H(no ratio)" );
   else
      lreply( msgcode, "            ratio  !C%d !H(!C1:%d!H)", uf.ratio, uf.ratio );
	lreply( msgcode, "          tagline  \"!C%s!H\"", uf.tagline );
   if ( uf.num_logins == 0 )
      lreply( msgcode, "       num_logins  !C0 !H(no limit)" );
   else
	   lreply( msgcode, "       num_logins  !C%d !H(!C%d !Hsimultaneous login%s)", 
         uf.num_logins, uf.num_logins, (uf.num_logins > 1) ? "s" : "" );
	lreply( msgcode, "exempt_from_limit  !C%d !H(!C%s!H)", uf.exempt_from_limit,
      ( uf.exempt_from_limit == 1 ) ? "Yes" : "No" );
   lreply( msgcode, "          credits  !C%lu", uf.credits );

	lreply( msgcode, "" );

	lreply( msgcode, cf.dividerline );
	reply( msgcode, "Command successful." );

	if ( load_userfile( currentuser ) )
		syslog( LOG_ERR, "[pheard] Calling function was suser_show(2)" );
                                
   sysoplog( "'%s' looked at stats for '%s'", uf.name, queryuser );
   
	return;
}
/*-- end of suser_show() --------------------------------------------------*/
                 
#define NUM_FIELDS 7

char *fields[ NUM_FIELDS ] =
   { "ratio",
     "tagline",
     "num_logins",
     "exempt_from_limit",
     "credits",
     "level",
     "color" };
     
char *field_help[ NUM_FIELDS ] =
   { "[0-9] The user's ratio",
     "[Str] The user's tagline",
     "[0-9] Max concurrent connections for user (0=unlimited)",
     "[0,1] 1=User can log in even if site is full, 0 otherwise",
     "[0-x] User's Ratio Credits (use SITE GIVE to ADD)",
     "[0,1] Color for User??" };

/***************************************************************************
   UFCHANGE
***************************************************************************/

void
ufchange(msgcode, args)
	int msgcode;
	char *args;
{
	char *tokptr;
	char currentuser[40];
	int currentlevel;
	char user_name[BUFSIZ];
	char field[BUFSIZ];
	char value[BUFSIZ];
	int ct;
	int okay = 0;

#ifdef DEBUG
	syslog(LOG_INFO, "[pheard] ufchange()");
	debugfn();
#endif

	/* Get/check user_name */
	tokptr = strtok(args, " ");
	strncpy(user_name, tokptr, sizeof(user_name));

	/* check for SITE SYSOP HELP */
	if (strncasecmp(user_name, "HELP", 4) == 0) {
		lreply(msgcode, "Valid fields & descriptions:");
		lreply(msgcode, "");
		for (ct = 0; ct < NUM_FIELDS; ct++)
			lreply(msgcode, "%-17.17s %s", fields[ct], field_help[ct]);
		lreply(msgcode, "");

		reply(msgcode, "Command successful.", field);
		return;
	}

    /* check if user exists, may not need to continue */
	if (!isuser(user_name)) {
		reply(msgcode, "'!C%s!H': !BUnknown user.", user_name);
		return;
	}

	/* Get <field> value or show user info */
	if ((tokptr = strtok(NULL, " ")) == NULL) {
		/* No <field>, show user information */
		suser_show(msgcode, user_name);
		return;
	}
	strncpy(field, tokptr, sizeof(field));

	/* Get <value> or show field help */
	value[0] = '\0';
	do {
		if (tokptr = strtok(NULL, " ")) {
			strcat(value, tokptr);
			strcat(value, " ");
		}
	} while (tokptr);
	trim(value);

	if (value[0] == '\0') {
		/* No <value>, show help on field */
		for (ct = 0; ct < NUM_FIELDS; ct++) {
			if (strcmp(field, fields[ct]) == 0) {
				reply(msgcode, "!C%s  !H%s", fields[ct], field_help[ct]);
				return;
			}
		}
		lreply(msgcode, "Valid fields:");
		lreply(msgcode, "");
		for (ct = 0; ct < NUM_FIELDS; ct++)
			lreply(msgcode, "!C%-17.17s !H%s", fields[ct], field_help[ct]);
		reply(msgcode, "");
		return;
	}

	/* check for valid field */
	for (ct = 0; ct < NUM_FIELDS; ct++) {
		if (strcmp(field, fields[ct]) == 0) { okay = 1; }
	}

	/* field not valid */
	if (okay == 0) {
		lreply(msgcode, "Valid fields:");
		lreply(msgcode, "");
		for (ct = 0; ct < NUM_FIELDS; ct++)
			lreply(msgcode, "!C%-17.17s !H%s", fields[ct], field_help[ct]);
		lreply(msgcode, "");
		reply(msgcode, "!C%s!h: !BField unknown.", field);
		return;
	}

	/* save old values and load in values for the user we're modding */
	strncpy(currentuser, uf.name, sizeof(currentuser));
	currentlevel = uf.level;
	update_user();
	if ( load_userfile(user_name) )
		syslog( LOG_ERR, "[pheard] Calling function was ufchange(1)" );

	/* Do the appropriate thing for each field */
	if (strcmp(field, "color") == 0) {
		int itmp = atoi(value);
		if ( (itmp < 0) || (itmp > 1) ) {
                	reply(msgcode, "!C%d!h: !BInvalid Value. (0/1).", itmp);
                	if ( load_userfile(currentuser) )
                		syslog( LOG_ERR, "[pheard] Calling function was ufchange(5)" );
                	return;
                }
                uf.use_color = itmp;
        }
	if (strcmp(field, "level") == 0) {
		int itmp = atoi(value);
		if ( currentlevel < itmp ) {
			reply(msgcode, "!BYou can't set a level higher than you are.");
			if ( load_userfile(currentuser) )
				syslog( LOG_ERR, "[pheard] Calling function was ufchange(2)" );
			return;
		}
		if ( (itmp < 1) || (itmp > 25) ) {
			reply(msgcode, "!C%d!h: !BInvalid Level.", itmp);
			if ( load_userfile(currentuser) )
				syslog( LOG_ERR, "[pheard] Calling function was ufchange(5)" );
			return;
		}
		sysoplog("'%s' changed level for '%s' from '%d' to '%d'", currentuser, user_name, uf.level, itmp );
		uf.level = itmp;
	}
	if (strcmp(field, "ratio") == 0) {
		int itmp = atoi(value);

		if (currentlevel < 15) {
			reply(msgcode, "!BYour access is not high enough to set ratios.");
			if ( load_userfile(currentuser) )
				syslog( LOG_ERR, "[pheard] Calling function was ufchange(2)" );
			return;
		}

		if ((itmp < 0) || (itmp > 20)) {
			reply(msgcode, "!C%d!h: !BOut of range for value.", itmp);
			if ( load_userfile(currentuser) )
				syslog( LOG_ERR, "[pheard] Calling function was ufchange(5)" );
			return;
		}

		sysoplog("'%s' changed ratio for '%s' from '%d' to '%d'",
			currentuser, user_name, uf.ratio, itmp);
		uf.ratio = itmp;
	}

	else if (strcmp(field, "tagline") == 0) {
		sysoplog("'%s' changed tagline for '%s' from '%s' to '%s'",
			currentuser, user_name, uf.tagline, value);
		strncpy(uf.tagline, value, sizeof(uf.tagline));
	}                    

	else if (strcmp(field, "num_logins") == 0) {
		int itmp = atoi(value);
		if ((itmp < 0) || (itmp > 10)) {
			reply(msgcode, "!C%d!h: !BOut of range for value.", itmp);
			if ( load_userfile(currentuser) )
				syslog( LOG_ERR, "[pheard] Calling function was ufchange(6)" );
			return;
		}
		sysoplog("'%s' changed num_logins for '%s' from '%d' to '%d'",
			currentuser, user_name, uf.num_logins, itmp);
		uf.num_logins = itmp;
	}

	else if (strcmp(field, "exempt_from_limit") == 0) {
		int itmp = atoi(value);
		if ((itmp != 0) && (itmp != 1)) {
			reply(msgcode, "!C%d!h: !C0!B (no) or !C1!B (yes) only.", itmp);
			if ( load_userfile(currentuser) )
				syslog( LOG_ERR, "[pheard] Calling function was ufchange(7)" );
			return;
		}
		sysoplog("'%s' changed exempt_from_limit for '%s' from '%d' to '%d'",
			currentuser, user_name, uf.exempt_from_limit, itmp);
		uf.exempt_from_limit = itmp;
	}

	else if (strcmp(field, "credits") == 0) {
		ulong ultmp = strtoul(value, NULL, 0);

		if (errno == ERANGE) {
			lreply(msgcode, "!C%lu!h: !BOut of range, value clamped.", ultmp);
		}
		sysoplog("'%s' changed credits for '%s' from '%lu' to '%lu'",
			currentuser, user_name, uf.credits, ultmp);
		uf.credits = ultmp;
	}

	/* save the updates and then reload our info */
	update_user();
	if ( load_userfile(currentuser) )
		syslog( LOG_ERR, "[pheard] Calling function was ufchange(9)" );

	reply(msgcode, "!C%s!h: !Hvalue of \"!C%s!H\" changed to \"!C%s!H\".",
		user_name, field, value);
}
/*-- end of ufchange() -------------------------------------------------------*/


/***************************************************************************
	CHECK_PARAMS
   Here is where you can add additional parameters, etc.
***************************************************************************/

int
check_params( int msgcode )
{  
   int    retval = 0;
   time_t timenow = time( NULL );
	int    ips;
										  
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] check_params()" );
	debugfn();
#endif

	if ( uf.level == 0 )
		return 0;
	
   timenow -= (time_t)( (time_t)86400L * (time_t)30L );
   if ( uf.last_on < timenow )
   {
      if ( uf.last_on == 0L )
         lreply( msgcode, "%-12.12s: Never logged on.", uf.name );
      else       
         lreply( msgcode, "%-12.12s: KILL: OVER 30 DAYS SINCE LAST LOGON.", uf.name );
      retval++;       
   }
	
	if ( uf.files_down > ( uf.files_up * 2 ) )
	{
      lreply( msgcode, "%-12.12s: Poor ratio: Dn: %dk, Up: %dk", uf.name, uf.bytes_down, uf.bytes_up );
      retval++;
	}

   if ( uf.files_up == 0 && uf.files_down != 0 )
   {
      lreply( msgcode, "%-12.12s: KILL: USER HAS NEVER UPLOADED.", uf.name );
      retval++;
   }

   if ( uf.files_up == 0 && uf.files_down == 0 )
   {
      lreply( msgcode, "%-12.12s: Blah, user has never done any xfers.", uf.name );
      retval++;
   }

   if ( uf.ratio > 3 )
   {
      lreply( msgcode, "%-12.12s: High ratio (1:%d)", uf.name, uf.ratio );
      retval++;       
   }  
	
#ifdef CRC
   if ( memcmp( uf.restrict, "/ftpserv", 8 ) != 0 )
#else
   if ( memcmp( uf.restrict, "/disk2/bbx", 10 ) != 0 )
#endif	
   {
      lreply( msgcode, "%-12.12s: *** USER HAS DANGEROUS RESTRICT PATH ***", uf.name );
      retval++;
   }

   if ( uf.num_logins > 1 && uf.level < 5 )
   {
      lreply( msgcode, "%-12.12s: User is allowed multiple logins with level < 5.", uf.name );
      retval++;       
   }                                       

   if ( uf.exempt_from_limit != 0 && uf.level < 10 )
   {
      lreply( msgcode, "%-12.12s: Non-Sysop user exempt from limit!", uf.name );
      retval++;       
   }

   if ( uf.ratio != 0 && uf.level >= 5 )
   {
      lreply( msgcode, "%-12.12s: Level %d user has a ratio (1:%d)", uf.name, uf.level, uf.ratio );
      retval++;       
   }              
   
   if ( uf.level > 9 )
   {
      lreply( msgcode, "%-12.12s: user has SYSOP access (level %d)", uf.name, uf.level );
      retval++;
   }

   if ( uf.level == 0 )
   {
      lreply( msgcode, "%-12.12s: user has been DELETED (%d Kb DL, %d Kb UL)", uf.name, uf.bytes_down, uf.bytes_up );
      retval++;
   }
	
	for ( ips = 0; ips < 10 && uf.ip[ips][0] != '\0'; ips++ )
		;
		
	if ( ips > 5 )
   {
      lreply( msgcode, "%-12.12s: user has %d IPs.", uf.name, ips );
      retval++;
   }
	
	for ( ips = 0; ips < 10 && uf.ip[ips][0] != '\0'; ips++ )
		if ( !memcmp( uf.ip[ips], "ip *", 4 ) )
	   {
   	   lreply( msgcode, "%-12.12s: EXTREMELY DANGEROUS IP: %s", uf.name, uf.ip[ips] );
      	retval++;
	   }
	
   return retval;
}
/*-- end of check_params() ------------------------------------------------*/
                           



/***************************************************************************
	CHECK_USERS
***************************************************************************/

void
check_users( int msgcode )
{
	DIR    *dirf;
	struct dirent *dn;
	struct stat st;
	char   temppath[ MAXPATHLEN + 1 ];
   char   currentuser[ 40 ];
   int    warnings = 0;
  uid_t oldid = geteuid();
   												
#ifdef DEBUG
	syslog( LOG_INFO, "[pheard] check_users()" );
	debugfn();
#endif
	
   strncpy( currentuser, uf.name, sizeof( currentuser ) );
	
	seteuid( 0 );
		                
   sprintf( temppath, "%s/users", cf.datapath );
	dirf = opendir( temppath );
	if ( !dirf )
	{
		lreply( msgcode, "Error reading dir: %s", strerror( errno ) );
		seteuid( oldid );
		return;
	}

	while ( 1 )					
	{
		dn = readdir( dirf );
		if ( !dn )
			break;		  
			
		sprintf( temppath, "%s/users/%s", cf.datapath, dn->d_name );

		stat( temppath, &st );
		
		if ( S_ISREG( st.st_mode ) ) 
		{     
   		if ( load_userfile( dn->d_name ) )
				syslog( LOG_ERR, "[pheard] Calling function was check_users(1)" );
         warnings += (int)(check_params( msgcode ));
		}
	}

  	(void)closedir( dirf );	
	if ( load_userfile( currentuser ) )
		syslog( LOG_ERR, "[pheard] Calling function was check_users(2)" );

   sysoplog( "'%s' looked at SITE SCHK (%d warnings)", 
      currentuser, warnings );
		
	seteuid( oldid );
	 
	lreply( msgcode, "" );
	lreply( msgcode, "!C%d !Hwarnings scanned." , warnings);
	lreply( msgcode, "" );
	reply( msgcode, "Command successful." );
	
   return;
}
/*-- end of check_users() -------------------------------------------------*/
