#include "../include/userfile.h"
#include "../include/sysconfig.h"
#include <stdio.h>
#include <dirent.h>
#include <pwd.h>
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <string.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <syslog.h>
#include <unistd.h>

extern void reply (int n, char *fmt,...);
extern void lreply (int n, char *fmt,...);
extern char *trim (char *str);
extern time_t weekstart (void);
extern int load_userfile (char *username);
extern void update_user (void);
extern size_t commafmt (char *buf, int bufsize, unsigned long N);
extern char *strrev (char *str);
extern void send_msg (int msgcode, char *msgstr, int send_reply);
extern int show_file( int msgcode, char *showname );
extern void show_text( int msgcode, const char *helpname );


/***************************************************************************
  LIST_NUKES
  Lists the most recently nuked files.
***************************************************************************/
										 
void
list_nukes( void )
{
	int ctr;
	struct tm *ptr;
	time_t timenow = time( NULL );
	char nukefile[ MAXPATHLEN+1 ];
	char tempname[ MAXPATHLEN+1 ];
   char outbuf1[ BUFSIZ ];
   char outbuf2[ BUFSIZ ];
	
	timenow -= (time_t)86400;
	ptr = localtime( &timenow );
	strftime( tempname, 64, "/dupes/%m-%d-%Y.nuked", ptr );
   sprintf( nukefile, "%s%s", cf.datapath, tempname );
   										
	show_text( 200, "nukes.yesterday" );
	if ( !show_file( 200, nukefile ) )
	{
		lreply( 200, "!H(!CNothing was nuked yesterday!!!H)" );
	}

	timenow += (time_t)86400;
	ptr = localtime( &timenow );
	strftime( tempname, 64, "/dupes/%m-%d-%Y.nuked", ptr );
   sprintf( nukefile, "%s%s", cf.datapath, tempname );
	
	show_text( 200, "nukes.today" );
	if ( !show_file( 200, nukefile ) )
	{
		lreply( 200, "!H(!CNothing has been nuked yet today!!!H)" );
	}       

	show_text( 200, "nukes.bottom" );
	
	lreply( 200, "" );
	reply( 200, "!HCommand successful." );
}
/*-- end of list_nukes() -------------------------------------------------*/
 

/***************************************************************************
  NUKE
  Nuke command...
  USAGE: SITE NUKE <directory> <#times> <message>
  Talk about your CODE...sheesh!
***************************************************************************/

void
nuke (int msgcode, char *args)
{
  	int multiplier = 1;
  	int fdes = -1;
  	struct tm *ptr;
  	time_t timenow = time (NULL);
  	char *tokptr;
  	ulong nukebytes = (ulong) 0L;
  	int nuked = 0;
  	char nukedir[MAXPATHLEN + 1];
  	char currentuser[24];
  	char message[BUFSIZ] = "\0";
  	DIR *dirf;
  	mode_t oldmask;
  	register struct passwd *p;
  	struct dirent *dn;
  	struct stat st;
  	char filebuf[MAXPATHLEN + 1];
  	time_t avg_sec;
  	char workbuf[BUFSIZ];
  	char workbuf2[BUFSIZ];
  	char msgbuf[1024];
  	char bytesbuf[25];
  	int bytes;
  	int ct;
  	int ct2;
  	char names[10][36];
  	ulong nukedbyt[10];
  	int numnames = 0;
  	uid_t oldid = geteuid();
  	int nuke_credits;

#ifdef DEBUG
  	syslog( LOG_INFO, "[pheard] nuke()" );
  	debugfn();
#endif
   if ( uf.level < 5 )
   {
      lreply (msgcode, "!HYou do not have access to nuke.");
      
      return;
	}
	/* Initialize names array. */
  	for (ct = 0; ct < 10; ct++)
    	names[ct][0] = '\0';
  									 
  	/*
    * Get dir to nuke & count bytes
    */
  	tokptr = strtok (args, " ");
  	strncpy (nukedir, tokptr, sizeof (nukedir));
  
   /*
    * Get nuke multiplier
    */
  
  	tokptr = strtok( '\0', " " );
  	if ( tokptr )
   {
   	multiplier = atoi( tokptr );
      if ( multiplier > 10 || multiplier < 1 )
		{
	  		if ( multiplier > cf.multiplier_max )
	    		multiplier = cf.multiplier_max;
	  		if ( multiplier < 1 )
	    		multiplier = 1;
	  		lreply( msgcode, "!BMultiplier out of range, !Hvalue clamped to !C%d!H.!9", 
		           cf.multiplier_max, multiplier );
		}
	}
  	else
   {  
   	reply (msgcode, "!HMultiplier value reqired.  Type !DSITE NUKE !Hfor help." );
      return;
   }
  
   /*
    * Get message
    */
  	do
   {
   	tokptr = strtok ('\0', " ");
      if (tokptr)
		{
	  		strcat (message, tokptr);
	  		strcat (message, " ");
		}
   }
  	while (tokptr);  
  	trim (message);
  
  	if (message[0] == '\0')
   {
   	reply (msgcode, "!HPlease include a message describing why you nuked this release!!");
      return;
   }
  
  	if (strlen (message) > 17)
   {
      reply (msgcode, "!HMessage cannot be longer than 12 characters.  Type !DSITE NUKE!H for help.");
      return;
   }
	 
   /*
    * Traverse directory, nuking files and other directories and accumulating
    * number of credits to remove from user...
    */
  
  	seteuid( 0 );
  
  	dirf = opendir (nukedir);
  	if (!dirf)
   {
      syslog (LOG_ERR, "[pheard] %s: nuke, error opening dir %s: %m",
	           uf.name, nukedir);
      reply (msgcode, "!C%s!H: Invalid directory.", nukedir);
      seteuid( oldid );
      return;
   }
  
  	while (1)
   {
   	dn = readdir (dirf);
      if (!dn)
		{
			break;
		}
		
      sprintf (filebuf, "%s/%s", nukedir, dn->d_name);
				 
      stat (filebuf, &st);

      if (S_ISREG (st.st_mode))
		{
	  		nuked++;
	  		nukebytes += (ulong) st.st_size;

	  		if ((p = getpwuid (st.st_uid)) == NULL)
	    	{
	      	/* Could not find user ID? */
	      	syslog (LOG_ERR, "[pheard] Nuking, user unknown: %d", 
		              (int) st.st_uid);
	      	lreply (msgcode, "!C%s!h: !HCould not find user !C%d!H.",
		              dn->d_name, (int) st.st_uid);
	    	}
	  		else
	    	{
				if ( strcmp( p->pw_name, "root" ) )
				{
		      	for (ct2 = 0; ct2 < 10; ct2++)
					{
			  			if (strcmp (names[ct2], p->pw_name) == 0)
		   	 		{
		      			nukedbyt[ct2] += (ulong) st.st_size;
		      			ct2 = 10;
			    		}
			  			else if (names[ct2][0] == '\0')
			    		{
		   	   		nukedbyt[ct2] = (ulong) st.st_size;
		      			strcpy (names[ct2], p->pw_name);
		      			numnames++;
		      			ct2 = 10;
			    		}
					}	

	   	   	/* Got user ID! */
	      		strncpy (currentuser, uf.name, sizeof (currentuser));

		      	if ( load_userfile (p->pw_name) )
					{
						syslog( LOG_ERR, "[pheard] Calling function was nuke(1)" );
						continue;
					}
				
	   	   	nuke_credits = (int)( ( (ulong)st.st_size * (ulong)uf.ratio ) 
					               / (ulong)1024 );
					
		      	if (uf.credits >= (ulong)( nuke_credits * multiplier ) )
					{
			  			uf.credits -= (ulong)( nuke_credits * multiplier );
					}
		      	else
					{	
			  			uf.credits = (ulong) 0L;
					}

		   		if (uf.files_up > 0)
					{
			  			avg_sec = (time_t) (uf.seconds_up / uf.files_up);
		 		 		if ( avg_sec < 0 || avg_sec > 10000 )
		  	  				avg_sec = 0;
		  				
			  			if ( uf.files_up > (1 * multiplier) )
				  			uf.files_up -= 1 * multiplier;
			  			else 
		   	  			uf.files_up = 0;
						
			  			if (uf.bytes_up > (((ulong) st.st_size / 1024U) * multiplier))
			    			uf.bytes_up -= (((ulong) st.st_size / 1024U) * multiplier);
			  			else
		   	 			uf.bytes_up = 0L;
							
		  				if ( uf.seconds_up > avg_sec )
			  			{
			  				if ( avg_sec )
			    				uf.seconds_up -= avg_sec;
		  				}	
		  				else
		    				uf.seconds_up = 0L;
					}

	      		if (st.st_mtime >= weekstart () 
		      		 && ( uf.files_up_wk > 0 && uf.bytes_up_wk > 0 ))
					{
						syslog( LOG_INFO, "[NUKE] reducing weekly stats" );
		  				avg_sec = (time_t) (uf.seconds_up_wk / uf.files_up_wk);
		  				if ( avg_sec < 0 || avg_sec > 10000 )
		  	  				avg_sec = 0;

					  	if ( uf.files_up_wk > (1 * multiplier) )
						  	uf.files_up_wk -= 1 * multiplier;
							  	else 
					     	uf.files_up_wk = 0;
			  			
					  	if (uf.bytes_up_wk > (((ulong) st.st_size / 1024U) * multiplier))
					    	uf.bytes_up_wk -= (((ulong) st.st_size / 1024U) * multiplier);
					  	else
					    	uf.bytes_up_wk = 0L;
						 
					  	if (uf.seconds_up_wk > avg_sec)
					  	{
					  		if ( avg_sec )
		   	 				uf.seconds_up_wk -= avg_sec;
		  				}
		  				else
		    				uf.seconds_up_wk = 0;
					}

					syslog( LOG_INFO, "[NUKE] updating user" );
		      	update_user ();
		      	if ( load_userfile (currentuser) )
						syslog( LOG_ERR, "[pheard] Calling function was nuke(2)" );
			
					syslog( LOG_INFO, "[NUKE] sending message" );
		      	commafmt( bytesbuf, 25, (ulong)(nuke_credits * multiplier));
			sprintf( msgbuf, "Nuke: %s (%s) for a total of %s credits (nuked by %s)", nukedir, message, bytesbuf, currentuser );
	      		send_msg( 200, msgbuf, 2 );

					syslog( LOG_INFO, "[NUKE] replying to nuker" );
		      	commafmt (bytesbuf, 25, st.st_size);
		      	lreply (msgcode, "%s: %s bytes removed from !C%s!H.",
			              dn->d_name, bytesbuf, p->pw_name);
	    		}
			}
			
	  		/* Nuke user */
			syslog( LOG_INFO, "[NUKE] unlink( %s )", filebuf );
	  		if (unlink (filebuf) != 0)
	    	{
	      	syslog (LOG_ERR, "[pheard] %s: Nuking, could not unlink '%s': %m",
		      	     uf.name, filebuf);

	      	lreply (msgcode, "!C%s!H: Error nuking: !C%s",
		      	     filebuf, strerror (errno));
						  
	      	continue;
	    	}
			
		}

      if (S_ISDIR (st.st_mode))
		{
	  		/* Remove stupid tag dirs */
			int x = strlen( filebuf );
			if (!( filebuf[x-1] == '.' && filebuf[x-2] == '.' && filebuf[x-3] == '/' )
             && !( filebuf[x-1] == '.' && filebuf[x-2] == '/' ))
			{
				syslog( LOG_INFO, "[NUKE] rmdir( \"%s\" );", filebuf );
		  		rmdir (filebuf);
			}
		}
	}
   syslog( LOG_INFO, "[NUKE] closing dir" );
  	(void) closedir (dirf);

   /* 
    * Don't remove dir, instead just mkdir a NUKED message
    */

  	if ( cf.create_nukedir != 0 )
   {
   	sprintf (workbuf, "%s/NUKED by %s", nukedir, uf.name);
      if (mkdir (workbuf, (mode_t) 0777) != 0)
		{
	  		syslog (LOG_ERR, "[pheard] %s: mkdir failed on '%s': %m", uf.name, 
		           nukedir);
	  		lreply (msgcode, "!HError creating directory: !C%s", strerror (errno));
		}
   }
  
  	if (nukedir[strlen (nukedir) - 1] == '/')
    	nukedir[strlen (nukedir) - 1] = '\0';
  
  	if ( cf.create_nukedir != 0 )
   {
   	sprintf (workbuf, "[NUKED]%s", nukedir);
      if (rename (nukedir, workbuf) != 0)
	   	syslog (LOG_ERR, "[pheard] %s: rename failed on '%s': %m", uf.name, 
		           workbuf);
   }
 	else
   {
      if ( rmdir( nukedir ) < 0 )
			syslog (LOG_ERR, "[pheard] %s: rmdir failed on '%s': %m", uf.name, 
		           nukedir);
   }
  
   /* 
    * Add line(s) to nukelog
    */
   syslog( LOG_INFO, "[NUKE] adding to nuke log" );
  	/* Build filename to use */
  	ptr = localtime (&timenow);
  	strftime (workbuf2, 64, "%m-%d-%Y.nuked", ptr);
  
  	/* Attempt to open the file */
  	sprintf (workbuf, "%s/dupes/%s", cf.datapath, workbuf2);
  	oldmask = umask (0000);
  	fdes = open (workbuf, O_CREAT | O_WRONLY | O_APPEND, 0666);
  	umask (oldmask);
  	if (fdes < 0)
   {
      syslog (LOG_ERR, "[pheard] %s: opening '%s': %m", uf.name, workbuf);
      goto nukend;
   }

  	ct = 0;
  	/* Attempt to lock the file */
  	while (flock (fdes, LOCK_EX) && ct < 20)
   {
   	ct++;
      syslog (LOG_ERR, "[pheard] %s: flocking '%s': %m", uf.name, workbuf);
      sleep (1);
   }

  	/* 20 seconds without lock, give up! */
  	if (ct == 10)
   {
      syslog (LOG_ERR, "[pheard] %s: flock failed: '%s'", uf.name, workbuf);
      goto nukend;
   }

  	for (ct = 0; ct < 10; ct++)
   {
   	if (names[ct][0] != '\0')
		{
/*	  		(void) strrev (bytesbuf);
	  		while (strlen (bytesbuf) < 12)
	    		strcat (bytesbuf, " ");
	  		(void) strrev (bytesbuf); */
	  		trim( message );
	  		bytes = nukedbyt[ct];
/* 	  commafmt( bytesbuf, 25, (ulong)(nuke_credits * multiplier));		*/
/*	  		bytes = atoi( bytesbuf ); */
#ifdef VDR
			sprintf (workbuf, "!h!5%-8.8s %-8.8s %-27.27s %1dx%9.0f %-17.17s!0\n", uf.name, names[ct], nukedir, multiplier, (double)( bytes / 1024 ), message);
#else
			sprintf (workbuf, "%-9.9s %-9.9s %-27.27s %1dx%9.0f %-17.17s\n", uf.name, names[ct], nukedir, multiplier, (double)( bytes / 1024 ), message);
#endif	
	  		write (fdes, workbuf, strlen (workbuf));
		}
	}
  
   flock (fdes, LOCK_UN);
   close (fdes);
  
  
nukend:
   uf.last_nuked = time (NULL);
   update_user ();

   /* 
    * Report back to user
    */
   commafmt (bytesbuf, 25, nukebytes);

   syslog (LOG_INFO, "[pheard] %s nuked %s (%d files, %d users)", 
	        uf.name, nukedir, nuked, numnames);
  
   reply(msgcode, "!HDirectory nuked, !C%d !Hfiles (!C%s !Hbytes) removed from !C%d !Husers.",
	      nuked, bytesbuf, numnames);
  
   seteuid( oldid );
}
/*-- end of nuke() -------------------------------------------------------*/

