static char rcsid[] = "@(#)$Id: extensions.c,v 1.18 1997/03/03 09:39:42 sob Exp sob $";
#include "../include/config.h.ftpd"
#include <stdio.h>
#include <errno.h>
#include <string.h>
#ifdef SYSSYSLOG
#include <sys/syslog.h>
#else
#include <syslog.h>
#endif
#include <time.h>
#include <pwd.h>
#include <grp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/param.h>
#if defined(HAVE_STATVFS)
#include <sys/statvfs.h>
#elif defined(HAVE_SYS_VFS)
#include <sys/vfs.h>
#endif

#include <arpa/ftp.h>

#include "../include/pathnames.h"
#include "../include/extensions.h"

#if defined(HAVE_FTW)
#include <ftw.h>
#else
#include "support/ftw.h"
#endif

#ifdef HAVE_REGEX_H
#include <regex.h>
#endif

#if defined(REGEX) && defined(SVR4) && !(defined(__hpux))
#include <libgen.h>
#endif
int
#ifdef __STDC__
type_match(char *typelist)
#else
type_match(typelist)
char *typelist;
#endif
{
return (0);
}
int
#ifdef __STDC__ 
path_compare(char *p1, char *p2)
#else
path_compare(p1,p2)
char *p1;
char *p2;
#endif
{
if ( (*p1 == '*' && *(p1 + 1) == '\0') ||
fnmatch(p1, p2, FNM_PATHNAME) == 0 ) /* 0 means they matched */
return(strlen(p1));
else
return(-2);
}
void
#ifdef __STDC__
expand_id(void)
#else
expand_id()
#endif
{
struct aclmember *entry = NULL;
struct passwd *pwent;
struct group *grent;
char buf[BUFSIZ];
while (getaclentry("upload", &entry) && ARG0 && ARG1 && ARG2 != NULL) {
if (ARG3 && ARG4) {
pwent = getpwnam(ARG3);
grent = getgrnam(ARG4);
if (pwent)  sprintf(buf, "%d", pwent->pw_uid);
else        sprintf(buf, "%d", 0);
ARG3 = (char *) malloc(strlen(buf) + 1);
strcpy(ARG3, buf);
if (grent)  sprintf(buf, "%d", grent->gr_gid);
else        sprintf(buf, "%d", 0);
ARG4 = (char *) malloc(strlen(buf) + 1);
strcpy(ARG4, buf);
endgrent();
} 
}     
}         
extern int fnmatch(),
  type,
  transflag,
  authenticated,
  autospout_free,
  data,
  anonymous,
  guest;
#ifdef __STDC__
extern char **ftpglob(register char *v),
#else
extern char **ftpglob(),
#endif
 *globerr,
  remotehost[],
  hostname[],
  authuser[],
 *autospout,
  Shutdown[];

char shuttime[30],
  denytime[30],
  disctime[30];

#ifdef __STDC__
extern char *realpath(const char *pathname, char *result);
#else
extern char *realpath();
#endif

#ifndef REGEX
char *re_comp();
#elif defined(M_UNIX)
extern char *regcmp(), *regex();
#endif

#ifdef __STDC__
extern FILE *dataconn(char *name, off_t size, char *mode);
#else
extern FILE *dataconn();
#endif
FILE *dout;

time_t newer_time;

int show_fullinfo;
int
#ifdef __STDC__
fn_check(char *name)
#else
fn_check(name)
char *name;
#endif
{
  /* check to see if this is a valid file name... path-filter <type>
   * <message_file> <allowed_charset> <disallowed> */

  struct aclmember *entry = NULL;
  int   j;
  char *sp;
  char *path;
#ifdef M_UNIX
# ifdef REGEX
  char *regp;
# endif
#endif

#ifdef REGEXEC
  regex_t regexbuf;
  regmatch_t regmatchbuf;
#endif

  while (getaclentry("path-filter", &entry) && ARG0 != NULL) {
      if (type_match(ARG0) && ARG1 && ARG2) {

		  /*
		   * check *only* the basename
		   */

		  if (path = strrchr(name, '/'))  ++path;
		  else	path = name;

          /* is it in the allowed character set? */
#if defined(REGEXEC)
          if (regcomp(&regexbuf, ARG2, REG_EXTENDED) != 0) {
              reply(553, "REGEX error");
#elif defined(REGEX)
          if ((sp = regcmp(ARG2, (char *) 0)) == NULL) {
              reply(553, "REGEX error");
#else
          if ((sp = re_comp(ARG2)) != 0) {
              perror_reply(553, sp);
#endif
              return(0);
          }
#if defined(REGEXEC)
          if (regexec(&regexbuf, path, 1, &regmatchbuf, 0) != 0) {
#elif defined(REGEX)
# ifdef M_UNIX
          regp = regex(sp, path);
          free(sp);
          if (regp == NULL) {
# else
          if ((regex(sp, path)) == NULL) {
# endif
#else
          if ((re_exec(path)) != 1) {
#endif
              pr_mesg(553, ARG1);
              reply(553, "%s: Permission denied. (Filename (accept))", name);
              return(0);
          }
          /* is it in any of the disallowed regexps */

          for (j = 3; j < MAXARGS; ++j) {
              /* ARGj == entry->arg[j] */
              if (entry->arg[j]) {
#if defined(REGEXEC)
                  if (regcomp(&regexbuf, entry->arg[j], REG_EXTENDED) != 0) {
                      reply(553, "REGEX error");
#elif defined(REGEX)
                  if ((sp = regcmp(entry->arg[j], (char *) 0)) == NULL) {
                      reply(553, "REGEX error");
#else
                  if ((sp = re_comp(entry->arg[j])) != 0) {
                      perror_reply(553, sp);
#endif
                      return(0);
                  }
#if defined(REGEXEC)
                  if (regexec(&regexbuf, path, 1, &regmatchbuf, 0) == 0) {
#elif defined(REGEX)
# ifdef M_UNIX
                  regp = regex(sp, path);
                  free(sp);
                  if (regp != NULL) {
# else
                  if ((regex(sp, path)) != NULL) {
# endif
#else
                  if ((re_exec(path)) == 1) {
#endif
                      pr_mesg(553, ARG1);
                      reply(553, "%s: Permission denied. (Filename (deny))", name);
                      return(0);
                  }
              }
          }
      }
  }
  return(1);
}

int
#ifdef __STDC__
dir_check(char *name, uid_t *uid, gid_t *gid, int *valid)
#else
dir_check(name,uid,gid,valid)
char *name;
uid_t *uid;
gid_t *gid;
int *valid;
#endif
{
  struct aclmember *entry = NULL;

  int i,
    match_value = -1;
  char *ap2 = NULL,
       *ap3 = NULL,
       *ap4 = NULL,
       *ap6 = NULL;
  char cwdir[BUFSIZ];
  char path[BUFSIZ];
  char *sp;
  extern struct passwd *pw;

  *valid = 0;
  /* what's our current directory? */

  strcpy(path, name);
  if (sp = strrchr(path, '/'))  *sp = '\0';
  else strcpy(path, ".");

  if ((realpath(path, cwdir)) == NULL) {
    perror_reply(553, "Could not determine cwdir");
    return(-1);
  }
  while (getaclentry("upload", &entry) && ARG0 && ARG1 && ARG2 != NULL) {
      if ( (!strcmp(ARG0, pw->pw_dir)) &&
           ((i = path_compare(ARG1, cwdir)) >= match_value) ) {
          match_value = i;
          ap2 = ARG2;
          if (ARG3)  ap3 = ARG3;
          else       ap3 = NULL;
          if (ARG4)  ap4 = ARG4;
          else       ap4 = NULL;
          if (ARG6)  ap6 = ARG6;
          else       ap6 = NULL;
      }
  }
  if ( ((ap2 && !strcasecmp(ap2, "no")) && (ap3 && strcasecmp(ap3, "dirs"))) || 
       (ap3 && !strcasecmp(ap3, "nodirs")) ||
       (ap6 && !strcasecmp(ap6, "nodirs")) ) {
      reply(530, "%s: Permission denied. (Upload dirs)", name);
      return(0);
  }
  if (ap3)
     *uid = atoi(ap3);    /* the uid  */
  if (ap4) {
     *gid = atoi(ap4);    /* the gid */
     *valid = 1;
   }
  return(1);
}

int
#ifdef __STDC__
upl_check(char *name, uid_t *uid, gid_t *gid, int *f_mode, int *valid)
#else
upl_check(name,uid,gid,f_mode,valid)
char *name;
uid_t *uid;
gid_t *gid;
int *f_mode;
int *valid;
#endif
{
  int  match_value = -1;
  char cwdir[BUFSIZ];
  char path[BUFSIZ];
  char *sp;
  int  i;

  char *ap1 = NULL,
   *ap2 = NULL,
   *ap3 = NULL,
   *ap4 = NULL,
   *ap5 = NULL;

  struct aclmember *entry = NULL;
  extern struct passwd *pw;

  *valid = 0;

      /* what's our current directory? */

      strcpy(path, name);
      if (sp = strrchr(path, '/'))  *sp = '\0';
      else strcpy(path, ".");

      if ((realpath(path, cwdir)) == NULL) {
          perror_reply(553, "Could not determine cwdir");
          return(-1);
      }

      /* we are doing a "best match"... ..so we keep track of what "match
       * value" we have received so far... */

      while (getaclentry("upload", &entry) && ARG0 && ARG1 && ARG2 != NULL) {
          if ( (!strcmp(ARG0, pw->pw_dir)) &&
		       ((i = path_compare(ARG1, cwdir)) >= match_value) ) {
              match_value = i;
              ap1 = ARG1;
              ap2 = ARG2;
              if (ARG3) ap3 = ARG3;
              else      ap3 = NULL;
              if (ARG4) ap4 = ARG4;
              else      ap4 = NULL;
              if (ARG5) ap5 = ARG5;
              else      ap5 = NULL;
          }
	}

      if (ap3 && ( (!strcasecmp("dirs",ap3)) || (!strcasecmp("nodirs", ap3)) ))
        ap3 = NULL;

      /* if we did get matches... ..else don't do any of this stuff */
      if (match_value >= 0) {
          if (!strcasecmp(ap2, "yes")) {
              if (ap3)
                  *uid = atoi(ap3);    /* the uid  */
              if (ap4) {
                  *gid = atoi(ap4);    /* the gid  */
		  *valid = 1;
		}
              if (ap5)
                  sscanf(ap5, "%o", f_mode); /* the mode */
          } else {
              reply(553, "%s: Permission denied. (Upload)", name);
              return(-1);
          }
      } else {
          /*
           * upload defaults to "permitted"
           */
          return(1);
      }

  return(match_value);
}

int
#ifdef __STDC_
del_check(char *name)
#else
del_check(name)
char *name;
#endif
{
  int pdelete = 1;
  struct aclmember *entry = NULL;

  while (getaclentry("delete", &entry) && ARG0 && ARG1 != NULL) {
      if (type_match(ARG1))
          if (*ARG0 == 'n')
              pdelete = 0;
  }
  
/* H* fix: no deletion, period. You put a file here, I get to look at it. */
#ifdef PARANOID
  pdelete = 0;
#endif

  if (!pdelete) {
      reply(553, "%s: Permission denied. (Delete)", name);
      return(0);
  } else {
      return(1);
  }
}

/* The following is from the Debian add-ons. */

#define lbasename(x) (strrchr(x,'/')?1+strrchr(x,'/'):x)

int
#ifdef __STDC__
checknoretrieve (char *name)
#else
checknoretrieve (name)
char *name;
#endif
{
  char cwd[MAXPATHLEN+1], realwd[MAXPATHLEN+1], realname[MAXPATHLEN+1];
  int i;
  struct aclmember *entry = NULL;

  if (name == (char *)NULL || *name == '\0')
    return 0; 

#ifdef HAVE_GETCWD
  (void)getcwd (cwd, MAXPATHLEN);
#else
  (void)getwd (cwd);
#endif

  realpath (cwd, realwd);
  realpath (name, realname);

   while (getaclentry("noretrieve", &entry)) {
        if (ARG0 == (char *)NULL)
            continue;
	for (i = 0; i< MAXARGS && 
	     (entry->arg[i] != (char *)NULL) && (*(entry->arg[i]) !='\0'); i++)
	  if (strcmp (((*(entry->arg[i]) == '/') ? realname : 
			lbasename (realname)), entry->arg[i]) == 0)
	  {
	    reply (550, "%s is marked unretrievable", entry->arg[i]);
	    return 1;
	  }
      }
   return 0;
}





