#include <stdio.h> 
#include <stdlib.h>
#include <errno.h>
#include <syslog.h>
#include <string.h>
#include "../include/userfile.h"
#include "../include/sysconfig.h"

extern char *trim( char *str );
extern void load_userfile( char *username );
extern void update_user( void );
extern void reply( int n, char *fmt, ... );
extern void lreply( int n, char *fmt, ... );
extern int   usecolor;

#define ESC 27





/***************************************************************************
	SETCOLOR
	Toggles color ON/OFF
***************************************************************************/

void
setcolor( int msgcode, char *args )
{
	trim( args );
   
	/* Set colors ON */
	if ( !strncasecmp( args, "ON", 2 ) )
	{			 
		uf.use_color = 1;
		usecolor = 0;
	 	reply( msgcode, "Z-Color Activated." );
	   update_user();
		return;
	}

	/* Set colors OFF */
	if ( !strncasecmp( args, "OFF", 3 ) )
	{			 
		uf.use_color = 0;
		usecolor = 0;
	 	reply( msgcode,"Z-Color De-Activated." );
	   update_user();
		return;
	}
}
/*-- end of setcolor() ----------------------------------------------------*/


 
/****************************************************************************
	COLORFORMAT
	Formats 'inbuf' into 'outbuf', replacing color cookies:
		!a: Black			!A: Dark gray		    !1: Black background
		!b: Red				!B: Bright red        !2: Red background
		!c: Green			!C: Bright green      !3: Green background
		!d: Brown			!D: Yellow			    !4: Yellow background
		!e: Blue				!E: Bright blue       !5: Blue background
		!f: Magenta			!F: Bright magenta    !6: Magenta background
		!g: Cyan				!G: Bright cyan       !7: Cyan background
		!h: Light Gray		!H: White			    !8: White background
		
		!0: All attributes off (use at end of each line!)
****************************************************************************/

void
colorformat( char *outbuf )
{
	int ct;
#ifdef DEBUG
	syslog( LOG_INFO, "-Z- colorformat()" );
	debugfn();
#endif
	
	for ( ct=0; ct < strlen( outbuf ); ct++ )
	{
		if ( outbuf[ct] != '!' )
			printf( "%c", outbuf[ct] );
		else
		{					  
			ct++;
			switch( outbuf[ct] )
			{								
  	 			case '0': /* All attributes off */
  	 				if ( usecolor )
  	 				   printf( "%c[0m", ESC );
  	 				break;
			
  	 			case 'a': /* Black */
  	 				if ( usecolor )
  	 				   printf( "%c[0;30m", ESC );
  	 				break;
  	 				
  	 			case 'b': /* Red */
  	 				if ( usecolor )
  	 				   printf( "%c[0;31m", ESC );
  	 				break;
  	 				
  	 			case 'c': /* Green */
  	 				if ( usecolor )
  	 				   printf( "%c[0;32m", ESC );
  	 				break;
  	 				
  	 			case 'd': /* Brown */
  	 				if ( usecolor )
  	 				   printf( "%c[0;33m", ESC );
  	 				break;
  	 				
  	 			case 'e': /* Blue */
  	 				if ( usecolor )
  	 				   printf( "%c[0;34m", ESC );
  	 				break;
  	 				
  	 			case 'f': /* Magenta */
  	 				if ( usecolor )
  	 				   printf( "%c[0;35m", ESC );
  	 				break;
  	 				
  	 			case 'g': /* Cyan */
  	 				if ( usecolor )
  	 				   printf( "%c[0;36m", ESC );
  	 				break;
  	 				
  	 			case 'h': /* Light Gray */
  	 				if ( usecolor )
  	 				   printf( "%c[0;37m", ESC );
  	 				break;
  	 				
  	 			case 'A': /* Dark gray */
  	 				if ( usecolor )
  	 				   printf( "%c[1;30m", ESC );
  	 				break;
  	 				
  	 			case 'B': /* Light red */
  	 				if ( usecolor )
  	 				   printf( "%c[1;31m", ESC );
  	 				break;
  	 				
  	 			case 'C': /* Light green */
  	 				if ( usecolor )
  	 				   printf( "%c[1;32m", ESC );
  	 				break;
  	 				
  	 			case 'D': /* Yellow */
  	 				if ( usecolor )
  	 				   printf( "%c[1;33m", ESC );
  	 				break;
  	 				
  	 			case 'E': /* Light blue */
  	 				if ( usecolor )
  	 				   printf( "%c[1;34m", ESC );
  	 				break;
  	 				
  	 			case 'F': /* Light magenta */
  	 				if ( usecolor )
  	 				   printf( "%c[1;35m", ESC );
  	 				break;
  	 				
  	 			case 'G': /* Light cyan */
  	 				if ( usecolor )
  	 				   printf( "%c[1;36m", ESC );
  	 				break;
  	 				
  	 			case 'H': /* White */
  	 				if ( usecolor )
  	 				   printf( "%c[1;37m", ESC );
  	 				break;
  	 						
  	 			case '1': /* Black background */
  	 				if ( usecolor )
  	 				   printf( "%c[40m", ESC );
  	 				break;
  	 				
  	 			case '2': /* Red background */
  	 				if ( usecolor )
  	 				   printf( "%c[41m", ESC );
  	 				break;
  	 				
  	 			case '3': /* Green background */
  	 				if ( usecolor )
  	 				   printf( "%c[42m", ESC );
  	 				break;
  	 				
  	 			case '4': /* Brown background */
  	 				if ( usecolor )
  	 				   printf( "%c[43m", ESC );
  	 				break;
  	 				
  	 			case '5': /* Blue background */
  	 				if ( usecolor )
  	 				   printf( "%c[44m", ESC );
  	 				break;
  	 				
  	 			case '6': /* Magenta background */
  	 				if ( usecolor )
  	 				   printf( "%c[45m", ESC );
  	 				break;
  	 				
  	 			case '7': /* Cyan background */
  	 				if ( usecolor )
  	 				   printf( "%c[46m", ESC );
  	 				break;
  	 				
  	 			case '8': /* White background */
  	 				if ( usecolor )
  	 				   printf( "%c[47m", ESC );
  	 				break;
  	 				
            case '!':	/* %%: Literal '!' */
  	 				printf( "!" );
  	 				break;
  	 				
            default:
  	 				printf( "!%c", outbuf[ct] );
  	 				break;
			}
		}
	}
}
/*-- end of colorformat() -------------------------------------------------*/ 
 
