char *version = "1.0.0";
 
#include <ctype.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <syslog.h>
#include <fcntl.h>

char diztagtext[ 52 ] ="--== fATE97 [Fast Action Trade Exchange] fATE97 ==--";

char *progname; 						/* The name of this program */
int  verbose = 1;						/* Be verbose? */
int  siteop = 0;						/* Siteop mode? */
int  cline = 0;						/* "commandline" mode? */
int  debug = 0;						/* Debug mode? */

char keyword[ 40 ][ 20 ];
int  keywords = 0;
char nfo[ 12 ] = "fate97.nfo";
char zipcomment[ 12 ] = "sitetag.asc";
char inner_dizname[ 13 ];
int total_success = 0;

struct stat orig_st;



/***************************************************************************
   COPY_FILE
***************************************************************************/
									  
int 
copy_file(char *from, char *to)
{
	int fdfrom,fdto;
	int bufsiz;

	fdfrom = open(from,O_RDONLY,0);
	if (fdfrom < 0)
   	return 1;

	/* Open R/W by owner, R by everyone else        */

	fdto=open(to,O_CREAT|O_TRUNC|O_RDWR,S_IREAD|S_IWRITE);
	if (fdto < 0)
      goto err;

	/* Use the largest buffer we can get    */

	for (bufsiz = 0x4000; bufsiz >= 128; bufsiz >>= 1)
	{
      register char *buffer;

      buffer = (char *) malloc(bufsiz);
      if (buffer)
      {
      	while (1)
         {
         	register int n;

            n = read(fdfrom,buffer,bufsiz);
            if (n == -1)                /* if error             */
            	break;
            if (n == 0)                 /* if end of file       */
            {
            	free(buffer);
               close(fdto);
               close(fdfrom);
               return 0;             /* success              */
            }
            if (n != write(fdto,buffer,(unsigned) n))
               break;
         }
         free(buffer);
         break;
      }
	}
	close(fdto);
	remove(to);                               /* delete any partial file  */
err: close(fdfrom);
	return 1;
}
/*-- end of copy_file() --------------------------------------------------*/



/***************************************************************************
	TRIM
***************************************************************************/

char *
trim( char *str )
{
	char *ibuf;
	char *obuf;

   if ( str )
   {
   	for ( ibuf = obuf = str; *ibuf; )
      {
        	while ( *ibuf && ( isspace ( *ibuf ) ) )
         	ibuf++;
        	if ( *ibuf && ( obuf != str ) )
            *( obuf++ ) = ' ';
        	while ( *ibuf && ( !isspace ( *ibuf ) ) )
            *( obuf++ ) = *( ibuf++ );
      }
      *obuf = '\0';
   }
   return( str );
}
/*-- end of trim() -------------------------------------------------------*/

			 

/***************************************************************************
	STRUPR
	Converts a string to uppercase
***************************************************************************/

char *
strupr( char *string )
{
	char *s;
		
	if ( string )
	{
		for ( s = string; *s; ++s )
	      *s = toupper( *s );
   }
	
   return string;
}
/*-- end of strupr() ------------------------------------------------------*/


/****************************************************************************
	READ_DATAFILE
	Data file is at CONFIGDIR/pheartag.conf
****************************************************************************/
										  
int
read_datafile( void )
{														 
	char linebuf[ BUFSIZ ];				/* I/O buffer */
	char cfgfile[ MAXPATHLEN+1 ];		/* The config filename */
	char *comment;							/* To axe comments */
	char *spcptr;							/* To parse lvalue */
	FILE *fp;								/* The file pointer */
	char lvalue[ BUFSIZ ];				/* Left value */
	char *rvalue;							/* Right value */
										 
	if ( debug )
		fprintf( stdout, "BEGIN read_datafile()\n" );
	
	sprintf( cfgfile, "%s/pheartag.conf", CONFIGDIR );

	if ( ( fp = fopen( cfgfile, "r" ) ) == NULL )
	{
		if ( verbose )
			printf( "error!\n%s: Error opening '%s': %s\n", progname, cfgfile, 
				strerror( errno ) );
		if ( siteop )
			syslog( LOG_ERR, "error opening '%s': %m", cfgfile );
		if ( debug )
			fprintf( stdout, "LEAVING[1] read_datafile()\n" );
		return 1;
	}
	
	while ( fgets( linebuf, BUFSIZ, fp ) != (char *)NULL )
	{
		if ( ( comment = strchr( linebuf, '#' ) ) != NULL )
			*comment = '\0';
			
		rvalue = strchr( linebuf, ' ' );
		if ( rvalue != (char *)NULL )
		{
			rvalue++;
			
			trim( linebuf );
			
			strncpy( lvalue, linebuf, sizeof( lvalue ) );
			
			if ( strncasecmp( lvalue, "keyword", 7 ) == 0 )		
			{
				/* no spaces in keyword... */
				if ( ( spcptr = strchr( rvalue, ' ' ) ) != NULL )
					*spcptr = '\0';
				strupr( rvalue );
				if ( keywords < 40 )
					strncpy( keyword[ keywords++ ], rvalue, 20 );
				else if ( verbose )
					printf( "WARNING: Too many keywords in %s: '%s' ignored!\n",
						cfgfile, rvalue );
			}
				
			if ( strncasecmp( lvalue, "tagline", 7 ) == 0 )
				strncpy( diztagtext, rvalue, sizeof( diztagtext ) );
			if ( strncasecmp( lvalue, "nfo", 3) == 0 )
				strncpy( nfo, rvalue, sizeof( nfo ) );
			if ( strncasecmp( lvalue, "comment", 7) == 0 )
				strncpy( zipcomment, rvalue, sizeof( rvalue ) );
		}
	}			
		
	if ( debug )
		fprintf( stdout, "LEAVING read_datafile()\n" );
	
	return 0;
}
/*-- end of read_datafile() -----------------------------------------------*/
				 

/****************************************************************************
	GET_FILELIST
	Creates the tmp file containing the listing of files in ZIP
****************************************************************************/

int
get_filelist( char *filename, char *tmpfile )
{
	char sysbuf[ MAXPATHLEN ];  
	struct stat st;				 
	
	if ( debug )
		fprintf( stdout, "BEGIN get_filelist( %s, %s )\n", filename, tmpfile );

	if ( stat( filename, &st ) != 0 )
	{
		if ( verbose )
			printf( "file not found\n" );
		if ( debug )
			fprintf( stdout, "LEAVING[1] get_filelist( %s, %s )\n", filename, tmpfile );
		if ( siteop )
			syslog( LOG_ERR, "stat '%s': %m", filename );
		return 1;
	}
		
	if ( siteop )
	{
		freopen( tmpfile, "w", stdout );
		execl( UNZIP, UNZIP, "-vqq", filename, NULL );
		freopen( "/dev/null", "w", stdout );
	}
	else
	{
		sprintf( sysbuf, "( %s -vqq %s > %s ) 2> /dev/null", UNZIP, filename, tmpfile );
		if ( cline )
			fprintf( stdout, "%s\n", sysbuf );
		system( sysbuf );
	}
	wait( 0 );
	
	if ( stat( tmpfile, &st ) != 0 )
	{
		if ( verbose )
			printf( "not a zipfile or no files in ZIP\n" );
		if ( debug )
			fprintf( stdout, "LEAVING[2] get_filelist( %s, %s )\n", filename, tmpfile );
		if ( siteop )
			syslog( LOG_ERR, "stat '%s': %m", tmpfile );
		return 1;
	}
	
	if ( debug )
		fprintf( stdout, "LEAVING get_filelist( %s, %s )\n", filename, tmpfile );
	
	return 0;
}
/*-- end of get_filelist() ------------------------------------------------*/
																		 

/****************************************************************************
	GET_DIZFILE					  
	Extracts the DIZ file from the zip
****************************************************************************/
		 								 
void
get_dizfile( char *filename, char *tmpdiz )
{
	char sysbuf[ MAXPATHLEN ];

	if ( debug )
		fprintf( stdout, "BEGIN get_dizfile( %s, %s )\n", filename, tmpdiz );
	
	if ( siteop )
	{
		freopen( tmpdiz, "w", stdout );
		execl( UNZIP, UNZIP, "-Cqqp", filename, "FILE_ID.DIZ", NULL );
		freopen( "/dev/null", "w", stdout );
	}
	else
	{
		sprintf( sysbuf, "%s -Cqqp %s FILE_ID.DIZ > %s 2>&1", UNZIP, filename, tmpdiz );
		if ( cline )
			fprintf( stdout, "%s\n", sysbuf );
		system( sysbuf );
	}
	wait( 0 );
				 
	if ( debug )
		fprintf( stdout, "LEAVING get_dizfile( %s, %s )\n", filename, tmpdiz );
	
	return;
}
/*-- end of get_dizfile() -------------------------------------------------*/
																								 
							  
/****************************************************************************
	GET_DIZNAME
	What is the DIZ called?  File_ID.DiZ maybe?
	Also checks the filelist for the nfos...returns -1 if we should stop
****************************************************************************/
															 
int
get_dizname( char *listfile )
{	 
	char linebuf[ BUFSIZ ];
	FILE *fp;
	int  c;
										  
	if ( debug )
		fprintf( stdout, "BEGIN get_dizname( %s )\n", listfile );

	inner_dizname[ 0 ] = '\0';

	fp = fopen( listfile, "r" );
	if ( fp == NULL )
	{
		if ( verbose )
			printf( "error!\n%s: opening '%s': %s\n", progname, listfile, 
				strerror( errno ) );
		if ( siteop )
			syslog( LOG_ERR, "error opening '%s': %m", listfile );
		if ( debug )
			fprintf( stdout, "LEAVING[1] get_dizname( %s )\n", listfile );
		return( -1 );
	}

	while ( fgets( linebuf, BUFSIZ, fp ) != (char *)NULL )
	{
		for ( c = 0; c < strlen( linebuf ); c++ )
		 	if ( strncasecmp( linebuf+c, "FILE_ID.DIZ", 11 ) == 0 )
				memcpy( inner_dizname, linebuf+c, 11 );

		strupr( linebuf );			
		for ( c = 0; c < keywords; c++ )
		{					  
			if ( strstr( linebuf, keyword[ c ] ) != (char *)NULL )
			{
				if ( verbose )
					printf( "keyword '%s' found in '%s'\n", keyword[ c ], linebuf );
				fclose( fp );
				if ( debug )
					fprintf( stdout, "LEAVING[2] get_dizname( %s )\n", listfile );
				return( -1 );
			}
		}
	}
	inner_dizname[ 11 ] = '\0';

	fclose( fp );

	if ( debug )
		fprintf( stdout, "LEAVING get_dizname( %s )\n", listfile );
		
	return( ( inner_dizname[ 0 ] == '\0' ) ? 0 : 1 );
}
/*-- end of get_dizname() -------------------------------------------------*/
														

/****************************************************************************
	COPY_AND_TAG
****************************************************************************/

int
copy_and_tag( char *filename, char *dizname )
{				  			 
	char linebuf[ BUFSIZ ];
	char compbuf[ BUFSIZ ];
	char sysbuff[ MAXPATHLEN+BUFSIZ ];
	char destpath[ BUFSIZ ];
	char ZIPdestpath[ BUFSIZ ];
	int  c;
	int  spc;
	int  len;								/* Our current length */
	int  maxwidth = 0;					/* The width of the widest line! */
	char *slashptr;
	FILE *fpin;
	FILE *fpout;
	int  dotag = 1;						/* Should we continue with the tag? */
	
	if ( debug )
		fprintf( stdout, "BEGIN copy_and_tag( %s, %s )\n", filename, dizname );
		 
	if ( debug )
		fprintf( stdout, " copy_and_tag() 1\n" );
		
	strcpy( destpath, filename );
	if ( ( slashptr = strrchr( destpath, '/' ) ) != NULL )
		*slashptr = '\0';
	strcat( destpath, "/" );
	if ( !siteop )
		strcat( destpath, inner_dizname );
	else
		strcat( destpath, "FILE_ID.DIZ" );
					  
	strcpy( ZIPdestpath, filename );
	if ( ( slashptr = strrchr( ZIPdestpath, '/' ) ) != NULL )
		*slashptr = '\0';
	strcat( ZIPdestpath, "/" );
	strcat( ZIPdestpath, inner_dizname );
										 
	if ( debug )
		fprintf( stdout, " copy_and_tag() 2\n" );
	
	if ( ( fpin = fopen( dizname, "rb" ) ) == NULL )
	{												  
		if ( verbose )
			printf( "error\n%s: opening '%s': %s", progname, 
				dizname, strerror( errno ) );
		if ( siteop )
			syslog( LOG_ERR, "error opening '%s': %m", dizname );
										
		if ( debug )
			fprintf( stdout, "LEAVING[1] copy_and_tag( %s, %s )\n", filename, dizname );
			
		return 1;													/* Error - Abort */
	}

	if ( debug )
		fprintf( stdout, " copy_and_tag() 4\n" );

	if ( ( fpout = fopen( destpath, "wb" ) ) == NULL )
	{
		if ( verbose )
			printf( "error\n%s: opening '%s': %s", progname, 
				destpath, strerror( errno ) );
		if ( siteop )
			syslog( LOG_ERR, "error opening '%s': %m", destpath );
		fclose( fpin );					 
		if ( debug )
			fprintf( stdout, "LEAVING[2] copy_and_tag( %s, %s )\n", filename, dizname );
		return 1;													/* Error - Abort */
	}

	while ( fgets( linebuf, BUFSIZ, fpin ) != (char *)NULL )
	{												  
		if ( debug )
			fprintf( stdout, " copy_and_tag() 5\n" );

		len = strlen( linebuf ) - 2;

		if ( len > maxwidth )
			maxwidth = len;

		strcpy( compbuf, linebuf );
		strupr( compbuf );

		for ( c = 0; c < keywords; c++ )
		{
			if ( debug )
				fprintf( stdout, " copy_and_tag() 6\n" );
			if ( strstr( compbuf, keyword[ c ] ) != (char *)NULL )
			{
				if ( verbose && dotag )
					printf( "keyword '%s' found\n", keyword[ c ] );
				dotag = 0;
				/* Oops!  I noticed that if you uncomment the following line 
				   it strips the other groups tag, too bad.... */
				/* return 1; */
			}
		}

		if ( debug )
			fprintf( stdout, " copy_and_tag() 7\n" );
			
		len=strlen(linebuf);
		if ( linebuf[len-2] == '\r' || linebuf[len-2] == '\n' )
			linebuf[len-2] = '\0';
		len=strlen(linebuf);
		if ( linebuf[len-1] == '\r' || linebuf[len-1] == '\n' )
			linebuf[len-1] = '\0';
			
		strcat( linebuf, "\n\r" );
		
		if ( len > 3 )
			fputs( linebuf, fpout );
	}

	if ( debug )
		fprintf( stdout, " copy_and_tag() 8\n" );

	/* 
    * Now concatenate the diz tag, centered about the max width:
	 */
	if ( dotag )
	{														
		if ( debug )
			fprintf( stdout, " copy_and_tag() 9\n" );
		/* Center the tag string */
		if ( debug )
			fprintf( stdout, " maxwidth = %d  strlen( diztagtext ) = %d\n",
						maxwidth, strlen( diztagtext ) );
						
		if ( maxwidth > strlen( diztagtext ) )
			spc = ( maxwidth - strlen( diztagtext ) ) / 2;
		else
			spc = 0;
			
		if ( spc < 0 || spc > 20 )
			spc = 0;
		 	
		if ( debug )
			fprintf( stdout, " spc = %d\n", spc );
			
		fprintf( fpout, "%*s%s\r\n", spc, " ", diztagtext );
	}
													  
	if ( debug )
		fprintf( stdout, " copy_and_tag() 10\n" );
	
	fclose( fpin );												/* Close files */
	fclose( fpout );
		
	if ( dotag == 0 )
	{
		if ( debug )
			fprintf( stdout, "LEAVING[3] copy_and_tag( %s, %s )\n", filename, dizname );
		return 1;
	}
	
	/* Remove the old DIZ from the zip and cram the new one in */
	if ( siteop )
	{
		execl( ZIP, ZIP, "-jqq", filename, ZIPdestpath, NULL );
	}
	else
	{
		sprintf( sysbuff, "%s -jqq %s %s > /dev/null 2>&1", ZIP, filename, ZIPdestpath );
		if ( cline )
			fprintf( stdout, "%s\n", sysbuff );
		system( sysbuff );
	}
	wait( 0 );
										 		 
	if ( debug )
		fprintf( stdout, "LEAVING copy_and_tag( %s, %s )\n", filename, dizname );
	
	return 0;
}
/*-- end of copy_and_tag() ------------------------------------------------*/
					

										
/****************************************************************************
	ADD_FATE_STUFF
****************************************************************************/
					  
void
add_fate_stuff( char *filename )
{
	char sysbuff[ MAXPATHLEN+BUFSIZ ]; 
	char pathbuf[ MAXPATHLEN ];
										 
	if ( debug )
		fprintf( stdout, "BEGIN add_fate_stuff( %s )\n", filename );
	
	if ( siteop )
	{
		sprintf( pathbuf, "%s/sitetag.asc", TEXTDIR );
		freopen( pathbuf, "r", stdin );
		execl( ZIP, ZIP, "-zqq", filename );
	}
	else
	{
		sprintf( sysbuff, "%s -zqq %s < %s/%s > /dev/null 2>&1", ZIP, filename, TEXTDIR, zipcomment );
		if ( cline )
			fprintf( stdout, "%s\n", sysbuff );
		system( sysbuff );
	}
	wait( 0 );
			 								 
	if ( siteop )
	{
		sprintf( pathbuf, "%s/phear97.nfo", TEXTDIR );
		execl( ZIP, ZIP, "-jqq", filename, pathbuf );
	}
	else
	{
		sprintf( sysbuff, "%s -jqq %s %s/%s  > /dev/null 2>&1", ZIP, filename, TEXTDIR, nfo );
		if ( cline )
			fprintf( stdout, "%s\n", sysbuff );
		system( sysbuff );
	}
	wait( 0 );
	
	if ( debug )
		fprintf( stdout, "LEAVING add_fate_stuff( %s )\n", filename );
}
/*-- end of add_fate_stuff() ----------------------------------------------*/
 

/****************************************************************************
	PROCESS_ZIPFILE
****************************************************************************/

void
process_zipfile( char *filename )
{							  
	char workbuff[ MAXPATHLEN ];
	char name_filelist[ MAXPATHLEN ];
	char name_tmpdiz[ MAXPATHLEN ];
	int  is_diz = 0;							/* Is there a file_id.diz? */
												  
	if ( debug )
		fprintf( stdout, "BEGIN process_zipfile( %s )\n", filename );
	
	if ( verbose )
		printf( "%s: ", filename );
		
	/*** Create filenames/file handles for file list and DIZ ***/
	sprintf( workbuff, "%s/rt_filelist_XXXXXX", TEMPDIR );
	strcpy( name_filelist, mktemp( workbuff ) );

	sprintf( workbuff, "%s/rt_tmpdiz_XXXXXX", TEMPDIR );
	strcpy( name_tmpdiz, mktemp( workbuff ) );

	/* Extract a file called <name_filelist> */
	if ( get_filelist( filename, name_filelist ) )
	{			 
		if ( debug )
			fprintf( stdout, "LEAVING[1] process_zipfile( %s )\n", filename );
		
		return;
	}

	if ( ( is_diz = get_dizname( name_filelist ) ) < 0 )
	{
		if ( debug )
			fprintf( stdout, "LEAVING[2] process_zipfile( %s )\n", filename );
	   return;
	}

	if ( is_diz )
	{													  
		if ( verbose )
			printf( "(%s) ", inner_dizname );

		/* Extract a file called <name_tmpdiz> */
		get_dizfile( filename, name_tmpdiz );

		if ( copy_and_tag( filename, name_tmpdiz ) )
		{
			if ( debug )
				fprintf( stdout, "LEAVING[3] process_zipfile( %s )\n", filename );
		   return;
		}
	}
	else if ( verbose )
		printf( "(no diz) " );
		
	add_fate_stuff( filename );
	if ( !siteop )
		printf( "done\n" );
	total_success++;
		
	if ( debug )
		fprintf( stdout, "LEAVING process_zipfile( %s )\n", filename );
	
	return;
}
/*-- end of process_zipfile() ---------------------------------------------*/


  
/****************************************************************************
	USAGE
****************************************************************************/
									
void
usage( void )
{
   printf( "Usage: %s [OPTION]... [Filename]...\n\n", progname );
	printf( "   -q    be quiet (output nothing, even on error)\n" );
	printf( "   -c    commandline output, shows what system commands are\n" );
	printf( "         being done.\n" );
	printf( "   -d    debug mode.\n" );
	printf( "   -s    siteop mode on (no output, errors to syslog)\n" );
	printf( "   -v    verbose mode on (default)\n" );
	printf( "   -?    display this help and exit\n" );
	printf( "   -V    display version information and exit\n" );
	printf( "\n" );
	printf( "Note that in this portable version long args are not allowed\n" );
	printf( "and options must be separate, i.e. use '-q -s' not '-qs'.\n" );
	
	exit( EXIT_FAILURE );
}
/*--- end of usage() ------------------------------------------------------*/


/****************************************************************************
	MAIN
****************************************************************************/
																							 
int
main( int argc, char **argv )
{
	char fullpath[ MAXPATHLEN ];
	int c;
	char ch;
		
/*	if ( ( progname = ( strrchr( argv[ 0 ], '/' ) + 1 ) ) == (char *)NULL )
		progname = *argv;*/
	progname = "pheartag";
	
	if ( argc == 1 )
		usage();
 
	for ( c = 1; c < argc; c++ )
	{		  
		if ( argv[ c ][ 0 ] != '-' )
			continue;
			
		ch = argv[ c ][ 1 ];
			
	   switch( ch )
		{
			case 'v':	 
				verbose = 1;
	  			printf( "%s: verbose mode on\n", progname );
	  			break;
				
			case 'c':	 
				cline = 1;
				verbose = 0;
				siteop = 0;
	  			printf( "%s: commandlines:\n", progname );
	  			break;
				
			case 'q':
				verbose = 0;
				break;
				
			case 'd':
	  			printf( "%s: debug mode on\n", progname );
			   debug = 1;
				break;

			case 's':		
				verbose = 0;
				siteop = 1;
				openlog( progname, LOG_PID, LOG_DAEMON );
				freopen( "/dev/null", "w", stdout );
				freopen( "/dev/null", "w", stderr );
	  			break;

			case 'V':
				printf( "FateTag v1.0\n");
				exit( EXIT_SUCCESS );
				break;

			default:
			case '?':
				usage();
	  			break;
		}
	}

	read_datafile();									
	for ( c = 1; c < argc; c++ )
	{
		if ( argv[ c ][ 0 ] != '-' )
		{
			realpath( argv[ c ], fullpath );
			stat( fullpath, &orig_st );
			process_zipfile( fullpath );
			if ( cline )
				fprintf( stdout, "chown %d.%d %s\n", 
							orig_st.st_uid, orig_st.st_uid, fullpath );
			chown( fullpath, orig_st.st_uid, orig_st.st_gid );
		}
	}

	if ( verbose )
		printf( "%s: %d files tagged\n", progname, total_success );
	
	if ( siteop )
		closelog();
	
	return 0;
}
/*--- end of main() ------------------------------------------------------*/

