#include <sys/param.h>
#include <time.h>
						 
/*
 * userfile structure (uf)
 */

#ifdef USERFILE
struct UF
{
  char   name[ 24 ];         /* Username */

  int    ratio;              /* Ratio multiplier value */
  int    level;              /* User's access level */
  char   restrict[ MAXPATHLEN ];    /* Restrict path */
  char   tagline[ 64 ];      /* The user's tagline */
  int	 num_logins;         /* Number of simultaneous logins allowed */
  int    exempt_from_limit;  /* 1 if exempt from overall site list */
  ulong  credits;            /* # kbytes credit */
  
  int    files_up;           /* Total # files upped */
  ulong  bytes_up;           /* Total # bytes upped */
  time_t seconds_up;         /* Total # seconds spent uploading */
  
  int    files_down;         /* Total # files downed */
  ulong  bytes_down;         /* Total # bytes downed */
  time_t seconds_down;       /* Total # seconds spent downloading */
  
  int    files_up_wk;        /* Total # files upped (week) */
  ulong  bytes_up_wk;        /* Total # bytes upped (week) */
  time_t seconds_up_wk;      /* Total # seconds spent uploading */
  
  int    files_down_wk;      /* Total # files downed (week) */
  ulong  bytes_down_wk;      /* Total # bytes downed (week) */
  time_t seconds_down_wk;    /* Total # seconds spent downloading (week) */

  int    files_up_day;
  ulong  bytes_up_day;
  time_t seconds_up_day;

  int    files_down_day;
  ulong  bytes_down_day;
  time_t seconds_down_day;

  int    files_up_month;
  ulong  bytes_up_month;
  time_t seconds_up_month;

  int    files_down_month;
  ulong  bytes_down_month;
  time_t seconds_down_month;

  int    glock;
 
  int    login_times;        /* # times logged on */  
  time_t last_on;            /* Last date online */
  int    time_limit;         /* Time limit (in minutes) */
  int    time_on_today;      /* Number of minutes spent online today */
  time_t last_nuked;         /* Time the user last nuked */
  int    use_color;          /* 1=Use color 0=No color (default) */	

  char   gadmin[ 15 ];		/* Is this user the administrator for a group */
  char   group_user[ 10 ][ 15 ];  /* Groups this user belongs to */
  char   group_priv[ 10 ][ 15 ];  /* Groups this user belongs to */
  
  char   ip[ 20 ][ 55 ];     /* IPs allowed for this login */
} uf;	       
#else
extern struct UF
{
  char   name[ 24 ];         /* Username */

  int    ratio;              /* Ratio multiplier value */
  int    level;              /* User's access level */
  char   restrict[ MAXPATHLEN ];    /* Restrict path */
  char   tagline[ 64 ];      /* The user's tagline */
  int	 num_logins;         /* Number of simultaneous logins allowed */
  int    exempt_from_limit;  /* 1 if exempt from overall site list */
  ulong  credits;            /* # kbytes credit */

  int    files_up;           /* Total # files upped */
  ulong  bytes_up;           /* Total # bytes upped */
  time_t seconds_up;         /* Total # seconds spent uploading */
  
  int    files_down;         /* Total # files downed */
  ulong  bytes_down;         /* Total # bytes downed */
  time_t seconds_down;       /* Total # seconds spent downloading */
  
  int    files_up_wk;        /* Total # files upped (week) */
  ulong  bytes_up_wk;        /* Total # bytes upped (week) */
  time_t seconds_up_wk;      /* Total # seconds spent uploading */
  
  int    files_down_wk;      /* Total # files downed (week) */
  ulong  bytes_down_wk;      /* Total # bytes downed (week) */
  time_t seconds_down_wk;    /* Total # seconds spent downloading (week) */

  int    files_up_day;
  ulong  bytes_up_day;
  time_t seconds_up_day;

  int    files_down_day;
  ulong  bytes_down_day;
  time_t seconds_down_day;

  int    files_up_month;
  ulong  bytes_up_month;
  time_t seconds_up_month; 

  int    files_down_month;
  ulong  bytes_down_month;
  time_t seconds_down_month;

  int    glock;
  
  int    login_times;        /* # times logged on */  
  time_t last_on;            /* Last date online */
  int    time_limit;         /* Time limit (in minutes) */
  int    time_on_today;      /* Number of minutes spent online today */
  time_t last_nuked;         /* Time the user last nuked */
  int    use_color;          /* 1=Use color 0=No color (default) */	
  	
  char   gadmin[ 15 ]; /* Group Administration shiznitz */						   
  char   group_user[ 10 ][ 15 ];  /* Groups this user belongs to */
  char   group_priv[ 10 ][ 15 ];  /* Groups this user belongs to */
  
  char   ip[ 20 ][ 55 ];     /* IPs allowed for this login */
} uf;
#endif

