#include <sys/param.h>
#include <stdio.h>

/*
 * sysconfig.h
 *
 * Structure that holds global system configuration info.
 *
 * bleachboy 1996
 */

struct CF
{
  char  datapath[ MAXPATHLEN ];    /* Path where data dir struct is at */
  int   max_users;	   	   /* Maximum # of users online at once */
  char  tag_file[ MAXPATHLEN ];    /* Name of file to tag all files with */
  char  welcome_msg[ MAXPATHLEN ]; /* Message to display when user logs in */
  int   show_diz;	           /* 1=show DIZ when CWD, 0=don't */
  int   default_ratio;             /* Default ratio for users */
  ulong free_ratio_amount;         /* # of bytes before ratio kicks in */
  int   dupe_check_days;	   /* # of days to check for dupes */
  char  default_restrict[ MAXPATHLEN ];	/* Default "restrict" path */
  char  default_tagline[ 64 ];	   /* Default tagline for all users */
  int   default_num_logins;	   /* Default #/simultaneous logins */
  int   default_level;		   /* Default level for new users */
  int   caps_first_letter;	   /* 1=Caps 1st letter on MKDIR */
  char  email[ 100 ];		   /* The siteop's email address */
  char  banner[ MAXPATHLEN ];      /* Banner file to display before login */
  char  sitename[ 50 ];            /* The name of the site */
  char  dividerline[ BUFSIZ ];     /* Used as a divider line */
  int   show_newsfile;             /* Show 'newsfile' after 1st use CWD */
  int   multiplier_max;            /* Maximum nuke multiplier value */
  int   max_oneliners;             /* How many oneliners online @ once */
  int   max_requests;
  int   create_nukedir;            /* Create irritating "!NUKED:" dir? */
  int   force_tagline;             /* No d/l until they change tagline */
  char requestdir [ MAXPATHLEN ];
  char incomingdir [ MAXPATHLEN ];
};

#ifdef SYSCONFIG 
struct CF cf;
#else
extern struct CF cf;
#endif
