#include <sys/param.h>

/*
 * Defines
 */

#define NUM_USERS 500		/* Max # users on your site */
#define NUM_LIST  10		/* Number of up/downloads to list in your list */

#define BB_POSS_IPS 			10
#define DEFAULT_RATIO   	6
#define FREE_RATIO_AMOUNT	50000000L
#define DUPE_CHECK_DAYS    7
#define DEFAULT_RESTRICT   "/home/.cache/.site"
#define DEFAULT_TAGLINE		"i luv zftpd!"
#define CAPS_FIRST_LETTER  1

/*
 * Global variables...if these have a predefined value, you may need to change them
 */

char  *xferlogname = "/var/log/ftpd/xferlog";              /* Location of your xferlog */
char  *sitepath = "/home/.cache/.site/";		   /* Where the site is */
char  *msgfilelocation = "/home/.cache/.site/welcome.msg"; /* What you call your message file */
char  *staticmsgfile = "/etc/.sitemsg";                    /* A generic site message */
char  *userfilename = "/etc/ftp-users";			  

/*
 * xfer: Structure in which a single xfer will be parsed:
 */

struct XFER
{
   char   month[ 4 ];                  /* The month of year */
   char   day[ 3 ];		       /* The day of the month */
   time_t transfer_time;               /* Total transfer time, in seconds */
   char   remote_host[ 255 ];          /* Name of the remote host */
   size_t file_size;                   /* Total size of transfer in bytes */
   char	  filename[ 255 ];	       /* Filename */
   char   direction;                   /* 'o': Outgoing, 'i': Incoming */
   char   username[ 25 ];              /* Local username or if guest, the ID string given */
} xfer;


/*
 * user: Structure in which a user's info will be tabulated
 */

int	num_users = 0;		       /* Number of non-empty items in the user array */

struct USER
{
   char   username[ 25 ];      /* The username associated */
   char   tagline[ 64 ];       /* User's tagline */
   unsigned long bytes_up;     /* Total # bytes uploaded */
   unsigned long bytes_down;   /* Total # bytes downloaded */
   int    transfers;           /* Total # transfers (up or down) */
   int    uploads;	       /* Number of uploads this user */
   int    downloads;	       /* Number of downloads this user */
   time_t total_uptime;	       /* Total time spend uploading */
   time_t total_downtime;      /* Total time spent downloading */
   time_t total_time;          /* Total time spend xferring */
   double upspeed;	       /* Average upload speed */
   double downspeed;	       /* Average download speed */		
  char   group_user[ 10 ][ 15 ];  /* Groups this user belongs to */
  char   group_priv[ 10 ][ 15 ];  /* Groups this user belongs to */

} user[ NUM_USERS ];

/*
 * Global files
 */

FILE *xferlog;
FILE *message = NULL;

/*
 * Generic global variables
 */

char work_buff[ 255 ];
char log_buff[ 512 ];
