/*
 * prototypes.h
 *
 * Missing function prototypes
 *
 * Juha Virtanen, <jiivee@hut.fi>; November 1995
 */
/*
 * $Id: prototypes.h,v 1.4 1995/12/17 03:10:14 marekm Exp $
 *
 * XXX - ANSI C compiler required, hopefully no problem in 1995 :-).
 */

#ifndef _PROTOTYPES_H
#define _PROTOTYPES_H

#include <utmp.h>
#include "pwd.h"
#include "grp.h"
#ifdef SHADOWPWD
#include "shadow.h"
#include "gshadow.h"
#endif
#include "faillog.h"

/* age.c */
#ifdef SHADOWPWD
extern void agecheck (struct passwd *pw, struct spwd *sp);
extern int expire (struct passwd *pw, struct spwd *sp);
extern int isexpired (struct passwd *pw, struct spwd *sp);
#else
extern void agecheck (struct passwd *pw);
extern int expire (struct passwd *pw);
extern int isexpired (struct passwd *pw);
#endif

#ifndef HAVE_BASENAME  /* Linux libc-4.6.27 has it, see <unistd.h> */
/* basename.c */
extern char *basename(char *str);
#endif

/* chowndir.c */
extern int chown_tree (char *root, int old_uid, int new_uid, int old_gid, int new_gid);

/* console.c */
extern int console (char *tty);

/* copydir.c */
extern int copy_tree (char *src_root, char *dst_root, UID_T uid, GID_T id, UID_T ouid, GID_T ogid);
extern int remove_tree (char *root);

/* dialchk.c */
extern int dialcheck (char *tty, char *shell);

/* entry.c */
extern void entry (char *name, struct passwd *pwent);

/* env.c */
extern void addenv (char *entry);

/* failure.c */
extern int failcheck (int uid, struct faillog *faillog, int failed);
extern void failprint (struct faillog *fail);
extern void failtmp (struct utmp *failent);
extern void failure (int uid, char *tty, struct faillog *faillog);

/* fields.c */
extern void change_field (char *buf, char *prompt);
extern int valid_field (char *field, char *illegal);

/* getdef.c */
extern int getdef_bool (char *item);
extern int getdef_num (char *item, int dflt);
extern char *getdef_str (char *item);

/* grdbm.c */
extern int gr_dbm_remove (struct group *gr);
extern int gr_dbm_update (struct group *gr);

/* grent.c */
extern int fputsx (char *s, FILE *stream);
extern int putgrent (struct group *g, FILE *f);

/* groupio.h */
extern int gr_close ();
extern int gr_lock ();
extern int gr_name (char *name);
extern int gr_open (int mode);
extern int gr_rewind ();
extern int gr_unlock ();
extern int gr_update (struct group *grent);

/* grpack.c */
extern int gr_pack (struct group *group, char *buf);

/* gsdbm.c */
extern int sg_dbm_remove (char *name);
extern int sg_dbm_update (struct sgrp *sgr);

/* gspack.c */
extern int sgr_pack (struct sgrp *sgrp, char *buf);
extern int sgr_unpack (char *buf, int len, struct sgrp *sgrp);

/* hushed.c */
extern int hushed (struct passwd *pw);

/* list.c */
extern char **add_list (char **list, char *member);
extern char **del_list (char **list, char *member);

/* obscure.c */
extern int obscure (char *old, char *new);
extern int palindrome (char *old, char *new);
extern int similiar (char *old, char *new);
extern int simple (char *old, char *new);

/* port.c */
extern int isttytime (char *id, char *port, long clock);

/* pwdbm.c */
extern int pw_dbm_remove (struct passwd	*pw);
extern int pw_dbm_update (struct passwd *pw);

/* pwio.h */
extern int pw_close ();
extern struct passwd *pw_locate (char *name);
extern int pw_lock ();
extern int pw_name (char *name);
extern int pw_open (int mode);
extern int pw_remove (char *name);
extern int pw_rewind ();
extern int pw_unlock ();
extern int pw_update (struct passwd *pwent);

/* pwpack.c */
extern int pw_pack (struct passwd *passwd, char *buf);

/* rad64.c */
extern int c64i (char c);
extern int i64c (int i);

/* setup.c */
extern void setup (struct passwd *info);

/* sgroupio.c */
extern int sgr_close ();
extern int sgr_lock ();
extern int sgr_name (char *name);
extern int sgr_open (int mode);
extern int sgr_rewind ();
extern int sgr_unlock ();
extern int sgr_update (struct sgrp *sgrent);

/* shadowio.h */
extern int spw_close ();
extern int spw_lock ();
extern int spw_name (char *name);
extern int spw_open (int mode);
extern int spw_remove (char *name);
extern int spw_unlock ();
extern int spw_update (struct spwd *spwd);

/* shell.c */
extern void	shell (char *file, char *arg);

/* spdbm.c */
extern int sp_dbm_remove (char *user);
extern int sp_dbm_update (struct spwd *sp);

/* sppack.c */
extern int spw_pack (struct spwd *spwd, char *buf);
extern int spw_unpack (char *buf, int len, struct spwd *spwd);

/* strtoday.c */
extern long strtoday (char *str);

/* ttytype.c */
extern void ttytype (char *line);

/* valid.c */
extern int valid (char *password, struct passwd *entry);

/* xmalloc.c */
extern char *xmalloc (unsigned size);
extern char *xstrdup (char *str);


#endif /* _PROTOTYPES_H */
