VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CWindow"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' Class Name:   CWindow
' Author:       Deborah Kurata, InStep Technologies
' Date:         1/24/97
' Description:  Generic window class to provide
'               additional form properties and
'               Windows methods.
'
' Revisions:
'
Option Explicit

Enum WinError
    winCBClearError = vbObjectError + 512 + 2
    winCBSelectError = vbObjectError + 512 + 3
    winCBGetError = vbObjectError + 512 + 4
End Enum
    
'Declare for formSetTopMost
Private Declare Function SetWindowPos Lib "user32" _
 (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, _
 ByVal x As Long, ByVal y As Long, ByVal cx As Long, _
 ByVal cy As Long, ByVal wFlags As Long) As Long

' SetWindowPos() hwndInsertAfter values
Const HWND_TOPMOST = -1
Const HWND_NOTOPMOST = -2
' SetWindowPos Flags
Const SWP_NOSIZE = &H1
Const SWP_NOMOVE = &H2
Const SWP_NOACTIVATE = &H10

' PUBLIC: *****************************************
' Public data members

' When this property is set, the window is made top most
Public Property Let OnTop(frmTop As Form, bSetOnTop As Boolean)
    If bSetOnTop = True Then
      ' Set the window to topmost window
      Call SetWindowPos(frmTop.hwnd, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOSIZE Or SWP_NOMOVE Or SWP_NOACTIVATE)
    Else
      ' Set the window to not topmost window
      Call SetWindowPos(frmTop.hwnd, HWND_NOTOPMOST, 0, 0, 0, 0, SWP_NOSIZE Or SWP_NOMOVE Or SWP_NOACTIVATE)
    End If
End Property

' PRIVATE: *****************************************
' Private data members

' Standard Copy procedure
' This could be enhanced to support alternative Clipboard types
Public Sub EditCopy()
    ' Set the error handler
    On Error Resume Next
    
    ' Clear the Clipboard
    Clipboard.Clear
    If Err.Number Then
        On Error GoTo 0
        Err.Raise winCBClearError, "CWindow::EditCopy", _
            "Could not clear Clipboard."
    Else
        ' Place selected text on the Clipboard
        Clipboard.SetText Screen.ActiveControl.SelText
        If Err.Number Then
            On Error GoTo 0
            Err.Raise winCBSelectError, "CWindow::EditCopy", _
                "Could not set text from active control to Clipboard."
        End If
    End If
End Sub

' Standard Cut procedure
' This could be enhanced to support alternative Clipboard types
Public Sub EditCut()
    ' Set the error handler
    On Error Resume Next

    ' Clear the Clipboard
    Clipboard.Clear
    If Err.Number Then
        On Error GoTo 0
        Err.Raise winCBClearError, "CWindow::EditCut", _
            "Could not clear Clipboard."
    Else
        ' Place selected text on the Clipboard
        Clipboard.SetText Screen.ActiveControl.SelText
        Screen.ActiveControl.SelText = ""
        If Err.Number Then
            On Error GoTo 0
            Err.Raise winCBSelectError, "CWindow::EditCut", _
                "Could not set text from active control to Clipboard."
        End If
    End If
End Sub

' Standard Paste procedure
' This could be enhanced to support alternative Clipboard types
Public Sub EditPaste()
    ' Set the error handler
    On Error Resume Next

    ' Place the text from the Clipboard
    Screen.ActiveControl.SelText = Clipboard.GetText()
    If Err.Number Then
        On Error GoTo 0
        Err.Raise winCBGetError, "CWindow::EditPaste", _
            "Could not set text from Clipboard to active control."
    End If
End Sub

