VERSION 5.00
Begin VB.Form frmPerson 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Address Book"
   ClientHeight    =   3840
   ClientLeft      =   1050
   ClientTop       =   1575
   ClientWidth     =   7170
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   3840
   ScaleWidth      =   7170
   Begin VB.CommandButton cmdPerson 
      Caption         =   "&Help"
      Height          =   432
      Index           =   3
      Left            =   6300
      TabIndex        =   29
      Top             =   0
      Width           =   735
   End
   Begin VB.CommandButton cmdPerson 
      Caption         =   "&Delete"
      Enabled         =   0   'False
      Height          =   432
      Index           =   2
      Left            =   5580
      TabIndex        =   28
      Top             =   0
      Width           =   735
   End
   Begin VB.CommandButton cmdPerson 
      Caption         =   "&Save"
      Enabled         =   0   'False
      Height          =   435
      Index           =   0
      Left            =   4140
      TabIndex        =   27
      Top             =   0
      Width           =   735
   End
   Begin VB.CommandButton cmdPerson 
      Caption         =   "&New"
      Height          =   432
      Index           =   1
      Left            =   4860
      TabIndex        =   26
      Top             =   0
      Width           =   735
   End
   Begin VB.TextBox txtPerson 
      Height          =   288
      Index           =   7
      Left            =   5100
      MaxLength       =   20
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   7
      Top             =   600
      Width           =   1932
   End
   Begin VB.ComboBox cboPerson 
      Height          =   288
      ItemData        =   "person.frx":0000
      Left            =   1320
      List            =   "person.frx":0007
      Sorted          =   -1  'True
      Style           =   2  'Dropdown List
      TabIndex        =   0
      Top             =   60
      Width           =   2712
   End
   Begin VB.TextBox txtPerson 
      Height          =   288
      Index           =   9
      Left            =   5100
      MaxLength       =   20
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   9
      Top             =   1320
      Width           =   1932
   End
   Begin VB.TextBox txtPerson 
      Height          =   288
      Index           =   8
      Left            =   5100
      MaxLength       =   20
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   8
      Top             =   960
      Width           =   1932
   End
   Begin VB.TextBox txtPerson 
      Height          =   285
      Index           =   1
      Left            =   2460
      MaxLength       =   20
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   2
      Top             =   600
      Width           =   1575
   End
   Begin VB.TextBox txtPerson 
      Height          =   288
      Index           =   0
      Left            =   1320
      MaxLength       =   10
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   1
      Top             =   600
      Width           =   1092
   End
   Begin VB.TextBox txtPerson 
      Height          =   615
      Index           =   2
      Left            =   1320
      MaxLength       =   32
      MultiLine       =   -1  'True
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   3
      Top             =   960
      Width           =   2715
   End
   Begin VB.TextBox txtPerson 
      Height          =   288
      Index           =   6
      Left            =   1320
      MaxLength       =   10
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   6
      Top             =   2100
      Width           =   1872
   End
   Begin VB.TextBox txtPerson 
      Height          =   288
      Index           =   4
      Left            =   1320
      MaxLength       =   20
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   4
      Top             =   1680
      Width           =   1872
   End
   Begin VB.TextBox txtPerson 
      Height          =   288
      Index           =   5
      Left            =   3360
      MaxLength       =   2
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   5
      Top             =   1680
      Width           =   672
   End
   Begin VB.TextBox txtPerson 
      Height          =   288
      Index           =   10
      Left            =   5100
      MaxLength       =   20
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   10
      Top             =   1680
      Width           =   1932
   End
   Begin VB.TextBox txtPerson 
      Height          =   288
      Index           =   11
      Left            =   5100
      MaxLength       =   20
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   11
      Top             =   2040
      Width           =   1932
   End
   Begin VB.TextBox txtPerson 
      Height          =   288
      Index           =   12
      Left            =   5100
      MaxLength       =   20
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   12
      Top             =   2400
      Width           =   1932
   End
   Begin VB.TextBox txtPerson 
      Height          =   972
      Index           =   13
      Left            =   60
      MaxLength       =   255
      MultiLine       =   -1  'True
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      ScrollBars      =   2  'Vertical
      TabIndex        =   13
      Top             =   2760
      Width           =   6972
   End
   Begin VB.Label Label2 
      Caption         =   ","
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   312
      Left            =   3240
      TabIndex        =   30
      Top             =   1740
      Width           =   132
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Zip Code:"
      Height          =   252
      Index           =   2
      Left            =   0
      TabIndex        =   25
      Top             =   2100
      Width           =   1212
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Select Person:"
      Height          =   252
      Index           =   15
      Left            =   120
      TabIndex        =   24
      Top             =   120
      Width           =   1092
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "E-Mail:"
      Height          =   252
      Index           =   14
      Left            =   4140
      TabIndex        =   23
      Top             =   2400
      Width           =   852
   End
   Begin VB.Line Line1 
      BorderColor     =   &H000000C0&
      X1              =   7140
      X2              =   60
      Y1              =   480
      Y2              =   480
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Department:"
      Height          =   252
      Index           =   13
      Left            =   4080
      TabIndex        =   22
      Top             =   1380
      Width           =   972
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Title:"
      Height          =   252
      Index           =   12
      Left            =   4140
      TabIndex        =   21
      Top             =   1020
      Width           =   852
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Company:"
      Height          =   252
      Index           =   11
      Left            =   4140
      TabIndex        =   20
      Top             =   660
      Width           =   852
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Name (First Last):"
      Height          =   252
      Index           =   0
      Left            =   0
      TabIndex        =   19
      Top             =   660
      Width           =   1272
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Address:"
      Height          =   252
      Index           =   1
      Left            =   360
      TabIndex        =   18
      Top             =   1020
      Width           =   852
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "City, State:"
      Height          =   252
      Index           =   3
      Left            =   0
      TabIndex        =   17
      Top             =   1680
      Width           =   1212
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Phone:"
      Height          =   252
      Index           =   6
      Left            =   4140
      TabIndex        =   16
      Top             =   1740
      Width           =   852
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "FAX:"
      Height          =   252
      Index           =   7
      Left            =   4140
      TabIndex        =   15
      Top             =   2040
      Width           =   852
   End
   Begin VB.Label Label1 
      Caption         =   "Notes:"
      Height          =   252
      Index           =   8
      Left            =   60
      TabIndex        =   14
      Top             =   2460
      Width           =   852
   End
End
Attribute VB_Name = "frmPerson"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Form Name:    frmPerson
' Author:       Deborah Kurata, InStep Technologies
' Date:         1/24/97
' Description:  Displays Address Book information
' Revisions:
'

Option Explicit

' PRIVATE: *****************************************
' Private data members

' Reference to a persons object
Private m_Persons As CPersons

' Define constants for this form
' This uses constants instead of "magic numbers"
' A constant could also be created for each text box

' Buttons
Enum persButton
    persSaveButton = 0
    persNewButton = 1
    persDeleteButton = 2
    persHelpButton = 3
End Enum

' Text boxes
Enum persText
    persFirstNameText = 0
    persLastNameText = 1
    persAddressText = 2
    persCityText = 4
    persStateText = 5
    persZipCodeText = 6
    persCompanyText = 7
    persTitleText = 8
    persDeptText = 9
    persPhoneText = 10
    persFAXText = 11
    persEMailText = 12
    persNotesText = 13
End Enum
' Pass in the reference from the parent form
Public Sub Display(Persons As CPersons)
    ' Set the value from the calling routine
    Set m_Persons = Persons

    ' Show the form
    Me.Show vbModeless, frmMain

End Sub

' When a person is selected, fill the form for this person
Private Sub cboPerson_Click()
On Error GoTo ERR_ROUTINE

    ' If something is selected
    If cboPerson.ListIndex <> -1 Then
    
        ' Fill the form for the selected person
        DoFind cboPerson.ItemData(cboPerson.ListIndex)
        
    End If
Exit Sub

ERR_ROUTINE:
    ' Display the error
    MsgBox "Error in application: " _
        & Err.Description
End Sub

Private Sub cboPerson_DropDown()
On Error GoTo ERR_ROUTINE
    ' Clear the combo
    cboPerson.Clear
    
    ' Fill the combo box with the information from the database
    m_Persons.FillPersonList cboPerson
Exit Sub

ERR_ROUTINE:
    ' Display the error
    MsgBox "Error in application: " _
        & Err.Description
End Sub

Private Sub cmdPerson_Click(index As Integer)
On Error GoTo ERR_ROUTINE
    Select Case index
        Case persNewButton
            ' Clear the screen for a new entry
            DoAdd
                    
        Case persSaveButton
            ' Put the current data
            ' from the form to the object
            DoSave
            
        Case persDeleteButton
            ' Delete the current person
            DoDelete
            
        Case persHelpButton
            ' *** Help file would go here
            MsgBox "This will display help"
    End Select
Exit Sub

ERR_ROUTINE:
    ' Display the error
    MsgBox "Error in application: " _
        & Err.Description
End Sub

Private Sub Form_Activate()
    ' Fill with form for the current person
    UpdateForm
End Sub

Private Sub Form_Deactivate()
    ' Save on deactivate
    DoSave
End Sub

Private Sub Form_Unload(Cancel As Integer)
    ' Save any currently displayed data
    DoSave
    
    ' Clear the references
    Set m_Persons = Nothing
    Set frmPerson = Nothing
End Sub

' When data has changed, enable the Save button
Private Sub txtPerson_Change(index As Integer)
    cmdPerson(persSaveButton).Enabled = True
    m_Persons.IsDirty = True
End Sub

' Add a new record
Private Sub DoAdd()
On Error GoTo ERR_ROUTINE
    ' Update the object with current data
    UpdateObject

    ' Add the new record
    m_Persons.Add
    
    ' Clear the fields
    UpdateForm
    
    ' Enable/disable the buttons
    cmdPerson(persDeleteButton).Enabled = False
    
    ' Clear the combo selection
    cboPerson.ListIndex = -1
Exit Sub

ERR_ROUTINE:
    Err.Raise Err.Number, Err.Source, Err.Description
End Sub

' Delete the displayed record
Private Sub DoDelete()
On Error GoTo ERR_ROUTINE
    ' Delete the current record
    m_Persons.Delete
    
    ' Do a new so the screen is cleared
    DoAdd
Exit Sub

ERR_ROUTINE:
    Err.Raise Err.Number, Err.Source, Err.Description
End Sub

' Do the Find
Private Sub DoFind(lID As Long)
Dim lUserID As Long
On Error GoTo ERR_ROUTINE
    ' Update the object with current data
    UpdateObject

    ' Store the current object's user ID
    lUserID = m_Persons.UserID
    ' Create a new instance of the Persons class
    Set m_Persons = New CPersons
    m_Persons.UserID = lUserID
    
    ' Find the selected person
    m_Persons.Find lID
    
    ' Display the selected person in the form
    UpdateForm
Exit Sub

ERR_ROUTINE:
    Err.Raise Err.Number, Err.Source, Err.Description
End Sub

' Save the current record
Private Sub DoSave()
On Error GoTo ERR_ROUTINE
    If m_Persons.IsDirty Then
        ' Update the object with current data
        UpdateObject
        
        ' Save the data
        m_Persons.Save
    
        ' Enable the delete button
        cmdPerson(persDeleteButton).Enabled = True
        ' Disable the save button
        cmdPerson(persSaveButton).Enabled = False
    End If
Exit Sub

ERR_ROUTINE:
    Err.Raise Err.Number, Err.Source, Err.Description
End Sub

' Update the controls on the form from the object
Private Sub UpdateForm()
On Error GoTo ERR_ROUTINE
    ' Display the selected person in the form
    ' This will clear the form if a new
    With m_Persons.Person
        txtPerson(persFirstNameText).Text = .FirstName
        txtPerson(persLastNameText).Text = .LastName
        txtPerson(persAddressText).Text = .Address
        txtPerson(persCityText).Text = .City
        txtPerson(persStateText).Text = .State
        txtPerson(persZipCodeText).Text = .ZipCode
        txtPerson(persCompanyText).Text = .Company
        txtPerson(persTitleText).Text = .Title
        txtPerson(persDeptText).Text = .Department
        txtPerson(persPhoneText).Text = .Phone
        txtPerson(persFAXText).Text = .FAX
        txtPerson(persEMailText).Text = .EMail
        txtPerson(persNotesText).Text = .Notes
    End With

    ' This turned the dirty flag on
    ' Turn it back off
    m_Persons.IsDirty = False

    ' Ensure the correct buttons are enabled/disabled
    cmdPerson(persDeleteButton).Enabled = True
    cmdPerson(persSaveButton).Enabled = False
Exit Sub

ERR_ROUTINE:
    Err.Raise Err.Number, Err.Source, Err.Description
End Sub

' Update object from controls on the form
Private Sub UpdateObject()
On Error GoTo ERR_ROUTINE
    ' If the current information has changed, copy
    ' it back to the person object
    If m_Persons.IsDirty Then
        With m_Persons.Person
            ' Set the values from the form to the class
            .FirstName = txtPerson(persFirstNameText).Text
            .LastName = txtPerson(persLastNameText).Text
            .Address = txtPerson(persAddressText).Text
            .City = txtPerson(persCityText).Text
            .State = txtPerson(persStateText).Text
            .ZipCode = txtPerson(persZipCodeText).Text
            .Company = txtPerson(persCompanyText).Text
            .Title = txtPerson(persTitleText).Text
            .Department = txtPerson(persDeptText).Text
            .Phone = txtPerson(persPhoneText).Text
            .FAX = txtPerson(persFAXText).Text
            .EMail = txtPerson(persEMailText).Text
            .Notes = txtPerson(persNotesText).Text
        End With
    End If
Exit Sub

ERR_ROUTINE:
    Err.Raise Err.Number, Err.Source, Err.Description
End Sub

