VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CPerson"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' Class Name:   CPerson
' Author:       Deborah Kurata, InStep Technologies
' Date:         1/22/97
' Description:  Provides services to maintain person information
'               such as name, address, phone
' Edit History:
'
Option Explicit

' PRIVATE: *****************************************
' Private data members

' Person data elements
Private m_sAddress As String
Private m_sCity As String
Private m_sCompany As String
Private m_sDepartment As String
Private m_sEmail As String
Private m_sFAX As String
Private m_sFirstName As String
Private m_lID As Long
Private m_sLastName As String
Private m_sNote As String
Private m_sPersonType As String
Private m_sPhone As String
Private m_sState As String
Private m_sTitle As String
Private m_sZipCode As String

' PUBLIC: *****************************************
' Public property procedures

Public Property Get Address() As String
    Address = m_sAddress
End Property
Public Property Let Address(ByVal sAddress As String)
    m_sAddress = StrConv(Trim(sAddress), vbProperCase)
End Property

Public Property Get City() As String
    City = m_sCity
End Property
Public Property Let City(ByVal sCity As String)
    m_sCity = StrConv(Trim(sCity), vbProperCase)
End Property

Public Property Get Company() As String
    Company = m_sCompany
End Property
Public Property Let Company(ByVal sCompany As String)
    m_sCompany = StrConv(Trim(sCompany), vbProperCase)
End Property

Public Property Get Department() As String
    Department = m_sDepartment
End Property
Public Property Let Department(ByVal sDepartment As String)
    m_sDepartment = sDepartment
End Property

Public Property Get EMail() As String
    EMail = m_sEmail
End Property
Public Property Let EMail(ByVal sEMail As String)
    m_sEmail = sEMail
End Property

Public Property Get FAX() As String
    FAX = m_sFAX
End Property
Public Property Let FAX(ByVal sFAX As String)
    m_sFAX = sFAX
End Property

Public Property Get FirstName() As String
    FirstName = m_sFirstName
End Property
Public Property Let FirstName(ByVal sName As String)
    m_sFirstName = StrConv(Trim(sName), vbProperCase)
End Property

Public Property Get ID() As Long
    ID = m_lID
End Property
Public Property Let ID(ByVal lID As Long)
    m_lID = lID
End Property

Public Property Get LastName() As String
    LastName = m_sLastName
End Property
Public Property Let LastName(ByVal sName As String)
    m_sLastName = StrConv(Trim(sName), vbProperCase)
End Property

' Concatenated version of name
Public Property Get Name(Optional LastNameFirst As Boolean = False) As String
    If LastNameFirst Then
        Name = LastName & ", " & FirstName
    Else
        Name = FirstName & " " & LastName
    End If
End Property

Public Property Get Notes() As String
    Notes = m_sNote
End Property
Public Property Let Notes(ByVal sNotes As String)
    m_sNote = sNotes
End Property

Public Property Get Phone() As String
    Phone = m_sPhone
End Property
Public Property Let Phone(ByVal sPhone As String)
    m_sPhone = sPhone
End Property

Public Property Get State() As String
    State = m_sState
End Property
Public Property Let State(ByVal sState As String)
    m_sState = StrConv(Trim(sState), vbUpperCase)
End Property

Public Property Get Title() As String
    Title = m_sTitle
End Property
Public Property Let Title(sTitle As String)
    m_sTitle = sTitle
End Property

Public Property Get ZipCode() As String
    ZipCode = m_sZipCode
End Property
Public Property Let ZipCode(ByVal sZip As String)
    m_sZipCode = sZip
End Property


