VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.1#0"; "COMDLG32.OCX"
Object = "{FAEEE763-117E-101B-8933-08002B2F4F5A}#1.1#0"; "DBLIST32.OCX"
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.1#0"; "COMCTL32.OCX"
Object = "{00028C01-0000-0000-0000-000000000046}#1.0#0"; "DBGRID32.OCX"
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Contact Management System"
   ClientHeight    =   6165
   ClientLeft      =   2760
   ClientTop       =   795
   ClientWidth     =   6915
   Icon            =   "main.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   6165
   ScaleWidth      =   6915
   Begin ComctlLib.Toolbar Toolbar1 
      Align           =   1  'Align Top
      Height          =   510
      Left            =   0
      Negotiate       =   -1  'True
      TabIndex        =   25
      Top             =   0
      Width           =   6915
      _ExtentX        =   12197
      _ExtentY        =   900
      ButtonWidth     =   820
      ButtonHeight    =   741
      AllowCustomize  =   0   'False
      Wrappable       =   0   'False
      ImageList       =   "ImageList1"
      _Version        =   327680
      BeginProperty Buttons {0713E452-850A-101B-AFC0-4210102A8DA7} 
         NumButtons      =   10
         BeginProperty Button1 {0713F354-850A-101B-AFC0-4210102A8DA7} 
            Key             =   ""
            Object.Tag             =   ""
            Style           =   4
            MixedState      =   -1  'True
         EndProperty
         BeginProperty Button2 {0713F354-850A-101B-AFC0-4210102A8DA7} 
            Key             =   "SAVE"
            Object.ToolTipText     =   "Save this contact entry"
            Object.Tag             =   ""
            ImageIndex      =   1
         EndProperty
         BeginProperty Button3 {0713F354-850A-101B-AFC0-4210102A8DA7} 
            Key             =   "PRINT"
            Object.ToolTipText     =   "Print contact information"
            Object.Tag             =   ""
            ImageIndex      =   2
         EndProperty
         BeginProperty Button4 {0713F354-850A-101B-AFC0-4210102A8DA7} 
            Key             =   ""
            Object.Tag             =   ""
            Style           =   4
            MixedState      =   -1  'True
         EndProperty
         BeginProperty Button5 {0713F354-850A-101B-AFC0-4210102A8DA7} 
            Key             =   "CUT"
            Object.ToolTipText     =   "Cut"
            Object.Tag             =   ""
            ImageIndex      =   3
         EndProperty
         BeginProperty Button6 {0713F354-850A-101B-AFC0-4210102A8DA7} 
            Key             =   "COPY"
            Object.ToolTipText     =   "Copy"
            Object.Tag             =   ""
            ImageIndex      =   4
         EndProperty
         BeginProperty Button7 {0713F354-850A-101B-AFC0-4210102A8DA7} 
            Key             =   "PASTE"
            Object.ToolTipText     =   "Paste"
            Object.Tag             =   ""
            ImageIndex      =   5
         EndProperty
         BeginProperty Button8 {0713F354-850A-101B-AFC0-4210102A8DA7} 
            Key             =   ""
            Object.Tag             =   ""
            Style           =   4
            MixedState      =   -1  'True
         EndProperty
         BeginProperty Button9 {0713F354-850A-101B-AFC0-4210102A8DA7} 
            Key             =   "NEW"
            Object.ToolTipText     =   "New contact entry"
            Object.Tag             =   ""
            ImageIndex      =   6
         EndProperty
         BeginProperty Button10 {0713F354-850A-101B-AFC0-4210102A8DA7} 
            Key             =   "DELETE"
            Object.ToolTipText     =   "Delete contact entry"
            Object.Tag             =   ""
            ImageIndex      =   7
         EndProperty
      EndProperty
      BorderStyle     =   1
      MouseIcon       =   "main.frx":0442
   End
   Begin VB.ComboBox cboPerson 
      Height          =   315
      Left            =   1440
      Style           =   2  'Dropdown List
      TabIndex        =   1
      ToolTipText     =   "Selects a contact person"
      Top             =   600
      Width           =   2895
   End
   Begin VB.TextBox txtPerson 
      Height          =   288
      Index           =   0
      Left            =   1380
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   3
      ToolTipText     =   "Person's first name"
      Top             =   1140
      Width           =   1032
   End
   Begin VB.TextBox txtPerson 
      Height          =   285
      Index           =   1
      Left            =   2460
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   4
      ToolTipText     =   "Person's last name"
      Top             =   1140
      Width           =   1875
   End
   Begin VB.TextBox txtPerson 
      Height          =   615
      Index           =   2
      Left            =   1380
      MultiLine       =   -1  'True
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   5
      ToolTipText     =   "Person's address"
      Top             =   1500
      Width           =   2955
   End
   Begin VB.TextBox txtPerson 
      Height          =   288
      Index           =   4
      Left            =   1380
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   6
      ToolTipText     =   "Person's city"
      Top             =   2220
      Width           =   1512
   End
   Begin VB.TextBox txtPerson 
      Height          =   288
      Index           =   5
      Left            =   2940
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   7
      ToolTipText     =   "Person's state"
      Top             =   2220
      Width           =   432
   End
   Begin VB.TextBox txtPerson 
      Height          =   285
      Index           =   6
      Left            =   3420
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   8
      ToolTipText     =   "Person's Zip Code"
      Top             =   2220
      Width           =   915
   End
   Begin VB.TextBox txtPerson 
      Height          =   285
      Index           =   10
      Left            =   5160
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   9
      ToolTipText     =   "Person's phone number"
      Top             =   1140
      Width           =   1695
   End
   Begin VB.TextBox txtPerson 
      Height          =   285
      Index           =   11
      Left            =   5160
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   10
      ToolTipText     =   "Person's FAX number"
      Top             =   1500
      Width           =   1695
   End
   Begin VB.TextBox txtPerson 
      Height          =   285
      Index           =   12
      Left            =   5160
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   11
      ToolTipText     =   "Person's email address"
      Top             =   1860
      Width           =   1695
   End
   Begin VB.Data datContactType 
      Caption         =   "Data1"
      Connect         =   "Access"
      DatabaseName    =   ""
      DefaultCursorType=   0  'DefaultCursor
      DefaultType     =   2  'UseODBC
      Exclusive       =   0   'False
      Height          =   300
      Left            =   5220
      Options         =   0
      ReadOnly        =   0   'False
      RecordsetType   =   2  'Snapshot
      RecordSource    =   "select * from ContactTypes order by contactTypeDescription"
      Top             =   2580
      Visible         =   0   'False
      Width           =   1155
   End
   Begin VB.Data datContact 
      Connect         =   "Access"
      DatabaseName    =   "D:\BOOK\VB5 Examples\Ex15.1\cms.mdb"
      DefaultCursorType=   0  'DefaultCursor
      DefaultType     =   2  'UseODBC
      Exclusive       =   0   'False
      Height          =   345
      Left            =   600
      Options         =   0
      ReadOnly        =   0   'False
      RecordsetType   =   1  'Dynaset
      RecordSource    =   $"main.frx":045E
      Top             =   5400
      Visible         =   0   'False
      Width           =   5265
   End
   Begin VB.TextBox txtContact 
      DataField       =   "contactDescription"
      DataSource      =   "datContact"
      Height          =   855
      Index           =   2
      Left            =   120
      MultiLine       =   -1  'True
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   14
      ToolTipText     =   "Notes regarding this contact"
      Top             =   2820
      Width           =   6735
   End
   Begin VB.TextBox txtContact 
      DataField       =   "contactDate"
      DataSource      =   "datContact"
      Height          =   285
      Index           =   1
      Left            =   5160
      OLEDragMode     =   1  'Automatic
      OLEDropMode     =   2  'Automatic
      TabIndex        =   12
      ToolTipText     =   "Date person contacted"
      Top             =   600
      Width           =   1695
   End
   Begin MSComDlg.CommonDialog cDlg 
      Left            =   6960
      Top             =   0
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   327680
      CancelError     =   -1  'True
      FontSize        =   1.1749e-38
   End
   Begin ComctlLib.StatusBar sbrStatus 
      Align           =   2  'Align Bottom
      Height          =   420
      Left            =   0
      TabIndex        =   24
      Top             =   5745
      Width           =   6915
      _ExtentX        =   12197
      _ExtentY        =   741
      SimpleText      =   "xxx"
      _Version        =   327680
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   3
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            AutoSize        =   1
            Object.Width           =   7011
            Text            =   "Select the person to be contacted."
            TextSave        =   "Select the person to be contacted."
            Key             =   "TEXT"
            Object.Tag             =   ""
         EndProperty
         BeginProperty Panel2 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Style           =   6
            AutoSize        =   2
            TextSave        =   "2/19/97"
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
         BeginProperty Panel3 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Style           =   5
            AutoSize        =   2
            TextSave        =   "11:39 PM"
            Key             =   ""
            Object.Tag             =   ""
         EndProperty
      EndProperty
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      MouseIcon       =   "main.frx":051E
   End
   Begin MSDBCtls.DBCombo cboContactType 
      Bindings        =   "main.frx":053A
      DataField       =   "contactType"
      DataSource      =   "datContact"
      Height          =   315
      Left            =   5160
      TabIndex        =   13
      ToolTipText     =   "Type of contact with this person"
      Top             =   2220
      Width           =   1695
      _ExtentX        =   2990
      _ExtentY        =   556
      _Version        =   327680
      MatchEntry      =   -1  'True
      Style           =   2
      BackColor       =   16777215
      ForeColor       =   0
      ListField       =   "contactTypeDescription"
      BoundColumn     =   "contactTypeID"
      Text            =   ""
   End
   Begin MSDBGrid.DBGrid grdContacts 
      Bindings        =   "main.frx":0553
      Height          =   1755
      Left            =   120
      Negotiate       =   -1  'True
      OleObjectBlob   =   "main.frx":0568
      TabIndex        =   15
      ToolTipText     =   "List of all prior contacts"
      Top             =   3780
      Width           =   6735
   End
   Begin ComctlLib.ImageList ImageList1 
      Left            =   8280
      Top             =   0
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   24
      ImageHeight     =   22
      MaskColor       =   12632256
      _Version        =   327680
      BeginProperty Images {0713E8C2-850A-101B-AFC0-4210102A8DA7} 
         NumListImages   =   7
         BeginProperty ListImage1 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "main.frx":162A
            Key             =   ""
         EndProperty
         BeginProperty ListImage2 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "main.frx":17C4
            Key             =   ""
         EndProperty
         BeginProperty ListImage3 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "main.frx":195E
            Key             =   ""
         EndProperty
         BeginProperty ListImage4 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "main.frx":1AF8
            Key             =   ""
         EndProperty
         BeginProperty ListImage5 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "main.frx":1C92
            Key             =   ""
         EndProperty
         BeginProperty ListImage6 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "main.frx":1E2C
            Key             =   ""
         EndProperty
         BeginProperty ListImage7 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "main.frx":1FBA
            Key             =   ""
         EndProperty
      EndProperty
   End
   Begin VB.Label lblPerson 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Address:"
      Height          =   195
      Index           =   0
      Left            =   480
      TabIndex        =   23
      Top             =   1500
      Width           =   795
   End
   Begin VB.Label lblPerson 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "City, State Zip"
      Height          =   255
      Index           =   2
      Left            =   0
      TabIndex        =   22
      Top             =   2280
      Width           =   1275
   End
   Begin VB.Label lblContact 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Phone:"
      Height          =   255
      Index           =   7
      Left            =   4560
      TabIndex        =   21
      Top             =   1200
      Width           =   555
   End
   Begin VB.Label lblContact 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "FAX:"
      Height          =   255
      Index           =   4
      Left            =   4560
      TabIndex        =   20
      Top             =   1500
      Width           =   555
   End
   Begin VB.Label lblContact 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "email:"
      Height          =   255
      Index           =   5
      Left            =   4560
      TabIndex        =   19
      Top             =   1860
      Width           =   555
   End
   Begin VB.Label lblContact 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Name (First Last):"
      Height          =   255
      Index           =   6
      Left            =   0
      TabIndex        =   2
      Top             =   1200
      Width           =   1275
      WordWrap        =   -1  'True
   End
   Begin VB.Line Line1 
      BorderColor     =   &H000000C0&
      X1              =   60
      X2              =   6960
      Y1              =   1020
      Y2              =   1020
   End
   Begin VB.Label lblContact 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Contact Type:"
      Height          =   495
      Index           =   3
      Left            =   4500
      TabIndex        =   18
      Top             =   2220
      Width           =   615
      WordWrap        =   -1  'True
   End
   Begin VB.Label lblContact 
      BackStyle       =   0  'Transparent
      Caption         =   "Contact Notes:"
      Height          =   255
      Index           =   2
      Left            =   120
      TabIndex        =   17
      Top             =   2580
      Width           =   1215
   End
   Begin VB.Label lblContact 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Person Contacted:"
      Height          =   255
      Index           =   1
      Left            =   60
      TabIndex        =   0
      Top             =   660
      Width           =   1335
   End
   Begin VB.Label lblContact 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Date:"
      Height          =   255
      Index           =   0
      Left            =   4560
      TabIndex        =   16
      Top             =   660
      Width           =   495
   End
   Begin VB.Menu mnuFileMenu 
      Caption         =   "&File"
      Begin VB.Menu mnuFile 
         Caption         =   "&New"
         Index           =   0
         Shortcut        =   ^N
      End
      Begin VB.Menu mnuFile 
         Caption         =   "&Open..."
         Index           =   1
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuFile 
         Caption         =   "&Save"
         Index           =   2
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuFile 
         Caption         =   "Save &As..."
         Index           =   3
      End
      Begin VB.Menu mnuFile 
         Caption         =   "-"
         Index           =   4
      End
      Begin VB.Menu mnuFile 
         Caption         =   "&Print..."
         Index           =   5
         Shortcut        =   ^P
      End
      Begin VB.Menu mnuFile 
         Caption         =   "Print Pre&view"
         Index           =   6
      End
      Begin VB.Menu mnuFile 
         Caption         =   "-"
         Index           =   7
      End
      Begin VB.Menu mnuFile 
         Caption         =   "E&xit"
         Index           =   8
      End
   End
   Begin VB.Menu mnuEditMenu 
      Caption         =   "&Edit"
      Begin VB.Menu mnuEdit 
         Caption         =   "Cu&t"
         Index           =   0
         Shortcut        =   ^X
      End
      Begin VB.Menu mnuEdit 
         Caption         =   "&Copy"
         Index           =   1
         Shortcut        =   ^C
      End
      Begin VB.Menu mnuEdit 
         Caption         =   "&Paste"
         Index           =   2
         Shortcut        =   ^V
      End
   End
   Begin VB.Menu mnuViewMenu 
      Caption         =   "&View"
      Begin VB.Menu mnuView 
         Caption         =   "&Address Book"
         Index           =   0
      End
      Begin VB.Menu mnuView 
         Caption         =   "&To Do List"
         Index           =   1
      End
   End
   Begin VB.Menu mnuHelpMenu 
      Caption         =   "&Help"
      Begin VB.Menu mnuHelp 
         Caption         =   "&Help Topics"
         Index           =   0
      End
      Begin VB.Menu mnuHelp 
         Caption         =   "-"
         Index           =   1
      End
      Begin VB.Menu mnuHelp 
         Caption         =   "&About Contact Manager..."
         Index           =   2
      End
   End
   Begin VB.Menu mnuContactPopup 
      Caption         =   "PopUp"
      Visible         =   0   'False
      Begin VB.Menu mnuContact 
         Caption         =   "&New"
         Index           =   0
      End
      Begin VB.Menu mnuContact 
         Caption         =   "&Save"
         Index           =   1
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Form Name:    frmMain
' Author:       Deborah Kurata, InStep Technologies
' Date:         1/24/97
' Description:  Main screen for sales contacts.
'               Note: Since this screen uses bound controls
'               the form talks directly to database fields
'
' Revisions:
'
Option Explicit

' PUBLIC: *****************************************
' Public data members

' PRIVATE: *****************************************
' Private data members

' SalesPerson top level class
Private m_SalesPerson As CSalesPerson

' Menu constants.
' These are used in place of "magic numbers"

' File menu options
Enum salesFileMenu
    salesFileNew = 0
    salesFileOpen = 1
    salesFileSave = 2
    salesFileSaveAs = 3
    salesFilePrint = 5
    salesFilePrintPreview = 6
    salesFileExit = 8
End Enum

' Edit menu options
Enum salesEditMenu
    salesEditCut = 0
    salesEditCopy = 1
    salesEditPaste = 2
End Enum

' View menu options
Enum salesViewMenu
    salesViewAddressBook = 0
    salesViewToDoList = 1
End Enum

' Help menu options
Enum salesHelpMenu
    salesHelpTopics = 0
    salesHelpAbout = 2
End Enum

' Popup menu options
Enum salesPopupMenu
    salesPopupNew = 0
    salesPopupSave = 1
End Enum

' Constant for help system
Private Const cdlHelpFinder = 11

' PUBLIC: ******************************************
' Public property procedures

' Retrive the contact person ID from the combo box
Private Property Get PersonID()
    If cboPerson.ListIndex = -1 Then
        PersonID = 0
    Else
        PersonID = cboPerson.ItemData(cboPerson.ListIndex)
    End If
End Property

Private Sub cboPerson_DropDown()
    ' Clear the list
    cboPerson.Clear
    
   ' Fill the combo box with the information from the database
    m_SalesPerson.Persons.FillPersonList cboPerson
    
End Sub

Private Sub cboPerson_Click()
    Fill PersonID
End Sub

Private Sub datContact_Reposition()
Static bDoingNew As Boolean
    ' If there are no records, add one
    If datContact.Recordset.BOF And datContact.Recordset.EOF Then
        If Not bDoingNew Then
            bDoingNew = True
            DoAdd
        End If
    Else
        If datContact.Recordset.BOF Then
            datContact.Recordset.MoveFirst
        End If
    
        If datContact.Recordset.EOF Then
            datContact.Recordset.MoveLast
        End If
    End If
    bDoingNew = False
End Sub

Private Sub Form_Activate()
    ' Refill to display current data
    UpdateForm
End Sub

Private Sub Form_Deactivate()
    ' Save on deactivate
    DoSave
End Sub

Private Sub Form_Load()
Dim lTop As Long, lLeft As Long
Dim oldCursor As Variant
    
    ' Store the cursor and reset it to normal
    oldCursor = Screen.MousePointer
    Screen.MousePointer = vbNormal
    
    ' Set the correct caption
    Me.Caption = App.Title
    
    ' Retrieve settings from the Registry
    lTop = Val(GetSetting(App.EXEName, "MainForm", "Top"))
    lLeft = Val(GetSetting(App.EXEName, "MainForm", "Left"))
    Me.Move lLeft, lTop

    ' Show the form
    Me.Show
    Me.Refresh
    
    ' Define the instance of the top level class
    Set m_SalesPerson = New CSalesPerson
    
    ' Establish the data control connection
    datContact.DatabaseName = g_DB.dbName
    datContact.RecordSource = m_SalesPerson.Contacts.QueryString
    datContact.Refresh
    
    datContactType.DatabaseName = datContact.DatabaseName
    datContactType.Refresh
    
    ' Upon return, reset the cursor
    Screen.MousePointer = oldCursor
End Sub

Private Sub Form_MouseUp(Button As Integer, Shift As Integer, _
   x As Single, y As Single)
    If Button = vbRightButton Then
        PopupMenu mnuContactPopup, , , , mnuContact(1)
    End If
End Sub

Private Sub Form_Unload(Cancel As Integer)

    ' Save on unload
    DoSave
    
    ' Save the current window location
    SaveSetting App.EXEName, "MainForm", "Top", CStr(Me.Top)
    SaveSetting App.EXEName, "MainForm", "Left", CStr(Me.Left)

    ' Clear the instances
    Set m_SalesPerson = Nothing
    Set frmMain = Nothing
    
    ' Write the log
    g_Err.ErrorLog "Application terminated.", vbLogEventTypeInformation
    
    End
End Sub

Private Sub mnuContact_Click(index As Integer)
    Select Case index
        Case salesPopupNew
            ' Create a new contact
            DoAdd
            
        Case salesPopupSave
            DoSave
    End Select
End Sub

' Handle the Edit menu options
Private Sub mnuEdit_Click(index As Integer)
Dim Win As New CWindow

    Select Case index
        Case salesEditCut
            Win.EditCut

        Case salesEditCopy
            Win.EditCopy

        Case salesEditPaste
            Win.EditPaste
    End Select

End Sub

' Enable/disable the appropriate Edit menu options.
Private Sub mnuEditMenu_Click()
    ' Set error handling
    On Error Resume Next
    
    ' Disable all three
    mnuEdit(salesEditCut).Enabled = False
    mnuEdit(salesEditCopy).Enabled = False
    mnuEdit(salesEditPaste).Enabled = False
    
    ' Ensure there is an active control
    If Not (Screen.ActiveControl Is Nothing) Then
        ' If the active control is a text box or combo box, then
        If TypeOf Screen.ActiveControl Is TextBox Or TypeOf Screen.ActiveControl Is ComboBox Then
            ' If something is selected, enable cut and copy
            If Screen.ActiveControl.SelLength > 0 Then
                If Err.Number = 0 Then
                    mnuEdit(salesEditCut).Enabled = True
                    mnuEdit(salesEditCopy).Enabled = True
                End If
            End If
            
            ' Something is on the Clipboard, enable Paste
            If Clipboard.GetFormat(vbCFText) Then
                mnuEdit(salesEditPaste) = True
            End If
        End If
    End If

End Sub

Private Sub mnuFile_Click(index As Integer)
Dim sFileName As String
Dim iNumCopies As Integer

    Select Case index
    
        Case salesFileNew
            ' Create the new file
            ' *** Code needed here to create a new file
            MsgBox "Code here would create a new contact file"
            
        Case salesFileOpen
            ' Use the common dialog to retrieve a file name
            FileOpenDB cDlg, sFileName
            
            ' Open the file
            ' *** Code needed here to open the file
            If Len(sFileName) <> 0 Then
                MsgBox "This would open a file named: " _
                   & sFileName
            End If
            
        Case salesFileSave
            ' Save the current data on the form
            DoSave
            
        Case salesFileSaveAs
            ' Use the common dialog to save to a different file name
            FileSaveAsDB cDlg, sFileName
            
            If Len(sFileName) <> 0 Then
               MsgBox "Code here would save as a file named: " _
                  & sFileName
            End If
           
        Case salesFilePrint
            ' Use the common dialog to obtain print specifications
            FilePrintDB cDlg, iNumCopies
            
            ' *** Code needed here to call a print routine
            MsgBox "Code here would print the information."

        Case salesFilePrintPreview
            ' *** Code needed here to call a print preview routine
            MsgBox "Code here would display a print preview."
            
        Case salesFileExit
            ' Close the window
            Unload Me
    End Select
End Sub

' Help menu options
Private Sub mnuHelp_Click(index As Integer)
   
   Select Case index
   
      Case salesHelpTopics
        ' Specify the help file to open
        cDlg.HelpFile = App.HelpFile
        cDlg.HelpCommand = cdlHelpFinder
        cDlg.ShowHelp

      Case salesHelpAbout     ' About
        ' Display an about box
        frmAbout.Display
        
   End Select

End Sub

Private Sub mnuView_Click(index As Integer)
    Select Case index
        Case salesViewAddressBook
            ' Ensure the current screen values
            ' are stored on the object
            UpdateObject
            
            ' Display the person form
           frmPerson.Display m_SalesPerson.Persons
        
        Case salesViewToDoList
            frmToDo.Display
    End Select
End Sub

Private Sub Toolbar1_ButtonClick(ByVal Button As Button)
Dim Win As New CWindow
Dim iNumCopies As Integer

    Select Case Button.Key
        Case "SAVE"
            ' Save the current data on the form
            DoSave
            
        Case "PRINT"
            ' Use the common dialog to obtain print specifications
            FilePrintDB cDlg, iNumCopies
            
            ' *** Code needed here to call a print routine
            MsgBox "Code here would print the information."
        
        Case "CUT"
            Win.EditCut
        
        Case "COPY"
            Win.EditCopy
            
        Case "Paste"
            Win.EditPaste
            
        Case "NEW"
            ' Perform the new operation
            DoAdd
            
            ' Set focus to the notes area
            txtContact(2).SetFocus
            
        Case "DELETE"
            ' Delete the record
            If Not datContact.Recordset.EOF Then
                datContact.Recordset.Delete
                ' Move to the next valid record
                datContact.Recordset.MoveFirst
            End If
    End Select
End Sub

Private Sub txtPerson_Change(index As Integer)
    m_SalesPerson.Persons.IsDirty = True
End Sub


' Perfoms a new operation
Private Sub DoAdd()
    ' Add the record
    datContact.Recordset.AddNew
    datContact.Recordset("SalesPersonID") = m_SalesPerson.Contacts.UserID
    datContact.Recordset("PersonID") = m_SalesPerson.Contacts.contactPersonID
    
    ' Set the date field to the current date
    txtContact(1).Text = Format$(Now, "m/d/yyyy h:mm AM/PM")
End Sub

' Performs the save operation
Private Sub DoSave()
    ' Update the object from the form
    UpdateObject
    
    ' Save the data
    m_SalesPerson.Persons.Save
    
    ' Refresh the grid
    datContact.Refresh
End Sub

' File Open dialog box processing
' Parameters:
'   cDlg        Common dialog control
'   sFileName   Name of the file selected by the user (Returned)
Private Sub FileOpenDB(cDlg As Control, sFileName As String)
    ' Set the error handler
    On Error Resume Next

     ' Use the common dialog box
    cDlg.CancelError = True
    cDlg.DialogTitle = "Open the File"
    cDlg.Filter = "All (*.*)|*.*|Text (*.txt)|*.txt|Logs (*.log)|*.log"
    cDlg.ShowOpen

     ' Trap error if user cancels
     If Err.Number = cdlCancel Then
        ' Return an empty file name
        sFileName = ""
     Else
         ' Return the file name
         sFileName = cDlg.filename
     End If
End Sub

' File Print dialog box processing
' Parameters
'   cDlg        common dialog control
'   iNumCopies  number of copies selected
Private Sub FilePrintDB(cDlg As Control, iNumCopies As Integer)
    ' Set the error handler
    On Error Resume Next

     ' Use the common dialog box
    cDlg.CancelError = True
    cDlg.DialogTitle = "Print"
    cDlg.Flags = cdlPDUseDevModeCopies
    cDlg.ShowPrinter

     ' Trap error if user cancels
     If Err.Number = cdlCancel Then
        iNumCopies = 0
     Else
        iNumCopies = cDlg.Copies
     End If
End Sub

' File Save As dialog box processing
' Parameters:
'   cDlg        Common dialog control
'   sFileName   Name of the file selected by the user (Returned)
Private Sub FileSaveAsDB(cDlg As Control, sFileName As String)
    ' Set the error handler
    On Error Resume Next

     ' Use the common dialog box
    cDlg.CancelError = True
    cDlg.DialogTitle = "Save the File As"
    cDlg.Filter = "Text (*.txt)|*.txt|Logs (*.log)|*.log"
    cDlg.ShowSave

     ' Trap error if user cancels
     If Err.Number = cdlCancel Then

        ' Return an empty file name
        sFileName = ""
     Else
         ' Return the file name
         sFileName = cDlg.filename
     End If
End Sub

' Fills the form with the defined person's data
Private Sub Fill(lID As Long)

    ' Copy the control values to the object
    UpdateObject
    
    ' Change the selected person
    m_SalesPerson.Persons.Find lID
    
    ' Set the values from the found person to
    ' the form
    UpdateForm

    ' Readjust the grid
    m_SalesPerson.Contacts.contactPersonID = lID
    datContact.RecordSource = m_SalesPerson.Contacts.QueryString
    datContact.Refresh

End Sub

' Updates form from object
Private Sub UpdateForm()
    With m_SalesPerson.Persons.Person
        txtPerson(0) = .FirstName
        txtPerson(1) = .LastName
        txtPerson(2) = .Address
        txtPerson(4) = .City
        txtPerson(5) = .State
        txtPerson(6) = .ZipCode
        txtPerson(10) = .Phone
        txtPerson(11) = .FAX
        txtPerson(12) = .EMail
    End With
    
    ' This turned the dirty flag on
    ' Turn it back off
    m_SalesPerson.Persons.IsDirty = False
    
End Sub
' Updates object from form
Private Sub UpdateObject()
    ' Transfer the info from the form to the person object
    If m_SalesPerson.Persons.IsDirty Then
        With m_SalesPerson.Persons.Person
            ' Set the values from the form to the class
            .FirstName = txtPerson(0).Text
            .LastName = txtPerson(1).Text
            .Address = txtPerson(2).Text
            .City = txtPerson(4).Text
            .State = txtPerson(5).Text
            .ZipCode = txtPerson(6).Text
            .Phone = txtPerson(10).Text
            .FAX = txtPerson(11).Text
            .EMail = txtPerson(12).Text
        End With
    End If
End Sub

