Attribute VB_Name = "MMain"
' Module Name:  MMain
' Author:       Deborah Kurata, InStep Technologies
' Date:         1/24/97
' Description:  This is the main module in the application.
'
' Revisions:
'
Option Explicit

' PUBLIC: *****************************************
' Public data members


' PRIVATE: *****************************************
' Private data members

' Global error class
Public g_Err As New CError

' Reference to the database class
Public g_DB As CDatabase

' Starting place of this application
Sub main()
On Error GoTo ERR_ROUTINE

    ' Turn on the hourglass cursor
    Screen.MousePointer = vbHourglass
    
    ' Show the splash screen
    frmSplash.Display
    
    ' Log that the application started
    g_Err.ErrorLog "CMS Application Started", vbLogEventTypeInformation
    
    ' Open the database
    Set g_DB = New CDatabase
    g_DB.dbName = App.Path & "\cms.mdb"
    
    ' Unload before displaying the login form
    Unload frmSplash
    
    ' Validate the user's ID
    frmLogin.Display
    
    If frmLogin.IsValid Then
        g_Err.ErrorLog "User : " & frmLogin.UserName & _
            " has logged in", vbLogEventTypeInformation
        
        ' Show the main desktop
        frmMain.Show
    End If
    
    ' Turn off the hourglass
    Screen.MousePointer = vbDefault
    
Exit Sub

ERR_ROUTINE:
    ' Unload the splash screen
    Unload frmSplash
    
    g_Err.ErrorLog "Application Error", vbLogEventTypeError
    MsgBox "This application has generated an error: " & _
        Err.Description
End Sub


