VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CError"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' Class Name:   CError
' Author:       Deborah Kurata, InStep Technologies
' Date:         1/23/97
' Description:  Provides error logging
'
' Revisions:
'
Option Explicit

' PUBLIC: *****************************************
' Public data members

' PRIVATE: *****************************************
' Private data members

' Standard error routine
' Any error that requires a log entry should call this routine.
' Parameters:
'   sMessage    String message
'   lErrLogType Type of error
Public Sub ErrorLog(sMessage As String, lErrLogType As Long)
Dim sPrintMsg As String
    
    ' Add the date and time to the message.
    sPrintMsg = Now & Space(5) & sMessage
    
    ' If it was an error message, append actual error info
    If lErrLogType = vbLogEventTypeError Then
        sPrintMsg = sMessage & vbCrLf & _
            "  Error: [" & Err.Number & "]: " & _
            Err.Description & _
            "  Error in: " & Err.Source
    End If
    
    ' Write it in the event log
    App.LogEvent sPrintMsg, lErrLogType
    
    ' Output the string to the debug window as well
    Debug.Print sPrintMsg

End Sub
