VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CDatabase"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' Class Name:   CDatabase
' Author:       Deborah Kurata, InStep Technologies
' Date:         1/22/97
' Description:  Provides database services
' Edit History:
'
Option Explicit

' Database
Private m_DB As Database
Private m_sDBName As String
Private m_WS As Workspace

' Database error enumeration
Enum dbErrors
    dbAccessError = vbObjectError + 512 + 1000
    dbOpenDBError = vbObjectError + 512 + 1001
    dbOpenRSError = vbObjectError + 512 + 1002
End Enum

' Provide a pointer to the database
Public Property Get db() As Database
    Set db = m_DB
End Property

' Name of the database file
' When the name is set, the database is opened
Public Property Let dbName(s As String)
    m_sDBName = s
    
    ' Open the database
    dbOpen
End Property
Public Property Get dbName() As String
    dbName = m_sDBName
End Property

Private Sub Class_Initialize()
    ' Use the default work space
    Set m_WS = Workspaces(0)

End Sub

Private Sub Class_Terminate()
    If Not (m_DB Is Nothing) Then
        m_DB.Close
    End If
    
    Set m_DB = Nothing
    Set m_WS = Nothing

End Sub

Private Sub dbOpen()
On Error GoTo ERR_ROUTINE
    Set m_DB = m_WS.OpenDatabase(dbName)
    
Exit Sub

ERR_ROUTINE:
    Err.Raise dbOpenDBError, "CDatabase::dbOpen", _
        "Error opening the database."
End Sub

