VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CContactEntries"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' Class Name:   CContactEntries
' Author:       Deborah Kurata, InStep Technologies
' Date:         1/24/97
' Description:  Manages the query string for contact
'               entries and contact types
' Edit History:
'
Option Explicit

' PUBLIC: ******************************************
' Public data members

' PRIVATE: *****************************************
' Private data members

Private m_lPersonId As Long
Private m_sQuery As String
Private m_lUserID As Long

' PUBLIC: *****************************************
' Public property procedures

' Allow the contact person ID to be changed
Public Property Get contactPersonID() As Long
    contactPersonID = m_lPersonId
End Property

Public Property Let contactPersonID(lID As Long)
    m_lPersonId = lID
    
    ' If the contact person ID changes, rebuild the query
    BuildQuery
End Property
' Provide the query string for the data control
Public Property Get QueryString() As String
    QueryString = m_sQuery
End Property

' Allow the SalesPerson class to change the current
' sales person
Public Property Get UserID() As Long
    UserID = m_lUserID
End Property
Public Property Let UserID(lUserID As Long)
    m_lUserID = lUserID
    
    ' If the user ID changes, rebuild the query
    BuildQuery
End Property

' PUBLIC: ******************************************
' Public methods

Private Sub BuildQuery()

    ' Set the recordsource for the dataset
    m_sQuery = "select contactEntries.*,contactTypes.contactTypeDescription " & _
        "from contactEntries left join contactTypes " & _
        "on contactEntries.contactType = contactTypes.contactTypeID " & _
        "where contactEntries.SalesPersonID = " & m_lUserID & " " & _
        "and contactEntries.PersonID = " & m_lPersonId & " " & _
        "order by contactDate DESC"
End Sub

