VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CPersons"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' Class Name:   CPersons
' Author:       Deborah Kurata, InStep Technologies
' Date:         1/25/97
' Description:  Provides services to interface to
'               the data for all persons
' Edit History:
'
Option Explicit

' PRIVATE: *****************************************
' Private data members

' Recordset
Private m_rs As Recordset

' Reference to a person object
Private m_Person As CPerson

' Dirty flag
Private m_bIsDirty As Boolean

' Error constants
Enum persError
    persInitError = vbObjectError + 512 + 2000
End Enum


' PUBLIC: *****************************************
' Public property procedures

Public Property Get IsDirty() As Boolean
    IsDirty = m_bIsDirty
End Property
Public Property Let IsDirty(bIsDirty As Boolean)
    m_bIsDirty = bIsDirty
End Property

Public Property Get Person() As CPerson
Attribute Person.VB_Description = "Pointer to the current person object."
    Set Person = m_Person
End Property

' Add a new record
Public Sub Add()
    ' If the person object is dirty, save it
    Save
    
    ' Reinitialize
    Set m_Person = New CPerson
End Sub

' Delete the current record
Public Sub Delete()
    m_rs.Delete
    m_rs.MoveFirst
End Sub

' Fill any list with Person list data
Public Sub FillPersonList(lst As Control)
    FillList lst, "personID", "FirstName", "LastName"
End Sub


' Find the defined person record
' Parameters:
'   lID         ID of desired record
Public Sub Find(lID As Long)
Dim vBookmark As Variant

    ' If the person object is dirty, save it
    Save
    
    ' Find the requested person
    vBookmark = m_rs.Bookmark
    m_rs.FindFirst "personID = " & lID
    If m_rs.NoMatch = True Then
        ' Return to the bookmark
        m_rs.Bookmark = vBookmark
    Else
        UpdateObject
    End If
End Sub

' Save the current record
Public Sub Save()
    ' If the person object is dirty, save it
    If m_bIsDirty Then
        UpdateRecord
        ' Turn the dirty flag is off
        m_bIsDirty = False
    End If
End Sub

' PRIVATE: *****************************************
' Private procedures

Private Sub Class_Initialize()
Dim sSQL As String
Dim sErr As String
On Error Resume Next

    ' Set the SQL statement
    sSQL = "select * from Person"

    ' Open the recordset
    Set m_rs = g_DB.db.OpenRecordset(sSQL, dbOpenDynaset)
    If Err.Number <> 0 Then
        sErr = Err.Description
        On Error GoTo 0
        Err.Raise dbOpenRSError, "CPersons::Initialize", _
            sErr
    End If
    
    ' Create the reference to a Person object
    Set m_Person = New CPerson
    If Err.Number <> 0 Then
        sErr = Err.Description
        On Error GoTo 0
        Err.Raise persInitError, "CPerson::Initialize", _
            sErr
    End If
End Sub

Private Sub Class_Terminate()
On Error Resume Next
    ' Close the recordset
    If Not (m_rs Is Nothing) Then
        m_rs.Close
    End If

    ' Clear the references
    Set m_rs = Nothing
    Set m_Person = Nothing

End Sub

' Fill any list with the data from the recordset
' Parameters:
'   cbo         list type control to fill
'   sIDColumn   name of the column containing the record ID
'   sColumns    name of the columns of data to display
Private Sub FillList(cbo As Control, sIDColumn As String, ParamArray sColumns() As Variant)
Dim sData As String
Dim i As Integer
Dim bmCurrentPos As Variant

    ' Save the current position
    bmCurrentPos = m_rs.Bookmark

    ' Clear the list
    cbo.Clear

    ' Move to the first record
    m_rs.MoveFirst

    ' Add each record until the end of the file
    Do Until m_rs.EOF
        ' Concatenate each desired column
        sData = ""
        For i = 0 To UBound(sColumns)
            sData = sData & " " & m_rs(sColumns(i))
        Next i

        ' Add the item to the list
        cbo.AddItem sData
        cbo.ItemData(cbo.NewIndex) = m_rs(sIDColumn)
        
        ' Move to the next row
        m_rs.MoveNext
    Loop
    
    ' Return to the current position
    m_rs.Bookmark = bmCurrentPos
End Sub

' Copy the data to the Person object
Private Sub UpdateObject()
    With m_Person
        .LastName = m_rs!LastName & ""
        .FirstName = m_rs!FirstName & ""
        .Address = m_rs!Address & ""
        .City = m_rs!City & ""
        .State = m_rs!State & ""
        .ZipCode = m_rs!ZipCode & ""
        .Company = m_rs!Company & ""
        .Title = m_rs!Title & ""
        .Department = m_rs!Department & ""
        .Phone = m_rs!Phone & ""
        .FAX = m_rs!FAX & ""
        .EMail = m_rs!EMail & ""
        .Notes = m_rs!Notes & ""
        .ID = m_rs!PersonID
    End With
End Sub

' Update the record with the current Person
' object properties
Private Sub UpdateRecord()
    ' If the ID is 0, it is a new
    If m_Person.ID = 0 Then
        m_rs.AddNew
    Else
        m_rs.Edit
    End If

    ' Copy the fields
    With m_Person
        m_rs!LastName = .LastName
        m_rs!FirstName = .FirstName
        m_rs!Address = .Address
        m_rs!City = .City
        m_rs!State = .State
        m_rs!ZipCode = .ZipCode
        m_rs!Company = .Company
        m_rs!Title = .Title
        m_rs!Department = .Department
        m_rs!Phone = .Phone
        m_rs!FAX = .FAX
        m_rs!EMail = .EMail
        m_rs!Notes = .Notes
    End With
    
    ' Do the Update
    m_rs.Update
    m_rs.Bookmark = m_rs.LastModified
    
    ' Retrieve the (new) ID
    m_Person.ID = m_rs!PersonID
End Sub

