VERSION 5.00
Begin VB.Form frmToDo 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "To Do List"
   ClientHeight    =   3795
   ClientLeft      =   1080
   ClientTop       =   1425
   ClientWidth     =   6840
   Icon            =   "ToDo.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   3795
   ScaleWidth      =   6840
   Begin VB.CommandButton cmdDelete 
      Caption         =   "D&elete Task"
      Height          =   372
      Left            =   2760
      TabIndex        =   8
      Top             =   3240
      Width           =   1275
   End
   Begin VB.ListBox lstTasks 
      Height          =   2040
      Left            =   120
      TabIndex        =   6
      Top             =   960
      Width           =   6615
   End
   Begin VB.CommandButton cmdClose 
      Cancel          =   -1  'True
      Caption         =   "&Close"
      Height          =   372
      Left            =   4440
      TabIndex        =   9
      Top             =   3240
      Width           =   1275
   End
   Begin VB.CommandButton cmdAdd 
      Caption         =   "&Add Task"
      Default         =   -1  'True
      Height          =   372
      Left            =   1080
      TabIndex        =   7
      Top             =   3240
      Width           =   1275
   End
   Begin VB.TextBox txtDue 
      Height          =   315
      Left            =   5520
      TabIndex        =   5
      Top             =   360
      Width           =   1095
   End
   Begin VB.TextBox txtPriority 
      Height          =   288
      Left            =   60
      TabIndex        =   1
      Top             =   360
      Width           =   372
   End
   Begin VB.TextBox txtDescription 
      Height          =   492
      Left            =   840
      MultiLine       =   -1  'True
      TabIndex        =   3
      Top             =   360
      Width           =   4452
   End
   Begin VB.Label Label1 
      Caption         =   "&Due:"
      Height          =   255
      Index           =   2
      Left            =   5520
      TabIndex        =   4
      Top             =   120
      Width           =   855
   End
   Begin VB.Label Label1 
      Caption         =   "&Priority:"
      Height          =   252
      Index           =   1
      Left            =   60
      TabIndex        =   0
      Top             =   120
      Width           =   672
   End
   Begin VB.Label Label1 
      Caption         =   "&To Do:"
      Height          =   252
      Index           =   0
      Left            =   840
      TabIndex        =   2
      Top             =   120
      Width           =   612
   End
End
Attribute VB_Name = "frmToDo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
' Form Name:    frmToDo
' Author:       Deborah Kurata, InStep Technologies
' Date:         1/8/97
' Description:  Displays a set of tasks in a to do list.
' Revisions:
'
Option Explicit

' Define the instance of the collection class
Private m_Tasks As CTasks
Attribute m_Tasks.VB_VarHelpID = -1

' Add the defined task to the collection and to the list box
Private Sub cmdAdd_Click()
Dim index As Integer
On Error GoTo ERR_ROUTINE
    
    ' Add the task to the collection
    m_Tasks.Add Val(txtPriority.Text), txtDescription.Text, txtDue.Text
    
    ' Add the task to the list box
    lstTasks.AddItem Format$(txtPriority.Text, "000") _
        & Space(2) & txtDescription.Text _
        & Space(2) & "Due: " & txtDue.Text
    
    ' Clear the fields on the form for entry of another task
    txtPriority.Text = ""
    txtDescription.Text = ""
    txtDue.Text = ""
    txtPriority.SetFocus
Exit Sub

ERR_ROUTINE:
    Select Case Err.Number
        Case taskPriorityValueError
            MsgBox "Please enter a valid priority value. " _
                & "Valid values range from: " _
                & taskUrgent & " to " & taskLow
            txtPriority.SetFocus
        Case taskInvalidTimeError
            MsgBox "Please enter a time defining when the task is due."
            txtDue.SetFocus
        Case Else
            ' If it was some other error, display it
            MsgBox "Error in application: " _
                & Err.Description
    End Select
End Sub

Private Sub cmdClose_Click()
    ' Unload the form
    Unload Me
End Sub

' Delete the task from the collection and list box
Private Sub cmdDelete_Click()
Dim ix As Integer
On Error GoTo ERR_ROUTINE
    ' Determine the index number
    ' It is one more than the list index because
    ' list boxes are 0-based and collections are 1-based
    ix = lstTasks.ListIndex + 1
    
    If ix > 0 Then
        ' Remove the task from the collection
        m_Tasks.Remove ix
    
        ' Remove the task from the list box
        lstTasks.RemoveItem lstTasks.ListIndex
    End If
Exit Sub
ERR_ROUTINE:
            MsgBox "Error in application: " _
                & Err.Description
End Sub

Private Sub Form_Load()
Dim tempTask As CTask
    
    ' Create the instance of the collection class
    Set m_Tasks = New CTasks
    
    ' Fill the list box with the items from the collection
    ' Shows the For Each...Next syntax!
    For Each tempTask In m_Tasks
        lstTasks.AddItem Format$(tempTask.Priority, "000") _
            & Space(2) & tempTask.Description _
            & Space(2) & "Due: " & tempTask.Due
    Next
End Sub

Private Sub Form_Unload(Cancel As Integer)
    ' Clear all of our object references
    Set m_Tasks = Nothing
    Set frmToDo = Nothing
    End
End Sub
