VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CCustomer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' Class Name:   CCustomer
' Author:       Deborah Kurata, InStep Technologies
' Date:         1/11/97
' Description:  Provides customer properties and methods
' Revisions:

Option Explicit

' Save interface for saving data
Implements ISave
' Person interface for common
' person properties and methods
Implements CPerson

' Declare an instance for delegation
Private m_Person As CPerson

Private m_sCustomerNumber As String
Private m_bIsDirty As Boolean

Public Property Get CustomerNumber() As String
    CustomerNumber = m_sCustomerNumber
End Property
Public Property Let CustomerNumber(ByVal sAcct As String)
    If m_sCustomerNumber <> sAcct Then
        m_sCustomerNumber = sAcct
        m_bIsDirty = True
    End If
End Property
    
Private Sub Class_Initialize()
    Set m_Person = New CPerson
End Sub

Private Sub Class_Terminate()
    Set m_Person = Nothing
End Sub

Private Property Get CPerson_Company() As String
    CPerson_Company = m_Person.Company
End Property

Private Property Let CPerson_Company(ByVal RHS As String)
    If m_Person.Company <> RHS Then
        m_Person.Company = RHS
        m_bIsDirty = True
    End If
End Property

Private Property Let ISave_IsDirty(RHS As Boolean)
    m_bIsDirty = RHS
End Property

Private Property Get ISave_IsDirty() As Boolean
    ISave_IsDirty = m_bIsDirty
End Property

Private Property Get CPerson_Name() As String
    CPerson_Name = m_Person.Name
End Property

Private Property Let CPerson_Name(ByVal RHS As String)
    If m_Person.Name <> RHS Then
        m_Person.Name = RHS
        m_bIsDirty = True
    End If
    
End Property

' Send followup materials
Private Function CPerson_SendFollowUp() As Boolean
    CPerson_SendFollowUp = m_Person.SendFollowUp
End Function

Private Sub ISave_Save()
    MsgBox "Saved the Customer"
End Sub
