VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CTask"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' Class Name:   CTask
' Author:       Deborah Kurata, InStep Technologies
' Date:         1/6/97
' Description:  Define task objects that have a description,
'               priority, and time due.
' Revisions:

Option Explicit
' PUBLIC: ******************************************
' Public data members

' PRIVATE: *****************************************
' Private data members

Private m_dtCreated As Date
Private m_sDescription As String
Private m_sDue As String
Private m_sID As String
Private m_iPriority As Integer

' Define constant priority values
Public Enum taskPriority
    taskEmpty = 0
    taskUrgent = 1
    taskHigh = 2
    taskMedium = 3
    taskLow = 4
End Enum

' Define error values
Public Enum TaskError
    taskPriorityValueError = vbObjectError + 512 + 2
    taskInvalidTimeError = vbObjectError + 512 + 3
End Enum

' PUBLIC: *****************************************
' Public property procedures

' Read-only creation date
Public Property Get Created() As Date
Attribute Created.VB_Description = "Date the task was created."
    Created = m_dtCreated
End Property

' Description of the task
Public Property Get Description() As String
    Description = m_sDescription
End Property
Public Property Let Description(ByVal sDescription As String)
Attribute Description.VB_Description = "Returns/sets the description of a task."
    m_sDescription = sDescription
End Property

' Time the task is due
Public Property Get Due() As String
Attribute Due.VB_Description = "Returns/sets the time the task is due."
    Due = m_sDue
End Property
Public Property Let Due(ByVal sDue As String)
    If Not (IsDate(sDue)) Then
        Err.Raise taskInvalidTimeError, "CTask::Due", _
         "Invalid date in time due property."
    End If
    m_sDue = sDue
End Property

' ID within the collection
' NOTE: it must be a unique string that is only set once
Public Property Let ID(ByVal sID As String)
Attribute ID.VB_Description = "Unique string ID for each task."
Static bAlreadySet As Boolean

    If Not bAlreadySet Then
        m_sID = sID
        bAlreadySet = True
    End If
End Property
Public Property Get ID() As String
    ID = m_sID
End Property

' Priority of the task
Public Property Get Priority() As taskPriority
Attribute Priority.VB_Description = "Returns/sets the priority of the task."
    Priority = m_iPriority
End Property
Public Property Let Priority(ByVal iPriority As taskPriority)
    ' Prevent invalid values
    If iPriority < taskEmpty Or iPriority > taskLow Then
        Err.Raise taskPriorityValueError, "CTask::Priority", _
            "Priority value out of range."
    End If
    
    m_iPriority = iPriority
    
End Property

' Initialize event
Private Sub Class_Initialize()
    ' Set the creation date
    m_dtCreated = Now
End Sub

' PUBLIC: *****************************************
' Public methods

' Clear the task
Public Sub Clear()
Attribute Clear.VB_Description = "Clear the properties of a task."
    Description = ""
    Priority = taskEmpty
    Due = ""
End Sub

' Read the data from the file
Public Sub ReadObjectData(File As CFile)
Attribute ReadObjectData.VB_Description = "Calls routines in the File object to read each property for a single task."
Dim lInt As Long
Dim sStr As String
    On Error GoTo ERR_ROUTINE
    
    ' Retrieve the priority
    File.ReadField lInt
    Priority = lInt

    ' Retrieve the description
    File.ReadField sStr
    Description = sStr
    
    ' Retrieve the time due
    File.ReadField sStr
    Due = sStr
Exit Sub

ERR_ROUTINE:
    Err.Raise Err.Number, Err.Source, Err.Description

End Sub

' Write the data to a file
Public Sub WriteObjectData(File As CFile)
Attribute WriteObjectData.VB_Description = "Calls routines in the File object to write each property for a single task."

    File.WriteField Priority
    File.WriteField Description
    File.WriteField Due
End Sub



