VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CFile"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' Class Name:   CFile
' Author:       Deborah Kurata, InStep Technologies
' Date:         1/25/97
' Description:  Generic file processing class.
' Revisions:

Option Explicit

' PUBLIC: *****************************************
' Public data members

' PRIVATE: *****************************************
' Private data members

' Path and name of the file to open
Private m_sFileName As String

' File number opened
Private m_iFileNumber As Integer

' Error constants
Enum FileError
    fileOpenError = vbObjectError + 512 + 2
    fileEOFError = vbObjectError + 512 + 3
    fileReadError = vbObjectError + 512 + 4
    fileWriteError = vbObjectError + 512 + 5
End Enum

Property Get FileName() As String
Attribute FileName.VB_Description = "Name of the file to contain the task information."
    FileName = m_sFileName
End Property
Property Let FileName(ByVal sFileName As String)
    ' Should validate valid path here
    m_sFileName = sFileName
End Property

' Reads all objects from a file into the defined object
' Parameters:
'   obj         Object to read
Public Sub ReadFile(obj As Object)
Attribute ReadFile.VB_Description = "Reads an object from a file."

    ' Enable error handling
    On Error Resume Next
    
    ' Get the file number
    m_iFileNumber = FreeFile
    
    ' Open the file and trap any errors
    Open m_sFileName For Binary Access Read As #m_iFileNumber
    Select Case Err.Number
        Case 0  ' No error
            ' Get the data
            obj.ReadObjects
        
        Case 53    ' File not found
            ' Do nothing
            
        Case Else
            ' Turn off error handling here
            On Error GoTo 0
            
            ' Pass the error out
            Err.Raise fileOpenError, "CFile::ReadFile", "Error opening file."
            
    End Select

    ' Close the file
    Close #m_iFileNumber
End Sub

' Reads a field from the file
' Parameters:
'   vField      field read from the file
Public Sub ReadField(vField As Variant)
    ' Set the error handler
    On Error GoTo ERR_HANDLER
    
    Get #m_iFileNumber, , vField
    
    If EOF(m_iFileNumber) Then
        ' Reached end of file
        Err.Raise fileEOFError
    End If
Exit Sub

ERR_HANDLER:
    ' Pass the error out
    If Err.Number = fileEOFError Then
        Err.Raise Err.Number, "CFile::ReadField", "EOF"
    Else
        Err.Raise fileReadError, "CFile::ReadField", Err.Description
    End If
End Sub

' Writes all objects to the file.
' Parameters:
'   obj         Object
Public Sub WriteFile(obj As Object)
Attribute WriteFile.VB_Description = "Writes an object to a file."

    ' Enable error handling
    On Error Resume Next

    ' Kill the existing file
    Kill m_sFileName
    Err.Clear

    ' Get the file number
    m_iFileNumber = FreeFile

    ' Open the file and trap any errors
    Open m_sFileName For Binary As #m_iFileNumber
    Select Case Err.Number
        Case 0  ' No error
            ' Write the data
            obj.WriteObjects

        Case Else
            ' Turn off error handling here
            On Error GoTo 0
            
            ' Pass the error out
            Err.Raise fileOpenError, "CFile::WriteFile", _
                "Error opening file: " & Err.Description

    End Select

    ' Close the file
    Close #m_iFileNumber
End Sub

' Write a field to the file
' Parameters:
'   vField      field to write to the file
Public Sub WriteField(ByVal vField As Variant)
' Set the error handler
On Error GoTo ERR_HANDLER

    Put #m_iFileNumber, , vField

Exit Sub
ERR_HANDLER:
    Err.Raise fileWriteError, "CFile::WriteField", _
        "Write Error: " & Err.Descpription
End Sub
