VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CTasks"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' Class Name:   CTasks
' Author:       Deborah Kurata
' Date:         1/9/97
' Description:  Maintains the collection of CTask objects.
'

Option Explicit

' PRIVATE: *****************************************
' Private data members

' Define the collection of tasks
Private m_colTasks As Collection

' Define error values
Public Enum TasksError
    tasksInvalidIndexError = vbObjectError + 512 + 10
End Enum

' Provide the count of the number in the collection
Public Property Get Count() As Long
Attribute Count.VB_Description = "Returns the number of objects in the collection."
    Count = m_colTasks.Count
End Property

' Initialize event
Private Sub Class_Initialize()
    ' Create the collection object
    Set m_colTasks = New Collection
End Sub

' Terminate event
Private Sub Class_Terminate()
    ' Clear the reference
    Set m_colTasks = Nothing
End Sub

' Add a task to the collection
' Parameters:
'   iPriority       priority of the task
'   sDescription    string description of the task
'   sDue            time the task is due
' Returns:
'   Task            task object
Public Function Add(ByVal iPriority As Integer, _
                    ByVal sDescription As String, _
                    ByVal sDue As String) As CTask
Attribute Add.VB_Description = "Adds an object to the collection."
On Error GoTo ERR_ROUTINE
Dim newTask As CTask

    ' Create the instance
    Set newTask = New CTask

    With newTask
        ' Set a unique ID
        .ID = NextID

        ' Set the properties
        .Priority = iPriority
        .Description = sDescription
        .Due = sDue
        
        ' Add the member to the collection
        m_colTasks.Add newTask, .ID
    End With

    ' Return the one that was added
    Set Add = newTask
Exit Function

ERR_ROUTINE:
    ' Pass any error up to the calling class from the lower level object
    Err.Raise Err.Number, Err.Source, Err.Description
End Function

' Clear the collection
Public Sub Clear()
Attribute Clear.VB_Description = "Clears all objects from a collection"
    Set m_colTasks = New Collection
End Sub

' Displays the defined member
' Parameters:
'   vkey         key or index of member to get
Public Function Item(ByVal vKey As Variant) As CTask
Attribute Item.VB_Description = "Returns a refernce to a defined item. The parameter to this function locates the item by index (integer) or key (string)."
Attribute Item.VB_UserMemId = 0
On Error GoTo ERR_ROUTINE
    Set Item = m_colTasks.Item(vKey)
    
Exit Function
ERR_ROUTINE:
    Err.Raise tasksInvalidIndexError, "CTasks::Item", _
        "Collection key or index is invalid"
End Function

' Exposes the enumeration object
' to allow the For Each...Next syntax
Public Function NewEnum() As IUnknown
Attribute NewEnum.VB_Description = "Required to expose the enumeration object and allow use of the For Each...Next syntax"
Attribute NewEnum.VB_UserMemId = -4
Attribute NewEnum.VB_MemberFlags = "40"
    Set NewEnum = m_colTasks.[_NewEnum]
End Function

' Provides the next available ID
' Returns:
'   NextID      Next unique Task ID
Private Function NextID() As String
Static iID As Integer

    iID = iID + 1
    NextID = "T" & Format$(iID, "00000")

End Function

' Remove the member from the collection.
' Parameters:
'   vkey         key or index of member to delete
Public Sub Remove(ByVal vKey As Variant)
Attribute Remove.VB_Description = "Removes an item from the collection."
On Error GoTo ERR_ROUTINE

    ' Remove the member from the collection
    m_colTasks.Remove vKey
    
Exit Sub
ERR_ROUTINE:
    Err.Raise tasksInvalidIndexError, "CTasks::Remove", _
        "Collection key or index is invalid"
End Sub



