VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CTask"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
' Class Name:   CTask
' Author:       Deborah Kurata, InStep Technologies
' Date:         1/6/97
' Description:  Define task objects that have a description,
'               priority, and time due.
' Revisions:

Option Explicit

' PUBLIC: ******************************************
' Public data members

' PRIVATE: *****************************************
' Private data members

Private m_dtCreated As Date
Private m_sDescription As String
Private m_sDue As String
Private m_iPriority As Integer

' PUBLIC: *****************************************
' Public property procedures

' Read-only creation date
Public Property Get Created() As Date
Attribute Created.VB_Description = "Date the task was created."
    Created = m_dtCreated
End Property

' Description of the task
Public Property Get Description() As String
    Description = m_sDescription
End Property
Public Property Let Description(ByVal sDescription As String)
Attribute Description.VB_Description = "Returns/sets the description of a task."
    m_sDescription = sDescription
End Property

' Time the task is due
Public Property Get Due() As String
Attribute Due.VB_Description = "Returns/sets the time the task is due."
    Due = m_sDue
End Property
Public Property Let Due(ByVal sDue As String)
    m_sDue = sDue
End Property

' Priority of the task
Public Property Get Priority() As Integer
Attribute Priority.VB_Description = "Returns/sets the priority of the task."
    Priority = m_iPriority
End Property
Public Property Let Priority(iPriority As Integer)
    ' Prevent invalid values
    If iPriority < 0 Or iPriority > 4 Then
        iPriority = 0
    End If
    
    m_iPriority = iPriority
    
End Property

' Initialize event
Private Sub Class_Initialize()
    ' Set the creation date
    m_dtCreated = Now

    ' Display this in a message box
    MsgBox "Task created: " & Created
End Sub

' Terminate event
Private Sub Class_Terminate()
    ' Display this in a message box
    MsgBox "Task was: " & Description _
           & "  Priority: " & Priority
    MsgBox "Task: " & Created & " is now terminated."
End Sub

' PUBLIC: *****************************************
' Public methods

' Clear the task
Public Sub Clear()
Attribute Clear.VB_Description = "Clear the properties of a task."
    Description = ""
    Priority = 0
    Due = ""
End Sub
