@ECHO OFF

REM There are three parameters passed to this function
REM One: the Windows location
REM Two: the destination directory
REM Three: NOREBOOT command that if set does not reboot the computer

IF '%1' == 'SETWIN' GOTO DVPFILES
REM Check for the F-PROT DVP file
IF NOT EXIST SE_DVPWN.EXE GOTO UNZIP_FILES
   COPY %1\SYSTEM.INI %1\SYSTEM.FPT > NUL
   COPY %1\WIN.INI %1\WIN.FPT > NUL
   REM Make a TEMP directory
   MD _TEMP
   REM Copy the DVP file in
   COPY SE_DVPWN.EXE _TEMP > NUL
   COPY AUTOINST.INI _TEMP > NUL
   REM Go in with it
   CD _TEMP
   REM Uncompress the files for FP-DVP
   SE_DVPWN.EXE -d -o
   REM Copy the following lines to the end of the INI file
   ECHO InstallFrom=%2\_TEMP>> AUTOINST.INI
   ECHO InstallTo=%2>> AUTOINST.INI
   ECHO. >> AUTOINST.INI
   ECHO [Local] >> AUTOINST.INI
   ECHO WindowsDirectory=%1>> AUTOINST.INI
   REM A person can edit the AUTOINST.INI file for extra control of FP-DVP
   AUTOINST
   CD..

   REM This files is needed to counteract video drivers
   IF EXIST F-PROTW.INI COPY F-PROTW.INI %1 > NUL
   IF EXIST F-PROTW.INI DEL F-PROTW.INI

   REM All done, remove the temp directories
   MCDEL _TEMP > NUL
   MCDEL _TEMP -D > NUL
   REM Del the WVIRSTOP support, both are not needed.
   IF EXIST WVIRSTOP.* DEL WVIRSTOP.*
   IF EXIST VIRSTOP.DLL DEL VIRSTOP.DLL
   IF EXIST %1\WVIRSTOP.* DEL %1\WVIRSTOP.*
   IF EXIST %1\VIRSTOP.DLL DEL %1\VIRSTOP.DLL

   IF NOT EXIST LOCAL\NUL GOTO UNZIP_FILES
   CD LOCAL
   RD BULLETIN
   RD INFECT
   RD MESSAGES
   RD REPORTS
   RD REPUSER
   RD SUSPECT
   RD TASKS
   CD..
   RD LOCAL
   GOTO UNZIP_FILES

:DVPFILES
IF EXIST _TEMP\SE_DVPWN.EXE _TEMP\SE_DVPWN.EXE _TEMP -D -O
IF EXIST _TEMP\SE_DVPWN.EXE DEL _TEMP\SE_DVPWN.EXE

:UNZIP_FILES
REM FPWIN support files
IF EXIST *.FPW GOTO UPGRADE
IF EXIST SE_FPW.EXE  SE_FPW.EXE  -D -O
IF EXIST SE_FPW.EXE  DEL SE_FPW.EXE

:UPGRADE
REM FPWIN main executable
IF EXIST SE_FPRTW.EXE   SE_FPRTW.EXE  -D -O
IF EXIST SE_FPRTW.EXE   DEL SE_FPRTW.EXE

REM WIN stub for the DOS installation
IF EXIST SE_WNST.EXE   SE_WNST.EXE  -D -O
IF EXIST SE_WNST.EXE   DEL SE_WNST.EXE

REM WORD DLL Files
IF EXIST SE_WORD.EXE   SE_WORD.EXE  -D -O
IF EXIST SE_WORD.EXE   DEL SE_WORD.EXE

REM VIRSTOP support in Windows
IF EXIST SE_WVSTP.EXE SE_WVSTP.EXE -D -O
IF EXIST SE_WVSTP.EXE DEL SE_WVSTP.EXE

REM Banyan vines support
IF EXIST SE_BNYN.EXE   SE_BNYN.EXE  -D -O
IF EXIST SE_BNYN.EXE   DEL SE_BNYN.EXE

REM Novell support
IF EXIST SE_NVCST.EXE  SE_NVCST.EXE -D -O
IF EXIST SE_NVCST.EXE  DEL SE_NVCST.EXE

REM Data integrity data base
IF EXIST SE_CHCK.EXE    SE_CHCK.EXE   -D -O
IF EXIST SE_CHCK.EXE    DEL SE_CHCK.EXE

IF EXIST SE_SCAN.EXE     SE_SCAN.EXE    -D -O
IF EXIST SE_SCAN.EXE     DEL SE_SCAN.EXE

IF EXIST SE_FMAC.EXE     SE_FMAC.EXE    -D -O
IF EXIST SE_FMAC.EXE     DEL SE_FMAC.EXE

if '%1' == 'SETWIN' GOTO DONE

REM Copy WVIRSTOP to the WIN dir
IF EXIST WVIRSTOP.EXE COPY WVIRSTOP.EXE %1
REM Delete it from the destination dir
IF EXIST WVIRSTOP.EXE DEL WVIRSTOP.EXE
REM Place WVIRSTOP in the WIN.INI
IF EXIST %1\WVIRSTOP.EXE %1\WVIRSTOP /QUIET

REM COPY VIRSTOP.DLL TO THE WINDOWS DIRECTORY
REM THEN DELETE IT FROM THE F-PROT DIR.
IF EXIST VIRSTOP.DLL COPY VIRSTOP.DLL %1
IF EXIST VIRSTOP.DLL DEL VIRSTOP.DLL

REM DELETE INTERUM PROGRAM WHEN DONE
DEL COMEXIT.COM

REM EXECUTE WINSET IF IT EXISTS
REM AND DELETE IT WHEN DONE
IF EXIST WINSET.EXE WINSET.EXE %1
IF EXIST WINSET.EXE DEL WINSET.EXE

REM CLEAR THE SCREEN AND RUN FIXDISK INSTALLATION
CLS
IF EXIST FIXDISK.EXE FIXDISK RESCUE CREATE

REM CLEAR THE SCREEN AND SHOW ENDING INFORMATION
CLS
REM CHECK TO SEE IF REBOOTING IS DESIREABLE
IF '%3'=='NOREBOOT' GOTO END

ECHO.
ECHO      Changes have been made in the start-up files.
ECHO      In order for those changes to take effect,
ECHO      your computer must be rebooted. If there is a
ECHO      disk in drive A:, please remove it at this time.
ECHO.

ECHO      If your computer does not reboot,
ECHO      press CTRL+ALT+DEL or the RESET button.
ECHO.

ECHO Press any key to reboot...
PAUSE > NUL
REM Runs the REBOOT file located within the F-PROT directory
REM If the file does not exist loop continuously
REM and force the user to REBOOT.
:RESTART
IF EXIST REBOOT.COM REBOOT
GOTO RESTART

REM The ending for the NOREBOOT switch
:end
ECHO.
ECHO Type F-PROT to run F-PROT.
:DONE
