{*******************************************************}
{                                                       }
{   Copyright (c) 1996 Classic Software                 }
{   All rights reserved                                 }
{                                                       }
{*******************************************************}

unit CSXCombo;

{$B-,P+,W-,X+}

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  StdCtrls, DBCtrls;

type
  { TCustomComboBox (the ancestor of TComboBox and TDBComboBox)
    does not remember the current item's index when its handle is
    destroyed.
    TcsComboBox and TcsDBComboBox will remember the current item's
    index when the control's handle is destroyed, such as when using
    SaveResources = True on a TcsNotebook and changing pages or when
    destroying handles of controls on TNotebook or TTabbedNotebook
    pages using other means.
  }
  TcsComboBox = class(TComboBox)
  private
    FSaveItemIndex: Integer;
  protected
    procedure CreateWnd; override;
    procedure DestroyWnd; override;
  end;

  TcsDBComboBox = class(TDBComboBox)
  private
    FSaveItemIndex: Integer;
  protected
    procedure CreateWnd; override;
    procedure DestroyWnd; override;
  end;

implementation

{$IFDEF EVALUATION} uses CSEval; {$ENDIF}

{ TcsComboBox }

procedure TcsComboBox.CreateWnd;
begin
  inherited CreateWnd;
  ItemIndex := FSaveItemIndex;
end;

procedure TcsComboBox.DestroyWnd;
begin
  if Items.Count > 0 then
    FSaveItemIndex := ItemIndex;
  inherited DestroyWnd;
end;

{ TcsDBComboBox }

procedure TcsDBComboBox.CreateWnd;
begin
  inherited CreateWnd;
  ItemIndex := FSaveItemIndex;
end;

procedure TcsDBComboBox.DestroyWnd;
begin
  if Items.Count > 0 then
    FSaveItemIndex := ItemIndex;
  inherited DestroyWnd;
end;

end.
