{*******************************************************}
{                                                       }
{   Copyright (c) 1995-1996 Classic Software            }
{   All rights reserved                                 }
{                                                       }
{*******************************************************}

unit CSString;

{$B-,P+,W-,X+}

interface

uses SysUtils, Classes {$IFNDEF WIN32}, WinCrt {$ENDIF};

{ StrToID returns the passed string as a LongInt after
  removing trailing spaces and checking for null string.
}
function StrToID(const Str: String): LongInt;
{ Trim removes trailing spaces from the string. }
function Trim(const Str: String): String;
{ Empty returns True if the string only contains spaces. }
function Empty(const Str: String): Boolean;
{ ProperCase will return the proper-case version (first character of
  each word capitalised) of the string.
}
function ProperCase(const Str: String): String;

implementation

{$IFDEF EVALUATION} uses CSEval; {$ENDIF}

function StrToID(const Str: String): LongInt;
var Pos: Integer;
    NewStr: String;
begin
  { determine position of first blank }
  Pos := 1;
  while ((Pos <= Length(Str)) and (not (Str[Pos] = ' '))) do
    Pos := Pos + 1;

  { StrToInt() bombs out if trailing blanks or null }
  if Length(Str) = 0 then
    NewStr := '0'
  else
    NewStr := Copy(Str, 1, Pos - 1);

  try
    Result := StrToInt(NewStr);
  except
    on EConvertError do Result := 0;
  end;

 end;


function Trim(const Str: String): String;
var Pos: Integer;
begin
  { determine position of last non-blank }
  Pos := Length(Str);
  while ((Pos >= 1) and ((Str[Pos] = ' '))) do
    Pos := Pos - 1;

  Result := Copy(Str, 1, Pos);
end;


function Empty(const Str: String): Boolean;
var Pos: Integer;
begin
  { determine position of first non-blank }
  Pos := 1;
  while ((Pos <= Length(Str)) and (Str[Pos] = #32)) do
    Pos := Pos + 1;

  Result := (Pos > Length(Str));
end;


function ProperCase(const Str: String): String;
const Delimiters: set of 0..255 = [32, 34, 39, 44, 45, 46, 47, 92];
var Delimiter: Boolean;
    ThisCh: String;
    I: Integer;
begin
  { treat start of string as delimiter }
  Delimiter := True;
  Result := '';

  if not Empty(Str) then
  begin
    for I := 1 to Length(Str) do
    begin
      ThisCh := Copy(Str, I, 1);
      if Delimiter then
      begin
        { character at previous position was a delimiter,
          capitalise this ch.
        }
        ThisCh := UpperCase(ThisCh);
        Delimiter := False;
      end
      else
      begin
        { character at previous position was not a delimiter,
          lower this ch.
         }
         ThisCh := LowerCase(ThisCh);
      end;
      Result := Result + ThisCh;

      if (Ord(ThisCh[1]) in Delimiters) then
      begin
        { character at this position is a delimiter,
          capitalise next character
        }
        Delimiter := True;
        if (ThisCh = #39) then  { apostrophe (') }
        begin
          { allow for 's on end of words,
            e.g. "St. Mark's" or "Joe's Diner"
          }
          if (I + 2 <= Length(Str)) then
            Delimiter := (Copy(Str, I + 2, 1) <> #32)
          else
            Delimiter := False;
        end;
      end;
      { test for special situations }
      if (Copy(Result, Length(Result) - 1, Length(Result)) = 'Mc') or
         (Copy(Result, Length(Result) - 2, Length(Result)) = 'Mac') then
        { Mc or Mac at end of new string so far, capitalise next character }
        Delimiter := True;
    end;
  end;
end;

end.
